/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.IDirectPayService;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.JobUtils;

public class DirectPayServiceImpl
extends TsateBaseDeclareService
implements IDirectPayService {
    private static Log LOGGER = LogFactory.getLog(DirectPayServiceImpl.class);

    @Override
    public Map<Long, String> validatePayData(List<Long> declareIds) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        this.validateOrgSubject(declares, erros);
        if (erros.size() > 0) {
            return erros;
        }
        this.validateStatus(declares, erros);
        return erros;
    }

    private void validateStatus(List<DynamicObject> declares, Map<Long, String> erros) {
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            StringBuilder erro = new StringBuilder();
            String billStatus = declare.getString("billstatus");
            BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
            if (!"C".equals(billStatus)) {
                erro.append(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7f34\u6b3e: ", (String)"DirectPayServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DirectPayServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(declareId, erro.toString());
                continue;
            }
            if (!"declared".equals(declare.getString("declarestatus"))) {
                erro.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7f34\u6b3e\u64cd\u4f5c: ", (String)"DirectPayServiceImpl_2", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DirectPayServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(declareId, erro.toString());
                continue;
            }
            if (!("unpaid".equals(declare.getString("paystatus")) || "payfailed".equals(declare.getString("paystatus")) || "yypayfailed".equals(declare.getString("paystatus")))) {
                erro.append(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u672a\u7f34\u6b3e\u201d\u3001\u201c\u7f34\u6b3e\u5931\u8d25\u201d\u6216\u201c\u9884\u7ea6\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7f34\u6b3e\u64cd\u4f5c: ", (String)"DirectPayServiceImpl_3", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DirectPayServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(declareId, erro.toString());
                continue;
            }
            if (BigDecimal.ZERO.compareTo(bqybtse) < 0) continue;
            erro.append(ResManager.loadKDString((String)"\u672c\u671f\u5e94\u8865\uff08\u9000\uff09\u7a0e\u989d\u5927\u4e8e0\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7f34\u6b3e\u64cd\u4f5c: ", (String)"DirectPayServiceImpl_4", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DirectPayServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
            erros.put(declareId, erro.toString());
        }
    }

    @Override
    public boolean support(List<Long> orgIds) {
        return true;
    }

    @Override
    public List<Map<String, Object>> sendTask(List<Long> declareIds) {
        Long declareId;
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        Map<Long, SupplierEnum> declareSupplers = TsateChannelBusiness.getDeclareChannelByData(declares);
        ArrayList<DynamicObject> tobeSend = new ArrayList<DynamicObject>(8);
        Map<Long, String> erros = this.validateSupplierConfig(declares, declareSupplers, tobeSend);
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(8);
        this.saveDeclareStatusAndRecord(tobeSend, records, declareSupplers);
        List<Map<String, Object>> params = this.getTaskParams(records);
        JobUtils.submitJobs(params);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<Long, String> erro : erros.entrySet()) {
            declareId = erro.getKey();
            String erroMsg = erro.getValue();
            result.add(this.genTaskExecuteInfo(declareId, true, erroMsg));
        }
        for (DynamicObject pass : tobeSend) {
            declareId = pass.getLong("id");
            result.add(this.genTaskExecuteInfo(declareId, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"DirectPayServiceImpl_5", (String)"taxc-tsate-business", (Object[])new Object[0])));
        }
        return result;
    }

    private List<Map<String, Object>> getTaskParams(List<DynamicObject> records) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject record : records) {
            String sbbid = String.valueOf(record.getString("sbbid"));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
            paramMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            paramMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
            paramMap.put("businessId", sbbid);
            paramMap.put("isQuery", false);
            paramMap.put("operationType", ExecuteTypeEnums.ZLJK.getKey());
            paramMap.put("recordtype", "ZLJK");
            paramMap.put("recordid", record.getLong("id"));
            paramMap.put("key", ExecuteTypeEnums.ZLJK.getKey());
            params.add(paramMap);
        }
        return params;
    }

    private void saveDeclareStatusAndRecord(List<DynamicObject> declares, List<DynamicObject> records, Map<Long, SupplierEnum> declareChannels) {
        for (DynamicObject declare : declares) {
            try {
                declare.set("paystatus", (Object)"submitted");
                declare.set("paytype", (Object)"1");
                declare.set("payer", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"1");
                declare.set("paydate", (Object)new Date());
                DynamicObject record = DirectPayServiceImpl.assembleDeclareRecord(declare, "ZLJK");
                records.add(record);
            }
            catch (Exception e) {
                LOGGER.error("invokeBizSerivce error:" + e);
            }
        }
        DeclarationMainFormBusniess.updateDeclareMainTable(declares, DeclareOperationEnum.DIRECTPAY);
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.YZF);
        sets.add(SupplierEnum.GXSJ);
        sets.add(SupplierEnum.ZWY);
        sets.add(SupplierEnum.QXY);
        return sets;
    }
}

