/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.ISchedulePayService;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;

public class SchedulePayServiceImpl
extends TsateBaseDeclareService
implements ISchedulePayService {
    private static Log LOGGER = LogFactory.getLog(SchedulePayServiceImpl.class);
    private static Long TAXOFFICE_ID_ZHEJIANG = 1010868748401298555L;

    @Override
    public List<Map<String, Object>> updateStatusByCancelYyjk(List<Long> declareIds) {
        DynamicObject[] declares;
        ArrayList<Map<String, Object>> executeInfos = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject declare : declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", declareIds)})) {
            Long sbbid = declare.getLong("id");
            declare.set("paystatus", (Object)"unpaid");
            declare.set("modifytime", (Object)new Date());
            declare.set("modifier", (Object)RequestContext.get().getUserId());
            declare.set("paytype", (Object)"");
            declare.set("paydate", null);
            declare.set("payer", (Object)0L);
            executeInfos.add(this.genTaskExecuteInfo(sbbid, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"SchedulePayServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0])));
        }
        DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"cancelPay", (Object[])new Object[]{declareIds});
        SaveServiceHelper.save((DynamicObject[])declares);
        return executeInfos;
    }

    @Override
    public List<Map<String, Object>> updateStatusByYyjk(List<Long> declareIds, Date payDate) {
        ArrayList<Map<String, Object>> executeInfos;
        block3: {
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", declareIds)});
            HashMap<Long, Map<String, Object>> channelInfos = new HashMap<Long, Map<String, Object>>(8);
            Map<Long, SupplierEnum> supplierMap = TsateChannelBusiness.getDeclareChannel(declareIds, channelInfos);
            executeInfos = new ArrayList<Map<String, Object>>(8);
            ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(8);
            if (declares == null || declares.length <= 0) break block3;
            for (DynamicObject declare : declares) {
                Long declareId;
                block5: {
                    block4: {
                        Long orgId = this.getPropertyIdFromDeclare(declare, "org");
                        Long taxOfficeId = (Long)((Map)channelInfos.get(orgId)).get("taxofficeid");
                        taxOfficeId = CommonInfoUtil.getParentTaxauthorityById((Long)taxOfficeId);
                        declareId = declare.getLong("id");
                        SupplierEnum supplier = supplierMap.get(declareId);
                        if (!TAXOFFICE_ID_ZHEJIANG.equals(taxOfficeId)) break block4;
                        if (SupplierEnum.ZWY == supplier) break block5;
                    }
                    StringBuilder erro = this.getDeclareDescr(declare);
                    erro.append(" ").append(ResManager.loadKDString((String)"\u4e0d\u662f\u6d59\u6c5f\u5730\u533a\u6216\u4e0d\u662f\u8d26\u65e0\u5fe7\u901a\u9053", (String)"SchedulePayServiceImpl_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                    Map<String, Object> executeInfo = this.genTaskExecuteInfo(declareId, true, erro.toString());
                    executeInfos.add(executeInfo);
                    continue;
                }
                declare.set("modifytime", (Object)new Date());
                declare.set("modifier", (Object)RequestContext.get().getUserId());
                declare.set("paytype", (Object)"2");
                declare.set("paydate", (Object)payDate);
                declare.set("payer", (Object)RequestContext.get().getUserId());
                updateData.add(declare);
                Map<String, Object> executeInfo = this.genTaskExecuteInfo(declareId, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"SchedulePayServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
                executeInfos.add(executeInfo);
            }
            SaveServiceHelper.save((DynamicObject[])updateData.toArray(new DynamicObject[0]));
        }
        return executeInfos;
    }

    @Override
    public Map<Long, String> validateYyjk(List<Long> declareIds) {
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", declareIds)});
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        this.validateOrgSubject(Arrays.asList(declares), erros);
        if (erros.size() > 0) {
            return erros;
        }
        this.validateYyjkStatus(Arrays.asList(declares), erros);
        return erros;
    }

    private void validateYyjkStatus(List<DynamicObject> declares, Map<Long, String> erroInfos) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        for (DynamicObject declare : declares) {
            StringBuilder failmsg = new StringBuilder();
            Long declareId = declare.getLong("id");
            if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                failmsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u672a\u7533\u62a5\u201d\u6216\u201c\u7533\u62a5\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u9884\u7ea6\u7f34\u6b3e: ", (String)"SchedulePayServiceImpl_2", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SchedulePayServiceImpl_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(declareId, failmsg.toString());
                continue;
            }
            BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
            if (BigDecimal.ZERO.compareTo(bqybtse) < 0) continue;
            failmsg.append(ResManager.loadKDString((String)"\u672c\u671f\u5e94\u8865\uff08\u9000\uff09\u7a0e\u989d\u5927\u4e8e0\u624d\u80fd\u9884\u7ea6\u7f34\u6b3e: ", (String)"SchedulePayServiceImpl_4", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SchedulePayServiceImpl_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
            erros.put(declareId, failmsg.toString());
        }
        erroInfos.putAll(erros);
    }

    @Override
    public Map<Long, String> validateCancelYyjk(List<Long> declareIds) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", declareIds)});
        this.validateOrgSubject(Arrays.asList(declares), erros);
        if (erros.size() > 0) {
            return erros;
        }
        this.validateCancelYyjkStatus(Arrays.asList(declares), erros);
        return erros;
    }

    private void validateCancelYyjkStatus(List<DynamicObject> declares, Map<Long, String> erroInfos) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        for (DynamicObject declare : declares) {
            StringBuilder failmsg = new StringBuilder();
            Long declareId = declare.getLong("id");
            if (!"2".equals(declare.getString("paytype"))) {
                failmsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u201c\u9884\u7ea6\u7f34\u6b3e\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u9884\u7ea6\u7f34\u6b3e: ", (String)"SchedulePayServiceImpl_5", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SchedulePayServiceImpl_6", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(declareId, failmsg.toString());
                continue;
            }
            if ("editing".equals(declare.getString("declarestatus")) || "declarefailed".equals(declare.getString("declarestatus"))) continue;
            failmsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u672a\u7533\u62a5\u201d\u6216\u201c\u7533\u62a5\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u53d6\u6d88\u9884\u7ea6\u7f34\u6b3e: ", (String)"SchedulePayServiceImpl_7", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SchedulePayServiceImpl_6", (String)"taxc-tsate-business", (Object[])new Object[0]));
            erros.put(declareId, failmsg.toString());
        }
        erroInfos.putAll(erros);
    }

    @Override
    public boolean support(List<Long> orgIds) {
        TsateCommonConfig cfg = TsateCommonConfig.getInstance();
        Map<Long, Long> orgTopTaxOfficeIds = cfg.getTopTaxofficeId(orgIds);
        for (Map.Entry<Long, Long> item : orgTopTaxOfficeIds.entrySet()) {
            Set<SupplierEnum> suppliers;
            Long orgId = item.getKey();
            Long topTaxOfficeId = item.getValue();
            if (!TAXOFFICE_ID_ZHEJIANG.equals(topTaxOfficeId) || !(suppliers = cfg.getAllSupplier(orgId)).contains(SupplierEnum.ZWY)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.ZWY);
        return sets;
    }
}

