/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.ISyncCancelStatusService;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.JobUtils;

public class SyncCancelStatusServiceImpl
extends TsateBaseDeclareService
implements ISyncCancelStatusService {
    private static final Log LOGGER = LogFactory.getLog(SyncCancelStatusServiceImpl.class);

    @Override
    public boolean support(List<Long> orgIds) {
        Map<Long, Map<String, Object>> channelConfigs = this.getOrgChannelConfigFromCache(orgIds);
        HashSet<SupplierEnum> suppliers = new HashSet<SupplierEnum>(8);
        for (Long orgId : orgIds) {
            suppliers.addAll(this.getSupplierFromConfig(channelConfigs, orgId));
        }
        return suppliers.contains(SupplierEnum.ZWY);
    }

    @Override
    public List<Map<String, Object>> sendTask(List<Long> declareIds) {
        Long declareId;
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        Map<Long, SupplierEnum> declareSupplers = this.getUseSupplier(declares);
        ArrayList<DynamicObject> tobeSend = new ArrayList<DynamicObject>(8);
        Map<Long, String> erros = this.validateSupplierConfig(declares, declareSupplers, tobeSend);
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(8);
        this.saveRecord(tobeSend, records);
        List<Map<String, Object>> params = this.getTaskParams(tobeSend, records, declareSupplers);
        JobUtils.submitJobs(params);
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(8);
        for (Map.Entry<Long, String> erro : erros.entrySet()) {
            declareId = erro.getKey();
            String erroMsg = erro.getValue();
            result.add(this.genTaskExecuteInfo(declareId, true, erroMsg));
        }
        for (DynamicObject pass : tobeSend) {
            declareId = pass.getLong("id");
            result.add(this.genTaskExecuteInfo(declareId, false, ResManager.loadKDString((String)"\u6210\u529f", (String)"SyncCancelStatusServiceImpl_0", (String)"taxc-tsate-business", (Object[])new Object[0])));
        }
        return result;
    }

    private List<Map<String, Object>> getTaskParams(List<DynamicObject> declares, List<DynamicObject> records, Map<Long, SupplierEnum> usefulSupplers) {
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(8);
        HashMap<Long, DynamicObject> declareMap = new HashMap<Long, DynamicObject>(8);
        for (DynamicObject dyn : declares) {
            declareMap.put(dyn.getLong("id"), dyn);
        }
        for (DynamicObject record : records) {
            DynamicObject dqdmObj;
            String sbbid = record.getString("sbbid");
            DynamicObject declareRelation = (DynamicObject)declareMap.get(Long.parseLong(sbbid));
            String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(declareRelation);
            Long recordId = record.getLong("id");
            JSONObject customMap = new JSONObject();
            customMap.put("messageId", UUID.randomUUID().toString().replaceAll("-", ""));
            customMap.put("orgname", declareRelation.getString("nsrmc"));
            customMap.put("transrc", ExecuteTypeEnums.ZLSB.getKey());
            customMap.put("isQuery", false);
            customMap.put("businessId", sbbid);
            customMap.put("type", type);
            customMap.put("nsrsbh", declareRelation.getString("nsrsbh"));
            Date skssqqDate = declareRelation.getDate("skssqq");
            customMap.put("skssqq", DateUtils.format((Date)skssqqDate, (String)"yyyy-MM-dd"));
            Date skssqzDate = declareRelation.getDate("skssqz");
            customMap.put("skssqz", DateUtils.format((Date)skssqzDate, (String)"yyyy-MM-dd"));
            customMap.put("ybtse", declareRelation.getBigDecimal("bqybtse"));
            customMap.put("recordid", recordId);
            customMap.put("key", "tbzt");
            Date sbrqDate = declareRelation.getDate("sbrq");
            customMap.put("sbrq", DateUtils.format((Date)sbrqDate, (String)"yyyy-MM-dd"));
            Long declareId = Long.parseLong(sbbid);
            SupplierEnum supplier = usefulSupplers.get(declareId);
            if (supplier != null) {
                LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7a0e\u5c40\u72b6\u6001\u7533\u62a5\u8868\u6307\u5b9a\u901a\u9053 {}\uff1a{}", (String)"SyncCancelStatusServiceImpl_6", (String)"taxc-tsate-business", (Object[])new Object[0]), (Object)sbbid, (Object)supplier.getName());
                customMap.put("supplier", supplier.getCode());
            }
            if ((dqdmObj = TsateChannelBusiness.getAreaInfo(declareId)) != null) {
                customMap.put("sbdq", dqdmObj.getString("xzqh"));
            }
            params.add((Map<String, Object>)customMap);
        }
        return params;
    }

    private void saveRecord(List<DynamicObject> declares, List<DynamicObject> records) {
        for (DynamicObject declare : declares) {
            DynamicObject record = SyncCancelStatusServiceImpl.assembleDeclareRecord(declare, "TBZT");
            records.add(record);
        }
    }

    @Override
    public Map<Long, String> validateSyncCancelData(List<Long> declareIds) {
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        List<DynamicObject> declares = DeclarationMainFormBusniess.queryByIdsNotThrowEx(declareIds);
        this.validateOrgSubject(declares, erros);
        if (erros.size() > 0) {
            return erros;
        }
        this.validateStatus(declares, erros);
        return erros;
    }

    private void validateStatus(List<DynamicObject> declares, Map<Long, String> erros) {
        for (DynamicObject declare : declares) {
            Long declareId = declare.getLong("id");
            StringBuilder erro = new StringBuilder();
            if (!"1".equals(DeclarationMainFormBusniess.getDeclareMethodByModel3(declare)) || !"declared".equals(declare.getString("declarestatus"))) {
                erro.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u7533\u62a5\u6210\u529f\u201d\u4e14\u7533\u62a5\u65b9\u5f0f\u4e3a\u201c\u76f4\u8fde\u7533\u62a5\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u83b7\u53d6\u7a0e\u5c40\u4f5c\u5e9f\u72b6\u6001\uff1a%s \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SyncCancelStatusServiceImpl_3", (String)"taxc-tsate-business", (Object[])new Object[]{this.getDeclareDescr(declare)}));
                erros.put(declareId, erro.toString());
                continue;
            }
            if (!"paid".equals(declare.getString("paystatus"))) continue;
            erro.append(ResManager.loadKDString((String)"\u7f34\u6b3e\u72b6\u6001\u4e3a\u201c\u7f34\u6b3e\u6210\u529f\u201d\u7684\u8bb0\u5f55\uff0c\u4e0d\u80fd\u83b7\u53d6\u7a0e\u5c40\u4f5c\u5e9f\u72b6\u6001\uff1a%s \u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"SyncCancelStatusServiceImpl_4", (String)"taxc-tsate-business", (Object[])new Object[]{this.getDeclareDescr(declare)}));
            erros.put(declareId, erro.toString());
        }
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.ZWY);
        sets.add(SupplierEnum.QXY);
        return sets;
    }

    private Map<Long, SupplierEnum> getUseSupplier(List<DynamicObject> declares) {
        HashMap<Long, SupplierEnum> useSupplier = new HashMap<Long, SupplierEnum>(8);
        TsateCommonConfig cfg = TsateCommonConfig.getInstance();
        Set<SupplierEnum> validSuppier = this.getSupportSuppliers();
        for (DynamicObject dyn : declares) {
            Long declareId = dyn.getLong("id");
            Long orgId = dyn.getLong("org.id");
            String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3(dyn);
            Set<SupplierEnum> cfgSupplier = cfg.getAllSupplier(orgId);
            SupplierEnum declareSupplier = cfg.getSupplier(orgId, DeclareTypeEnum.valueOfCode((String)declareType));
            if (validSuppier.contains(declareSupplier)) {
                useSupplier.put(declareId, declareSupplier);
                continue;
            }
            for (SupplierEnum cfgItem : cfgSupplier) {
                if (!validSuppier.contains(cfgItem)) continue;
                useSupplier.put(declareId, cfgItem);
                break;
            }
            useSupplier.computeIfAbsent(declareId, key -> declareSupplier);
        }
        return useSupplier;
    }
}

