/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.declare.TsateBaseDeclareService;
import kd.taxc.tsate.business.declare.api.ISzyhPlatformService;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.CommonInfoUtil;

public class SzyhPlatformServiceImpl
extends TsateBaseDeclareService
implements ISzyhPlatformService {
    private static Log LOGGER = LogFactory.getLog(SzyhPlatformServiceImpl.class);

    public static String buildUrlParams(Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        if (map != null) {
            Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> item = iterator.next();
                if (item.getValue() == null) continue;
                stringBuilder.append(item.getKey()).append('=').append(item.getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append('&');
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getSzyhPlatformUrl(Long userId) {
        ApiResult result = (ApiResult)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tsate", (String)"DeclareService", (String)"getToken", null);
        if (result.getSuccess()) {
            LOGGER.info(String.format("szyh getToken resonse: %s", result.getData()));
            QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)userId)};
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String ssoUrl = (String)configMap.get("cloudcc_sso_url");
            String redirectUrl = (String)configMap.get("cloudcc_redirect_url");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"bos_user", (String)"number", (QFilter[])filters);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("username", obj.getString("number"));
            paramMap.put("timestamp", System.currentTimeMillis());
            paramMap.put("visit_type", "0");
            paramMap.put("redirect_uri", redirectUrl);
            paramMap.put("security_token", result.getData());
            String url = ssoUrl + "?" + SzyhPlatformServiceImpl.buildUrlParams(paramMap);
            LOGGER.info(String.format("szyh redirect url: %s", url));
            return url;
        }
        return null;
    }

    @Override
    public boolean support(List<Long> orgIds) {
        Map<Long, Map<String, Object>> channelConfigs = this.getOrgChannelConfigFromCache(orgIds);
        HashSet<SupplierEnum> suppliers = new HashSet<SupplierEnum>(8);
        for (Long orgId : orgIds) {
            suppliers.addAll(this.getSupplierFromConfig(channelConfigs, orgId));
        }
        return suppliers.contains(SupplierEnum.SZYH);
    }

    @Override
    public Set<SupplierEnum> getSupportSuppliers() {
        HashSet<SupplierEnum> sets = new HashSet<SupplierEnum>(8);
        sets.add(SupplierEnum.SZYH);
        return sets;
    }
}

