/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.api.ISupplierSupport;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CacheHelper;

public abstract class TsateBaseDeclareService
implements ISupplierSupport {
    protected static final String ORG_KEY = "org.id";
    protected static final String ORG_NAME = "org.name";
    private static final String CHANNEL_CONFIG_KEY = "tsate_yjbs";

    protected Map<Long, String> validateSupplierConfig(List<DynamicObject> declares, Map<Long, SupplierEnum> declareSuppliers, List<DynamicObject> pass) {
        Set<SupplierEnum> validSuppliers = this.getSupportSuppliers();
        HashMap<Long, String> erros = new HashMap<Long, String>(8);
        for (DynamicObject declare : declares) {
            Long id = declare.getLong("id");
            StringBuilder erromsg = this.getDeclareDescr(declare);
            SupplierEnum supplier = declareSuppliers.get(id);
            if (supplier == null) {
                erromsg.append(ResManager.loadKDString((String)" \u901a\u9053\u672a\u914d\u7f6e\u3002", (String)"TsateBaseDeclareService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(id, erromsg.toString());
                continue;
            }
            if (!validSuppliers.contains(supplier)) {
                erromsg.append(ResManager.loadKDString((String)" \u901a\u9053\u4e0d\u652f\u6301\u3002", (String)"TsateBaseDeclareService_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
                erros.put(id, erromsg.toString());
                continue;
            }
            pass.add(declare);
        }
        return erros;
    }

    protected List<Map<String, Object>> getTaskResultBySupplierConfig(List<DynamicObject> declares, Map<Long, SupplierEnum> declareSuppliers) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(8);
        for (DynamicObject declare : declares) {
            Long id = declare.getLong("id");
            HashMap<String, Object> info = new HashMap<String, Object>(8);
            info.put("sbbid", declare.getLong("id"));
            if (declareSuppliers.get(id) == null) {
                StringBuilder failmsg = new StringBuilder();
                failmsg.append(declare.getString("nsrmc")).append(ResManager.loadKDString((String)" \u672a\u914d\u7f6e\u901a\u9053\u3002", (String)"TsateBaseDeclareService_2", (String)"taxc-tsate-business", (Object[])new Object[0]));
                info.put("isfail", true);
                info.put("failmsg", failmsg.toString());
            } else {
                info.put("isfail", false);
                info.put("failmsg", ResManager.loadKDString((String)"\u6210\u529f", (String)"TsateBaseDeclareService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
            }
            list.add(info);
        }
        return list;
    }

    protected static DynamicObject assembleDeclareRecord(DynamicObject declare, String executeType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{new QFilter("executestatus", "=", (Object)"1").and("sbbid", "=", (Object)declare.getString("id")).and("tasktype.number", "=", (Object)executeType)});
        if (dynamicObject != null) {
            dynamicObject.set("modifytime", (Object)new Date());
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
        } else {
            DynamicObject channelObj;
            dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
            DynamicObject org = declare.getDynamicObject("org");
            dynamicObject.set("org", (Object)org.getLong("id"));
            dynamicObject.set("skssqq", (Object)declare.getDate("skssqq"));
            dynamicObject.set("createtime", (Object)new Date());
            dynamicObject.set("creator", (Object)RequestContext.get().getUserId());
            dynamicObject.set("executestatus", (Object)"1");
            dynamicObject.set("skssqz", (Object)declare.getDate("skssqz"));
            dynamicObject.set("type", (Object)DeclarationMainFormBusniess.getDeclareTypeByModel3(declare));
            dynamicObject.set("billstatus", (Object)"C");
            dynamicObject.set("sbbid", (Object)declare.getString("id"));
            DynamicObject taskObj = BusinessDataServiceHelper.loadSingleFromCache((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)executeType)});
            if (taskObj != null) {
                dynamicObject.set("executetype", (Object)executeType);
                dynamicObject.set("tasktype", (Object)taskObj.getLong("id"));
            }
            if ((channelObj = TsateChannelBusiness.getChannel(declare.getLong("id"))) != null) {
                dynamicObject.set("channel", (Object)channelObj.getDynamicObject("declarechannel").getString("number"));
                dynamicObject.set("declarechannel", (Object)channelObj.getDynamicObject("declarechannel").getLong("id"));
            }
            DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
            dynamicObject = objs[0];
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            codeRuleService.getNumber("tsate_declare_record", dynamicObject, null);
            String number = codeRuleService.readNumber("tsate_declare_record", dynamicObject, null);
            dynamicObject.set("billno", (Object)number);
        }
        return ((DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject}))[0];
    }

    protected Long getPropertyIdFromDeclare(DynamicObject declareMain, String property) {
        Object data = declareMain.get(property);
        if (data instanceof DynamicObject) {
            return declareMain.getLong(property + ".id");
        }
        if (data instanceof Long) {
            return (Long)data;
        }
        return null;
    }

    protected String getOrgNameFromDeclare(DynamicObject declareMain) {
        Object org = declareMain.get("org");
        if (org instanceof DynamicObject) {
            return declareMain.getString(ORG_NAME);
        }
        return declareMain.getString("nsrmc");
    }

    protected SupplierEnum getSupplierFromConfig(Map<Long, Map<String, Object>> channelInfosMaps, DynamicObject declareDyn) {
        List list;
        Long orgId = declareDyn.getLong(ORG_KEY);
        String declareType = DeclarationMainFormBusniess.getDeclareTypeByModel3(declareDyn);
        Map<String, Object> map = channelInfosMaps.get(orgId);
        if (map != null && (list = (List)map.get("channelinfos")) != null) {
            for (Map channel : list) {
                String type = (String)channel.get("declaretype");
                if (!declareType.equals(type)) continue;
                String supplierCode = (String)channel.get("channelnumber");
                return SupplierEnum.valueOfCode((String)supplierCode);
            }
        }
        return null;
    }

    protected Set<SupplierEnum> getSupplierFromConfig(Map<Long, Map<String, Object>> channelInfosMaps, Long orgId) {
        List list;
        HashSet<SupplierEnum> set = new HashSet<SupplierEnum>(8);
        Map<String, Object> map = channelInfosMaps.get(orgId);
        if (map != null && (list = (List)map.get("channelinfos")) != null) {
            for (Map channel : list) {
                String supplierCode = (String)channel.get("channelnumber");
                SupplierEnum supplier = SupplierEnum.valueOfCode((String)supplierCode);
                if (supplier == null) continue;
                set.add(supplier);
            }
        }
        return set;
    }

    protected Map<String, Object> genTaskExecuteInfo(Long sbbid, Boolean isfail, String failmsg) {
        HashMap<String, Object> info = new HashMap<String, Object>();
        info.put("sbbid", sbbid);
        info.put("isfail", isfail);
        info.put("failmsg", failmsg);
        return info;
    }

    protected void validateOrgSubject(List<DynamicObject> declareMains, Map<Long, String> failMsgs) {
        Set orgIds = declareMains.stream().map(item -> this.getPropertyIdFromDeclare((DynamicObject)item, "org")).collect(Collectors.toSet());
        ArrayList orgIdList = new ArrayList(8);
        orgIdList.addAll(orgIds);
        TaxResult result = TaxcMainDataServiceHelper.queryTaxcMainOrgIdByOrgIdAndIsTaxpayer(orgIdList);
        HashSet subjectOrgIds = new HashSet(8);
        subjectOrgIds.addAll((Collection)result.getData());
        HashSet<Long> unValidateOrgId = new HashSet<Long>(8);
        for (DynamicObject declareDyn : declareMains) {
            Long declareId = declareDyn.getLong("id");
            Long orgId = this.getPropertyIdFromDeclare(declareDyn, "org");
            if (subjectOrgIds.contains(orgId) || unValidateOrgId.contains(orgId)) continue;
            unValidateOrgId.add(orgId);
            String orgName = declareDyn.getString("nsrmc");
            unValidateOrgId.add(orgId);
            StringBuilder erro = new StringBuilder();
            erro.append(ResManager.loadKDString((String)"\u53ef\u7528\u4e14\u5df2\u5ba1\u6838\u7684\u7eb3\u7a0e\u4e3b\u4f53\u624d\u80fd\u53d1\u8d77\u64cd\u4f5c: %s\u7ec4\u7ec7\u4e0d\u7b26\u5408\u3002", (String)"TsateBaseDeclareService_7", (String)"taxc-tsate-business", (Object[])new Object[]{orgName}));
            failMsgs.put(declareId, erro.toString());
        }
    }

    protected StringBuilder getDeclareDescr(DynamicObject declare) {
        String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(declare);
        String typeName = DeclareTypeEnum.valueOfCode((String)type).getName();
        String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
        String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
        String orgName = declare.getString("nsrmc");
        String t = ResManager.loadKDString((String)"%1$s %2$s \u81f3 %3$s %4$s", (String)"TsateBaseDeclareService_5", (String)"taxc-tsate-business", (Object[])new Object[0]);
        StringBuilder descr = new StringBuilder(String.format(t, orgName, skssqq, skssqz, typeName));
        return descr;
    }

    protected Map<Long, Map<String, Object>> getOrgChannelConfigFromCache(List<Long> orgIds) {
        Map<Long, Map<String, Object>> configs;
        String requestId = RequestContext.get().getRequestId();
        String cacheStr = CacheHelper.get((String)this.getChannelConfigCacheKey(requestId));
        if (cacheStr != null) {
            configs = TsateChannelBusiness.deSerializeConfig(cacheStr);
        } else {
            configs = TsateChannelBusiness.getDeclareConfigByOrgId(orgIds, true, true, true);
            CacheHelper.put((String)this.getChannelConfigCacheKey(requestId), (String)TsateChannelBusiness.serializeConfig(configs), (int)10);
        }
        return configs;
    }

    private String getChannelConfigCacheKey(String key) {
        StringBuilder sb = new StringBuilder(CHANNEL_CONFIG_KEY);
        sb.append("_").append(key);
        return sb.toString();
    }
}

