/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare.validete;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateCcxwsBussiness;
import kd.taxc.tsate.business.TsateTysbbBussniess;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.declare.validete.enums.SupplierTysbbSupportTaxTypeEnum;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.servicehelperutils.ServiceHelperBaseUtils;

public class AbstractDeclareValidateService {
    private static final String TYSB_INFO = "tysbInfo";
    private static final String TYSB_SBB_INFO = "tysbSbbInfo";
    private static final String ORG_ID = "org.id";
    private static final String TYSP_METHOD_NAME = "specialValidTysb";

    public Map<String, Object> buildValidateContextMap(List<DynamicObject> declares, String validateMethod) {
        HashMap<String, Object> validateContextMap = new HashMap<String, Object>(16);
        if (TYSP_METHOD_NAME.equals(validateMethod)) {
            HashMap<Long, DynamicObjectCollection> tysbInfoMap = new HashMap<Long, DynamicObjectCollection>(16);
            TaxResult tysbTaxResult = TaxcMainDataServiceHelper.queryTaxcMainQtsfByOrgId(AbstractDeclareValidateService.getIdList(ORG_ID, declares));
            ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)tysbTaxResult, (String)ResManager.loadKDString((String)"\u7533\u62a5\u6821\u9a8c\u65f6\u8c03\u7528\u83b7\u53d6\u901a\u7528\u7533\u62a5\u4fe1\u606f\u63a5\u53e3\u5931\u8d25:", (String)"AbstractDeclareValidateService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            List data = (List)tysbTaxResult.getData();
            for (DynamicObject datum : data) {
                tysbInfoMap.put(datum.getLong("orgid.id"), datum.getDynamicObjectCollection("qtsfentity"));
            }
            validateContextMap.put(TYSB_INFO, tysbInfoMap);
            validateContextMap.put(TYSB_SBB_INFO, TsateTysbbBussniess.getTysbbInfoBySbbIds(AbstractDeclareValidateService.getIdList("id", declares)));
        }
        return validateContextMap;
    }

    public void specialValidTysb(DynamicObject declare, Map<Long, SupplierEnum> declareSuppliers, SupplierEnum supplier, DeclareTypeEnum declareType, Map<Long, String> failMsgs, Map<Long, String> riskMsgs, Map<String, Object> context) {
        long declareId = declare.getLong("id");
        String orgName = declare.getString("org.name");
        long orgId = declare.getLong(ORG_ID);
        Map tysbValidateData = (Map)context.get(this.getClass().getName() + "_specialValidTysb");
        Map tysbSbbInfo = (Map)tysbValidateData.get(TYSB_SBB_INFO);
        SupplierTysbbSupportTaxTypeEnum supportTaxTypeEnum = SupplierTysbbSupportTaxTypeEnum.getTysbbSupportTaxBySupplierAndDeclareType(supplier, declareType);
        if (supportTaxTypeEnum == null) {
            return;
        }
        List<String> supportDeclareType = supportTaxTypeEnum.getTaxTypes();
        List tysbSbbInfoObjects = (List)tysbSbbInfo.get(declareId);
        if (CollectionUtils.isEmpty((Collection)tysbSbbInfoObjects)) {
            return;
        }
        List sbbZspmNames = tysbSbbInfoObjects.stream().map(o -> o.getString("zspm")).collect(Collectors.toList());
        if (!supportDeclareType.containsAll(sbbZspmNames)) {
            failMsgs.put(declareId, String.format(supportTaxTypeEnum.getFailMsg(), orgName));
            return;
        }
        Map tysbInfo = (Map)tysbValidateData.get(TYSB_INFO);
        DynamicObjectCollection tysbInfoObjects = (DynamicObjectCollection)tysbInfo.get(orgId);
        Map<String, List<DynamicObject>> groupBySq = tysbSbbInfoObjects.stream().collect(Collectors.groupingBy(o -> DateUtils.format((Date)o.getDate("startdate")) + "," + DateUtils.format((Date)o.getDate("enddate"))));
        for (Map.Entry<String, List<DynamicObject>> entry : groupBySq.entrySet()) {
            String dateSplicing = entry.getKey();
            String[] dateStrings = dateSplicing.split(",");
            Date skssqq = DateUtils.stringToDate((String)dateStrings[0]);
            Date skssqz = DateUtils.stringToDate((String)dateStrings[1]);
            List sbbZspmName = entry.getValue().stream().map(o -> o.getString("zspm")).collect(Collectors.toList());
            TaxPeriodType taxLimit = DateUtils.getTaxLimit3((Date)skssqq, (Date)skssqz);
            ArrayList<String> zspmNames = new ArrayList<String>(8);
            for (DynamicObject infoObject : tysbInfoObjects) {
                Date[] intersectionDate;
                Date startDate = infoObject.getDate("effectivestart");
                Date date = infoObject.getDate("effectiveend");
                String taxPeriod = infoObject.getString("taxperiod");
                if ("count".equals(taxPeriod)) {
                    taxPeriod = TaxPeriodType.SINGLE.getCode();
                }
                String zspmName = infoObject.getString("collectrate.name");
                if (taxLimit == null || !taxLimit.getCode().equals(taxPeriod) || !supportDeclareType.contains(zspmName) || (intersectionDate = DateUtils.getIntersectionDate((Date)skssqq, (Date)skssqz, (Date)startDate, (Date)date)) == null || intersectionDate[0] == null || intersectionDate[1] == null || intersectionDate[0].compareTo(skssqq) != 0 || intersectionDate[1].compareTo(skssqz) != 0) continue;
                zspmNames.add(zspmName);
            }
            if (sbbZspmName.containsAll(zspmNames)) continue;
            HashSet<Object> errorZspms = new HashSet<Object>(16);
            errorZspms.addAll(sbbZspmName);
            errorZspms.addAll(zspmNames);
            StringBuilder builder = new StringBuilder();
            for (String string : errorZspms) {
                builder.append(string).append("\u3001");
            }
            builder.deleteCharAt(builder.length() - 1).append(String.format(ResManager.loadKDString((String)"\u9700\u4e00\u540c\u7533\u62a5\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", (String)"AbstractDeclareValidateService_1", (String)"taxc-tsate-business", (Object[])new Object[0]), orgName));
            failMsgs.put(declareId, builder.toString());
        }
    }

    public void specialValidateCcxws(List<DynamicObject> declares, Map<Long, SupplierEnum> declareChannels, Map<Long, String> failMsgs) {
        HashMap<Long, Boolean> statusMap = new HashMap<Long, Boolean>(16);
        HashMap<String, Set<String>> taxTypesMap = new HashMap<String, Set<String>>(16);
        HashMap<String, Boolean> isDetailMap = new HashMap<String, Boolean>(16);
        this.getOhterTaxInfo(declares, statusMap, taxTypesMap, isDetailMap);
        for (DynamicObject declare : declares) {
            String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(declare);
            Long declareId = declare.getLong("id");
            StringBuilder failMsg = new StringBuilder();
            if (!"ccxws".equals(type)) continue;
            TsateCcxwsBussiness.declareValidate(failMsg, declare, statusMap, taxTypesMap, isDetailMap, declareChannels);
            if (failMsg.length() <= 0) continue;
            failMsgs.put(declareId, failMsg.toString());
        }
    }

    private void getOhterTaxInfo(List<DynamicObject> declareDyns, Map<Long, Boolean> taxEnableMap, Map<String, Set<String>> taxTypesMap, Map<String, Boolean> isDetailMap) {
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        ArrayList<String> declareIds = new ArrayList<String>(8);
        for (DynamicObject dyn : declareDyns) {
            orgIds.add(this.getPropertyIdFromDeclare(dyn, "org"));
            declareIds.add(dyn.getString("id"));
        }
        taxEnableMap.putAll(BastaxTaxorgBusiness.queryTaxTypesEnableStatus(orgIds, "fcs,cztdsys"));
        taxTypesMap.putAll(TsateCcxwsBussiness.queryCcxwsSbbTaxType(declareIds));
        isDetailMap.putAll(TsateCcxwsBussiness.queryCcxwsIsDetailDeclare(declareIds));
    }

    public static List<Long> getIdList(String idKey, List<DynamicObject> declares) {
        if (CollectionUtils.isEmpty(declares)) {
            return new ArrayList<Long>();
        }
        return declares.stream().map(declare -> declare.getLong(idKey)).collect(Collectors.toList());
    }

    public void validateStatus(List<DynamicObject> declares, Map<Long, SupplierEnum> declareChannels, Map<Long, String> failMsg) {
        for (DynamicObject declare : declares) {
            boolean isbefore;
            StringBuilder erroMsg = new StringBuilder();
            Long declareId = declare.getLong("id");
            String billStatus = declare.getString("billstatus");
            SupplierEnum supplier = declareChannels.get(declareId);
            if (!"C".equals(billStatus)) {
                erroMsg.append(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: ", (String)"AbstractDeclareValidateService_2", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"AbstractDeclareValidateService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
                failMsg.put(declareId, erroMsg.toString());
                continue;
            }
            if (SupplierEnum.SZYH == supplier) {
                if (!("editing".equals(declare.getString("declarestatus")) || "declarefailed".equals(declare.getString("declarestatus")) || "submitted".equals(declare.getString("declarestatus")))) {
                    erroMsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u672a\u7533\u62a5\u201d\u3001\u201c\u7533\u62a5\u5931\u8d25\u201d\u6216\u201c\u5df2\u63d0\u4ea4\u5f85\u7533\u62a5\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7533\u62a5\u64cd\u4f5c: ", (String)"AbstractDeclareValidateService_4", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"AbstractDeclareValidateService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
                    failMsg.put(declareId, erroMsg.toString());
                    continue;
                }
            } else if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                erroMsg.append(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u4e3a\u201c\u672a\u7533\u62a5\u201d\u6216\u201c\u7533\u62a5\u5931\u8d25\u201d\u7684\u8bb0\u5f55\uff0c\u624d\u80fd\u8fdb\u884c\u7533\u62a5\u64cd\u4f5c: ", (String)"AbstractDeclareValidateService_5", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"AbstractDeclareValidateService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
                failMsg.put(declareId, erroMsg.toString());
                continue;
            }
            Date payDate = declare.getDate("paydate");
            if (!"2".equals(declare.getString("paytype")) || payDate == null || !(isbefore = payDate.compareTo(DateUtils.stringToDate((String)DateUtils.format((Date)new Date()), (String)"yyyy-MM-dd")) < 0)) continue;
            erroMsg.append(ResManager.loadKDString((String)"\u76f4\u8fde\u7533\u62a5\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u9884\u7ea6\u7f34\u6b3e\u65e5\u671f: ", (String)"AbstractDeclareValidateService_6", (String)"taxc-tsate-business", (Object[])new Object[0])).append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"AbstractDeclareValidateService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
            failMsg.put(declareId, erroMsg.toString());
        }
    }

    public void validateRisk(List<DynamicObject> declares, Map<Long, String> riskMsgs) {
        for (DynamicObject declare : declares) {
            String riskstatus = declare.getString("riskcontent");
            Long declareId = declare.getLong("id");
            if (!"abnormal".equals(riskstatus)) continue;
            StringBuilder riskMsg = new StringBuilder();
            riskMsg.append((CharSequence)this.getDeclareDescr(declare)).append(ResManager.loadKDString((String)" \u98ce\u9669\u63d0\u793a\u5f02\u5e38\uff0c\u786e\u5b9a\u7ee7\u7eed\u7533\u62a5\u5417?", (String)"AbstractDeclareValidateService_7", (String)"taxc-tsate-business", (Object[])new Object[0]));
            riskMsgs.put(declareId, riskMsg.toString());
        }
    }

    protected StringBuilder getDeclareDescr(DynamicObject declare) {
        String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(declare);
        String typeName = DeclareTypeEnum.valueOfCode((String)type).getName();
        String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
        String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
        String orgName = declare.getString("nsrmc");
        String t = ResManager.loadKDString((String)"%s %s \u81f3 %s %s", (String)"AbstractDeclareValidateService_8", (String)"taxc-tsate-business", (Object[])new Object[0]);
        StringBuilder descr = new StringBuilder(String.format(t, orgName, skssqq, skssqz, typeName));
        return descr;
    }

    protected Long getPropertyIdFromDeclare(DynamicObject declareMain, String property) {
        Object data = declareMain.get(property);
        if (data instanceof DynamicObject) {
            return declareMain.getLong(property + ".id");
        }
        if (data instanceof Long) {
            return (Long)data;
        }
        return null;
    }
}

