/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare.validete.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.taxc.tsate.common.constant.MultiLangEnumBridge;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;

public enum SupplierTysbbSupportTaxTypeEnum {
    QXY_TSF_TYSBB(SupplierEnum.QXY, Collections.singletonList(new MultiLangEnumBridge("\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39", "SupplierTysbbSupportTaxTypeEnum_0", "taxc-tsate-business")), DeclareTypeEnum.QTSF_FSSTYSBB, new MultiLangEnumBridge("\u975e\u7a0e\u6536\u5165\u7533\u62a5\u8868\u6682\u53ea\u652f\u6301\u76f4\u8fde\u7533\u62a5\u57ce\u9547\u5783\u573e\u5904\u7406\u8d39\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", "SupplierTysbbSupportTaxTypeEnum_1", "taxc-tsate-business")),
    QXY_QTSF_FSSTYSBB(SupplierEnum.QXY, Arrays.asList(new MultiLangEnumBridge("\u5de5\u4f1a\u7ecf\u8d39", "SupplierTysbbSupportTaxTypeEnum_2", "taxc-tsate-business"), new MultiLangEnumBridge("\u5de5\u4f1a\u7b79\u5907\u91d1", "SupplierTysbbSupportTaxTypeEnum_3", "taxc-tsate-business"), new MultiLangEnumBridge("\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1", "SupplierTysbbSupportTaxTypeEnum_4", "taxc-tsate-business")), DeclareTypeEnum.QTSF_TYSBB, new MultiLangEnumBridge("\u901a\u7528\u7533\u62a5\u8868\u6682\u53ea\u652f\u6301\u76f4\u8fde\u7533\u62a5\u5de5\u4f1a\u7ecf\u8d39\u3001\u5de5\u4f1a\u7b79\u5907\u91d1\u4e0e\u5730\u65b9\u6c34\u5229\u5efa\u8bbe\u57fa\u91d1\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", "SupplierTysbbSupportTaxTypeEnum_5", "taxc-tsate-business")),
    YZF_QTSF_TYSBB(SupplierEnum.YZF, Arrays.asList(new MultiLangEnumBridge("\u5de5\u4f1a\u7ecf\u8d39", "SupplierTysbbSupportTaxTypeEnum_2", "taxc-tsate-business"), new MultiLangEnumBridge("\u5de5\u4f1a\u7b79\u5907\u91d1", "SupplierTysbbSupportTaxTypeEnum_3", "taxc-tsate-business")), DeclareTypeEnum.QTSF_TYSBB, new MultiLangEnumBridge("\u901a\u7528\u7533\u62a5\u8868\u6682\u53ea\u652f\u6301\u76f4\u8fde\u7533\u62a5\u5de5\u4f1a\u7ecf\u8d39\u3001\u5de5\u4f1a\u7b79\u5907\u91d1\uff0c\u8bf7\u8c03\u6574\u7533\u62a5\u8868\u540e\u518d\u7533\u62a5\uff1a%s\u4e0d\u7b26\u5408\u3002", "SupplierTysbbSupportTaxTypeEnum_6", "taxc-tsate-business"));

    private SupplierEnum supplier;
    private List<MultiLangEnumBridge> taxTypes;
    private DeclareTypeEnum declareType;
    private MultiLangEnumBridge failMsg;

    private SupplierTysbbSupportTaxTypeEnum(SupplierEnum supplier, List<MultiLangEnumBridge> taxTypes, DeclareTypeEnum declareType, MultiLangEnumBridge failMsg) {
        this.supplier = supplier;
        this.taxTypes = taxTypes;
        this.declareType = declareType;
        this.failMsg = failMsg;
    }

    public SupplierEnum getSupplier() {
        return this.supplier;
    }

    public List<String> getTaxTypes() {
        return this.taxTypes.stream().map(v -> v.loadKDString()).collect(Collectors.toList());
    }

    public DeclareTypeEnum getDeclareType() {
        return this.declareType;
    }

    public String getFailMsg() {
        return this.failMsg.loadKDString();
    }

    public static SupplierTysbbSupportTaxTypeEnum getTysbbSupportTaxBySupplierAndDeclareType(SupplierEnum supplier, DeclareTypeEnum declareType) {
        for (SupplierTysbbSupportTaxTypeEnum supportTaxTypeEnum : SupplierTysbbSupportTaxTypeEnum.values()) {
            if (supportTaxTypeEnum.getSupplier() != supplier || supportTaxTypeEnum.getDeclareType() != declareType) continue;
            return supportTaxTypeEnum;
        }
        return null;
    }
}

