/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare.validete.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.declare.validete.AbstractDeclareValidateService;
import kd.taxc.tsate.business.declare.validete.SupplierDeclareValidateEnum;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import org.apache.commons.collections.CollectionUtils;

public class DeclareValidateService {
    public static void validateDeclareData(List<DynamicObject> declares, Map<Long, SupplierEnum> declareSuppliers, Map<Long, String> failMsgs, Map<Long, String> riskMsgs) {
        ArrayList<DynamicObject> declaresCopy = new ArrayList<DynamicObject>(declares);
        DeclareValidateService.validateStatus(declaresCopy, declareSuppliers, failMsgs);
        DeclareValidateService.validateRisk(declaresCopy, riskMsgs);
        DeclareValidateService.specialValidateCcxws(declaresCopy, declareSuppliers, failMsgs);
        Map<String, Object> contextMap = DeclareValidateService.buildDeclareValidateContextMap(declaresCopy, declareSuppliers);
        for (DynamicObject declare : declaresCopy) {
            String declareTypeCode = DeclarationMainFormBusniess.getDeclareTypeByModel3(declare);
            DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)declareTypeCode);
            Long declareId = declare.getLong("id");
            SupplierEnum supplier = declareSuppliers.get(declareId);
            SupplierDeclareValidateEnum declareValidateEnum = SupplierDeclareValidateEnum.getBySuppplierAndDeclareType(supplier, declareType);
            if (declareValidateEnum == null || !"specialValidTysb".equals(declareValidateEnum.getValidateMethod())) continue;
            declareValidateEnum.getValidateService().specialValidTysb(declare, declareSuppliers, supplier, declareType, failMsgs, riskMsgs, contextMap);
        }
    }

    public static Map<String, Object> buildDeclareValidateContextMap(List<DynamicObject> declares, Map<Long, SupplierEnum> declareSuppliers) {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        Map<SupplierDeclareValidateEnum, List<DynamicObject>> serviceMap = declares.stream().filter(declare -> SupplierDeclareValidateEnum.getBySuppplierAndDeclareType((SupplierEnum)declareSuppliers.get(declare.getLong("id")), DeclareTypeEnum.valueOfCode((String)DeclarationMainFormBusniess.getDeclareTypeByModel3(declare))) != null).collect(Collectors.groupingBy(declare -> SupplierDeclareValidateEnum.getBySuppplierAndDeclareType((SupplierEnum)declareSuppliers.get(declare.getLong("id")), DeclareTypeEnum.valueOfCode((String)DeclarationMainFormBusniess.getDeclareTypeByModel3(declare)))));
        for (Map.Entry<SupplierDeclareValidateEnum, List<DynamicObject>> entry : serviceMap.entrySet()) {
            SupplierDeclareValidateEnum validateEnum = entry.getKey();
            List<DynamicObject> declareData = entry.getValue();
            if (validateEnum == null || CollectionUtils.isEmpty(declareData)) continue;
            Map<String, Object> serviceContextMap = validateEnum.getValidateService().buildValidateContextMap(declareData, validateEnum.getValidateMethod());
            if (!CollectionUtils.isNotEmpty(declareData)) continue;
            contextMap.put(validateEnum.getValidateService().getClass().getName() + "_" + validateEnum.getValidateMethod(), serviceContextMap);
        }
        return contextMap;
    }

    private static void specialValidateCcxws(List<DynamicObject> declares, Map<Long, SupplierEnum> declareChannels, Map<Long, String> failMsgs) {
        AbstractDeclareValidateService validateService = new AbstractDeclareValidateService();
        validateService.specialValidateCcxws(declares, declareChannels, failMsgs);
        DeclareValidateService.removeIsFailData(declares, failMsgs);
    }

    public static void validateStatus(List<DynamicObject> declares, Map<Long, SupplierEnum> declareChannels, Map<Long, String> failMsg) {
        AbstractDeclareValidateService validateService = new AbstractDeclareValidateService();
        validateService.validateStatus(declares, declareChannels, failMsg);
        DeclareValidateService.removeIsFailData(declares, failMsg);
    }

    private static void removeIsFailData(List<DynamicObject> declares, Map<Long, String> failMsg) {
        Iterator<DynamicObject> iterator = declares.iterator();
        while (iterator.hasNext()) {
            DynamicObject object = iterator.next();
            long id = object.getLong("id");
            if (!StringUtil.isNotBlank((CharSequence)failMsg.get(id))) continue;
            iterator.remove();
        }
    }

    public static void validateRisk(List<DynamicObject> declares, Map<Long, String> riskMsgs) {
        AbstractDeclareValidateService validateService = new AbstractDeclareValidateService();
        validateService.validateRisk(declares, riskMsgs);
    }
}

