/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.declare.validete.service;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.declare.validete.AbstractDeclareValidateService;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;

public class SzyhDeclareValidateService
extends AbstractDeclareValidateService {
    private static Log LOGGER = LogFactory.getLog(SzyhDeclareValidateService.class);

    @Override
    public void specialValidTysb(DynamicObject declare, Map<Long, SupplierEnum> declareSuppliers, SupplierEnum supplier, DeclareTypeEnum declareType, Map<Long, String> failMsgs, Map<Long, String> riskMsgs, Map<String, Object> context) {
        DynamicObject tysbbDeclare = this.getTysbDataWithOutBillStatus(declare);
        if (tysbbDeclare != null) {
            if (this.validateTysbNotAudit(tysbbDeclare, failMsgs)) {
                return;
            }
            declareSuppliers.put(tysbbDeclare.getLong("id"), SupplierEnum.SZYH);
            this.validateStatus(Collections.singletonList(tysbbDeclare), declareSuppliers, failMsgs);
            this.validateRisk(Collections.singletonList(tysbbDeclare), riskMsgs);
        }
    }

    public Map<String, Object> buildValidateContextMap(List<DynamicObject> declares) {
        return new HashMap<String, Object>(16);
    }

    private DynamicObject getTysbDataWithOutBillStatus(DynamicObject declare) {
        return this.dealTysbb(declare, true);
    }

    private DynamicObject dealTysbb(DynamicObject declare, boolean isValidate) {
        try {
            if (declare != null) {
                DynamicObject channelObj;
                DynamicObject org = declare.getDynamicObject("org");
                Date skssqq = declare.getDate("skssqq");
                Date skssqz = declare.getDate("skssqz");
                QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                QFilter billstatusFilter = null;
                if (!isValidate) {
                    billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
                }
                QFilter declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0");
                QFilter delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared");
                QFilter typeFilter = "qtsf_fsstysbb".equals(DeclarationMainFormBusniess.getDeclareTypeByModel3(declare)) ? new QFilter("type", "=", (Object)"qtsf_tysbb") : new QFilter("type", "=", (Object)"qtsf_fsstysbb");
                QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
                DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tsate_declare_query_list", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_query_list"), (QFilter[])new QFilter[]{qFilter, typeFilter, skssqqzFilter, declareTypeQfilter, billstatusFilter, delcareStatusQfilter});
                if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                    String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                    if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                        return tysbDeclare;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5408\u5e76\u5904\u7406\u5931\u8d25", (String)"SzyhDeclareValidateService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
        }
        return null;
    }

    private boolean validateTysbNotAudit(DynamicObject tysbbDeclare, Map<Long, String> failMsgs) {
        if (!"C".equals(tysbbDeclare.getString("billstatus"))) {
            String type = DeclarationMainFormBusniess.getDeclareTypeByModel3(tysbbDeclare);
            String orgName = tysbbDeclare.getString("org.name");
            String billNo = tysbbDeclare.getString("billno");
            String typeName = null;
            DeclareTypeEnum typeEnum = DeclareTypeEnum.valueOfCode((String)type);
            if (typeEnum != null) {
                typeName = typeEnum.getName();
            }
            StringBuilder erroMsg = new StringBuilder();
            erroMsg.append(orgName).append(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5ba1\u6838\u7684", (String)"SzyhDeclareValidateService_1", (String)"taxc-tsate-business", (Object[])new Object[0])).append(typeName).append(billNo).append("\uff0c").append(ResManager.loadKDString((String)"\u65e0\u6cd5\u5408\u5e76\u63d0\u4ea4\u7533\u62a5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SzyhDeclareValidateService_2", (String)"taxc-tsate-business", (Object[])new Object[0]));
            failMsgs.put(tysbbDeclare.getLong("id"), erroMsg.toString());
            return true;
        }
        return false;
    }
}

