/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.enums.StatusChangedEventEnum;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class DeclareMainStatusChangedEventBusiness {
    private static Log logger = LogFactory.getLog(DeclareMainStatusChangedEventBusiness.class);
    public static final String CHANGE_STATUS_FIELDS = "declarestatus,paystatus";
    public static final String EVENT_NUMBER = "taxc_tsate_status_changed";

    public static DynamicObject copyData(DynamicObject declare) {
        if (declare == null) {
            return null;
        }
        CloneUtils cloneUtils = new CloneUtils(false, false);
        return (DynamicObject)cloneUtils.clone((IDataEntityBase)declare);
    }

    public static void batchConvertDataAndSendEvent(List<DynamicObject> oldDatas, List<DynamicObject> newDatas) {
        ArrayList<Map<String, String>> eventData = new ArrayList<Map<String, String>>();
        for (DynamicObject oldData : oldDatas) {
            for (DynamicObject newData : newDatas) {
                if (!StringUtil.equals((CharSequence)newData.getString("id"), (CharSequence)oldData.getString("id"))) continue;
                eventData.addAll(DeclareMainStatusChangedEventBusiness.buildEventData(oldData, newData));
            }
        }
        DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent(eventData);
    }

    public static void convertDataAndSendEvent(DynamicObject oldData, DynamicObject newData) {
        DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent(DeclareMainStatusChangedEventBusiness.buildEventData(oldData, newData));
    }

    private static void convertDataAndSendEvent(List<Map<String, String>> changeData) {
        DeclareMainStatusChangedEventBusiness.convertDataAndSendEvent(changeData, "");
    }

    public static void convertDataAndSendEvent(List<Map<String, String>> changeData, String head) {
        if (CollectionUtils.isEmpty(changeData)) {
            return;
        }
        HashMap<String, Object> eventMap = new HashMap<String, Object>();
        eventMap.put("head", head);
        eventMap.put("changeData", changeData);
        try {
            logger.info("start push changeEvent");
            EventServiceHelper.triggerEventSubscribe((String)EVENT_NUMBER, (String)SerializationUtils.toJsonString(eventMap));
        }
        catch (Exception e) {
            logger.error("push mainStatusChangedEvent error:{}", (Object)ExceptionUtil.toString((Exception)e));
            throw new KDBizException("push mainStatusChangedEvent error:" + e.getMessage());
        }
    }

    public static List<Map<String, String>> buildEventData(DynamicObject oldData, DynamicObject newData) {
        String[] statusFields;
        ArrayList<Map<String, String>> eventData = new ArrayList<Map<String, String>>();
        if (oldData == null || newData == null) {
            return eventData;
        }
        Map<String, String> commonDataMap = DeclareMainStatusChangedEventBusiness.buildCommData(oldData);
        for (String statusFiled : statusFields = CHANGE_STATUS_FIELDS.split(",")) {
            String oldStatus = oldData.getString(statusFiled);
            String newStatus = newData.getString(statusFiled);
            if (oldStatus == null || newStatus == null || oldStatus.equals(newStatus)) continue;
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("changeType", statusFiled);
            dataMap.put("oldStatus", oldStatus);
            dataMap.put("newStatus", newStatus);
            dataMap.putAll(commonDataMap);
            eventData.add(dataMap);
        }
        logger.info("row changeData ={}", (Object)SerializationUtils.toJsonString(eventData));
        return eventData;
    }

    private static Map<String, String> buildCommData(DynamicObject oldData) {
        HashMap<String, String> commonDataMap = new HashMap<String, String>(8);
        for (StatusChangedEventEnum eventEnum : StatusChangedEventEnum.values()) {
            String mainDataFiled = eventEnum.getMainDataFiled();
            String eventField = eventEnum.getEventField();
            if ("tpo_declare_main_tsc".equals(oldData.getDataEntityType().getName()) && eventEnum == StatusChangedEventEnum.DECLARE_TYPE) {
                commonDataMap.put(eventField, oldData.getString("templatetype.id"));
                continue;
            }
            String eventFieldValue = oldData.getString(mainDataFiled);
            commonDataMap.put(eventField, eventFieldValue);
        }
        return commonDataMap;
    }
}

