/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.event;

import java.util.HashMap;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.workflow.EventServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class FKXXChangedEventBusiness {
    private static Log logger = LogFactory.getLog(FKXXChangedEventBusiness.class);
    public static final String EVENT_NUMBER = "taxc_tsate_fkxx_changed";

    public static void convertDataAndSendEvent(SupplierEnum supplier, String oldFkxx, String newFkxx) {
        try {
            if (StringUtils.isEmpty((String)newFkxx)) {
                return;
            }
            if (newFkxx.equals(oldFkxx)) {
                return;
            }
            FKXXChangedEventBusiness.dealFKXX(supplier, newFkxx);
            HashMap<String, String> eventMap = new HashMap<String, String>();
            eventMap.put("supplierType", supplier == null ? "" : supplier.getCode());
            eventMap.put("changeData", newFkxx);
            logger.info("start push taxc_tsate_fkxx_changed changeEvent");
            EventServiceHelper.triggerEventSubscribe((String)EVENT_NUMBER, (String)SerializationUtils.toJsonString(eventMap));
        }
        catch (Exception e) {
            logger.error("push taxc_tsate_fkxx_changed error:{}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }

    public static void dealFKXX(SupplierEnum supplier, String fkxx) {
        if (supplier == null) {
            return;
        }
    }
}

