/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.exportdeclaration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationInputDataHandlerService;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationService;
import kd.taxc.tsate.common.helper.TaxResultBuilder;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationRespVo;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationTaskVo;
import kd.taxc.tsate.common.util.ExceptionUtil;

public class AbstractExportDeclarationService
implements ExportDeclarationService {
    private static final Log logger = LogFactory.getLog(AbstractExportDeclarationService.class);
    private Integer batchPageSize = 5;
    private Boolean continueBatch = true;
    private Boolean isScheduleSync = false;
    private ExportDeclarationInputDataHandlerService exportInputService;

    public AbstractExportDeclarationService(ExportDeclarationInputDataHandlerService exportInputService, Boolean isScheduleSync) {
        this.exportInputService = exportInputService;
        this.isScheduleSync = isScheduleSync;
    }

    public AbstractExportDeclarationService(Integer batchPageSize, Boolean continueBatch, ExportDeclarationInputDataHandlerService exportInputService) {
        this.batchPageSize = batchPageSize;
        this.continueBatch = continueBatch;
        this.exportInputService = exportInputService;
    }

    public AbstractExportDeclarationService(Integer batchPageSize, ExportDeclarationInputDataHandlerService exportInputService) {
        this.batchPageSize = batchPageSize;
        this.exportInputService = exportInputService;
    }

    public TaxResult<ExportDeclarationRespVo> downLoadExportDeclaration(ExportDeclarationTaskVo vo, List batchData) {
        return TaxResultBuilder.buildFailedResult();
    }

    public TaxResult dataHandle(TaxResult data, ExportDeclarationTaskVo vo) {
        return TaxResultBuilder.buildFailedResult();
    }

    public TaxResult<List> getAllExportDeclarationForBatch(ExportDeclarationTaskVo vo) {
        return TaxResultBuilder.buildSuccessResultAndSetDate(Collections.singletonList(1));
    }

    public TaxResult doBusiness(ExportDeclarationTaskVo vo) {
        logger.info("downLoadExportDeclaration vo={}", (Object)JSON.toJSONString((Object)vo));
        if (vo.getScheduleSync().booleanValue()) {
            return this.ScheduleSyncDownLoad(vo);
        }
        TaxResult taskResult = this.batchDownLoadExportDeclaration(vo);
        if (!this.isScheduleSync.booleanValue() || !taskResult.isSuccess()) {
            TsateDeclareRecordBusiness.updateRecordByTaxResult(taskResult, vo.getRecordId());
        }
        return taskResult;
    }

    private TaxResult ScheduleSyncDownLoad(ExportDeclarationTaskVo vo) {
        JSONArray downLoadData;
        Long recordId = vo.getRecordId();
        DynamicObject record = TsateDeclareRecordBusiness.getRecordById(recordId);
        String detailLogTag = record.getString("detaillog_tag");
        String detailLog = record.getString("detaillog");
        JSONObject detailJson = JSON.parseObject((String)detailLogTag);
        JSONObject pageInfo = new JSONObject();
        JSONArray jSONArray = downLoadData = detailJson.getJSONArray("downLoadData") == null ? new JSONArray() : detailJson.getJSONArray("downLoadData");
        if (StringUtil.isBlank((CharSequence)detailLogTag) || downLoadData.isEmpty()) {
            TsateDeclareRecordBusiness.updateRecordByBoolean(recordId, ResManager.loadKDString((String)"\u4efb\u52a1\u672a\u83b7\u53d6\u5230\u6709\u6548\u5904\u7406\u6570\u636e\u3002", (String)"AbstractExportDeclarationService_8", (String)"taxc-tsate-business", (Object[])new Object[0]), null, false);
            return TaxResultBuilder.buildFailedResult();
        }
        int total = detailJson.getInteger("total") == null ? 0 : detailJson.getInteger("total");
        JSONObject jsonObject = StringUtil.isBlank((CharSequence)detailLog) ? new JSONObject() : JSON.parseObject((String)detailLog);
        Integer index = jsonObject.getInteger("index") == null ? Integer.valueOf(0) : jsonObject.getInteger("index");
        Integer successSize = jsonObject.getInteger("successSize") == null ? Integer.valueOf(0) : jsonObject.getInteger("successSize");
        Boolean isSuccess = jsonObject.getBoolean("isSuccess") == null ? Boolean.TRUE : jsonObject.getBoolean("isSuccess");
        ArrayList<Object> oneBatchData = new ArrayList<Object>();
        for (int i = 0; i < vo.getSchPageSize() && index < downLoadData.size(); ++i) {
            oneBatchData.add(downLoadData.get(index.intValue()));
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
        pageInfo.put("index", (Object)index);
        TaxResult<ExportDeclarationRespVo> result = this.getABatchTaskResult(vo, oneBatchData);
        Integer batchSuccessSize = result.getData() == null || ((ExportDeclarationRespVo)result.getData()).getSuccessSaveSize() == null ? Integer.valueOf(0) : ((ExportDeclarationRespVo)result.getData()).getSuccessSaveSize();
        successSize = successSize + batchSuccessSize;
        pageInfo.put("successSize", (Object)successSize);
        isSuccess = isSuccess != false && result.isSuccess();
        pageInfo.put("isSuccess", (Object)isSuccess);
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"\u53ef\u91c7\u96c6\u5173\u5355\u6570\uff1a%1$s\u6761\u3002\u6709\u6548\u5173\u5355\u6570\uff1a%2$s\u6761\u3002\u5f53\u524d\u4e0b\u8f7d\u5230\u7b2c%3$s\u6761\u3002\u91c7\u96c6\u6210\u529f\u5173\u5355\u6570\uff1a%4$s", (String)"AbstractExportDeclarationService_9", (String)"taxc-tsate-business", (Object[])new Object[]{total, downLoadData.size(), index, successSize}));
        msg.append(System.lineSeparator());
        if (StringUtil.isNotBlank((CharSequence)result.getMessage())) {
            msg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6279\u6b21\u5904\u7406\u7ed3\u679c", (String)"AbstractExportDeclarationService_13", (String)"taxc-tsate-business", (Object[])new Object[0])).append(result.getMessage());
        }
        if (index < downLoadData.size()) {
            isSuccess = null;
        }
        TsateDeclareRecordBusiness.updateRecordByBoolean(recordId, msg.toString(), JSON.toJSONString((Object)pageInfo), isSuccess);
        return result;
    }

    private TaxResult batchDownLoadExportDeclaration(ExportDeclarationTaskVo vo) {
        TaxResult<List> forBatchResult;
        TaxResult taskResult = TaxResultBuilder.buildFailedResult();
        try {
            forBatchResult = this.getAllExportDeclarationForBatch(vo);
        }
        catch (Exception e) {
            logger.error("getAllExportDeclarationForBatch error\uff1a{}", (Object)ExceptionUtil.toString((Exception)e));
            taskResult.setMessage(String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5904\u7406\u5f02\u5e38\uff1a%1$s", (String)"AbstractExportDeclarationService_14", (String)"taxc-tsate-business", (Object[])new Object[0]), e.getMessage()));
            return taskResult;
        }
        if (!forBatchResult.isSuccess()) {
            taskResult.setMessage(forBatchResult.getMessage());
            return taskResult;
        }
        List batchData = (List)forBatchResult.getData();
        if (CollectionUtils.isEmpty((Collection)batchData)) {
            taskResult.setMessage(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u627e\u5230\u6709\u6548\u62a5\u5173\u5355\u6570\u636e\u3002", (String)"AbstractExportDeclarationService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return taskResult;
        }
        this.dealBusinessLog(batchData, vo.getRecordId(), "downLoadData");
        if (this.isScheduleSync.booleanValue()) {
            return forBatchResult;
        }
        StringBuilder errorMsg = new StringBuilder();
        List batchPartition1 = Lists.partition((List)batchData, (int)this.batchPageSize);
        ArrayList failDeclarationData = new ArrayList(64);
        int pageNo = 0;
        for (List oneBatchData : batchPartition1) {
            logger.info("ExportDeclaration dataHandle pageNo={} aBatchList={}", (Object)pageNo, (Object)JSON.toJSONString((Object)oneBatchData));
            TaxResult<ExportDeclarationRespVo> result = this.getABatchTaskResult(vo, oneBatchData);
            failDeclarationData.addAll(((ExportDeclarationRespVo)result.getData()).getFailDeclarationData());
            ++pageNo;
            if (result.isSuccess()) continue;
            errorMsg.append(ResManager.loadKDString((String)"\u6279\u6b21\uff1a%1$s\uff0c\u91c7\u96c6\u5931\u8d25\uff1a%2$s", (String)"AbstractExportDeclarationService_3", (String)"taxc-tsate-business", (Object[])new Object[]{pageNo, result.getMessage()}));
            errorMsg.append(System.lineSeparator());
            if (this.continueBatch.booleanValue()) continue;
            break;
        }
        this.dealBusinessLog(failDeclarationData, vo.getRecordId(), "failData");
        if (StringUtil.isBlank((CharSequence)errorMsg.toString())) {
            taskResult.setSuccess(true);
        }
        taskResult.setMessage(errorMsg.toString());
        return taskResult;
    }

    private TaxResult<ExportDeclarationRespVo> getABatchTaskResult(ExportDeclarationTaskVo vo, List batchData) {
        TaxResult dataHandleResult;
        TaxResult<ExportDeclarationRespVo> result;
        TaxResult taskResult = TaxResultBuilder.buildFailedResult();
        try {
            result = this.downLoadExportDeclaration(vo, batchData);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u5904\u7406\u5f02\u5e38\uff1a%1$s", (String)"AbstractExportDeclarationService_14", (String)"taxc-tsate-business", (Object[])new Object[0]), e.getMessage());
            logger.error("downLoadExportDeclaration error\uff1a{}", (Object)ExceptionUtil.toString((Exception)e));
            taskResult.setMessage(msg);
            return taskResult;
        }
        logger.info("downLoadExportDeclaration 1,downLoadExportDeclaration ,result  success={} msg={},data={}", new Object[]{result.isSuccess(), result.getMessage(), JSON.toJSONString((Object)result.getData())});
        if (!result.isSuccess()) {
            taskResult.setMessage(result.getMessage());
            return taskResult;
        }
        ExportDeclarationRespVo respData = (ExportDeclarationRespVo)result.getData();
        taskResult.setData((Object)respData);
        try {
            dataHandleResult = this.exportInputService.dataHandle(respData.getExportDeclarationData(), vo);
        }
        catch (Exception e) {
            String msg = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u8c03\u7528\u5904\u7406\u5f02\u5e38\uff1a%1$s", (String)"AbstractExportDeclarationService_1", (String)"taxc-tsate-business", (Object[])new Object[0]), e.getMessage());
            logger.error("exportDeclaration dataHandle error\uff1a{}", (Object)ExceptionUtil.toString((Exception)e));
            taskResult.setMessage(msg);
            return taskResult;
        }
        respData.setSuccessSaveSize((Integer)dataHandleResult.getData());
        taskResult.setData((Object)respData);
        logger.info("downLoadExportDeclaration 2,dataHandle,result  success={} msg={},data={}", new Object[]{dataHandleResult.isSuccess(), dataHandleResult.getMessage(), JSON.toJSONString((Object)dataHandleResult.getData())});
        if (!dataHandleResult.isSuccess()) {
            taskResult.setMessage(dataHandleResult.getMessage());
            return taskResult;
        }
        taskResult.setSuccess(true);
        taskResult.setMessage(this.getSuccessMsg(dataHandleResult));
        return taskResult;
    }

    private String getSuccessMsg(TaxResult result) {
        return result.getMessage();
    }

    private void dealBusinessLog(List result, Long recordId, String key) {
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        try {
            TsateDeclareRecordBusiness.dealDetailLog(result, recordId, key, null);
        }
        catch (Exception e) {
            logger.error("exportDeclaration dealBusniesslLog error\uff1a{}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }

    public static void saveTotalCount(int total, Long recordId) {
        try {
            StringBuilder builder = new StringBuilder(ResManager.loadKDString((String)"\u53ef\u91c7\u96c6\u5173\u5355\u6570\uff1a%1$s\uff0c\u5f00\u59cb\u4e0b\u8f7d\u3002", (String)"AbstractExportDeclarationService_15", (String)"taxc-tsate-business", (Object[])new Object[]{total}));
            TsateDeclareRecordBusiness.dealDetailLog(total, recordId, "total", builder.toString());
        }
        catch (Exception e) {
            logger.error("exportDeclaration dealBusniesslLog error\uff1a{}", (Object)ExceptionUtil.toString((Exception)e));
        }
    }
}

