/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.exportdeclaration;

import com.alibaba.fastjson.JSON;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.tsate.business.BastaxTaxorgBusiness;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationService;
import kd.taxc.tsate.business.exportdeclaration.enums.ExportDeclarationServiceSuppilerEnum;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.task.TaskBaseVo;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationTaskVo;
import kd.taxc.tsate.common.util.JobUtils;

public class ExportDeclarationBusiness {
    public static void downloadExportDeclaration(Map<String, Object> originParams) {
        ExportDeclarationTaskVo vo = (ExportDeclarationTaskVo)JSON.parseObject((String)((String)originParams.get("vo")), ExportDeclarationTaskVo.class);
        vo.setAsyn(Boolean.valueOf(false));
        if (originParams.containsKey("isScheduleSync")) {
            vo.setScheduleSync(Boolean.valueOf(true));
            vo.setSchPageSize((Integer)originParams.get("syncPageSize"));
            vo.setRecordId((Long)originParams.get("recordId"));
        }
        ExportDeclarationBusiness.downloadExportDeclaration(vo);
    }

    public static void downloadExportDeclaration(Long orgId, Date startUpdateDate, Date endUpdateDate, String exportDeclarationno, String clearanceStatus, Boolean isSync) {
        ExportDeclarationTaskVo declarationTaskVo = new ExportDeclarationTaskVo(orgId, "", ExecuteTypeEnums.CKBGDXZ, null, startUpdateDate, endUpdateDate, exportDeclarationno, clearanceStatus);
        declarationTaskVo.setSupplier(ExportDeclarationBusiness.getSuppiler(declarationTaskVo));
        if (isSync.booleanValue()) {
            declarationTaskVo.setAsyn(Boolean.valueOf(false));
        }
        ExportDeclarationBusiness.downloadExportDeclaration(declarationTaskVo);
    }

    private static SupplierEnum getSuppiler(ExportDeclarationTaskVo declarationTaskVo) {
        return SupplierEnum.CMS;
    }

    private static void downloadExportDeclaration(ExportDeclarationTaskVo vo) {
        if (vo.getAsyn().booleanValue()) {
            ExportDeclarationBusiness.asynDownloadExportDeclaration(vo);
            return;
        }
        if (!vo.getScheduleSync().booleanValue()) {
            DynamicObject recordByTaskBaseVo = TsateDeclareRecordBusiness.saveNewRecordByTaskBaseVo((TaskBaseVo)vo);
            DynamicObject temp = BastaxTaxorgBusiness.queryTaxcOrgInfoByOrgId(vo.getOrgId());
            if (temp != null) {
                vo.setNsrsbh(temp.getString("entry_unifiedsocialcode"));
            }
            vo.setRecordId(Long.valueOf(recordByTaskBaseVo.getLong("id")));
        }
        ExportDeclarationService exportDeclarationService = ExportDeclarationServiceSuppilerEnum.getExportDeclarationServiceBySupplier(vo.getSupplier());
        exportDeclarationService.doBusiness(vo);
    }

    private static void asynDownloadExportDeclaration(ExportDeclarationTaskVo vo) {
        HashMap<String, String> originParams = new HashMap<String, String>(16);
        originParams.put("key", vo.getExecuteType().getExecuteType());
        originParams.put("vo", JSON.toJSONString((Object)vo));
        JobUtils.submitJob(originParams);
    }
}

