/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.exportdeclaration.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import org.apache.commons.collections.CollectionUtils;

public class BgdHelper {
    public static Long getCurrency(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bd_currency", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return null;
    }

    public static Long getOrg(String code) {
        TaxResult ids = TaxcOrgDataServiceHelper.queryTaxcOrgIdByUnifiedsocialcode(Collections.singletonList(code));
        if (ids.isSuccess()) {
            if (((List)ids.getData()).size() == 0) {
                return 0L;
            }
            return (Long)((List)ids.getData()).get(0);
        }
        return 0L;
    }

    public static Object getOrgByName(String name) {
        TaxResult dyns = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgName(Collections.singletonList(name));
        if (dyns.isSuccess() && dyns.getData() != null && ((DynamicObject[])dyns.getData()).length > 0) {
            return ((DynamicObject[])dyns.getData())[0].getLong("id");
        }
        return 0L;
    }

    public static Object getOrgByFirmName(String name) {
        TaxResult dyns = TaxcOrgDataServiceHelper.queryTaxcOrgByFirmName(Collections.singletonList(name));
        if (dyns.isSuccess() && dyns.getData() != null && ((DynamicObject[])dyns.getData()).length > 0) {
            return ((DynamicObject[])dyns.getData())[0].getLong("id");
        }
        return 0L;
    }

    public static Long getCustomer(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return 0L;
    }

    public static Object getCustomerByName(String name) {
        QFilter f = new QFilter("name", "=", (Object)name);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bd_customer", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return 0L;
    }

    public static Long getUnit(SupplierEnum supplier, String code) {
        QFilter f = new QFilter("jldwnumber", "=", (Object)code);
        f.and("suppliernumber", "=", (Object)supplier.getName());
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"tdm_setting_jldw", (String)"unitfield.id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("unitfield.id");
        }
        return 0L;
    }

    public static Long getSupervision(String code) {
        QFilter f = new QFilter("number", "=", (Object)code);
        DynamicObject[] dyns = BusinessDataServiceHelper.load((String)"bastax_supervision", (String)"id", (QFilter[])new QFilter[]{f});
        if (dyns.length > 0) {
            return dyns[0].getLong("id");
        }
        return 0L;
    }

    public static Long getGoods(Date sbrq, String code) {
        QFilter f2;
        QFilter f1;
        DynamicObject[] dyns;
        if (StringUtils.isNotEmpty((String)code) && code.length() == 10) {
            code = code.substring(0, 8);
        }
        if ((dyns = BusinessDataServiceHelper.load((String)"bastax_hscode", (String)"id,startdate,enddate", (QFilter[])new QFilter[]{f1 = new QFilter("number", "=", (Object)code), f2 = new QFilter("enable", "=", (Object)"1")})).length > 0) {
            if (sbrq != null) {
                for (DynamicObject dyn : dyns) {
                    Date start = dyn.getDate("startdate");
                    Date end = dyn.getDate("enddate");
                    if (start == null || end == null || sbrq.before(start) || sbrq.after(end)) continue;
                    return dyn.getLong("id");
                }
            }
            return 0L;
        }
        return 0L;
    }

    public static List<String> getAuditedNos(List<String> exportDeclarationNos) {
        QFilter qFilter = new QFilter("billno", "in", exportDeclarationNos).and("billstatus", "=", (Object)"C");
        DynamicObjectCollection exportDeclarationAuditedData = QueryServiceHelper.query((String)"tdm_export_declaration", (String)"id,billno", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)exportDeclarationAuditedData)) {
            return new ArrayList<String>();
        }
        return exportDeclarationAuditedData.stream().map(o -> o.getString("billno")).collect(Collectors.toList());
    }
}

