/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.exportdeclaration.cms;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.business.api.cms.exportdeclaration.CmsExportDeclarationAPl;
import kd.taxc.tsate.business.exportdeclaration.AbstractExportDeclarationService;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationInputDataHandlerService;
import kd.taxc.tsate.business.exportdeclaration.cms.BgdHelper;
import kd.taxc.tsate.common.api.cms.CmsRepVo;
import kd.taxc.tsate.common.helper.TaxResultBuilder;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationRespVo;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationTaskVo;
import kd.taxc.tsate.common.util.DateUtils;

public class CmsExportDeclarationService
extends AbstractExportDeclarationService {
    private static final Log logger = LogFactory.getLog(CmsExportDeclarationService.class);

    public CmsExportDeclarationService(ExportDeclarationInputDataHandlerService exportInputService) {
        super(exportInputService, true);
    }

    public CmsExportDeclarationService(Integer batchPageSize, Boolean continueBatch, ExportDeclarationInputDataHandlerService exportInputService) {
        super(batchPageSize, continueBatch, exportInputService);
    }

    public CmsExportDeclarationService(Integer batchPageSize, ExportDeclarationInputDataHandlerService exportInputService) {
        super(batchPageSize, exportInputService);
    }

    @Override
    public TaxResult<List> getAllExportDeclarationForBatch(ExportDeclarationTaskVo vo) {
        TaxResult result = TaxResultBuilder.buildFailedResult();
        if (StringUtil.isBlank((CharSequence)vo.getNsrsbh())) {
            result.setMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7a0e\u52a1\u7ec4\u7ec7\u7a0e\u53f7\u3002", (String)"CmsExportDeclarationService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return result;
        }
        int pageNo = 1;
        int pageSize = 30;
        HashMap<String, String> entryIdDecNoMap = new HashMap<String, String>();
        TaxResult<CmsRepVo> declSwList = this.getDeclSwList(vo, pageNo);
        if (!declSwList.isSuccess()) {
            result.setMessage(String.format(ResManager.loadKDString((String)"\u5206\u6279\u4e0b\u8f7d\u4e2d\u5b58\u5728\u5931\u8d25\u6279\u6b21\uff1a\u7b2c%s\u6279\u51fa\u9519\u3002\u539f\u56e0\uff1a%s", (String)"CmsExportDeclarationService_1", (String)"taxc-tsate-business", (Object[])new Object[0]), pageNo, declSwList.getMessage()));
            return result;
        }
        this.setDecNoListByResult(entryIdDecNoMap, declSwList);
        int total = ((CmsRepVo)declSwList.getData()).getJSONObjectData().getInteger("Total");
        if (total == 0) {
            result.setMessage(ResManager.loadKDString((String)"\u6839\u636e\u6761\u4ef6\u672a\u627e\u5230\u62a5\u5173\u5355\uff0c\u8bf7\u8c03\u6574\u540e\u4e0b\u8f7d\u3002", (String)"CmsExportDeclarationService_2", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return result;
        }
        while (pageNo * pageSize < total) {
            TaxResult<CmsRepVo> pageResult = this.getDeclSwList(vo, ++pageNo);
            logger.info("CMS downLoadExportDeclaration pageNo={},result success={} msg={},data={}", new Object[]{pageNo, pageResult.isSuccess(), pageResult.getMessage(), JSON.toJSONString((Object)((CmsRepVo)pageResult.getData()).getData())});
            if (!pageResult.isSuccess()) {
                result.setMessage(String.format(ResManager.loadKDString((String)"\u5206\u6279\u4e0b\u8f7d\u4e2d\u5b58\u5728\u5931\u8d25\u6279\u6b21\uff1a\u7b2c%s\u6279\u51fa\u9519\u3002\u539f\u56e0\uff1a%s", (String)"CmsExportDeclarationService_1", (String)"taxc-tsate-business", (Object[])new Object[0]), pageNo, pageResult.getMessage()));
                return result;
            }
            this.setDecNoListByResult(entryIdDecNoMap, pageResult);
        }
        CmsExportDeclarationService.saveTotalCount(total, vo.getRecordId());
        result.setData(this.filterAuditedData(entryIdDecNoMap));
        result.setSuccess(true);
        return result;
    }

    private List<String> filterAuditedData(Map<String, String> entryIdDecNoMap) {
        List<String> entryIds = entryIdDecNoMap.entrySet().stream().map(o -> (String)o.getKey()).collect(Collectors.toList());
        List<String> auditedNos = BgdHelper.getAuditedNos(entryIds);
        for (String auditedNo : auditedNos) {
            entryIdDecNoMap.remove(auditedNo);
        }
        return entryIdDecNoMap.entrySet().stream().map(o -> (String)o.getValue()).collect(Collectors.toList());
    }

    @Override
    public TaxResult<ExportDeclarationRespVo> downLoadExportDeclaration(ExportDeclarationTaskVo vo, List batchData) {
        TaxResult<ExportDeclarationRespVo> dataHandleResult = super.downLoadExportDeclaration(vo, batchData);
        TaxResult<CmsRepVo> declSwData = CmsExportDeclarationAPl.getDeclSwData(batchData);
        JSONArray respData = ((CmsRepVo)declSwData.getData()).getJSONArraryData();
        if (!declSwData.isSuccess()) {
            StringBuilder errorMsg = new StringBuilder();
            this.buildErrorMsgByDataResuilt(declSwData, errorMsg, batchData);
            dataHandleResult.setMessage(errorMsg.toString());
            return dataHandleResult;
        }
        ExportDeclarationRespVo respVo = new ExportDeclarationRespVo();
        ArrayList<String> failData = new ArrayList<String>();
        ArrayList<Object> successData = new ArrayList<Object>();
        for (int i = 0; i < respData.size(); ++i) {
            JSONObject respJson = respData.getJSONObject(i);
            if (respJson.getJSONObject("DecData") == null) {
                failData.add(respJson.getString("DecNo"));
                continue;
            }
            successData.add(respJson.toJavaObject(Map.class));
        }
        respVo.setFailDeclarationData(failData);
        respVo.setExportDeclarationData(successData);
        dataHandleResult.setSuccess(true);
        dataHandleResult.setData((Object)respVo);
        return dataHandleResult;
    }

    private TaxResult<CmsRepVo> getDeclSwList(ExportDeclarationTaskVo vo, int pageNo) {
        return CmsExportDeclarationAPl.getDeclSwList(DateUtils.format((Date)vo.getStartUpdateDate()), DateUtils.format((Date)vo.getEndUpdateDate()), pageNo, vo.getNsrsbh(), vo.getClearanceStatus(), vo.getExportDeclarationNo());
    }

    private void setDecNoListByResult(Map<String, String> entryIdDecNoMap, TaxResult<CmsRepVo> declSwList) {
        JSONArray rows = ((CmsRepVo)declSwList.getData()).getJSONObjectData().getJSONArray("Rows");
        for (Object row : rows) {
            JSONObject rowObj = (JSONObject)row;
            String entryId = rowObj.getString("EntryId");
            if (!StringUtil.isNotBlank((CharSequence)entryId)) continue;
            entryIdDecNoMap.put(entryId, rowObj.getString("CusCiqNo"));
        }
    }

    private void buildErrorMsgByDataResuilt(TaxResult<CmsRepVo> declSwData, StringBuilder errorMsg, List<String> decNoListPage) {
        errorMsg.append(ResManager.loadKDString((String)"\u5355\u53f7\uff1a", (String)"CmsExportDeclarationService_3", (String)"taxc-tsate-business", (Object[])new Object[0]));
        for (String s : decNoListPage) {
            errorMsg.append(s).append(",");
        }
        errorMsg.append(ResManager.loadKDString((String)"\u83b7\u53d6\u62a5\u5173\u5355\u6570\u636e\u9519\u8bef\uff1a", (String)"CmsExportDeclarationService_4", (String)"taxc-tsate-business", (Object[])new Object[0])).append(declSwData.getMessage()).append(System.lineSeparator());
    }
}

