/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.exportdeclaration.cms;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.tsate.business.exportdeclaration.AbstractExportDeclarationInputDataHandlerService;
import kd.taxc.tsate.business.exportdeclaration.cms.BgdHelper;
import kd.taxc.tsate.business.vmtemplate.VmTemplateUtils;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.task.TaskBaseVo;
import kd.taxc.tsate.common.task.exportdeclaration.ExportDeclarationTaskVo;
import kd.taxc.tsate.common.util.XmlUtil;

public class CmsInputDataHandlerService
extends AbstractExportDeclarationInputDataHandlerService {
    private static final Log logger = LogFactory.getLog(CmsInputDataHandlerService.class);
    private static final String KEY_ORG = "org";

    private static void dealBgds(Map<String, Object> bgdMap, Map<String, Object> customeParams) {
        CmsInputDataHandlerService.dealFilds(bgdMap, "declarationdate", bgdvalue -> DateUtils.stringToDate((String)CmsInputDataHandlerService.parseDateStr((String)bgdvalue, new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy-MM-dd"))));
        CmsInputDataHandlerService.dealFilds(bgdMap, "exportdate", bgdvalue -> DateUtils.stringToDate((String)CmsInputDataHandlerService.parseDateStr((String)bgdvalue, new SimpleDateFormat("yyyyMMdd"), new SimpleDateFormat("yyyy-MM-dd"))));
        CmsInputDataHandlerService.dealFilds(bgdMap, KEY_ORG, bgdvalue -> customeParams.get(KEY_ORG));
        CmsInputDataHandlerService.dealFilds(bgdMap, "consignor", bgdvalue -> BgdHelper.getOrgByFirmName((String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(bgdMap, "consignee", bgdvalue -> BgdHelper.getCustomerByName((String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(bgdMap, "premiumcurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(bgdMap, "sundrycurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(bgdMap, "freightcurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(bgdMap, "supervision", bgdvalue -> BgdHelper.getSupervision((String)bgdvalue));
    }

    private static StringBuilder getErro(List<Map<String, Object>> saveInfos) {
        StringBuilder err = new StringBuilder();
        HashSet<String> errSet = new HashSet<String>(16);
        for (Map<String, Object> info : saveInfos) {
            Boolean success = (Boolean)info.get("success");
            String billNo = (String)info.get("billNo");
            String msg = (String)info.get("msg");
            if (!errSet.add(msg) || success == null || success.booleanValue()) continue;
            if (err.length() > 0) {
                err.append(",");
            }
            err.append(billNo).append(":").append(msg);
        }
        return err;
    }

    private static List<Map<String, Object>> formatReqData(List<Map> reqData) {
        ArrayList<Map<String, Object>> target = new ArrayList<Map<String, Object>>(10);
        for (Map item : reqData) {
            Map decData = (Map)item.get("DecData");
            if (decData == null) {
                logger.info("formatReqData\u672a\u83b7\u53d6\u5230\u62a5\u5173\u5355\u6570\u636e\uff1a" + item.get("Message"));
                continue;
            }
            target.add(decData);
        }
        return target;
    }

    private static List<Map<String, Object>> transferData(Map<String, Object> map, ExportDeclarationTaskVo vo) {
        String data = VmTemplateUtils.generateFromTemplate(VmTemplateUtils.getBusniessTemlatePathByTaskVo((TaskBaseVo)vo), map);
        List list = (List)XmlUtil.parseXmlString((String)data);
        return list;
    }

    private static boolean extralDeal(List<Map<String, Object>> list, Map<String, Object> customeParams) {
        for (Map<String, Object> bgd : list) {
            CmsInputDataHandlerService.dealBgds(bgd, customeParams);
            List goodsList = (List)bgd.get("entryentity");
            if (goodsList == null) continue;
            for (Map goods : goodsList) {
                CmsInputDataHandlerService.dealGoods(goods, bgd, customeParams);
            }
        }
        return true;
    }

    public static String parseDateStr(String inputDateStr, SimpleDateFormat inputFormat, SimpleDateFormat outputFormat) {
        if (StringUtils.isEmpty((String)inputDateStr) || inputFormat == null || outputFormat == null) {
            return inputDateStr;
        }
        inputFormat.setLenient(false);
        try {
            Date date = inputFormat.parse(inputDateStr);
            String outputDateString = outputFormat.format(date);
            return outputDateString;
        }
        catch (ParseException e) {
            return inputDateStr;
        }
    }

    @Override
    public TaxResult<List<Map<String, Object>>> dataConvert(List rawData, ExportDeclarationTaskVo vo) {
        List bgdList = rawData;
        HashMap<String, Object> originData = new HashMap<String, Object>(4);
        List<Map<String, Object>> formattedReqData = CmsInputDataHandlerService.formatReqData(bgdList);
        if (formattedReqData == null || formattedReqData.isEmpty()) {
            TaxResult failedResult = new TaxResult();
            failedResult.setSuccess(false);
            failedResult.setMessage(ResManager.loadKDString((String)"\u63a5\u53e3\u672a\u67e5\u8be2\u5230\u62a5\u5173\u5355\u6570\u636e", (String)"CmsInputDataHandlerService_1", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return failedResult;
        }
        originData.put("bgdlist", formattedReqData);
        List<Map<String, Object>> listMap = CmsInputDataHandlerService.transferData(originData, vo);
        try {
            HashMap<String, Object> customeParams = new HashMap<String, Object>(4);
            customeParams.put(KEY_ORG, vo.getOrgId());
            CmsInputDataHandlerService.extralDeal(listMap, customeParams);
        }
        catch (Exception e) {
            TaxResult failedResult = new TaxResult();
            failedResult.setSuccess(false);
            failedResult.setMessage(e.getMessage());
            return failedResult;
        }
        return new TaxResult(listMap);
    }

    private static void dealGoods(Map<String, Object> goodsMap, Map<String, Object> bgdMap, Map<String, Object> customeParams) {
        CmsInputDataHandlerService.dealFilds(goodsMap, "firstunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.CMS, (String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(goodsMap, "secondunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.CMS, (String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(goodsMap, "tradeunit", bgdvalue -> BgdHelper.getUnit(SupplierEnum.CMS, (String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(goodsMap, "tradecurrency", bgdvalue -> BgdHelper.getCurrency((String)bgdvalue));
        Date sbrq = (Date)bgdMap.get("declarationdate");
        CmsInputDataHandlerService.dealFilds(goodsMap, "hscode", bgdvalue -> BgdHelper.getGoods(sbrq, (String)bgdvalue));
        CmsInputDataHandlerService.dealFilds(goodsMap, "itemno", bgdvalue -> {
            if (StringUtils.isNotEmpty((String)((String)bgdvalue)) && ((String)bgdvalue).length() == 1) {
                return "0" + bgdvalue;
            }
            return bgdvalue;
        });
        CmsInputDataHandlerService.dealFilds(goodsMap, "unwriteoffqty", bgdvalue -> goodsMap.get("tradeqty"));
        CmsInputDataHandlerService.dealFilds(goodsMap, "datasource", bgdvalue -> "3");
    }

    private static void dealFilds(Map<String, Object> map, String key, Function fun) {
        Object dzbgdValue = map.get(key);
        Object kdValue = fun.apply(dzbgdValue);
        map.put(key, kdValue);
    }

    private static void saveByIsc(List<Map<String, Object>> bgdList, List<Map<String, Object>> saveInfo) {
        List saveResult = (List)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tdm", (String)"ExportDeclarationMService", (String)"saveByIsc", (Object[])new Object[]{bgdList});
        saveInfo.addAll(saveResult);
    }

    @Override
    public TaxResult saveData(List convertData, ExportDeclarationTaskVo vo) {
        List listMap = convertData;
        Integer successSize = 0;
        if (listMap == null || listMap.isEmpty()) {
            TaxResult result = new TaxResult();
            result.setSuccess(false);
            result.setData((Object)successSize);
            result.setMessage(ResManager.loadKDString((String)"\u65e0\u51fa\u53e3\u62a5\u5173\u5355\u6570\u636e\u53ef\u8fdb\u884c\u4fdd\u5b58", (String)"CmsInputDataHandlerService_0", (String)"taxc-tsate-business", (Object[])new Object[0]));
            return result;
        }
        ArrayList<Map<String, Object>> saveInfos = new ArrayList<Map<String, Object>>(10);
        CmsInputDataHandlerService.saveByIsc(listMap, saveInfos);
        StringBuilder erro = CmsInputDataHandlerService.getErro(saveInfos);
        for (Map map : saveInfos) {
            Boolean success = (Boolean)map.get("success");
            if (success == null || !success.booleanValue()) continue;
            Integer n = successSize;
            Integer n2 = successSize = Integer.valueOf(successSize + 1);
        }
        TaxResult result = new TaxResult();
        result.setData((Object)successSize);
        if (erro.length() > 0) {
            result.setSuccess(false);
            result.setMessage(erro.toString());
        } else {
            result.setSuccess(true);
        }
        return result;
    }
}

