/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.fi;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tcvvt.tras.TcvvtDeclareCheckReportServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.fi.SupplierSupportFiFileFormatEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.servicehelperutils.ServiceHelperBaseUtils;

public class TsateFiDeclareBusiness {
    public static Map<String, Object> getFiAttachmentsBySbbid(Long sbbId) {
        TaxResult result = TcvvtDeclareCheckReportServiceHelper.getAttachmentsBySbbid((Long)sbbId);
        ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)result);
        return (Map)result.getData();
    }

    public static boolean formatIsSupport(Map<String, Object> attachments, SupplierEnum supplier) {
        List fileFormatData = attachments.keySet().stream().map(fileName -> {
            String[] nameSplits = fileName.split("\\.");
            return nameSplits[nameSplits.length - 1];
        }).collect(Collectors.toList());
        List supportFormatBySupplier = SupplierSupportFiFileFormatEnum.getSupportFormatBySupplier((SupplierEnum)supplier);
        for (String formatDatum : fileFormatData) {
            if (supportFormatBySupplier.contains(formatDatum)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkQxySupportAttachment(Map<String, Object> attachments) {
        if (EmptyCheckUtils.isEmpty(attachments)) {
            return true;
        }
        return attachments.size() < 2 && TsateFiDeclareBusiness.formatIsSupport(attachments, SupplierEnum.QXY);
    }

    public static List<Map<String, String>> changeAttachmentDataAndEncrypt(Map<String, Object> attachments, String encryptType) {
        ArrayList<Map<String, String>> attachmentsData = new ArrayList<Map<String, String>>(16);
        if (EmptyCheckUtils.isEmpty(attachments)) {
            return attachmentsData;
        }
        for (Map.Entry<String, Object> entry : attachments.entrySet()) {
            HashMap<String, String> attachmentData = new HashMap<String, String>(8);
            attachmentData.put("attachName", entry.getKey());
            String attachmentEncryptData = "";
            if ("1".equals(encryptType)) {
                attachmentEncryptData = Base64.getEncoder().encodeToString((byte[])entry.getValue());
            }
            attachmentData.put("attachEncode", attachmentEncryptData);
            attachmentsData.add(attachmentData);
        }
        return attachmentsData;
    }
}

