/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.taxdialog;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.event.FKXXChangedEventBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.taxdialog.vo.OptionTypeEnums;
import kd.taxc.tsate.common.constant.taxdialog.vo.PopupFromDataVo;
import kd.taxc.tsate.common.constant.taxdialog.vo.SelectOptionVo;
import kd.taxc.tsate.common.constant.taxdialog.vo.qxy.PoppupStatusEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import org.apache.commons.collections.CollectionUtils;

public class TasteDeclarePopupBusiness {
    private static final String ENTITY_NAME = "tsate_pupupdata_declare";
    private static final String SBB_ID = "sbbid";
    private static final String CHANNEL = "channel";
    private static final String POPPUP_STATUS = "pupupstatus";
    private static final String NOW_POPPUP = "nowpopup";
    private static final String QUERY_STRINGS = "id,billno,sbbid,popupdata_tag,businessdata_tag,sbbtype,channel,pupupstatus,creator,nowpopup,projectname,modifytime,modifier";

    public static void initPopupData(String sbbId, String popupData, SupplierEnum supplier) {
        QFilter filter;
        DynamicObject initData;
        Long channelId = supplier.getId();
        String popupStatus = PoppupStatusEnum.INIT.getCode();
        QFilter nowPopupFilter = new QFilter(SBB_ID, "=", (Object)sbbId).and(POPPUP_STATUS, "!=", (Object)popupStatus).and(NOW_POPPUP, "=", (Object)true);
        DynamicObject nowPopupData = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])nowPopupFilter.toArray());
        if (nowPopupData != null) {
            nowPopupData.set(NOW_POPPUP, (Object)false);
            nowPopupData.set("modifytime", (Object)new Date());
            nowPopupData.set("modifier", (Object)RequestContext.get().getCurrUserId());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{nowPopupData});
        }
        if ((initData = BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])(filter = new QFilter(SBB_ID, "=", (Object)sbbId).and(POPPUP_STATUS, "=", (Object)popupStatus)).toArray())) == null) {
            initData = BusinessDataServiceHelper.newDynamicObject((String)ENTITY_NAME);
        }
        initData.set(SBB_ID, (Object)sbbId);
        initData.set(CHANNEL, (Object)channelId);
        initData.set(POPPUP_STATUS, (Object)popupStatus);
        initData.set("popupdata_tag", (Object)popupData);
        initData.set("creator", (Object)RequestContext.get().getCurrUserId());
        initData.set(NOW_POPPUP, (Object)true);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{initData});
    }

    public static void initQxyPopupData(String sbbId, String popupData) {
        TasteDeclarePopupBusiness.initPopupData(sbbId, popupData, SupplierEnum.QXY);
    }

    public static DynamicObject queryQxyInitPopupData(String sbbId) {
        return TasteDeclarePopupBusiness.queryInitPopupData(sbbId, SupplierEnum.QXY);
    }

    public static void updatePopupData(String sbbId, PoppupStatusEnum status, String businessData, String sbbType, SupplierEnum supplierEnum, String billNo, String projectName) {
        if (status == null) {
            return;
        }
        List<PoppupStatusEnum> oldStatusEnum = TasteDeclarePopupBusiness.getOldStatus(status);
        DynamicObject dataByStatus = TasteDeclarePopupBusiness.queryNowPopupDataByStatus(sbbId, supplierEnum, oldStatusEnum);
        if (dataByStatus == null) {
            return;
        }
        if (StringUtils.isNotBlank((CharSequence)billNo)) {
            dataByStatus.set("billno", (Object)billNo);
        }
        String oldFkxx = dataByStatus.getString("businessdata_tag");
        if (StringUtils.isNotBlank((CharSequence)businessData)) {
            dataByStatus.set("businessdata_tag", (Object)businessData);
        }
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            dataByStatus.set("projectname", (Object)projectName);
        }
        if (StringUtils.isNotBlank((CharSequence)sbbType)) {
            dataByStatus.set("sbbtype", (Object)DeclareTypeEnum.valueOfCode((String)sbbType).getId());
        }
        dataByStatus.set(POPPUP_STATUS, (Object)status.getCode());
        SaveServiceHelper.update((DynamicObject)dataByStatus);
        FKXXChangedEventBusiness.convertDataAndSendEvent(SupplierEnum.QXY, oldFkxx, businessData);
    }

    public static void updateQxyPopupData(String sbbId, PoppupStatusEnum status, String businessData, String sbbType, String billNo, String projectName) {
        TasteDeclarePopupBusiness.updatePopupData(sbbId, status, businessData, sbbType, SupplierEnum.QXY, billNo, projectName);
    }

    public static void updateQxyPopupDataByFormData(String sbbId, PoppupStatusEnum status, String sbbType, PopupFromDataVo fromData) {
        JSONObject businessData = new JSONObject();
        businessData.put("formData", (Object)JSON.toJSONString((Object)fromData));
        TasteDeclarePopupBusiness.updatePopupData(sbbId, status, businessData.toJSONString(), sbbType, SupplierEnum.QXY, fromData.getNumber(), fromData.getProjectName());
    }

    public static void updateQxyPopupDataStatus(String sbbId, PoppupStatusEnum status) {
        TasteDeclarePopupBusiness.updateQxyPopupData(sbbId, status, null, null, null, null);
    }

    public static void updatePopupDataStatusBySbbids(List<Long> sbbIds, PoppupStatusEnum status) {
        TasteDeclarePopupBusiness.updatePopupDataStatusBySbbids(sbbIds, status, null);
    }

    public static void updatePopupDataStatusBySbbids(List<Long> sbbIds, PoppupStatusEnum status, SupplierEnum supplier) {
        if (status == null) {
            return;
        }
        List<PoppupStatusEnum> oldStatus = TasteDeclarePopupBusiness.getOldStatus(status);
        DynamicObject[] objects = TasteDeclarePopupBusiness.queryNowPopupDataByStatusBySbbids(sbbIds, supplier, oldStatus);
        if (objects == null || objects.length == 0) {
            return;
        }
        ArrayList<DynamicObject> updateData = new ArrayList<DynamicObject>(objects.length);
        for (DynamicObject object : objects) {
            object.set(POPPUP_STATUS, (Object)status.getCode());
            updateData.add(object);
        }
        SaveServiceHelper.update((DynamicObject[])updateData.toArray(new DynamicObject[0]));
    }

    private static List<PoppupStatusEnum> getOldStatus(PoppupStatusEnum status) {
        ArrayList<PoppupStatusEnum> oldStatus = new ArrayList<PoppupStatusEnum>();
        if (status == PoppupStatusEnum.INIT || status == PoppupStatusEnum.SELECTED) {
            oldStatus.add(PoppupStatusEnum.INIT);
        }
        if (status == PoppupStatusEnum.VOID) {
            oldStatus.add(PoppupStatusEnum.INIT);
            oldStatus.add(PoppupStatusEnum.SELECTED);
        }
        if (status == PoppupStatusEnum.USED) {
            oldStatus.add(PoppupStatusEnum.SELECTED);
        }
        return oldStatus;
    }

    public static DynamicObject queryInitPopupData(String sbbId, SupplierEnum supplier) {
        if (StringUtils.isBlank((CharSequence)sbbId)) {
            return null;
        }
        Long channelId = supplier.getId();
        String popupStatus = PoppupStatusEnum.INIT.getCode();
        QFilter filter = new QFilter(SBB_ID, "=", (Object)sbbId).and(new QFilter(CHANNEL, "=", (Object)channelId.toString())).and(POPPUP_STATUS, "=", (Object)popupStatus);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])filter.toArray());
    }

    public static DynamicObject queryNowPopupDataByStatus(String sbbId, SupplierEnum supplier, PoppupStatusEnum statusEnum) {
        if (supplier == null) {
            return null;
        }
        Long channelId = supplier.getId();
        String popupStatus = statusEnum.getCode();
        QFilter filter = new QFilter(SBB_ID, "=", (Object)sbbId).and(new QFilter(CHANNEL, "=", (Object)channelId.toString())).and(POPPUP_STATUS, "=", (Object)popupStatus).and(NOW_POPPUP, "=", (Object)true);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])filter.toArray());
    }

    public static DynamicObject queryNowPopupDataByStatus(String sbbId, SupplierEnum supplier, List<PoppupStatusEnum> statusEnum) {
        if (supplier == null) {
            return null;
        }
        Long channelId = supplier.getId();
        List oldStatus = statusEnum.stream().map(statu -> statu.getCode()).collect(Collectors.toList());
        QFilter filter = new QFilter(SBB_ID, "=", (Object)sbbId).and(new QFilter(CHANNEL, "=", (Object)channelId.toString())).and(POPPUP_STATUS, "in", oldStatus).and(NOW_POPPUP, "=", (Object)true);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])filter.toArray());
    }

    public static DynamicObject[] queryNowPopupDataByStatusBySbbids(List<Long> sbbIds, SupplierEnum supplier, List<PoppupStatusEnum> statusEnum) {
        if (CollectionUtils.isEmpty(sbbIds)) {
            return null;
        }
        List status = statusEnum.stream().map(statu -> statu.getCode()).collect(Collectors.toList());
        List sbbIdsStrings = sbbIds.stream().map(data -> String.valueOf(data)).collect(Collectors.toList());
        QFilter filter = new QFilter(SBB_ID, "in", sbbIdsStrings).and(POPPUP_STATUS, "in", status).and(NOW_POPPUP, "=", (Object)true);
        if (supplier != null) {
            Long channelId = supplier.getId();
            filter.and(new QFilter(CHANNEL, "=", (Object)channelId.toString()));
        }
        return BusinessDataServiceHelper.load((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])filter.toArray());
    }

    public static DynamicObject queryNowPopupDataByStatusList(String sbbId, SupplierEnum supplier, List<PoppupStatusEnum> statusEnums) {
        if (supplier == null) {
            return null;
        }
        Long channelId = supplier.getId();
        List popupStatus = statusEnums.stream().map(status -> status.getCode()).collect(Collectors.toList());
        QFilter filter = new QFilter(SBB_ID, "=", (Object)sbbId).and(new QFilter(CHANNEL, "=", (Object)channelId.toString())).and(POPPUP_STATUS, "in", popupStatus).and(NOW_POPPUP, "=", (Object)true);
        return BusinessDataServiceHelper.loadSingle((String)ENTITY_NAME, (String)QUERY_STRINGS, (QFilter[])filter.toArray());
    }

    public static List<Long> querySbbIdsWithPopup(List<Long> sbbIds) {
        List sbbIdsStrings = sbbIds.stream().map(data -> String.valueOf(data)).collect(Collectors.toList());
        QFilter filter = new QFilter(SBB_ID, "in", sbbIdsStrings).and(POPPUP_STATUS, "=", (Object)PoppupStatusEnum.INIT.getCode()).and(NOW_POPPUP, "=", (Object)true);
        DynamicObjectCollection initData = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,sbbid", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)initData)) {
            return new ArrayList<Long>();
        }
        return initData.stream().map(data -> data.getLong(SBB_ID)).collect(Collectors.toList());
    }

    public static Map<String, String> getQxyPopupSelectData(Long sbbid) {
        HashMap<String, String> opMap = new HashMap<String, String>();
        if (EmptyCheckUtils.isEmpty((Object)sbbid)) {
            return opMap;
        }
        DynamicObject selectPopupData = TasteDeclarePopupBusiness.queryNowPopupDataByStatus(String.valueOf(sbbid), SupplierEnum.QXY, PoppupStatusEnum.SELECTED);
        if (selectPopupData == null) {
            return opMap;
        }
        String businessDataStr = selectPopupData.getString("businessdata_tag");
        if (StringUtils.isBlank((CharSequence)businessDataStr)) {
            return opMap;
        }
        JSONObject businessData = JSON.parseObject((String)businessDataStr);
        String formDataSrt = businessData.getString("formData");
        PopupFromDataVo formData = (PopupFromDataVo)JSON.parseObject((String)formDataSrt, PopupFromDataVo.class);
        SelectOptionVo selectNode = formData.getSelectNode();
        opMap.put("optionCode", selectNode.getOptionCode());
        opMap.put("memoJson", selectNode.getOptionValue());
        return opMap;
    }

    public static PopupFromDataVo buildQxyPopupFromData(String sbbid) {
        if (EmptyCheckUtils.isEmpty((Object)sbbid)) {
            return null;
        }
        DynamicObject selectPopupData = TasteDeclarePopupBusiness.queryNowPopupDataByStatusList(sbbid, SupplierEnum.QXY, Arrays.asList(PoppupStatusEnum.SELECTED, PoppupStatusEnum.USED));
        if (selectPopupData == null) {
            return null;
        }
        String businessDataStr = selectPopupData.getString("businessdata_tag");
        if (StringUtils.isBlank((CharSequence)businessDataStr)) {
            return null;
        }
        JSONObject businessData = JSON.parseObject((String)businessDataStr);
        String formDataSrt = businessData.getString("formData");
        PopupFromDataVo formData = (PopupFromDataVo)JSON.parseObject((String)formDataSrt, PopupFromDataVo.class);
        return formData;
    }

    public static OptionTypeEnums getFieldTypeEnum(String filedKey) {
        String fieldType = filedKey.split("_")[0];
        return OptionTypeEnums.getByOptionTyp((String)fieldType);
    }

    public static Map<Long, PoppupStatusEnum> querySbPopupStatus(List<Long> sbbIds) {
        HashMap<Long, PoppupStatusEnum> popupStatus = new HashMap<Long, PoppupStatusEnum>();
        List sbbIdsStrings = sbbIds.stream().map(data -> String.valueOf(data)).collect(Collectors.toList());
        QFilter filter = new QFilter(SBB_ID, "in", sbbIdsStrings).and(NOW_POPPUP, "=", (Object)true);
        DynamicObjectCollection popupData = QueryServiceHelper.query((String)ENTITY_NAME, (String)"id,sbbid,pupupstatus", (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)popupData)) {
            return popupStatus;
        }
        for (DynamicObject popupDatum : popupData) {
            popupStatus.put(popupDatum.getLong(SBB_ID), PoppupStatusEnum.valueOfCode((String)popupDatum.getString(POPPUP_STATUS)));
        }
        return popupStatus;
    }
}

