/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.token;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.token.ApiTokenDao;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.api.ApiTokenTimeOutEnum;

public class ApiTokenService {
    public static String getEnableToken(SupplierEnum supplier) {
        DynamicObject data = ApiTokenDao.queryData(supplier);
        if (data == null) {
            return "";
        }
        String enable = data.getString("enable");
        if ("0".equals(enable)) {
            return "";
        }
        Date nowDate = new Date();
        BigDecimal timeOut = data.getBigDecimal("timeout");
        Date modifyTime = data.getDate("modifytime");
        if (nowDate.getTime() - modifyTime.getTime() > timeOut.multiply(new BigDecimal(3600000)).longValue()) {
            return "";
        }
        return data.getString("token_tag");
    }

    public static void updateOrSaveToken(SupplierEnum supplier, String token) {
        DynamicObject data = ApiTokenDao.queryData(supplier);
        if (data == null) {
            DynamicObject apiToken = BusinessDataServiceHelper.newDynamicObject((String)"tsate_api_token");
            apiToken.set("token_tag", (Object)token);
            apiToken.set("channel", (Object)supplier.getId());
            apiToken.set("timeout", (Object)ApiTokenTimeOutEnum.valueOfSupplier((SupplierEnum)supplier));
            apiToken.set("createtime", (Object)new Date());
            apiToken.set("enable", (Object)"1");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{apiToken});
        } else {
            data.set("token_tag", (Object)token);
            data.set("enable", (Object)"1");
            SaveServiceHelper.update((DynamicObject)data);
        }
    }
}

