/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.vmtemplate;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.directive.Directive;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.Node;

public class CalculateSavaValue
extends Directive {
    Log logger = LogFactory.getLog(CalculateSavaValue.class);
    private static final String SYMBOL = "+-*/";

    public String getName() {
        return "calValue";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter internalContextAdapter, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        BigDecimal num2;
        String numbers;
        String symbol;
        BigDecimal num1;
        int size = node.jjtGetNumChildren();
        if (size != 2 && size != 3 && size != 4) {
            StringBuilder detailLog = this.getDetailLog(node);
            detailLog.append(ResManager.loadKDString((String)" velocity\u9519\u8bef\uff1acal\u6307\u4ee4\u53c2\u6570\u6570\u91cf\u6709\u8bef\uff0c\u5b9e\u9645\u6570\u91cf", (String)"CalculateSavaValue_0", (String)"taxc-tsate-business", (Object[])new Object[0])).append(size);
            this.logger.error(detailLog.toString());
            throw new KDBizException(detailLog.toString());
        }
        Object value = node.jjtGetChild(0).value(internalContextAdapter);
        if (value == null) {
            return true;
        }
        try {
            num1 = new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            return false;
        }
        String calStr = node.jjtGetChild(1).literal();
        if (size == 2) {
            calStr = this.removeQuotationMark(calStr);
            symbol = calStr.substring(0, 1);
            numbers = calStr.substring(1);
        } else {
            symbol = this.removeQuotationMark(calStr);
            Object secondNumber = node.jjtGetChild(2).value(internalContextAdapter);
            if (secondNumber == null) {
                return true;
            }
            numbers = secondNumber.toString();
        }
        if (!this.checkSymbol(symbol)) {
            StringBuilder detailLog = this.getDetailLog(node);
            detailLog.append(ResManager.loadKDString((String)" velocity\u9519\u8bef\uff1acal\u6307\u4ee4\u53c2\u6570\u8fd0\u7b97\u7b26\u53f7\u4e0d\u7b26\u5408\u89c4\u5219\uff0c\u53ea\u80fd\u5c5e\u4e8e+-*/", (String)"CalculateSavaValue_1", (String)"taxc-tsate-business", (Object[])new Object[0])).append(size);
            this.logger.error(detailLog.toString());
            throw new KDBizException(detailLog.toString());
        }
        try {
            num2 = new BigDecimal(numbers);
        }
        catch (NumberFormatException e) {
            return false;
        }
        BigDecimal bigDecimal = this.cal(num1, symbol, num2);
        if (size <= 3) {
            writer.write(bigDecimal.toPlainString());
        } else {
            Node ref = node.jjtGetChild(size - 1);
            if (ref instanceof ASTReference) {
                ASTReference refNode = (ASTReference)ref;
                if (StringUtils.isNotEmpty((String)bigDecimal.toPlainString())) {
                    refNode.setValue(internalContextAdapter, (Object)bigDecimal.toPlainString());
                } else {
                    refNode.setValue(internalContextAdapter, (Object)"");
                }
            }
        }
        return true;
    }

    private String removeQuotationMark(String str) {
        if (str.startsWith("\"") || str.startsWith("'")) {
            str = str.substring(1, str.length());
        }
        if (str.endsWith("\"") || str.startsWith("'")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    private BigDecimal cal(BigDecimal n1, String symbol, BigDecimal n2) {
        if ("*".equals(symbol)) {
            return n1.multiply(n2);
        }
        if ("/".equals(symbol)) {
            return n1.divide(n2);
        }
        if ("+".equals(symbol)) {
            return n1.add(n2);
        }
        if ("-".equals(symbol)) {
            return n1.subtract(n2);
        }
        return n1;
    }

    private boolean checkSymbol(String symbol) {
        if (StringUtils.isEmpty((String)symbol)) {
            return false;
        }
        return SYMBOL.indexOf(symbol) != -1;
    }

    private StringBuilder getDetailLog(Node node) {
        StringBuilder detailLog = new StringBuilder();
        detailLog.append(ResManager.loadKDString((String)"\u6587\u4ef6 ", (String)"CalculateSavaValue_2", (String)"taxc-tsate-business", (Object[])new Object[0])).append(node.getTemplateName()).append(ResManager.loadKDString((String)" \u884c\u53f7", (String)"CalculateSavaValue_3", (String)"taxc-tsate-business", (Object[])new Object[0])).append(node.getLine()).append(ResManager.loadKDString((String)" \u5217\u53f7", (String)"CalculateSavaValue_4", (String)"taxc-tsate-business", (Object[])new Object[0])).append(node.getColumn()).append(ResManager.loadKDString((String)" \u5b57\u7b26\u4e32", (String)"CalculateSavaValue_5", (String)"taxc-tsate-business", (Object[])new Object[0])).append(node.literal()).append("\n");
        return detailLog;
    }
}

