/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.business.vmtemplate.resourceloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.runtime.resource.loader.FileResourceLoader;
import org.apache.velocity.runtime.resource.loader.ResourceLoader;
import org.apache.velocity.util.ExtProperties;

public class KdResourceLoader
extends ResourceLoader {
    Log logger = LogFactory.getLog(KdResourceLoader.class);
    private static final String PATH = "file.resource.loader.path";
    private static final String PATH_START = "vm";
    private ResourceLoader proxy;
    private String path;

    public void commonInit(RuntimeServices rs, ExtProperties configuration) {
        String filepath = rs.getString(PATH);
        this.path = this.getRealPath(filepath);
        super.commonInit(rs, configuration);
        this.proxy = new FileResourceLoader();
        this.proxy.commonInit(rs, configuration);
    }

    public void init(ExtProperties extProperties) {
        this.proxy.init(extProperties);
    }

    public Reader getResourceReader(String s, String s1) throws ResourceNotFoundException {
        DynamicObject config = this.queryConfig(this.path + s);
        String content = this.getConfigBwContent(config);
        try {
            if (content != null && content.length() > 0) {
                return new InputStreamReader((InputStream)new BufferedInputStream(new ByteArrayInputStream(content.getBytes("UTF-8"))), "UTF-8");
            }
        }
        catch (Exception e) {
            this.logger.error("IO\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            this.logger.error("\u6253\u5f00\u5b57\u8282\u6d41\u5931\u8d25\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8d44\u6e90\u52a0\u8f7d\u5668");
        }
        String fileUrl = this.getConfigBwUrl(config);
        if (StringUtils.isNotEmpty((String)fileUrl)) {
            try {
                URL url = new URL(fileUrl);
                return new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), "UTF-8");
            }
            catch (IOException e) {
                this.logger.error("IO\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
                this.logger.error("\u6253\u5f00URL\u6d41\u5931\u8d25\u5c06\u4f7f\u7528\u9ed8\u8ba4\u8d44\u6e90\u52a0\u8f7d\u5668");
            }
        }
        return this.proxy.getResourceReader(s, s1);
    }

    public boolean isSourceModified(Resource resource) {
        return this.proxy.isSourceModified(resource);
    }

    public long getLastModified(Resource resource) {
        return this.proxy.getLastModified(resource);
    }

    private DynamicObject queryConfig(String path) {
        if (StringUtils.isEmpty((String)path)) {
            return null;
        }
        QFilter filter = new QFilter("path", "=", (Object)path);
        Date now = new Date();
        filter.and("enddate", ">", (Object)now);
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"tsate_setting_bw", (String)"id,billno,billstatus,creator,modifier,auditor,auditdate,modifytime,createtime,name,path,enddate,enable,content,content_tag", (QFilter[])new QFilter[]{filter});
        if (dyns.size() > 0) {
            return (DynamicObject)dyns.get(0);
        }
        return null;
    }

    private String getConfigBwUrl(DynamicObject config) {
        if (config == null) {
            return null;
        }
        Long id = config.getLong("id");
        List list = AttachmentServiceHelper.getAttachments((String)"tsate_setting_bw", (Object)id, (String)"attachmentpanel");
        if (list.size() > 0) {
            return (String)((Map)list.get(0)).get("url");
        }
        return null;
    }

    private String getConfigBwContent(DynamicObject config) {
        if (config == null) {
            return null;
        }
        return config.getString("content_tag");
    }

    private String getRealPath(String filePath) {
        int i = filePath.indexOf(PATH_START);
        if (i == -1) {
            return null;
        }
        String path = filePath.substring(i - 1);
        if (!(path = path.replaceAll("\\\\", "/")).endsWith("/")) {
            path = path + "/";
        }
        return path;
    }
}

