/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.ext.cloudcc.beans.UrlParams;
import kd.taxc.tsate.common.ext.cloudcc.utils.HttpUtils;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.service.szyh.SzyhRequest;
import org.apache.commons.lang3.time.DateFormatUtils;

public class DeclareService {
    private static Log logger = LogFactory.getLog(DeclareService.class);
    public static final String VERSION = "1.0";
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public ApiResult getToken() {
        ApiResult apiResult;
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            StringBuilder reqUrl = new StringBuilder(baseUrl).append("/token/getToken");
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            String passWord = (String)configMap.get("cloudcc_access_password");
            DeclareService.buildSignature(urlParams, passWord, reqUrl);
            String response = SzyhRequest.doPost(reqUrl.toString(), null, "");
            logger.info(String.format("szyh getToken resonse: %s", response));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u8fd4\u56de\u4e3a\u7a7a", (String)"DeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                ApiResult apiResult2 = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult2;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = "200".equals(String.valueOf(responseMap.get("Code"))) ? CustomApiResult.dealResponse(responseMap.get("Token"), (String)responseMap.get("Message"), String.valueOf(responseMap.get("Code")), true) : CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), String.valueOf(responseMap.get("Code")), false);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"DeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void buildSignature(UrlParams urlParams, String passWord, StringBuilder url) throws UnsupportedEncodingException {
        String urlParam = HttpUtils.buildUrlParams((UrlParams)urlParams);
        String accessKeySecret = Md5Utils.getEncode((byte[])passWord.getBytes("UTF-8"));
        String signature = Md5Utils.getSignature((byte[])urlParam.getBytes("UTF-8"), (byte[])accessKeySecret.getBytes("UTF-8"));
        urlParams.setSignature(signature);
        url.append("?").append(HttpUtils.buildUrlParams((UrlParams)urlParams));
    }
}

