/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.ext.fi.fatvs.skilldata.ISkillRunnable;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunContext;
import kd.bos.ext.fi.fatvs.skilldata.SkillRunResult;
import kd.taxc.tsate.business.DeclareSkillBusiness;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.mservice.constant.DeclareSkillEnum;

public class DeclareSkillApi
implements ISkillRunnable {
    private static String SKILL_NUMBER = "yjbsjqr";

    public SkillRunResult pullData(SkillRunContext skillRunContext) {
        SkillRunResult skillResult = skillRunContext.getSkillResult();
        String skillNum = skillRunContext.getSkillNum();
        Date startTime = skillRunContext.getStartTime();
        Date endTime = skillRunContext.getEndTime();
        if (SKILL_NUMBER.equalsIgnoreCase(skillNum)) {
            ArrayList list = new ArrayList(3);
            Date now = new Date();
            Date startDate = DateUtils.getFirstDateOfMonth((Date)now);
            Date endDate = DateUtils.getLastDateOfMonth((Date)now);
            for (DeclareSkillEnum skillEnum : DeclareSkillEnum.values()) {
                String number = skillEnum.getNumber();
                String count = this.getCountByNumber(number, startDate, endDate);
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("number", number);
                paramMap.put("name", skillEnum.getName());
                paramMap.put("valueType", skillEnum.getValueType());
                paramMap.put("value", String.valueOf(count));
                list.add(paramMap);
            }
            String totalCount = this.getCountByNumber("ljsbcgsl", startTime, endTime);
            skillResult.setData(list);
            skillResult.setDate(skillRunContext.getStartTime());
            skillResult.setSkillNum(skillNum);
            skillResult.setFailCount(Integer.valueOf(0));
            skillResult.setTotalCount(Integer.valueOf(Integer.parseInt(String.valueOf(totalCount))));
        }
        return skillResult;
    }

    private String getCountByNumber(String number, Date startTime, Date endTime) {
        switch (number) {
            case "bysbcgcs": {
                DynamicObject[] declareObjs = DeclareSkillBusiness.queryBysbxgs(Collections.singletonList("declared"));
                return EmptyCheckUtils.isEmpty((Object)declareObjs) ? "0" : String.valueOf(declareObjs.length);
            }
            case "bydsbjls": {
                DynamicObject[] dsbjls = DeclareSkillBusiness.queryBysbxgs(Arrays.asList("declaring", "editing", "declarefailed", "importing", "submitted"));
                return EmptyCheckUtils.isEmpty((Object)dsbjls) ? "0" : String.valueOf(dsbjls.length);
            }
            case "ljsbcgsl": {
                DynamicObject[] ljsbjls = DeclareSkillBusiness.queryLjsbxgs(Collections.singletonList("declared"), (Date)startTime, (Date)endTime);
                return EmptyCheckUtils.isEmpty((Object)ljsbjls) ? "0" : String.valueOf(ljsbjls.length);
            }
            case "byjkcgcs": {
                DynamicObject[] payObjs = DeclareSkillBusiness.queryByjkxgs(Collections.singletonList("paid"));
                return EmptyCheckUtils.isEmpty((Object)payObjs) ? "0" : String.valueOf(payObjs.length);
            }
            case "bydjkjls": {
                DynamicObject[] bydjkObjs = DeclareSkillBusiness.queryByjkxgs(Arrays.asList("payfailed", "paying", "submitted", "unpaid"));
                return EmptyCheckUtils.isEmpty((Object)bydjkObjs) ? "0" : String.valueOf(bydjkObjs.length);
            }
            case "ljjkcgcs": {
                DynamicObject[] ljjks = DeclareSkillBusiness.queryLjjkxgs(Collections.singletonList("paid"), (Date)startTime, (Date)endTime);
                return EmptyCheckUtils.isEmpty((Object)ljjks) ? "0" : String.valueOf(ljjks.length);
            }
            case "byjksehj": {
                DynamicObject[] byjkse = DeclareSkillBusiness.queryByjkxgs(Collections.singletonList("paid"));
                BigDecimal totalBqybtse = BigDecimal.valueOf(0.0);
                if (EmptyCheckUtils.isNotEmpty((Object)byjkse)) {
                    for (DynamicObject obj : byjkse) {
                        totalBqybtse = totalBqybtse.add(obj.getBigDecimal("bqybtse"));
                    }
                }
                return totalBqybtse.toString();
            }
            case "ljjksehj": {
                DynamicObject[] ljjkse = DeclareSkillBusiness.queryLjjkxgs(Collections.singletonList("paid"), (Date)startTime, (Date)endTime);
                BigDecimal ljtotalBqybtse = BigDecimal.valueOf(0.0);
                if (EmptyCheckUtils.isNotEmpty((Object)ljjkse)) {
                    for (DynamicObject obj : ljjkse) {
                        ljtotalBqybtse = ljtotalBqybtse.add(obj.getBigDecimal("bqybtse"));
                    }
                }
                return ljtotalBqybtse.toString();
            }
        }
        return "0";
    }
}

