/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.mservice.SupplierTaskServiceHelper;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import org.apache.commons.lang3.StringUtils;

public class DirectDeclarePlugin
implements IBillWebApiPlugin {
    private static Log LOGGER = LogFactory.getLog(DirectDeclarePlugin.class);

    public ApiResult doCustomService(Map<String, Object> params) {
        LOGGER.info(ResManager.loadKDString((String)"\u76f4\u8fde\u7533\u62a5\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"DirectDeclarePlugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + params);
        ApiResult result = new ApiResult();
        try {
            result.setSuccess(true);
            result.setErrorCode(ErrorCode.SUCCESS.getCode());
            SBMessageBaseVo vo = new SBMessageBaseVo();
            vo.setParams((Map)params);
            Object supplier = params.get("supplier");
            String supplierLabel = supplier == null ? "" : String.valueOf(supplier);
            vo.setMessageId(String.valueOf(params.get("messageId")));
            vo.setOperationType(String.valueOf(params.get("key")));
            vo.setName(String.valueOf(params.get("key")));
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("forceCodes"))) {
                vo.setForceCodes((List)params.get("forceCodes"));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("businessId"))) {
                DynamicObject declare = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)Long.valueOf(String.valueOf(params.get("businessId"))));
                vo.setDeclareVersion(DeclarationMainFormBusniess.getOneModelVersionStringByObj((DynamicObject)declare));
                if (declare != null) {
                    DynamicObject dqdmObj;
                    DynamicObject channelObj;
                    if (StringUtils.isBlank((CharSequence)supplierLabel) && (channelObj = TsateChannelBusiness.getChannelByData((DynamicObject)declare)) != null) {
                        supplierLabel = channelObj.getDynamicObject("declarechannel").getString("number");
                    }
                    if (EmptyCheckUtils.isNotEmpty((Object)params.get("recordid"))) {
                        vo.setId(Long.valueOf(String.valueOf(params.get("recordid"))));
                    }
                    String type = DeclarationMainFormBusniess.getDeclareTypeByModel3((DynamicObject)declare);
                    vo.setBusinessType(type);
                    if ("ccxws".equals(type)) {
                        Long businessId = Long.valueOf(String.valueOf(params.get("businessId")));
                        SupplierTaskServiceHelper.buildCcxwsTaxType(businessId, vo, supplierLabel);
                    }
                    vo.setNsrsbh(declare.getString("nsrsbh"));
                    vo.setType(type);
                    vo.setSkssqq(declare.getDate("skssqq"));
                    vo.setSkssqz(declare.getDate("skssqz"));
                    vo.setYbtse(declare.getBigDecimal("bqybtse"));
                    vo.setBusinessId(declare.getString("id"));
                    vo.setOrgName(declare.getString("nsrmc"));
                    vo.setPayDate(declare.getDate("paydate"));
                    if (EmptyCheckUtils.isNotEmpty((Object)params.get("relationid"))) {
                        vo.setRelationIds(Collections.singletonList(Long.valueOf(String.valueOf(params.get("relationid")))));
                    }
                    if ((dqdmObj = TsateChannelBusiness.getAreaInfoByData((DynamicObject)declare)) != null) {
                        vo.setSbdq(dqdmObj.getString("xzqh"));
                    }
                    vo.setOrg(declare.getDynamicObject("org").getString("id"));
                }
            }
            if (params.get("isQuery") != null) {
                vo.setQuery((Boolean)params.get("isQuery"));
            } else {
                vo.setQuery(false);
            }
            vo.setDatasource(supplierLabel);
            LOGGER.info(ResManager.loadKDString((String)"\u5f53\u524d\u901a\u9053", (String)"DirectDeclarePlugin_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + supplierLabel);
            return SupplierTaskServiceHelper.invoke(supplierLabel, vo);
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a", (String)"DirectDeclarePlugin_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + e);
            LOGGER.error(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff1a", (String)"DirectDeclarePlugin_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + e.getMessage());
            LOGGER.error(ExceptionUtil.toString((Exception)e));
            return result;
        }
    }
}

