/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.business.declare.declaremain.DeclarationMainFormBusniess;
import kd.taxc.tsate.business.exportdeclaration.ExportDeclarationBusiness;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.mservice.SupplierTaskServiceHelper;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;

public class MessageSendPlugin
implements IBillWebApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(MessageSendPlugin.class);
    private final String[] fields = new String[]{"messageId", "transrc", "type", "nsrsbh", "skssqq", "skssqz", "sbdq", "businessId"};
    private static final String DIRECT_DECLARE = "directdeclare";
    private static final String DIRECT_PAY = "fastpay";

    public ApiResult doCustomService(Map<String, Object> params) {
        LOGGER.info(ResManager.loadKDString((String)"\u76f4\u8fde\u7533\u62a5\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"MessageSendPlugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + params);
        ApiResult result = new ApiResult();
        try {
            DynamicObject obj;
            result.setSuccess(true);
            result.setErrorCode(ErrorCode.SUCCESS.getCode());
            if (ExecuteTypeEnums.CKBGDXZ.getExecuteType().equals(params.get("key"))) {
                ExportDeclarationBusiness.downloadExportDeclaration(params);
                return result;
            }
            StringBuilder failedLog = new StringBuilder();
            SBMessageBaseVo vo = new SBMessageBaseVo();
            vo.setParams((Map)params);
            String businessId = params.get("businessId") == null ? "" : String.valueOf(params.get("businessId"));
            Long id = null;
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("recordid"))) {
                id = Long.valueOf(String.valueOf(params.get("recordid")));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("downLoadYears"))) {
                vo.setDownLoadYears((List)params.get("downLoadYears"));
            }
            if (params.get("org") != null) {
                vo.setOrg(params.get("org").toString());
                if (EmptyCheckUtils.isEmpty((Object)params.get("nsrsbh"))) {
                    DynamicObject taxorg = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"unifiedsocialcode", (QFilter[])new QFilter[]{new QFilter("id", "=", params.get("org"))});
                    params.put("nsrsbh", taxorg.get("unifiedsocialcode"));
                }
            }
            if (StringUtils.equals((CharSequence)DIRECT_PAY, (CharSequence)String.valueOf(params.get("key"))) || StringUtils.equals((CharSequence)DIRECT_DECLARE, (CharSequence)String.valueOf(params.get("key")))) {
                for (String field : this.fields) {
                    if (!EmptyCheckUtils.isEmpty((Object)params.get(field))) continue;
                    result.setErrorCode(ErrorCode.E0006.getCode());
                    result.setMessage(ResManager.loadKDString((String)"\u53c2\u6570%1$s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"MessageSendPlugin_9", (String)"taxc-tsate-mservice", (Object[])new Object[]{field}));
                    failedLog.append(result.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(businessId, id, "declarestatus", "declarefailed", "3", failedLog);
                    return result;
                }
            }
            if (EmptyCheckUtils.isEmpty((Object)params.get("nsrsbh"))) {
                result.setErrorCode(ErrorCode.E0006.getCode());
                result.setMessage(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458", (String)"MessageSendPlugin_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                failedLog.append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(id, "3", failedLog);
                return result;
            }
            if (params.get("isQuery") != null) {
                vo.setQuery((Boolean)params.get("isQuery"));
            } else {
                vo.setQuery(false);
            }
            vo.setMessageId(String.valueOf(params.get("messageId")));
            vo.setNsrsbh(String.valueOf(params.get("nsrsbh")));
            vo.setSbdq(String.valueOf(params.get("sbdq")));
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("type"))) {
                vo.setType(String.valueOf(params.get("type")));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("recordid"))) {
                vo.setId(Long.valueOf(String.valueOf(params.get("recordid"))));
            }
            vo.setOperationType(String.valueOf(params.get("key")));
            if (StringUtils.equals((CharSequence)"sbjt", (CharSequence)String.valueOf(params.get("key")))) {
                vo.setScreenshotType("1");
            } else if (StringUtils.equals((CharSequence)"kkjt", (CharSequence)String.valueOf(params.get("key")))) {
                vo.setScreenshotType("2");
            }
            vo.setFormPkId(String.valueOf(params.get("formPkId")));
            if (params.get("skssqq") != null) {
                vo.setSkssqq(DateUtils.stringToDate((String)params.get("skssqq").toString(), (String)"yyyy-MM-dd"));
            }
            if (params.get("skssqz") != null) {
                vo.setSkssqz(DateUtils.stringToDate((String)params.get("skssqz").toString(), (String)"yyyy-MM-dd"));
            }
            if (EmptyCheckUtils.isNotEmpty((Object)params.get("ybtse"))) {
                vo.setYbtse(new BigDecimal(String.valueOf(params.get("ybtse"))));
            }
            vo.setBusinessId(businessId);
            String supplierLabel = null;
            DynamicObject declare = null;
            if (StringUtils.isNotBlank((CharSequence)businessId)) {
                declare = DeclarationMainFormBusniess.queryOneByIdNotThrowEx((Long)Long.valueOf(businessId));
                vo.setDeclareVersion(DeclarationMainFormBusniess.getOneModelVersionStringByObj((DynamicObject)declare));
            }
            if (EmptyCheckUtils.isEmpty((Object)params.get("supplier"))) {
                DynamicObject channelObj = TsateChannelBusiness.getChannelByData((DynamicObject)declare);
                if (channelObj != null) {
                    supplierLabel = channelObj.getDynamicObject("declarechannel").getString("number");
                }
            } else {
                supplierLabel = String.valueOf(params.get("supplier"));
            }
            if (params.get("key") != null) {
                vo.setName(params.get("key").toString());
                if (params.get(params.get("key")) != null) {
                    vo.setPzTypeName(params.get(params.get("key")).toString());
                }
            }
            if (params.get("supplier") != null) {
                vo.setDatasource(params.get("supplier").toString());
            }
            if (params.get("sbdq") != null && (obj = CommonInfoUtil.getAreaInfoByNsrsbh((String)vo.getNsrsbh())) != null) {
                String sbdq = obj.getString("xzqh");
                vo.setSbdq(sbdq);
            }
            if (params.get("orgname") != null) {
                vo.setOrgName(params.get("orgname").toString());
            }
            if ("ccxws".equals(vo.getType()) && ExecuteTypeEnums.TBZT.getKey().equals(vo.getOperationType())) {
                SupplierTaskServiceHelper.buildCcxwsTaxType(Long.valueOf(businessId), vo, supplierLabel);
            }
            if (params.get("sbrq") != null) {
                vo.setSbrq(DateUtils.stringToDate((String)params.get("sbrq").toString(), (String)"yyyy-MM-dd"));
            }
            return SupplierTaskServiceHelper.invoke(supplierLabel, vo);
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a", (String)"MessageSendPlugin_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + e);
            LOGGER.error(ResManager.loadKDString((String)"\u5904\u7406\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a", (String)"MessageSendPlugin_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + e.getMessage());
            LOGGER.error(ExceptionUtil.toString((Exception)e));
            return result;
        }
    }
}

