/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.threadpools.Task;
import kd.taxc.tsate.common.threadpools.ThreadPoolsService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.task.ShSyncTask;

public class ShMessageSendPlugin
implements IBillWebApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(ShMessageSendPlugin.class);
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String ID_NUMBER_NAME_TAXPAYER_CODE = "id,number,name,taxpayer,unifiedsocialcode";
    private static final String CHANNEL = "channel";
    private static final String ORG = "org";
    private static final String NSRSBH = "nsrsbh";
    private static final String UNIFIEDSOCIAL_CODE = "unifiedsocialcode";
    private static final String STATUS = "status";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";

    public ApiResult doCustomService(Map<String, Object> params) {
        LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7a0e\u53f7\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"ShMessageSendPlugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + params);
        ApiResult result = new ApiResult();
        try {
            result.setSuccess(true);
            result.setErrorCode(ErrorCode.SUCCESS.getCode());
            StringBuilder failedLog = new StringBuilder();
            String key = params.get("flag").toString();
            Object orgids = params.get("orgids");
            DynamicObject[] querys = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID_NUMBER_NAME_TAXPAYER_CODE, (QFilter[])new QFilter[]{new QFilter("id", "in", orgids)});
            ArrayList<Future> futureList = new ArrayList<Future>();
            if ("syn_sh_submit".equals(key)) {
                for (DynamicObject load : querys) {
                    HashMap<String, Object> mparams = new HashMap<String, Object>();
                    mparams.put("OrgId", load.getString("id"));
                    mparams.put("szyh_org_id", "");
                    mparams.put("OrgName", load.getString(1));
                    mparams.put("OrgTaxNum", load.getString(2));
                    mparams.put("flag", key);
                    futureList.add(ThreadPoolsService.getInstance().submitCountFuture((Task)new ShSyncTask(mparams)));
                }
            } else if ("syn_sh_retry".equals(key)) {
                List unifiedsocialcode = Arrays.stream(querys).map(e -> e.get(UNIFIEDSOCIAL_CODE)).collect(Collectors.toList());
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)"tsate_declare_shinfo", (String)"id,org,orgtaxnum,orgid", (QFilter[])new QFilter[]{new QFilter("orgtaxnum", "in", unifiedsocialcode)});
                HashMap<String, String> map = new HashMap<String, String>(loads.length);
                for (DynamicObject load : loads) {
                    map.put(load.getString("orgtaxnum"), load.getString("orgid"));
                }
                for (DynamicObject query : querys) {
                    HashMap<String, Object> mparams = new HashMap<String, Object>();
                    mparams.put("OrgName", query.getString(1));
                    mparams.put("OrgTaxNum", query.getString(2));
                    mparams.put("flag", key);
                    mparams.put("OrgId", query.getString("id"));
                    if (map.get(query.getString(UNIFIEDSOCIAL_CODE)) != null) {
                        mparams.put("szyh_org_id", map.get(query.getString(UNIFIEDSOCIAL_CODE)));
                    } else {
                        mparams.put("szyh_org_id", "");
                    }
                    futureList.add(ThreadPoolsService.getInstance().submitCountFuture((Task)new ShSyncTask(mparams)));
                }
            }
            for (Future future : futureList) {
                try {
                    Map map = (Map)((Future)future.get()).get();
                }
                catch (InterruptedException | ExecutionException e2) {}
            }
        }
        catch (Throwable e3) {
            Object orgids = params.get("orgids");
            Object recodes = params.get("records");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("id", "in", recodes)});
            Arrays.stream(load).forEach(o -> o.set("executestatus", (Object)"3"));
            Arrays.stream(load).forEach(o -> o.set("deallog", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u7eb3\u7a0e\u8bc6\u522b\u53f7\uff1a%1$s", (String)"ShMessageSendPlugin_1", (String)"taxc-tsate-mservice", (Object[])new Object[]{o.get("deallog")})));
            SaveServiceHelper.save((DynamicObject[])load);
            DynamicObject[] ogs = BusinessDataServiceHelper.load((String)"tsate_declare_dynsh", (String)"id,org,nsrsbh,status,channel,creator", (QFilter[])new QFilter[]{new QFilter(ORG, "in", orgids)});
            Arrays.stream(ogs).forEach(o -> o.set(STATUS, (Object)3));
            SaveServiceHelper.save((DynamicObject[])ogs);
        }
        return result;
    }
}

