/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import com.google.common.collect.Lists;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.TsateCcxwsBussiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.TaxEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.mservice.constant.KdTaxcTypeEnums;
import kd.taxc.tsate.mservice.constant.SupplierDeclareServiceEnum;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.enums.CcxwsTypeEnums;
import kd.taxc.tsate.msmessage.enums.DeclareMethodEnums;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import org.apache.commons.collections.CollectionUtils;

public class SupplierTaskServiceHelper {
    private static final Log LOGGER = LogFactory.getLog(SupplierTaskServiceHelper.class);

    public static ApiResult invoke(String supplierLabel, SBMessageBaseVo vo) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        MessageSendService messageSendService = SupplierDeclareServiceEnum.getServiceBySupplierCode(supplierLabel);
        Method method = vo.getQuery() != false ? MessageSendService.class.getMethod("refresh", SBMessageBaseVo.class) : MessageSendService.class.getMethod(DeclareMethodEnums.getMethodNameByKey(String.valueOf(vo.getOperationType())), SBMessageBaseVo.class);
        LOGGER.info(ResManager.loadKDString((String)"\u5f53\u524d\u65b9\u6cd5", (String)"SupplierTaskServiceHelper_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + method.getName());
        LOGGER.info(ResManager.loadKDString((String)"\u5f53\u524d\u7c7b\u540d", (String)"SupplierTaskServiceHelper_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + messageSendService.getClass().getName());
        return (ApiResult)method.invoke((Object)messageSendService, vo);
    }

    public static void buildCcxwsTaxType(Long businessId, SBMessageBaseVo vo, String supplierLabel) {
        DynamicObject ccxwsObj = BusinessDataServiceHelper.loadSingle((String)"tcret_declare_main", (String)MetadataUtil.getAllFieldString((String)"tcret_declare_main"), (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)businessId)});
        if (EmptyCheckUtils.isEmpty((Object)ccxwsObj)) {
            return;
        }
        vo.setMainDataId(ccxwsObj.getString("id"));
        SupplierEnum supplier = SupplierEnum.valueOfCode((String)supplierLabel);
        if (SupplierEnum.ZWY == supplier) {
            QFilter sbbidFilter = new QFilter("sbbid", "=", (Object)String.valueOf(businessId));
            DynamicObjectCollection tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"taxtype", (QFilter[])new QFilter[]{sbbidFilter});
            if (CollectionUtils.isEmpty((Collection)tcretCcxwsZbs)) {
                return;
            }
            String type = CcxwsTypeEnums.getTypeByZwType(((DynamicObject)tcretCcxwsZbs.get(0)).getString("taxtype"));
            if (StringUtils.isBlank((CharSequence)type)) {
                return;
            }
            if (CcxwsTypeEnums.YHS.getType().equals(type)) {
                DynamicObject yhsObj = QueryServiceHelper.queryOne((String)"tctb_declare_main", (String)"taxlimit", (QFilter[])new QFilter("id", "=", (Object)businessId).toArray());
                String taxlimit = yhsObj.getString("taxlimit");
                String flag = type + "_" + taxlimit;
                type = KdTaxcTypeEnums.getTaxTypeByFlag(flag);
            }
            vo.setBusinessType(type);
        } else if (SupplierEnum.QXY == supplier || SupplierEnum.YZF == supplier) {
            Map subTaxTypes = TsateCcxwsBussiness.queryCcxwsSbbTaxType2((List)Lists.newArrayList((Object[])new String[]{businessId + ""}));
            Set taxEnums = (Set)subTaxTypes.get(businessId + "");
            if (taxEnums == null) {
                LOGGER.error(ResManager.loadKDString((String)"\u8d22\u4ea7\u884c\u4e3a\u7a0e\u4e0d\u5305\u542b\u5b50\u7a0e\u79cd", (String)"SupplierTaskServiceHelper_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return;
            }
            if (taxEnums.contains(TaxEnum.YHS)) {
                vo.setBusinessType(DeclareTypeEnum.YHS.getCode());
            } else if (taxEnums.contains(TaxEnum.HBS)) {
                vo.setBusinessType(DeclareTypeEnum.TCEPT.getCode());
            } else if (taxEnums.contains(TaxEnum.FCS) && taxEnums.contains(TaxEnum.CZTDSYS)) {
                vo.setBusinessType(DeclareTypeEnum.CCXWS_FCJTDSYS.getCode());
            } else if (taxEnums.contains(TaxEnum.FCS)) {
                vo.setBusinessType(DeclareTypeEnum.CCXWS_FCS.getCode());
            } else if (taxEnums.contains(TaxEnum.CZTDSYS)) {
                vo.setBusinessType(DeclareTypeEnum.CCXWS_CZTDSYS.getCode());
            }
        }
    }
}

