/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.threadpools.Task;
import kd.taxc.tsate.common.threadpools.ThreadPoolsService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.task.UserSyncTask;

public class UserMessageSendPlugin
implements IBillWebApiPlugin {
    private static final Log LOGGER = LogFactory.getLog(UserMessageSendPlugin.class);
    private static final String SYN_USER = "synuser";
    private static final String RETRY_SYN_USER = "retrysynuser";
    private static final String USER_IDS = "user_ids";
    private static final String USER_ID = "userid";
    private static final String DECLARE_RECORD_CS = "id,org,executetype,executestatus,creator,createtime,channel,detaillog,deallog";
    private static final String DECLARE_RECORD_YH = "id,executetype,executestatus,creator,createtime,channel,detaillog,deallog";

    public ApiResult doCustomService(Map<String, Object> params) {
        LOGGER.info(ResManager.loadKDString((String)"\u540c\u6b65\u7528\u6237\u8bf7\u6c42\u53c2\u6570\uff1a", (String)"UserMessageSendPlugin_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]) + params);
        ApiResult result = new ApiResult();
        try {
            result.setSuccess(true);
            result.setErrorCode(ErrorCode.SUCCESS.getCode());
            StringBuilder failedLog = new StringBuilder();
            String key = params.get("flag").toString();
            Object userids = params.get(USER_IDS);
            DynamicObject[] querys = BusinessDataServiceHelper.load((String)"bos_user", (String)"id,name,number,username,phone", (QFilter[])new QFilter[]{new QFilter("id", "in", userids)});
            ArrayList<Future> futureList = new ArrayList<Future>();
            if ("syn_user_submit".equals(key)) {
                for (DynamicObject load : querys) {
                    HashMap<String, Object> mparams = new HashMap<String, Object>();
                    mparams.put("UserName", load.getString("number"));
                    mparams.put("OrgId", "");
                    mparams.put("UserId", "");
                    mparams.put("deallog", load.getString("id"));
                    futureList.add(ThreadPoolsService.getInstance().submitCountFuture((Task)new UserSyncTask(mparams)));
                }
            } else if ("syn_user_retry".equals(key)) {
                List number = Arrays.stream(querys).map(e -> e.get("number")).collect(Collectors.toList());
                DynamicObject[] loads = BusinessDataServiceHelper.load((String)"tsate_declare_userinfo", (String)"id,number,userid", (QFilter[])new QFilter[]{new QFilter("number", "in", number)});
                HashMap<String, String> map = new HashMap<String, String>(loads.length);
                for (DynamicObject load : loads) {
                    map.put(load.getString("number"), load.getString(USER_ID));
                }
                for (DynamicObject query : querys) {
                    HashMap<String, Object> mparams = new HashMap<String, Object>();
                    mparams.put("OrgId", "");
                    mparams.put("UserName", query.getString("number"));
                    mparams.put("deallog", query.getString("number"));
                    if (map.get(query.getString("number")) != null) {
                        mparams.put("UserId", map.get(query.getString("number")));
                    } else {
                        mparams.put("UserId", "");
                    }
                    futureList.add(ThreadPoolsService.getInstance().submitCountFuture((Task)new UserSyncTask(mparams)));
                }
            }
            for (Future future : futureList) {
                try {
                    Map map = (Map)((Future)future.get()).get();
                }
                catch (InterruptedException | ExecutionException e2) {}
            }
        }
        catch (Throwable e3) {
            Object userids = params.get(USER_IDS);
            Object recodes = params.get("records");
            DynamicObject[] load = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)DECLARE_RECORD_CS, (QFilter[])new QFilter[]{new QFilter("id", "in", recodes)});
            Arrays.stream(load).forEach(o -> o.set("executestatus", (Object)"3"));
            Arrays.stream(load).forEach(o -> o.set("deallog", (Object)ResManager.loadKDString((String)"\u540c\u6b65\u5931\u8d25\uff0c\u5de5\u53f7\uff1a%1$s", (String)"UserMessageSendPlugin_1", (String)"taxc-tsate-mservice", (Object[])new Object[]{o.get("deallog")})));
            SaveServiceHelper.save((DynamicObject[])load);
            DynamicObject[] querys = BusinessDataServiceHelper.load((String)"tsate_declare_dynuser", (String)"id,user,status,channel,createtime,creator", (QFilter[])new QFilter[]{new QFilter("user", "in", userids)});
            Arrays.stream(querys).forEach(o -> o.set("status", (Object)"3"));
            SaveServiceHelper.save((DynamicObject[])querys);
        }
        return result;
    }
}

