/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.mservice.sbpz;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.taxc.tsate.mservice.api.sbpz.SbpzArchiveWriteBackMService;
import org.apache.commons.collections.CollectionUtils;

public class SbpzArchiveWriteBackMServiceImpl
implements SbpzArchiveWriteBackMService {
    private static final String ARCHIVESTATUS = "fisarchive";

    public String writeBack(String archiveStatus, String billEntityNumber, Set<Long> ids) {
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        List<Object> errorIds = this.writeBackArchiveStatus(archiveStatus, billEntityNumber, ids);
        if (CollectionUtils.isNotEmpty(errorIds)) {
            returnMap.put("code", "-1000");
            returnMap.put("description", ResManager.loadKDString((String)"\u53cd\u5199\u5931\u8d25", (String)"SbpzArchiveWriteBackMServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            returnMap.put("errIds", errorIds);
        } else {
            returnMap.put("code", "0000");
            returnMap.put("description", ResManager.loadKDString((String)"\u53cd\u5199\u6210\u529f", (String)"SbpzArchiveWriteBackMServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            returnMap.put("errIds", errorIds);
        }
        return SerializationUtils.toJsonString(returnMap);
    }

    private List<Object> writeBackArchiveStatus(String archiveStatus, String billEntityNumber, Set<Long> ids) {
        MainEntityType mt = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
        ArrayList<Object> errorIds = new ArrayList<Object>();
        for (Long id : ids) {
            Object[] param = new Object[]{archiveStatus, id};
            params.add(param);
            if (params.size() < 10000) continue;
            try {
                this.batchExecuteSql(mt.getAlias(), params);
                params.clear();
            }
            catch (Exception e) {
                List errIds = params.stream().map(f -> f[1]).collect(Collectors.toList());
                errorIds.addAll(errIds);
            }
        }
        if (!params.isEmpty()) {
            try {
                this.batchExecuteSql(mt.getAlias(), params);
            }
            catch (Exception e) {
                List errIds = params.stream().map(f -> f[1]).collect(Collectors.toList());
                errorIds.addAll(errIds);
            }
        }
        return errorIds;
    }

    private void batchExecuteSql(String tableName, List<Object[]> params) throws Exception {
        DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)("update " + tableName + " set " + ARCHIVESTATUS + " = ?  where fid = ?"), params);
    }
}

