/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.taxc.tsate.business.TsateCcxwsBussiness;
import kd.taxc.tsate.msmessage.collection.ISbbCollectionFilter;
import kd.taxc.tsate.msmessage.enums.CcxwsSouceJmInfoMappingEnums;

public class FilterFcjtdsys
implements ISbbCollectionFilter {
    private static Log logger = LogFactory.getLog(FilterFcjtdsys.class);

    @Override
    public String name() {
        return "fcjtdsys";
    }

    @Override
    public boolean pre(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        return false;
    }

    @Override
    public void post(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
    }

    @Override
    public void post(String templateId, String businessId, Map<Object, Object> returnMap) {
        this.buildSumJmse(businessId, returnMap);
        this.buildFcsSourceInfos(returnMap);
    }

    private void buildFcsSourceInfos(Map<Object, Object> returnMap) {
        List<Map<String, String>> cjSourceInfos = this.filteIsXgmData(returnMap, CcxwsSouceJmInfoMappingEnums.FCS_CJ.getSourceNumber());
        List<Map<String, String>> czSourceInfos = this.filteIsXgmData(returnMap, CcxwsSouceJmInfoMappingEnums.FCS_CZ.getSourceNumber());
        ArrayList<Map<String, String>> fcSourceInfos = new ArrayList<Map<String, String>>(8);
        HashSet<String> numberSet = new HashSet<String>();
        this.buildSumSourceInfos(cjSourceInfos, czSourceInfos, fcSourceInfos, numberSet);
        this.buildCzSourceInfos(czSourceInfos, fcSourceInfos, numberSet);
        returnMap.put("fcs_sum_source_infos", fcSourceInfos);
    }

    private void buildCzSourceInfos(List<Map<String, String>> czSourceInfos, List<Map<String, String>> fcSourceInfos, Set<String> numberSet) {
        List noSumInfos = czSourceInfos.stream().filter(dataMap -> !numberSet.contains(dataMap.get("number"))).collect(Collectors.toList());
        for (Map czSourceInfo : noSumInfos) {
            HashMap<String, String> itemMap = new HashMap<String, String>(16);
            this.buildCzBaseInfo(czSourceInfo, itemMap);
            fcSourceInfos.add(itemMap);
        }
    }

    private void buildSumSourceInfos(List<Map<String, String>> cjSourceInfos, List<Map<String, String>> czSourceInfos, List<Map<String, String>> fcSourceInfos, Set<String> numberSet) {
        for (Map<String, String> cjSourceInfo : cjSourceInfos) {
            String cjNumber = cjSourceInfo.get("number");
            HashMap<String, String> itemMap = new HashMap<String, String>(16);
            this.buildCjBaseInfo(itemMap, cjSourceInfo);
            for (Map<String, String> czSourceInfo : czSourceInfos) {
                String czNumber = czSourceInfo.get("number");
                if (StringUtils.isEmpty((Object)czNumber) || StringUtils.isEmpty((Object)cjNumber)) {
                    logger.info("\u5904\u7406\u623f\u4ea7\u7a0e\u6e90\u65f6\u51fa\u73b0\u7f16\u7801\u4e3a\u7a7a\u7684\u60c5\u51b5\uff0csbbId={}", (Object)czSourceInfo.get("sbbid_id"));
                    continue;
                }
                if (!cjNumber.equals(czNumber)) continue;
                itemMap.put("czmj", czSourceInfo.get("sumHireArea"));
                numberSet.add(czNumber);
                break;
            }
            fcSourceInfos.add(itemMap);
        }
    }

    private void buildCzBaseInfo(Map<String, String> czSourceInfo, Map<String, String> itemMap) {
        itemMap.put("sbbId", czSourceInfo.get("sbbid_id"));
        itemMap.put("fcbh", czSourceInfo.get("number"));
        itemMap.put("czmj", czSourceInfo.get("sumHireArea"));
        itemMap.put("zgswjg", czSourceInfo.get("taxauthority.name"));
    }

    private void buildCjBaseInfo(Map<String, String> itemMap, Map<String, String> cjSourceInfo) {
        itemMap.put("sbbId", cjSourceInfo.get("sbbid_id"));
        itemMap.put("fcbh", cjSourceInfo.get("number"));
        itemMap.put("jzmj", cjSourceInfo.get("area"));
        itemMap.put("fcyz", cjSourceInfo.get("assertvalue"));
        itemMap.put("czmj", cjSourceInfo.get("hirearea"));
        itemMap.put("fwzlxxdz", cjSourceInfo.get("detailaddr"));
        itemMap.put("zgswjg", cjSourceInfo.get("taxauthority.name"));
    }

    private List<Map<String, String>> filteIsXgmData(Map<Object, Object> returnMap, String sourceNumber) {
        return ((List)returnMap.get(sourceNumber)).stream().filter(item -> !this.checkIsxgm((String)item.get("isxgm"))).collect(Collectors.toList());
    }

    private boolean checkIsxgm(String isxgm) {
        return StringUtils.isEmpty((Object)isxgm) || Boolean.TRUE.toString().equals(isxgm);
    }

    private void buildSumJmse(String businessId, Map<Object, Object> returnMap) {
        String[] sourceNumbers;
        for (String sourceNumber : sourceNumbers = "tcret_pbt_tds_sum,tcret_pbt_fcs_price_sum,tcret_pbt_fcs_hire_sum".split(",")) {
            DynamicObjectCollection jmInfos;
            CcxwsSouceJmInfoMappingEnums mappingEnum;
            List<Map<String, String>> sourceInfo = this.filteIsXgmData(returnMap, sourceNumber);
            if (CollectionUtils.isEmpty(sourceInfo) || (mappingEnum = CcxwsSouceJmInfoMappingEnums.getEnumBySourceNumber(sourceNumber)) == null || CollectionUtils.isEmpty((Collection)(jmInfos = TsateCcxwsBussiness.queryCcxwsJmfbInfoBySbbId((String)mappingEnum.getJmEntityNumber(), (String)mappingEnum.getSelectFields(), (String)businessId)))) continue;
            String mappingKey = mappingEnum.getMappingKey();
            for (Map<String, String> item : sourceInfo) {
                String sourceKey = item.get("number");
                BigDecimal sumJmje = BigDecimal.ZERO;
                for (DynamicObject info : jmInfos) {
                    String jmKey = info.getString(mappingKey);
                    if (StringUtils.isEmpty((Object)jmKey) || !jmKey.equals(sourceKey)) continue;
                    sumJmje = sumJmje.add(info.getBigDecimal("jmse"));
                }
                item.put("sumJmse", sumJmje.toPlainString());
            }
        }
    }
}

