/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.metadata.domain.EntityField;
import kd.taxc.tsate.common.metadata.domain.EntityInfo;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.msmessage.collection.ISbbCollectionFilter;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.MessageService;
import org.apache.commons.lang3.StringUtils;

public class FilterQTSFFSSTYSBB
implements ISbbCollectionFilter {
    private static Log logger = LogFactory.getLog(FilterQTSFFSSTYSBB.class);
    public static final String VERTICAL_LINE = "|";
    private static final String ZERO_PREFIX = "00";

    @Override
    public String name() {
        return "qtsf_fsstysbb";
    }

    @Override
    public boolean pre(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        return true;
    }

    @Override
    public void post(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        this.dealJmxzdm(businessId, entityId, returnMap);
    }

    @Override
    public void post(String templateId, String businessId, Map<Object, Object> returnMap) {
        if (!returnMap.containsKey("isspecial") || !"1".equals(returnMap.get("isspecial"))) {
            this.dealTysbb(businessId, returnMap);
        }
    }

    private void dealJmxzdm(String businessId, String entityId, Map<Object, Object> returnMap) {
        HashMap entityMap = new HashMap();
        ArrayList<String> targetField = new ArrayList<String>();
        targetField.add("deductioncode");
        entityMap.put("totf_sjfzsf_dtb", targetField);
        for (Map.Entry entry : entityMap.entrySet()) {
            if (!((String)entry.getKey()).equals(entityId)) continue;
            QFilter q1 = new QFilter("sbbid", "=", (Object)businessId);
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)entityId);
            for (EntityField entityField : entityInfo.getFieldList()) {
                String fieldId = entityField.getFieldId();
                String fieldType = entityField.getFieldType();
                if (!"sbbid".equals(fieldId)) continue;
                if (!"BigInt".equals(fieldType)) break;
                q1.__setValue((Object)Long.valueOf(businessId));
                break;
            }
            for (String fieldId : targetField) {
                String queryField = "id," + fieldId + ".number," + fieldId + ".name," + fieldId + ".secondcode," + fieldId + ".policyname," + fieldId + ".policycaluse";
                DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)queryField, (QFilter[])new QFilter[]{q1});
                Object data = returnMap.get(entityId);
                if (entityId == null || !(data instanceof List)) continue;
                List list = (List)data;
                for (Map item : list) {
                    String itemid = (String)item.get("id");
                    for (DynamicObject obj : collection) {
                        String id = obj.getString("id");
                        if (!itemid.equals(id)) continue;
                        item.put("jmxzdm", obj.getString(fieldId + ".number"));
                        item.put("jmxzmc", obj.getString(fieldId + ".name"));
                        item.put("jmsxdm", obj.getString(fieldId + ".secondcode"));
                        item.put("policyname", obj.getString(fieldId + ".policyname"));
                        item.put("policycaluse", obj.getString(fieldId + ".policycaluse"));
                        if (!StringUtils.isNotBlank((CharSequence)obj.getString(fieldId + ".number"))) continue;
                        String policycaluse = obj.getString(fieldId + ".policycaluse");
                        String prefix = ZERO_PREFIX;
                        if (obj.getString(fieldId + ".number").length() >= 10) {
                            prefix = "";
                        }
                        if (StringUtils.isEmpty((CharSequence)policycaluse)) {
                            policycaluse = "";
                        }
                        if (StringUtils.isNotBlank((CharSequence)obj.getString(fieldId + ".secondcode"))) {
                            item.put("jmxzdm_mc", prefix + obj.getString(fieldId + ".number") + VERTICAL_LINE + obj.getString(fieldId + ".secondcode") + VERTICAL_LINE + obj.getString(fieldId + ".policyname") + policycaluse + VERTICAL_LINE + obj.getString(fieldId + ".name"));
                            continue;
                        }
                        item.put("jmxzdm_mc", prefix + obj.getString(fieldId + ".number") + VERTICAL_LINE + obj.getString(fieldId + ".policyname") + policycaluse + VERTICAL_LINE + obj.getString(fieldId + ".name"));
                    }
                }
            }
        }
    }

    private void dealTysbb(String businessId, Map<Object, Object> returnMap) {
        try {
            DynamicObject channelObj;
            DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(businessId), (String)"tcvat_nsrxx");
            if (declare != null && (channelObj = CommonInfoUtil.getChannel((Long)declare.getLong("id"))) != null) {
                String channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                    QFilter delcareStatusQfilter;
                    QFilter declareTypeQfilter;
                    QFilter billstatusFilter;
                    QFilter skssqqzFilter;
                    QFilter typeFilter;
                    DynamicObject org = declare.getDynamicObject("org");
                    Date skssqq = declare.getDate("skssqq");
                    Date skssqz = declare.getDate("skssqz");
                    QFilter qFilter = new QFilter("org", "=", (Object)org.getLong("id"));
                    DynamicObject tysbDeclare = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)"id,type,nsrsbh", (QFilter[])new QFilter[]{qFilter, typeFilter = new QFilter("type", "=", (Object)"qtsf_tysbb"), skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz)), billstatusFilter = new QFilter("billstatus", "=", (Object)"C"), declareTypeQfilter = new QFilter("declaretype", "!=", (Object)"0"), delcareStatusQfilter = new QFilter("declarestatus", "!=", (Object)"declared")});
                    if (tysbDeclare != null && (channelObj = CommonInfoUtil.getChannel((Long)tysbDeclare.getLong("id"))) != null) {
                        channelNumber = channelObj.getDynamicObject("declarechannel").getString("number");
                        if (SupplierEnum.SZYH.getCode().equals(channelNumber)) {
                            this.dealHbData(returnMap, tysbDeclare);
                            this.dealHjData(returnMap);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5408\u5e76\u5904\u7406\u5931\u8d25");
        }
    }

    private void dealHbData(Map<Object, Object> returnMap, DynamicObject tysbDeclare) throws MessageException {
        MessageSend templateMessage = new MessageSend();
        templateMessage.setMsgtype("declare");
        templateMessage.setBusinessid(tysbDeclare.getString("id"));
        templateMessage.setBusinesstype(tysbDeclare.getString("type"));
        templateMessage.setNsrType(tysbDeclare.getString("type"));
        templateMessage.setSupplier(SupplierEnum.SZYH.getName());
        templateMessage.setIsspecial(true);
        Map<Object, Object> map = MessageService.collectionWithoutTemplate(templateMessage, tysbDeclare.getString("nsrsbh"));
        for (Map.Entry<Object, Object> tysbItem : map.entrySet()) {
            if (!returnMap.containsKey(tysbItem.getKey())) {
                returnMap.put(tysbItem.getKey(), tysbItem.getValue());
                continue;
            }
            Object tysbValue = tysbItem.getValue();
            Object value = returnMap.get(tysbItem.getKey());
            if (!(value instanceof List) || !(tysbValue instanceof List)) continue;
            List list = (List)value;
            if (tysbValue instanceof List) {
                list.addAll((List)tysbValue);
            }
            returnMap.put(tysbItem.getKey(), list);
        }
    }

    private void dealHjData(Map<Object, Object> returnMap) {
        Object tysbInfo;
        if (returnMap.containsKey("totf_sjfzsf_info") && (tysbInfo = returnMap.get("totf_sjfzsf_info")) instanceof List) {
            List list = (List)tysbInfo;
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("ewblxh", "1");
            BigDecimal hjybse = BigDecimal.ZERO;
            BigDecimal hjyjse = BigDecimal.ZERO;
            BigDecimal hjynse = BigDecimal.ZERO;
            BigDecimal hjjmse = BigDecimal.ZERO;
            BigDecimal hjxgmjze = BigDecimal.ZERO;
            for (Map item : list) {
                if (EmptyCheckUtils.isNotEmpty(item.get("enddate")) && !valueMap.containsKey("enddate")) {
                    valueMap.put("enddate", item.get("enddate"));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("startdate")) && !valueMap.containsKey("startdate")) {
                    valueMap.put("startdate", item.get("startdate"));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("qtgrzjsfft")) && !valueMap.containsKey("qtgrzjsfft")) {
                    valueMap.put("qtgrzjsfft", item.get("qtgrzjsfft"));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("yzjsr")) && !valueMap.containsKey("yzjsr")) {
                    valueMap.put("yzjsr", item.get("yzjsr"));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("hjybse"))) {
                    hjybse = hjybse.add(new BigDecimal(String.valueOf(item.get("hjybse"))));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("hjyjse"))) {
                    hjyjse = hjyjse.add(new BigDecimal(String.valueOf(item.get("hjyjse"))));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("hjynse"))) {
                    hjynse = hjynse.add(new BigDecimal(String.valueOf(item.get("hjynse"))));
                }
                if (EmptyCheckUtils.isNotEmpty(item.get("hjjmse"))) {
                    hjjmse = hjjmse.add(new BigDecimal(String.valueOf(item.get("hjjmse"))));
                }
                if (!EmptyCheckUtils.isNotEmpty(item.get("hjxgmjze"))) continue;
                hjxgmjze = hjxgmjze.add(new BigDecimal(String.valueOf(item.get("hjxgmjze"))));
            }
            valueMap.put("hjybse", hjybse);
            valueMap.put("hjyjse", hjyjse);
            valueMap.put("hjynse", hjynse);
            valueMap.put("hjjmse", hjjmse);
            valueMap.put("hjxgmjze", hjxgmjze);
            returnMap.put("totf_sjfzsf_info", Collections.singletonList(valueMap));
        }
    }
}

