/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.business.TctbTaxMainBusiness;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.msmessage.collection.ISbbCollectionFilter;
import org.apache.commons.lang.StringUtils;

public class FilterQYSDSJB
implements ISbbCollectionFilter {
    private static final String MULTI100_PREFIX = "multi100_";
    private static final String DIVIDE100_PREFIX = "divide100_";

    @Override
    public String name() {
        return "qysdsjb";
    }

    @Override
    public boolean pre(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        return true;
    }

    @Override
    public void post(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        this.addA202000DynamicRowCode(businessId, entityId, returnMap);
        this.addA201020DynamicRowCode(businessId, entityId, returnMap);
        FilterQYSDSJB.dealzjgxzqhByNsrsbh(entityId, returnMap);
    }

    @Override
    public void post(String templateId, String businessId, Map<Object, Object> returnMap) {
        HashSet<String> set = new HashSet<String>(8);
        set.add("tccit_qysds_jdtbxx");
        set.add("tccit_qysds_zb");
        set.add("tccit_qysds_jmsdsyh");
        set.add("tccit_qysds_msyhmx");
        for (String keyId : set) {
            this.generate(keyId, returnMap);
        }
        this.persentNumberTranslate(returnMap);
        this.gzdzsjA202000YwbdCheck(returnMap);
    }

    private void generate(String entityId, Map<Object, Object> returnMap) {
        if (returnMap.containsKey(entityId)) {
            List list = (List)returnMap.get(entityId);
            for (Map map : list) {
                String ewblxh = (String)map.get("ewblxh");
                for (Map.Entry entry : map.entrySet()) {
                    String key = (String)entry.getKey();
                    String fullKey = entityId + "_" + ewblxh + "_" + key;
                    returnMap.put(fullKey, map.get(key));
                }
            }
        }
    }

    private void gzdzsjA202000YwbdCheck(Map<Object, Object> returnMap) {
        Object fzjgxx = returnMap.get("tccit_qysds_fzjgxx_dyn");
        if (fzjgxx instanceof List) {
            List list = (List)fzjgxx;
            if (list.size() > 0) {
                returnMap.put("tccit_qysds_fzjgxx_exist_validcheck", 1);
            } else {
                returnMap.put("tccit_qysds_fzjgxx_exist_validcheck", 0);
            }
        }
    }

    private void persentNumberTranslate(Map<Object, Object> returnMap) {
        BigDecimal target;
        BigDecimal d;
        BigDecimal v;
        Object value;
        HashSet keys_devide100 = new HashSet();
        HashSet<String> keys_multi100 = new HashSet<String>();
        keys_multi100.add("tccit_qysds_zb_1_sl");
        for (String key : keys_devide100) {
            if (!returnMap.containsKey(key) || !((value = returnMap.get(key)) instanceof String)) continue;
            v = new BigDecimal(value.toString());
            d = new BigDecimal(100);
            target = v.divide(d);
            returnMap.put(DIVIDE100_PREFIX + key, target.toPlainString());
        }
        for (String key : keys_multi100) {
            if (!returnMap.containsKey(key) || !((value = returnMap.get(key)) instanceof String)) continue;
            v = new BigDecimal(value.toString());
            d = new BigDecimal(100);
            target = v.multiply(d);
            returnMap.put(MULTI100_PREFIX + key, target.toPlainString());
        }
    }

    private void addA202000DynamicRowCode(String businessId, String entityId, Map<Object, Object> returnMap) {
        ArrayList<String> dynNameList = new ArrayList<String>();
        dynNameList.add("tccit_qysds_ext_dyn");
        dynNameList.add("tccit_qysds_ext_dyn2");
        dynNameList.add("tccit_qysds_ext_dyn3");
        for (String dyn : dynNameList) {
            if (!dyn.equals(entityId)) continue;
            DynamicObject channelObj = CommonInfoUtil.getChannel((Long)Long.parseLong(businessId));
            QFilter q1 = new QFilter("sbbid", "=", (Object)businessId);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)"item,item.number,item.name,item.deductiontype.number,item.deductiontype.name,item.deductiontype.secondcode,item.deductiontype.policyname,item.deductiontype.policycaluse", (QFilter[])new QFilter[]{q1});
            HashMap<String, DynamicObject> mapping = this.buildMappingMap(collection, channelObj, "discount");
            Object dynData = returnMap.get(dyn);
            if (dyn == null || !(dynData instanceof List)) continue;
            List list = (List)dynData;
            for (Map item : list) {
                if (item.get("item") == null) continue;
                String itemid = (String)item.get("item");
                for (DynamicObject obj : collection) {
                    String id = obj.getString(0);
                    if (!itemid.equals(id)) continue;
                    int flag = 0;
                    String itemcode = obj.getString(1);
                    String jmxzdm = obj.getString(3);
                    String jmxzmc = obj.getString(2);
                    DynamicObject amapping = mapping.get(id);
                    if (EmptyCheckUtils.isNotEmpty((Object)amapping)) {
                        jmxzdm = amapping.getString("jmxzdm");
                        jmxzmc = amapping.getString("name");
                        itemcode = amapping.getString("number");
                        flag = 1;
                    }
                    item.put("itemcode", itemcode);
                    item.put("itemname", obj.getString(2));
                    item.put("jmxzdm", jmxzdm);
                    item.put("jmxzmc", jmxzmc);
                    item.put("jmsxdm", obj.getString(5));
                    item.put("policyname", obj.getString(6));
                    item.put("policycaluse", obj.getString(7));
                    item.put("flag", flag);
                }
            }
        }
    }

    private void addA201020DynamicRowCode(String businessId, String entityId, Map<Object, Object> returnMap) {
        ArrayList<String> dynNameList = new ArrayList<String>();
        dynNameList.add("tccit_qysds_a201020_dyn1");
        dynNameList.add("tccit_qysds_a201020_dyn2");
        for (String dyn : dynNameList) {
            if (!dyn.equals(entityId)) continue;
            DynamicObject channelObj = CommonInfoUtil.getChannel((Long)Long.parseLong(businessId));
            QFilter q1 = new QFilter("sbbid", "=", (Object)businessId);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)"item,item.number,item.name,item.deductiontype.number,item.deductiontype.name", (QFilter[])new QFilter[]{q1});
            HashMap<String, DynamicObject> mapping = this.buildMappingMap(collection, channelObj, "discountfb");
            Object dynData = returnMap.get(dyn);
            if (dyn == null || !(dynData instanceof List)) continue;
            List list = (List)dynData;
            for (Map item : list) {
                if (item.get("item") == null) continue;
                String itemid = (String)item.get("item");
                for (DynamicObject obj : collection) {
                    String id = obj.getString(0);
                    if (!itemid.equals(id)) continue;
                    int flag = 0;
                    String swsxdm = obj.getString(1);
                    String jmxzdm = obj.getString(3);
                    String jmxzmc = obj.getString(2);
                    DynamicObject amapping = mapping.get(id);
                    if (EmptyCheckUtils.isNotEmpty((Object)amapping)) {
                        jmxzdm = amapping.getString("jmxzdm");
                        jmxzmc = amapping.getString("name");
                        swsxdm = amapping.getString("number");
                        flag = 1;
                    }
                    item.put("itemcode", swsxdm);
                    item.put("itemname", obj.getString(2));
                    item.put("jmxzdm", jmxzdm);
                    item.put("jmxzmc", jmxzmc);
                    item.put("flag", flag);
                }
            }
        }
    }

    private HashMap<String, DynamicObject> buildMappingMap(DynamicObjectCollection collection, DynamicObject channelObj, String discount) {
        ArrayList<Long> discountIds = new ArrayList<Long>();
        for (DynamicObject object : collection) {
            discountIds.add(object.getLong("item"));
        }
        DynamicObjectCollection jmxzdmMapping = QueryServiceHelper.query((String)"tsate_jmxzdm_mapping", (String)("number,name,jmxzdm," + discount), (QFilter[])new QFilter(discount, "in", discountIds).and(new QFilter("group", "=", (Object)channelObj.getLong("declarechannel.id"))).and(new QFilter("sbtype", "=", (Object)this.name())).toArray());
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(40);
        if (!CollectionUtils.isEmpty((Collection)jmxzdmMapping)) {
            for (DynamicObject object : jmxzdmMapping) {
                returnMap.put(object.getString(discount), object);
            }
        }
        return returnMap;
    }

    private static DynamicObject dealzjgxzqhByNsrsbh(String entityId, Map<Object, Object> returnMap) {
        Object dynData;
        if ("tccit_qysds_zjgxx".equals(entityId) && (dynData = returnMap.get(entityId)) instanceof List) {
            List list = (List)dynData;
            for (Map item : list) {
                DynamicObject areaObj;
                if (item.get("zjgnsrsbh") == null) continue;
                String zjgnsrsbh = (String)item.get("zjgnsrsbh");
                DynamicObject taxMain = null;
                if (!StringUtils.isBlank((String)zjgnsrsbh)) {
                    taxMain = TctbTaxMainBusiness.getByNsrshb((String)zjgnsrsbh);
                }
                if (null == taxMain || !EmptyCheckUtils.isNotEmpty((Object)taxMain.getString("registeraddress")) || (areaObj = FilterQYSDSJB.getParentXzqhById(Long.valueOf(taxMain.getString("registeraddress")))) == null) continue;
                returnMap.put("tccit_qysds_zjgxx_1_xzqh", areaObj.getString("areacode"));
            }
        }
        return null;
    }

    public static DynamicObject getParentXzqhById(Long address) {
        QFilter qFilter = new QFilter("id", "=", (Object)address);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bd_admindivision", (String)"id, parent.id, areacode", (QFilter[])new QFilter[]{qFilter});
        if (obj != null) {
            if (obj.getLong("parent.id") == 0L) {
                return obj;
            }
            return FilterQYSDSJB.getParentXzqhById(obj.getLong("parent.id"));
        }
        return null;
    }
}

