/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.msmessage.collection.ISbbCollectionFilter;

public class FilterZZSYBNSR
implements ISbbCollectionFilter {
    private static final String TEMPLATE_IDS = "tcvat_ybnsr_gjncpzjxshd,tcvat_ybnsr_trccfhdncp";
    private static final String METADATA_KEY = "tpo_tcvat_assist_entry";
    private static final String FILES_KEY = "id,fvalue1";

    @Override
    public String name() {
        return "zzsybnsr";
    }

    @Override
    public boolean pre(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        return true;
    }

    @Override
    public void post(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
    }

    @Override
    public void post(String templateId, String businessId, Map<Object, Object> returnMap) {
        String[] templateIds = TEMPLATE_IDS.split(",");
        HashSet<Long> entryIds = new HashSet<Long>(16);
        for (String id : templateIds) {
            this.genMetaDataIds(entryIds, (List)returnMap.get(id));
        }
        if (CollectionUtils.isEmpty(entryIds)) {
            return;
        }
        DynamicObjectCollection metaDatas = QueryServiceHelper.query((String)METADATA_KEY, (String)FILES_KEY, (QFilter[])new QFilter("id", "in", entryIds).toArray());
        Map<String, String> metaMap = metaDatas.stream().collect(Collectors.toMap(each -> each.getString("id"), each -> each.getString("fvalue1")));
        for (String id : templateIds) {
            List datas = (List)returnMap.get(id);
            if (CollectionUtils.isEmpty((Collection)datas)) continue;
            for (Map data : datas) {
                data.put("cpmc_value", metaMap.get(data.get("cpmc")));
                data.put("hyncpmc_value", metaMap.get(data.get("hyncpmc")));
            }
            returnMap.put(id, datas);
        }
    }

    private void genMetaDataIds(Set<Long> entryIds, List<Map<String, String>> gjncpzjxshd) {
        if (CollectionUtils.isEmpty(gjncpzjxshd)) {
            return;
        }
        for (Map<String, String> gjn : gjncpzjxshd) {
            String cpmc = gjn.get("cpmc");
            String fhyncpmc = gjn.get("hyncpmc");
            if (!StringUtils.isEmpty((CharSequence)cpmc)) {
                entryIds.add(Long.valueOf(cpmc));
            }
            if (StringUtils.isEmpty((CharSequence)fhyncpmc)) continue;
            entryIds.add(Long.valueOf(fhyncpmc));
        }
    }
}

