/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.taxc.tsate.msmessage.collection.ISbbCollectionFilter;

public class FilterZZSYJSKB
implements ISbbCollectionFilter {
    private static Log logger = LogFactory.getLog(FilterZZSYJSKB.class);

    @Override
    public String name() {
        return "zzsyjskb";
    }

    @Override
    public boolean pre(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        return true;
    }

    @Override
    public void post(String templateId, String businessId, String entityId, Map<Object, Object> returnMap) {
        this.translateSpecialAdvancescale(entityId, returnMap);
        this.translateSpecialSl(entityId, returnMap);
    }

    private void translateSpecialAdvancescale(String entityId, Map<Object, Object> returnMap) {
        if (!"tcvat_prepay".equals("entityId")) {
            return;
        }
        Object prepay = returnMap.get("tcvat_prepay");
        if (prepay instanceof List) {
            List list = (List)prepay;
            for (Map map : list) {
                String advancescale = (String)map.get("advancescale");
                if (!StringUtils.isNotEmpty((String)advancescale)) continue;
                BigDecimal num = this.specialStrToNum(advancescale);
                if (num != null) {
                    map.put("advancescale_translate", num.toString());
                    continue;
                }
                map.put("advancescale_translate", advancescale);
            }
        }
    }

    private void translateSpecialSl(String entityId, Map<Object, Object> returnMap) {
        if (!"tcvat_prepay_flzl".equals(entityId)) {
            return;
        }
        Object flzl = returnMap.get("tcvat_prepay_flzl");
        if (flzl instanceof List) {
            List list = (List)flzl;
            for (Map map : list) {
                String sl = (String)map.get("sl");
                if (!StringUtils.isNotEmpty((String)sl)) continue;
                BigDecimal num = this.specialStrToNum(sl);
                if (num != null) {
                    map.put("sl_translate", num.toString());
                    continue;
                }
                map.put("sl_translate", sl);
            }
        }
    }

    private BigDecimal specialStrToNum(String inputStr) {
        if (StringUtils.isEmpty((String)inputStr)) {
            return null;
        }
        try {
            if (inputStr.indexOf("\u2030") != -1) {
                return this.getDoubleBypermillage(inputStr);
            }
            if (inputStr.indexOf("%") != -1) {
                return this.getDoubleByPercent(inputStr);
            }
            if (FilterZZSYJSKB.isNumeric(inputStr)) {
                return new BigDecimal(inputStr).divide(new BigDecimal(100));
            }
            return new BigDecimal(inputStr);
        }
        catch (Exception e) {
            logger.warn("\u589e\u503c\u7a0e\u9884\u7f34 \u5b57\u6bb5\u8f6c\u6362\u5f02\u5e38");
            logger.warn(e.getMessage());
            return null;
        }
    }

    private BigDecimal getDoubleBypermillage(String str) {
        String numStr = str.replace("\u2030", "");
        if (FilterZZSYJSKB.isNumeric(numStr)) {
            BigDecimal n = new BigDecimal(numStr);
            return n.divide(new BigDecimal(1000));
        }
        return null;
    }

    private BigDecimal getDoubleByPercent(String str) {
        String numStr = str.replace("%", "");
        if (FilterZZSYJSKB.isNumeric(numStr)) {
            BigDecimal n = new BigDecimal(numStr);
            return n.divide(new BigDecimal(100));
        }
        return null;
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[1-9]+\\.?[0-9]+");
        Pattern pattern2 = Pattern.compile("[1-9]+");
        Matcher isNum = pattern.matcher(str);
        Matcher isNum2 = pattern2.matcher(str);
        return isNum.matches() || isNum2.matches();
    }
}

