/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tcret.CcxwsTaxSourceDetailServiceHelper;
import kd.taxc.bdtaxr.common.helper.tcret.DeclareDataServiceHelper;
import kd.taxc.tsate.business.config.TsateCommonConfig;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.metadata.domain.EntityField;
import kd.taxc.tsate.common.metadata.domain.EntityInfo;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.declare.TemplateFormulaServiceHelper;
import kd.taxc.tsate.common.util.servicehelperutils.ServiceHelperBaseUtils;
import kd.taxc.tsate.common.util.template.TemplateUtils;
import kd.taxc.tsate.msmessage.collection.BaseCollection;
import kd.taxc.tsate.msmessage.collection.FilterProxy;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.enums.BaseDataFieldEnums;
import kd.taxc.tsate.msmessage.enums.CcxwsInterfaceSupportEnum;
import kd.taxc.tsate.msmessage.enums.CcxwsSourceEntrieEnums;
import kd.taxc.tsate.msmessage.enums.CcxwsSourceInfoEnums;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SbbCollection
implements BaseCollection {
    public static final String VERTICAL_LINE = "|";
    private static final Log logger = LogFactory.getLog(SbbCollection.class);
    private static final String ZERO_PREFIX = "00";
    private static final String EWBLNAME = "ewblname";
    private static final String TCVAT_YBNSR_JSXM = "tcvat_ybnsr_jsxm";
    private static final String TCVAT_SB_FJSF = "tcvat_sb_fjsf";
    private static final String TCVAT_YBNSR_MSXM = "tcvat_ybnsr_msxm";
    private static final String TPO_TAXDEDUCTION = "tpo_taxdeduction";
    private static final String SWSXDM = "swsxdm";
    private static final String EWBLXH = "ewblxh";
    private static final String ENTITY_ID = "tcvat_nsrxx";
    public static final String JMXZDM = "jmxzdm";
    public static final String SDQYJMXZDM = "sdqyjmxzdm";
    public static final String FHC_BODY_ENTITY = "tcret_pbt_fcs_hire_sum";

    @Override
    public Map<Object, Object> doBusiness(MessageSend message) {
        try {
            QFilter pkFilter = new QFilter("id", "=", (Object)Long.parseLong(message.getBusinessid()));
            Map mainMap = TemplateUtils.dataToMap((String)ENTITY_ID, (String)"_", (QFilter[])new QFilter[]{pkFilter});
            HashMap<Object, Object> returnMap = new HashMap<Object, Object>(mainMap);
            if (!mainMap.isEmpty()) {
                Long orgId = Long.parseLong(String.valueOf(returnMap.get("tcvat_nsrxx_1_org_id")));
                SbbCollection.dealTopTaxoffice(returnMap, orgId);
                String templateTypeId = (String)mainMap.get("tcvat_nsrxx_1_type");
                if (!StringUtils.equals((CharSequence)templateTypeId, (CharSequence)"ccxws")) {
                    this.dealOtherTaxType(message, returnMap, templateTypeId);
                } else {
                    Long templateId = Long.valueOf(String.valueOf(returnMap.get("tcvat_nsrxx_1_templateid")));
                    this.dealCcxws(message, returnMap, templateId);
                }
            }
            return returnMap;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            logger.error(e.getMessage());
            return null;
        }
    }

    private void dealOtherTaxType(MessageSend message, Map<Object, Object> returnMap, String templateTypeId) {
        QFilter qFilter;
        DynamicObjectCollection list;
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)templateTypeId, (String)"tctb_template_type");
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)message.getBusinessid());
                String entityId = dobj.getString("entityid");
                EntityInfo entityInfo = MetadataUtil.getEntityById((String)entityId);
                if (!FilterProxy.instance().pre(templateTypeId, message.getBusinessid(), entityId, returnMap)) continue;
                if (!ENTITY_ID.equals(entityId)) {
                    for (EntityField entityField : entityInfo.getFieldList()) {
                        String fieldId = entityField.getFieldId();
                        String fieldType = entityField.getFieldType();
                        if (!"sbbid".equals(fieldId)) continue;
                        if (!"BigInt".equals(fieldType)) break;
                        sbbIdFilter.__setValue((Object)Long.valueOf(message.getBusinessid()));
                        break;
                    }
                    List<Map<String, String>> dataList = this.queryDataList(entityId, new QFilter[]{sbbIdFilter});
                    if (TCVAT_SB_FJSF.equals(entityId) && dataList != null && dataList.size() > 0) {
                        this.sumFjs(dataList);
                    }
                    returnMap.put(entityId, dataList);
                }
                FilterProxy.instance().post(templateTypeId, message.getBusinessid(), entityId, returnMap);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = QueryServiceHelper.query((String)"tctb_tax_main", (String)"categoryentryentity.orgplace", (QFilter[])new QFilter[]{qFilter = new QFilter("orgid", "=", (Object)Long.parseLong(String.valueOf(returnMap.get("tcvat_nsrxx_1_org_id")))).and(new QFilter("categoryentryentity.taxtype", "=", (Object)"fjsf"))})))) {
            returnMap.put("orgplace", ((DynamicObject)list.get(0)).getString("categoryentryentity.orgplace"));
        }
        if (message.isIsspecial()) {
            returnMap.put("isspecial", "1");
        }
        FilterProxy.instance().post(templateTypeId, message.getBusinessid(), returnMap);
    }

    private void dealCcxws(MessageSend message, Map<Object, Object> returnMap, Long templateId) {
        String sourceInfoFormId;
        Map metaDataMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateId);
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)message.getBusinessid());
        if (metaDataMap != null && !metaDataMap.isEmpty()) {
            for (Map.Entry item : metaDataMap.entrySet()) {
                String entityId = (String)item.getValue();
                if (ENTITY_ID.equals(entityId)) continue;
                List<Map<String, String>> dataList = this.queryDataList(entityId, new QFilter[]{sbbIdFilter});
                returnMap.put(entityId, dataList);
            }
        }
        String businesstype = message.getBusinesstype();
        long sbbId = Long.parseLong(message.getBusinessid());
        DynamicObject channelObj = CommonInfoUtil.getChannel((Long)sbbId);
        CcxwsInterfaceSupportEnum supportEnum = CcxwsInterfaceSupportEnum.valueOfSupplier(SupplierEnum.valueOfId((Long)channelObj.getLong("declarechannel.id")));
        if (supportEnum != null && supportEnum.getTypes().contains(businesstype)) {
            TaxResult declareData = DeclareDataServiceHelper.getProcessedDeclareData(null, (Long)sbbId);
            String mse = ResManager.loadKDString((String)"\u83b7\u53d6\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u6216\u8054\u7cfb\u6280\u672f\u4eba\u5458\uff1a", (String)"SbbCollection_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)declareData, (String)"200", (String)mse);
            Object data = declareData.getData();
            try {
                JSONObject declareDataJson = JSON.parseObject((String)JSON.toJSONString((Object)data));
                logger.info("ccxws \u63a5\u53e3\u53d6\u6570 zbData={}", (Object)declareDataJson.getString("zbData"));
                logger.info("ccxws \u63a5\u53e3\u53d6\u6570 jmData={}", (Object)declareDataJson.getString("jmData"));
            }
            catch (Exception e) {
                logger.info("\u6253\u5370\u65e5\u5fd7\u5f02\u5e38");
            }
            returnMap.put("declareData", data);
        }
        if (supportEnum != null && supportEnum.getSourceTypes().contains(businesstype)) {
            TaxResult sourceData = CcxwsTaxSourceDetailServiceHelper.getTaxSourceDetailBySbbId((Long)sbbId);
            ServiceHelperBaseUtils.checkTaxResultAndThrowEx((TaxResult)sourceData, (String)"200", (String)ResManager.loadKDString((String)"\u83b7\u53d6\u7a0e\u6e90\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff0c\u6216\u8054\u7cfb\u6280\u672f\u4eba\u5458\u3002", (String)"SbbCollection_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            logger.info("ccxws \u7a0e\u6e90\u63a5\u53e3\u53d6\u6570 sourceData={}", (Object)JSON.toJSONString((Object)sourceData.getData()));
            returnMap.put("ccxwstaxsource", sourceData.getData());
        }
        if (StringUtils.isNotBlank((CharSequence)(sourceInfoFormId = CcxwsSourceInfoEnums.getFormIdByType(businesstype)))) {
            String[] sourceFormIds = sourceInfoFormId.split(",");
            QFilter sourceFilter = new QFilter("sbbid", "=", (Object)Long.valueOf(message.getBusinessid()));
            for (String formId : sourceFormIds) {
                List<Map<String, String>> dataList = this.querySourceInfoList(formId, new QFilter[]{sourceFilter});
                if ("tcret_yhs_tax_source_info".equals(formId) && dataList != null && dataList.size() > 0) {
                    this.sumYhs(dataList, returnMap);
                }
                returnMap.put(formId, dataList);
            }
        }
        FilterProxy.instance().post(businesstype, message.getBusinessid(), returnMap);
    }

    private List<Map<String, String>> querySourceInfoList(String entityId, QFilter[] filters) {
        DynamicObjectCollection collection;
        logger.info("\u83b7\u53d6\u7a0e\u6e90\u7ed3\u679c\u96c6entityid:" + entityId);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        EntityInfo entityInfo = MetadataUtil.getEntityById((String)entityId);
        if (null == entityInfo) {
            return dataList;
        }
        this.buildBaseDataFileds(entityId, entityInfo);
        Set hasBodyEntities = Arrays.asList("tcret_pbt_tds_sum,tcret_pbt_fcs_price_sum,tcret_pbt_fcs_hire_sum".split(",")).stream().collect(Collectors.toSet());
        if (hasBodyEntities.contains(entityId)) {
            DynamicObject[] headers = BusinessDataServiceHelper.load((String)entityId, (String)entityInfo.getAllFields(), (QFilter[])filters);
            collection = new DynamicObjectCollection();
            Collections.addAll(collection, headers);
        } else {
            collection = QueryServiceHelper.query((String)entityId, (String)entityInfo.getAllFields(), (QFilter[])filters);
        }
        if (collection == null || collection.isEmpty()) {
            return dataList;
        }
        if (CollectionUtils.isNotEmpty((Collection)collection)) {
            HashMap taxItemMap = new HashMap();
            HashMap subtaxitemMap = new HashMap();
            HashMap itemMap = new HashMap();
            if ("tcret_yhs_tax_source_info".equals(entityId)) {
                DynamicObjectCollection items;
                DynamicObjectCollection taxItems;
                List subtaxitemIds = collection.stream().filter(o -> EmptyCheckUtils.isNotEmpty((Object)o.getLong("subtaxitem"))).map(o -> o.getLong("subtaxitem")).collect(Collectors.toList());
                DynamicObjectCollection subtaxitems = QueryServiceHelper.query((String)"tpo_tcsd_bizdef_entry", (String)"id,projectname,number", (QFilter[])new QFilter[]{new QFilter("id", "in", subtaxitemIds)});
                if (CollectionUtils.isNotEmpty((Collection)subtaxitems)) {
                    subtaxitems.stream().forEach(o -> subtaxitemMap.put(o.getLong("id"), o));
                }
                if (CollectionUtils.isNotEmpty((Collection)(taxItems = QueryServiceHelper.query((String)"tpo_tcsd_taxrateentry", (String)"id,name,taxrate, number", null)))) {
                    taxItems.stream().forEach(o -> taxItemMap.put(o.getLong("id"), o));
                }
                if (CollectionUtils.isNotEmpty((Collection)(items = QueryServiceHelper.query((String)"tsate_yhs_taxitem", (String)"name,number", null)))) {
                    items.stream().forEach(o -> itemMap.put(o.getString("number"), o.getString("name")));
                }
            }
            for (DynamicObject dObject : collection) {
                HashMap<String, String> map = new HashMap<String, String>(entityInfo.getFieldList().size());
                BigDecimal ynse = BigDecimal.ZERO;
                BigDecimal jmse = BigDecimal.ZERO;
                BigDecimal yjse = BigDecimal.ZERO;
                this.buildSouceEntityInfos(dObject, entityId, map);
                for (EntityField field : entityInfo.getFieldList()) {
                    String rate;
                    Object obj = dObject.get(field.getFieldId());
                    map.put(field.getFieldId(), TemplateUtils.dataFormatPreSave((Object)obj, (EntityField)field));
                    String fieldId = field.getFieldId();
                    if (FHC_BODY_ENTITY.equals(entityId) && "rententryentity".equals(fieldId)) {
                        DynamicObjectCollection rententryentity = dObject.getDynamicObjectCollection("rententryentity");
                        if (CollectionUtils.isEmpty((Collection)rententryentity)) continue;
                        this.buildSumHireArea(rententryentity, map);
                    }
                    if ("ynse".equals(field.getFieldId()) && EmptyCheckUtils.isNotEmpty((Object)dObject.get("ynse"))) {
                        ynse = dObject.getBigDecimal("ynse");
                    }
                    if ("deducttax".equals(field.getFieldId()) && EmptyCheckUtils.isNotEmpty((Object)dObject.get("deducttax"))) {
                        jmse = dObject.getBigDecimal("deducttax");
                    }
                    if ("yjse".equals(field.getFieldId()) && EmptyCheckUtils.isNotEmpty((Object)dObject.get("yjse"))) {
                        yjse = dObject.getBigDecimal("yjse");
                    }
                    if (field.getFieldId().equals("taxitem")) {
                        map.put("taxitem_name", (String)itemMap.get(((DynamicObject)taxItemMap.get(obj)).getString("number")));
                        rate = ((DynamicObject)taxItemMap.get(obj)).getString("taxrate");
                        if (StringUtils.isNotBlank((CharSequence)rate) && rate.contains("\u2030")) {
                            map.put("taxitem_taxrate", new BigDecimal(rate.replace("\u2030", "")).divide(new BigDecimal(1000)).toString());
                        } else if (StringUtils.isNotBlank((CharSequence)rate) && rate.contains("%")) {
                            map.put("taxitem_taxrate", new BigDecimal(rate.replace("%", "")).divide(new BigDecimal(100)).toString());
                        } else if (StringUtils.isNotBlank((CharSequence)rate) && SbbCollection.isNumeric(rate)) {
                            map.put("taxitem_taxrate", new BigDecimal(rate).divide(new BigDecimal(100)).toString());
                        } else {
                            map.put("taxitem_taxrate", rate);
                        }
                    }
                    if (field.getFieldId().equals("taxrate")) {
                        rate = dObject.getString("taxrate");
                        if (StringUtils.isNotBlank((CharSequence)rate) && rate.contains("\u2030")) {
                            map.put("taxrate_t", new BigDecimal(rate.replace("\u2030", "")).divide(new BigDecimal(1000)).toString());
                        } else if (StringUtils.isNotBlank((CharSequence)rate) && rate.contains("%")) {
                            map.put("taxrate_t", new BigDecimal(rate.replace("%", "")).divide(new BigDecimal(100)).toString());
                        } else if (StringUtils.isNotBlank((CharSequence)rate) && SbbCollection.isNumeric(rate)) {
                            map.put("taxrate_t", new BigDecimal(rate).divide(new BigDecimal(100)).toString());
                        } else {
                            map.put("taxrate_t", rate);
                        }
                    }
                    if (!field.getFieldId().equals("subtaxitem") || !subtaxitemMap.containsKey(obj)) continue;
                    map.put("subtaxitem_name", ((DynamicObject)subtaxitemMap.get(obj)).getString("projectname"));
                }
                BigDecimal bqybts = ynse.subtract(jmse).subtract(yjse);
                map.put("bqybts", bqybts.toPlainString());
                if ("tcret_yhs_tax_source_info".equals(entityId)) {
                    DynamicObject object = QueryServiceHelper.queryOne((String)TPO_TAXDEDUCTION, (String)"number,name,policyname,policycaluse,secondcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("deductioncode")))});
                    this.dealJmxzdm(map, object);
                }
                dataList.add(map);
            }
        }
        logger.info("\u83b7\u53d6\u7a0e\u6e90\u8868\u6570\u636e:" + dataList);
        return dataList;
    }

    private void buildSouceEntityInfos(DynamicObject dObject, String entityId, Map<String, String> map) {
        CcxwsSourceEntrieEnums sourceEntrieInfo = CcxwsSourceEntrieEnums.getSourceEntrieInfo(entityId);
        if (sourceEntrieInfo == null) {
            return;
        }
        DynamicObjectCollection entries = dObject.getDynamicObjectCollection(sourceEntrieInfo.getEntriesNumber());
        if (CollectionUtils.isEmpty((Collection)entries)) {
            return;
        }
        String[] fields = sourceEntrieInfo.getFields().split(",");
        String decimalFields = sourceEntrieInfo.getDecimalFields();
        ArrayList entryInfos = new ArrayList();
        entries.stream().forEach(entry -> {
            HashMap entryMap = new HashMap(16);
            Stream.of(fields).forEach(filed -> {
                if (decimalFields.contains((CharSequence)filed)) {
                    entryMap.put(filed, entry.getBigDecimal(filed).toPlainString());
                    return;
                }
                entryMap.put(filed, entry.getString(filed));
            });
            entryInfos.add(entryMap);
        });
        map.put("entryInfos", JSON.toJSONString(entryInfos));
    }

    private void buildSumHireArea(DynamicObjectCollection rententryentity, Map<String, String> map) {
        BigDecimal sumHireArea = BigDecimal.ZERO;
        for (DynamicObject hireObject : rententryentity) {
            BigDecimal hireArea = hireObject.getBigDecimal("hirearea");
            sumHireArea = hireArea.add(sumHireArea);
        }
        map.put("sumHireArea", sumHireArea.toPlainString());
    }

    private void buildBaseDataFileds(String entityId, EntityInfo entityInfo) {
        String fileds = BaseDataFieldEnums.getFiledsByEntityId(entityId);
        if (StringUtils.isNotBlank((CharSequence)fileds)) {
            StringBuilder nobaseDataFields = new StringBuilder(entityInfo.getAllFields());
            entityInfo.setAllFields(nobaseDataFields.append(",").append(fileds).toString());
            String[] fieldNames = fileds.split(",");
            List fieldList = entityInfo.getFieldList();
            for (String name : fieldNames) {
                EntityField field = new EntityField();
                field.setEntityId(entityId);
                field.setFieldId(name);
                fieldList.add(field);
            }
            entityInfo.setFieldList(fieldList);
        }
    }

    private void dealJmxzdm(Map<String, String> map, DynamicObject object) {
        if (null != object) {
            String policycaluse;
            map.put("hmc", ZERO_PREFIX + object.getString("number"));
            map.put("jsxzdm", ZERO_PREFIX + object.getString("number"));
            map.put("jsxzmc", object.getString("name"));
            String jmsxdm = "";
            if (StringUtils.isNotEmpty((CharSequence)object.getString("secondcode"))) {
                jmsxdm = object.getString("secondcode");
                map.put("jmsxdm", jmsxdm);
            }
            if (StringUtils.isEmpty((CharSequence)(policycaluse = object.getString("policycaluse")))) {
                policycaluse = "";
            }
            map.put("jmxzmc", object.getString("policyname") + policycaluse);
            if (StringUtils.isNotBlank((CharSequence)jmsxdm)) {
                map.put("jmxzdm_mc", ZERO_PREFIX + object.getString("number") + VERTICAL_LINE + jmsxdm + VERTICAL_LINE + object.getString("policyname") + policycaluse + VERTICAL_LINE + object.getString("name"));
            } else {
                map.put("jmxzdm_mc", ZERO_PREFIX + object.getString("number") + VERTICAL_LINE + object.getString("policyname") + policycaluse + VERTICAL_LINE + object.getString("name"));
            }
        } else {
            map.put("hmc", map.get(EWBLNAME));
        }
    }

    private List<Map<String, String>> queryDataList(String entityId, QFilter[] filters) {
        logger.info("\u83b7\u53d6\u7533\u62a5\u8868\u7ed3\u679c\u96c6entityid:" + entityId);
        ArrayList<Map<String, String>> dataList = new ArrayList<Map<String, String>>();
        EntityInfo entityInfo = MetadataUtil.getEntityById((String)entityId);
        if (null == entityInfo) {
            return dataList;
        }
        this.buildBaseDataFileds(entityId, entityInfo);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)entityId, (String)entityInfo.getAllFields(), (QFilter[])filters, (String)EWBLXH);
        if (collection == null || collection.isEmpty()) {
            return dataList;
        }
        Map ewbMap = MetadataUtil.getComboItemsMap((String)entityId, (String)EWBLXH);
        for (DynamicObject dObject : collection) {
            DynamicObject object;
            HashMap<String, String> map = new HashMap<String, String>(entityInfo.getFieldList().size());
            String ewbxh = dObject.getString(EWBLXH);
            for (EntityField field : entityInfo.getFieldList()) {
                Object obj = dObject.get(field.getFieldId());
                map.put(field.getFieldId(), TemplateUtils.dataFormatPreSave((Object)obj, (EntityField)field));
                this.dealComboType(dObject, map, field);
            }
            if ("".equals(map.getOrDefault(EWBLNAME, "").trim())) {
                map.put(EWBLNAME, (String)ewbMap.get(ewbxh));
            }
            if ("tcvat_ybnsr_fb2".equals(entityId) && "23a".equals(ewbxh)) {
                map.put("orderno", "38");
            } else {
                map.put("orderno", ewbxh.split("=")[0]);
            }
            if (TCVAT_YBNSR_JSXM.equals(entityId) || TCVAT_YBNSR_MSXM.equals(entityId)) {
                object = QueryServiceHelper.queryOne((String)TPO_TAXDEDUCTION, (String)"number,name,policyname,policycaluse,secondcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get(SWSXDM)))});
                this.dealJmxzdm(map, object);
            }
            if (TCVAT_SB_FJSF.equals(entityId) || "tcvat_prepay_flzl".equals(entityId)) {
                this.dealFjsJmxzDm(map);
            }
            if ("tccit_qysds_ext_dyn".equals(entityId) || "tccit_qysds_ext_dyn2".equals(entityId)) {
                object = QueryServiceHelper.queryOne((String)"tpo_discount_tree", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("item")))});
                if (null != object) {
                    map.put("itemname", object.getString("name"));
                } else {
                    map.put("itemname", "");
                }
            }
            if (Arrays.asList("tcvat_ybnsr_trccfhdncp", "tcvat_ybnsr_gjncpyyscjy").contains(entityId)) {
                DynamicObject object1;
                object = QueryServiceHelper.queryOne((String)"tcvat_ncp_declare_name", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("cpmc")))});
                if (null != object) {
                    map.put("cpmc_num_name", object.getString("number") + VERTICAL_LINE + object.getString("name"));
                }
                if (null != (object1 = QueryServiceHelper.queryOne((String)"tcvat_ncp_declare_name", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("hyncpmc")))}))) {
                    map.put("hyncpmc_name", object1.getString("name"));
                }
            }
            if ("tcvat_ybnsr_gjncpzjxshd".equals(entityId) && null != (object = QueryServiceHelper.queryOne((String)"tcvat_ncp_declare_name", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("cpmc")))}))) {
                map.put("cpmc_num_name", object.getString("number") + VERTICAL_LINE + object.getString("name"));
            }
            if ("tccit_qysds_a06779".equals(entityId)) {
                DynamicObject object1 = QueryServiceHelper.queryOne((String)"tpo_tccit_bizdef", (String)"entry_detail.subnumber as number ,entry_detail.projectname as name", (QFilter[])new QFilter[]{new QFilter("entry_detail.id", "=", (Object)Long.valueOf((String)map.get("techtype_id")))});
                DynamicObject object2 = QueryServiceHelper.queryOne((String)"bastax_taxorgan", (String)"number,name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf((String)map.get("taxoffice_id")))});
                map.put("techtype_number", Optional.ofNullable(object1).map(s -> s.getString("number")).orElseGet(() -> ""));
                map.put("taxoffice_name", Optional.ofNullable(object2).map(s -> s.getString("name")).orElseGet(() -> ""));
            }
            dataList.add(map);
            dataList.forEach(item -> {
                String orderno = item.getOrDefault("orderno", "999");
                try {
                    Integer.parseInt(orderno);
                }
                catch (NumberFormatException e) {
                    item.put("orderno", "999");
                }
            });
            dataList.sort(Comparator.comparingInt(o -> Integer.parseInt((String)o.get("orderno"))));
        }
        logger.info("\u83b7\u53d6\u7533\u62a5\u8868\u6570\u636e:" + dataList);
        return dataList;
    }

    private void dealComboType(DynamicObject dObject, Map<String, String> map, EntityField field) {
        Optional<ValueMapItem> firstValue;
        List comboItems;
        if ("Combo".equals(field.getFieldType()) && CollectionUtils.isNotEmpty((Collection)(comboItems = field.getComboItems())) && (firstValue = comboItems.stream().filter(o -> StringUtils.equals((CharSequence)o.getValue(), (CharSequence)String.valueOf(dObject.get(field.getFieldId())))).findFirst()).isPresent()) {
            map.put(field.getFieldId() + "_name", firstValue.get().getName().getLocaleValue());
        }
    }

    private void dealFjsJmxzDm(Map<String, String> map) {
        DynamicObject object = QueryServiceHelper.queryOne((String)TPO_TAXDEDUCTION, (String)"number,name,policyname,policycaluse,secondcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(map.get(JMXZDM)))});
        if (null != object) {
            String policycaluse;
            map.put("fjsjsxzdm", object.getString("number"));
            map.put("fjsjsxzdm_name", object.getString("name"));
            String fjsjmsxdm = "";
            if (StringUtils.isNotEmpty((CharSequence)object.getString("secondcode"))) {
                fjsjmsxdm = object.getString("secondcode");
                map.put("fjsjmsxdm", fjsjmsxdm);
            }
            if (StringUtils.isEmpty((CharSequence)(policycaluse = object.getString("policycaluse")))) {
                policycaluse = "";
            }
            if (StringUtils.isNotBlank((CharSequence)fjsjmsxdm)) {
                map.put("fjsjmxzdm_mc", ZERO_PREFIX + object.getString("number") + VERTICAL_LINE + fjsjmsxdm + VERTICAL_LINE + object.getString("policyname") + policycaluse + VERTICAL_LINE + object.getString("name"));
            } else {
                map.put("fjsjmxzdm_mc", ZERO_PREFIX + object.getString("number") + VERTICAL_LINE + object.getString("policyname") + policycaluse + VERTICAL_LINE + object.getString("name"));
            }
            map.put("fjspolicyname", object.getString("policyname") + policycaluse);
        }
        if (map.containsKey(SDQYJMXZDM)) {
            DynamicObject sdqyObject = QueryServiceHelper.queryOne((String)TPO_TAXDEDUCTION, (String)"number,name,policyname,policycaluse,secondcode", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(map.get(SDQYJMXZDM)))});
            if (null != sdqyObject) {
                String policycaluse;
                map.put(SDQYJMXZDM, sdqyObject.getString("number"));
                map.put("sdqyjmxzdm_name", sdqyObject.getString("name"));
                String sdqyjmsxdm = "";
                if (StringUtils.isNotEmpty((CharSequence)sdqyObject.getString("secondcode"))) {
                    sdqyjmsxdm = sdqyObject.getString("secondcode");
                    map.put("sdqyjmsxdm", sdqyjmsxdm);
                }
                if (StringUtils.isEmpty((CharSequence)(policycaluse = sdqyObject.getString("policycaluse")))) {
                    policycaluse = "";
                }
                if (StringUtils.isNotBlank((CharSequence)sdqyjmsxdm)) {
                    map.put("sdqyjmxzdm_mc", ZERO_PREFIX + sdqyObject.getString("number") + VERTICAL_LINE + sdqyjmsxdm + VERTICAL_LINE + sdqyObject.getString("policyname") + policycaluse + VERTICAL_LINE + sdqyObject.getString("name"));
                } else {
                    map.put("sdqyjmxzdm_mc", sdqyObject.getString("number") + VERTICAL_LINE + sdqyObject.getString("policyname") + policycaluse + VERTICAL_LINE + sdqyObject.getString("name"));
                }
            } else {
                map.remove(SDQYJMXZDM);
            }
        }
    }

    private void sumFjs(List<Map<String, String>> dataList) {
        BigDecimal ybzzs = BigDecimal.ZERO;
        BigDecimal mdse = BigDecimal.ZERO;
        BigDecimal ldtsbqkce = BigDecimal.ZERO;
        BigDecimal xejmje = BigDecimal.ZERO;
        for (Map<String, String> fjsMap : dataList) {
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)fjsMap.get(EWBLXH)) && !StringUtils.equals((CharSequence)"2", (CharSequence)fjsMap.get(EWBLXH)) && !StringUtils.equals((CharSequence)"3", (CharSequence)fjsMap.get(EWBLXH))) continue;
            ybzzs = ybzzs.add(new BigDecimal(fjsMap.get("ybzzs")));
            mdse = mdse.add(new BigDecimal(fjsMap.get("mdse")));
            ldtsbqkce = ldtsbqkce.add(new BigDecimal(fjsMap.get("ldtsbqkce")));
            xejmje = xejmje.add(new BigDecimal(fjsMap.get("xejmje")));
        }
        for (Map<String, String> fjsMap : dataList) {
            if (!StringUtils.equals((CharSequence)"9", (CharSequence)fjsMap.get(EWBLXH))) continue;
            fjsMap.put("ybzzs", ybzzs.toString());
            fjsMap.put("mdse", mdse.toString());
            fjsMap.put("ldtsbqkce", ldtsbqkce.toString());
            fjsMap.put("xejmje", xejmje.toString());
            break;
        }
    }

    private void sumYhs(List<Map<String, String>> dataList, Map<Object, Object> returnMap) {
        BigDecimal acYnse = BigDecimal.ZERO;
        BigDecimal acDeducttax = BigDecimal.ZERO;
        BigDecimal acCalctaxamount = BigDecimal.ZERO;
        BigDecimal aqYnse = BigDecimal.ZERO;
        BigDecimal aqDeducttax = BigDecimal.ZERO;
        BigDecimal aqCalctaxamount = BigDecimal.ZERO;
        BigDecimal hjnse = BigDecimal.ZERO;
        BigDecimal hjdeducttax = BigDecimal.ZERO;
        BigDecimal hjcalctaxamount = BigDecimal.ZERO;
        for (Map<String, String> yhsMap : dataList) {
            hjnse = hjnse.add(new BigDecimal(yhsMap.get("ynse")));
            hjdeducttax = hjdeducttax.add(new BigDecimal(yhsMap.get("deducttax")));
            hjcalctaxamount = hjcalctaxamount.add(new BigDecimal(yhsMap.get("calctaxamount")));
            if (StringUtils.equals((CharSequence)"aqsb", (CharSequence)yhsMap.get("declaretype"))) {
                aqYnse = aqYnse.add(new BigDecimal(yhsMap.get("ynse")));
                aqDeducttax = aqDeducttax.add(new BigDecimal(yhsMap.get("deducttax")));
                aqCalctaxamount = aqCalctaxamount.add(new BigDecimal(yhsMap.get("calctaxamount")));
                continue;
            }
            if (!StringUtils.equals((CharSequence)"acsb", (CharSequence)yhsMap.get("declaretype"))) continue;
            acYnse = acYnse.add(new BigDecimal(yhsMap.get("ynse")));
            acDeducttax = acDeducttax.add(new BigDecimal(yhsMap.get("deducttax")));
            acCalctaxamount = acCalctaxamount.add(new BigDecimal(yhsMap.get("calctaxamount")));
        }
        returnMap.put("yhs_acynse", acYnse);
        returnMap.put("yhs_acdeducttax", acDeducttax);
        returnMap.put("yhs_accalctaxamount", acCalctaxamount);
        returnMap.put("yhs_aqynse", aqYnse);
        returnMap.put("yhs_aqdeducttax", aqDeducttax);
        returnMap.put("yhs_aqcalctaxamount", aqCalctaxamount);
        returnMap.put("yhs_hjynse", hjnse);
        returnMap.put("yhs_hjdeducttax", hjdeducttax);
        returnMap.put("yhs_hjcalctaxamount", hjcalctaxamount);
    }

    private static boolean isNumeric(String str) {
        Pattern pattern = Pattern.compile("[1-9]+\\.?[0-9]+");
        Pattern pattern2 = Pattern.compile("[1-9]+");
        Matcher isNum = pattern.matcher(str);
        Matcher isNum2 = pattern2.matcher(str);
        return isNum.matches() || isNum2.matches();
    }

    private static void dealTopTaxoffice(Map<Object, Object> map, Long orgId) {
        Long[] taxOfficeIdsids;
        Map info;
        TsateCommonConfig cfg = TsateCommonConfig.getInstance();
        Map taxOfficeIdMap = cfg.getTopTaxofficeId(Collections.singletonList(orgId));
        if (taxOfficeIdMap.size() > 0 && (info = cfg.getTaxofficeInfo((taxOfficeIdsids = taxOfficeIdMap.values().toArray(new Long[0]))[0])) != null) {
            map.put("sbsj_id", info.get("id"));
            map.put("sbsj_number", info.get("number"));
            map.put("sbsj_name", info.get("name"));
        }
    }
}

