/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.collection.datacollection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.msmessage.collection.datacollection.DataCollectionService;
import kd.taxc.tsate.msmessage.collection.declare.DeclareFormDataCollection;
import kd.taxc.tsate.msmessage.collection.declare.LedgerDataCollection;
import kd.taxc.tsate.msmessage.domain.MessageSend;

public enum DataCollectionServiceEnum {
    DECLARE_MODLE_3("declare", "3", Collections.singletonList(new DeclareFormDataCollection())),
    DECLARE_CJRJYBZJ_MODLE_3("declare", DeclareTypeEnum.TOTF_CJRJYBZJ, "3", Lists.newArrayList((Object[])new DataCollectionService[]{new DeclareFormDataCollection(), new LedgerDataCollection()}));

    private String msgType;
    private SupplierEnum supplier;
    private DeclareTypeEnum declareType;
    private String version;
    private List<DataCollectionService> dataCollectionServices;

    public String getMsgType() {
        return this.msgType;
    }

    public SupplierEnum getSupplier() {
        return this.supplier;
    }

    public DeclareTypeEnum getDeclareType() {
        return this.declareType;
    }

    public String getVersion() {
        return this.version;
    }

    private DataCollectionServiceEnum(String msgType, SupplierEnum supplier, DeclareTypeEnum declareType, String version, List<DataCollectionService> dataCollectionServices) {
        this.msgType = msgType;
        this.supplier = supplier;
        this.declareType = declareType;
        this.version = version;
        this.dataCollectionServices = dataCollectionServices;
    }

    private DataCollectionServiceEnum(String msgType, DeclareTypeEnum declareType, String version, List<DataCollectionService> dataCollectionServices) {
        this.msgType = msgType;
        this.declareType = declareType;
        this.version = version;
        this.dataCollectionServices = dataCollectionServices;
    }

    private DataCollectionServiceEnum(String msgType, String version, List<DataCollectionService> dataCollectionServices) {
        this.msgType = msgType;
        this.version = version;
        this.dataCollectionServices = dataCollectionServices;
    }

    public List<DataCollectionService> getDataCollectionServices() {
        return this.dataCollectionServices;
    }

    public static List<DataCollectionService> getServiceByMessageSend(MessageSend messageSend) {
        int level = 0;
        List<DataCollectionService> collectionServices = new ArrayList<DataCollectionService>();
        for (DataCollectionServiceEnum serviceEnum : DataCollectionServiceEnum.values()) {
            Boolean msgEquals = DataCollectionServiceEnum.msgEquals(messageSend, serviceEnum);
            Boolean supplierEquals = DataCollectionServiceEnum.supplierEquals(messageSend, serviceEnum);
            Boolean declareTypeEquals = DataCollectionServiceEnum.declareTypeEquals(messageSend, serviceEnum);
            Boolean versionEquals = DataCollectionServiceEnum.versionEquals(messageSend, serviceEnum);
            List<DataCollectionService> dataCollectionServices = serviceEnum.getDataCollectionServices();
            if (msgEquals.booleanValue() && supplierEquals.booleanValue() && declareTypeEquals.booleanValue() && versionEquals.booleanValue()) {
                return dataCollectionServices;
            }
            if (msgEquals.booleanValue() && declareTypeEquals.booleanValue() && versionEquals.booleanValue() && level < 3) {
                level = 3;
                collectionServices = dataCollectionServices;
            }
            if (!msgEquals.booleanValue() || !versionEquals.booleanValue() || level >= 2) continue;
            level = 2;
            collectionServices = dataCollectionServices;
        }
        return collectionServices;
    }

    private static Boolean versionEquals(MessageSend messageSend, DataCollectionServiceEnum serviceEnum) {
        return serviceEnum.getVersion().equals(messageSend.getVersion());
    }

    private static Boolean declareTypeEquals(MessageSend messageSend, DataCollectionServiceEnum serviceEnum) {
        if (serviceEnum.getDeclareType() == null) {
            return false;
        }
        return serviceEnum.getDeclareType().getCode().equals(messageSend.getBusinesstype());
    }

    private static Boolean supplierEquals(MessageSend messageSend, DataCollectionServiceEnum serviceEnum) {
        if (serviceEnum.getSupplier() == null) {
            return false;
        }
        return serviceEnum.getSupplier().getName().equals(messageSend.getSupplier());
    }

    private static Boolean msgEquals(MessageSend messageSend, DataCollectionServiceEnum serviceEnum) {
        return serviceEnum.getMsgType().equals(messageSend.getMsgtype());
    }
}

