/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.config;

import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.event.FKXXChangedEventBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import org.apache.commons.lang.StringUtils;

public class ConnectConfigService {
    private static Log logger = LogFactory.getLog(ConnectConfigService.class);
    private static final String CONFIG_MAIN_ENTITY = "tsate_declare_config";

    public static IdentityData queryIdentityData(SBMessageBaseVo vo) {
        QFilter qFilter;
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org,taxpayer", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        String allFields = MetadataUtil.getAllFieldString((String)CONFIG_MAIN_ENTITY);
        DynamicObject[] configData = BusinessDataServiceHelper.load((String)CONFIG_MAIN_ENTITY, (String)allFields, (QFilter[])new QFilter[]{qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org")).and(new QFilter("enable", "=", (Object)"1"))}, (String)"modifytime desc");
        if (null != configData && configData.length > 0) {
            String[] telephoneNums;
            IdentityData data = new IdentityData();
            data.setUsername(configData[0].getString("taxusername"));
            data.setPassword(configData[0].getString("taxpassword"));
            data.setNsrmc(taxOrg.getString("taxpayer"));
            data.setNsrsbh(vo.getNsrsbh());
            data.setTaxmanName(configData[0].getString("taxmanname"));
            data.setTaxmanPwd(configData[0].getString("taxmanpassword"));
            data.setCapassword(configData[0].getString("capassword"));
            String telephoneNum = configData[0].getString("telephone");
            if (EmptyCheckUtils.isNotEmpty((Object)telephoneNum) && (telephoneNums = telephoneNum.split("-")).length > 1) {
                telephoneNum = telephoneNum.split("-")[1];
            }
            data.setTelephoneNum(telephoneNum);
            data.setJghm(configData[0].getString("jghm"));
            data.setLoginType(configData[0].getString("logintype"));
            data.setJgport(configData[0].getString("jgport"));
            data.setValidatestatus(configData[0].getString("validatestatus"));
            data.setId(Long.valueOf(configData[0].getLong("id")));
            data.setDlsf(configData[0].getString("dlsf"));
            data.setTaxmanSfz(configData[0].getString("taxmansfz"));
            return data;
        }
        return null;
    }

    public static IdentityData queryIdentityDataByNsrsbh(String nsrsbh) {
        QFilter qFilter;
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org,taxpayer", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)nsrsbh)});
        String allFields = MetadataUtil.getAllFieldString((String)CONFIG_MAIN_ENTITY);
        DynamicObject[] configData = BusinessDataServiceHelper.load((String)CONFIG_MAIN_ENTITY, (String)allFields, (QFilter[])new QFilter[]{qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org")).and(new QFilter("enable", "=", (Object)"1"))}, (String)"modifytime desc");
        if (null != configData && configData.length > 0) {
            String[] telephoneNums;
            IdentityData data = new IdentityData();
            data.setUsername(configData[0].getString("taxusername"));
            data.setPassword(configData[0].getString("taxpassword"));
            data.setNsrmc(taxOrg.getString("taxpayer"));
            data.setNsrsbh(nsrsbh);
            data.setTaxmanName(configData[0].getString("taxmanname"));
            data.setTaxmanPwd(configData[0].getString("taxmanpassword"));
            data.setCapassword(configData[0].getString("capassword"));
            String telephoneNum = configData[0].getString("telephone");
            if (EmptyCheckUtils.isNotEmpty((Object)telephoneNum) && (telephoneNums = telephoneNum.split("-")).length > 1) {
                telephoneNum = telephoneNum.split("-")[1];
            }
            data.setTelephoneNum(telephoneNum);
            data.setJghm(configData[0].getString("jghm"));
            data.setLoginType(configData[0].getString("logintype"));
            data.setJgport(configData[0].getString("jgport"));
            data.setValidatestatus(configData[0].getString("validatestatus"));
            data.setId(Long.valueOf(configData[0].getLong("id")));
            data.setDlsf(configData[0].getString("dlsf"));
            data.setTaxmanSfz(configData[0].getString("taxmansfz"));
            return data;
        }
        return null;
    }

    public static boolean isExistQcRecord(SBMessageBaseVo vo) {
        return ConnectConfigService.isExistQcRecord(vo, false);
    }

    public static boolean isExistQcRecord(SBMessageBaseVo vo, boolean checkRecord) {
        DynamicObject[] signInfoData;
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        QFilter qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org"));
        QFilter typeFilter = new QFilter("type", "=", (Object)vo.getType());
        QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)vo.getSkssqq()).and(new QFilter("skssqz", "<=", (Object)vo.getSkssqz()));
        if (checkRecord) {
            qFilter.and("recordid", "=", (Object)(vo.getId() + ""));
        }
        return null != (signInfoData = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)"qcstatus", (QFilter[])new QFilter[]{qFilter.and(typeFilter).and(skssqqzFilter)})) && signInfoData.length > 0;
    }

    public static boolean isObtainQcData(SBMessageBaseVo vo) {
        return ConnectConfigService.isObtainQcData(vo, false);
    }

    public static boolean isObtainQcData(SBMessageBaseVo vo, boolean checkRecord) {
        DynamicObject[] signInfoData;
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        QFilter qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org"));
        qFilter.and("sbbid", "=", (Object)vo.getBusinessId());
        QFilter typeFilter = new QFilter("type", "=", (Object)vo.getType());
        QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)vo.getSkssqq()).and(new QFilter("skssqz", "<=", (Object)vo.getSkssqz()));
        if (checkRecord) {
            qFilter.and("recordid", "=", (Object)(vo.getId() + ""));
        }
        if (null != (signInfoData = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)"qcstatus", (QFilter[])new QFilter[]{qFilter.and(typeFilter).and(skssqqzFilter)})) && signInfoData.length > 0) {
            return StringUtils.equals((String)signInfoData[0].getString("qcstatus"), (String)"1");
        }
        DynamicObject signInfo = BusinessDataServiceHelper.newDynamicObject((String)"tsate_sign_info");
        signInfo.set("org", (Object)taxOrg.getLong("org"));
        signInfo.set("skssqq", (Object)vo.getSkssqq());
        signInfo.set("createtime", (Object)new Date());
        signInfo.set("creator", (Object)RequestContext.get().getUserId());
        signInfo.set("qcstatus", (Object)"0");
        signInfo.set("skssqz", (Object)vo.getSkssqz());
        signInfo.set("type", (Object)vo.getType());
        signInfo.set("sbbid", (Object)vo.getBusinessId());
        signInfo.set("billstatus", (Object)"C");
        signInfo.set("recordid", (Object)("" + vo.getId()));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{signInfo});
        return false;
    }

    public static DynamicObject getRequestId(String nsrsbh, String nsrType, Date skssqq, Date skssqz, String status) {
        return ConnectConfigService.getRequestId(nsrsbh, nsrType, skssqq, skssqz, status, RequestTypeEnum.DECLARE);
    }

    public static DynamicObject getRequestId(String nsrsbh, String nsrType, Date skssqq, Date skssqz, String status, RequestTypeEnum requestType) {
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)nsrsbh)});
        QFilter qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org"));
        QFilter typeFilter = new QFilter("type", "=", (Object)nsrType);
        QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)skssqq).and(new QFilter("skssqz", "<=", (Object)skssqz));
        if (EmptyCheckUtils.isNotEmpty((Object)status)) {
            skssqqzFilter = skssqqzFilter.and(new QFilter("executestatus", "=", (Object)status));
        }
        if (requestType == null) {
            requestType = RequestTypeEnum.DECLARE;
        }
        QFilter requestTypeFilter = new QFilter("requesttype", "=", (Object)requestType.getCode());
        DynamicObject[] requestData = BusinessDataServiceHelper.load((String)"tsate_declare_status_info", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_status_info"), (QFilter[])new QFilter[]{qFilter.and(typeFilter).and(skssqqzFilter).and(requestTypeFilter)}, (String)"createtime desc");
        if (null != requestData && requestData.length > 0) {
            return requestData[0];
        }
        return null;
    }

    public static DynamicObject buildRequestId(String requestId, SBMessageBaseVo vo, RequestTypeEnum requestType) {
        DynamicObject taxOrg;
        if (requestType == null) {
            requestType = RequestTypeEnum.VERIFICATION;
        }
        if ((taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())})) != null) {
            Object obj;
            DynamicObject requestInfo = ConnectConfigService.getRequestIdByRequestType(vo.getNsrsbh(), "1", requestType);
            if (requestInfo == null) {
                requestInfo = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_status_info");
                requestInfo.set("org", (Object)taxOrg.getLong("org"));
                requestInfo.set("billstatus", (Object)"C");
                requestInfo.set("requesttype", (Object)requestType.getCode());
            }
            requestInfo.set("executestatus", (Object)"1");
            requestInfo.set("createtime", (Object)new Date());
            requestInfo.set("creator", (Object)RequestContext.get().getUserId());
            requestInfo.set("requestid", (Object)requestId);
            Object[] result = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestInfo});
            if (result.length > 0 && (obj = result[0]) instanceof DynamicObject) {
                DynamicObject dynObj = (DynamicObject)obj;
                return dynObj;
            }
        }
        return null;
    }

    public static DynamicObject getRequestIdByRequestType(String nsrsbh, String status, RequestTypeEnum requestType) {
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)nsrsbh)});
        QFilter qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org")).and("executestatus", "=", (Object)status);
        if (requestType == null) {
            requestType = RequestTypeEnum.VERIFICATION;
        }
        QFilter requestTypeFilter = new QFilter("requesttype", "=", (Object)requestType.getCode());
        DynamicObject[] requestData = BusinessDataServiceHelper.load((String)"tsate_declare_status_info", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_status_info"), (QFilter[])new QFilter[]{qFilter.and(requestTypeFilter)}, (String)"createtime desc");
        if (null != requestData && requestData.length > 0) {
            return requestData[0];
        }
        return null;
    }

    public static void dealFkxx(Object info, String sbbId, boolean isSuccess) {
        if (!isSuccess) {
            DeleteServiceHelper.delete((String)"tsate_sign_info", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
        } else {
            DynamicObject[] recordObjs = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)MetadataUtil.getAllFieldString((String)"tsate_sign_info"), (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)sbbId)});
            if (recordObjs != null && recordObjs.length > 0) {
                String oldFkxx = (String)recordObjs[0].get("sjfkxx_tag");
                recordObjs[0].set("sjfkxx_tag", info);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObjs[0]});
                FKXXChangedEventBusiness.convertDataAndSendEvent((SupplierEnum)SupplierEnum.ZWY, (String)oldFkxx, (String)((String)info));
            }
        }
    }

    public static void updateStatusInfo(Long id, String statusInfo, String executestatus) {
        DynamicObject requestObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)"tsate_declare_status_info");
        if (null != requestObj && !StringUtils.equals((String)executestatus, (String)requestObj.getString("executestatus"))) {
            requestObj.set("detailinfo_tag", (Object)statusInfo);
            requestObj.set("executestatus", (Object)executestatus);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestObj});
        }
    }

    public static void updateIdentityData(Long id, String status) {
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)id, (String)CONFIG_MAIN_ENTITY);
        if (null != obj) {
            obj.set("validatetime", (Object)new Date());
            obj.set("validatestatus", (Object)status);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
        }
    }

    public static void updateSignInfo(SBMessageBaseVo vo, String status) {
        ConnectConfigService.updateSignInfo(vo, status, false);
    }

    public static void updateSignInfo(SBMessageBaseVo vo, String status, boolean checkRecord) {
        DynamicObject[] signInfoData;
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        QFilter qFilter = new QFilter("org", "=", (Object)taxOrg.getLong("org"));
        QFilter typeFilter = new QFilter("type", "=", (Object)vo.getType());
        QFilter skssqqzFilter = new QFilter("skssqq", ">=", (Object)vo.getSkssqq()).and(new QFilter("skssqz", "<=", (Object)vo.getSkssqz()));
        if (checkRecord) {
            qFilter.and("recordid", "=", (Object)vo.getId());
        }
        if (null != (signInfoData = BusinessDataServiceHelper.load((String)"tsate_sign_info", (String)MetadataUtil.getAllFieldString((String)"tsate_sign_info"), (QFilter[])new QFilter[]{qFilter.and(typeFilter).and(skssqqzFilter)}, (String)"modifytime desc")) && signInfoData.length > 0) {
            signInfoData[0].set("qcstatus", (Object)status);
            signInfoData[0].set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{signInfoData[0]});
        }
    }
}

