/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.constant;

import java.util.HashMap;
import java.util.Map;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.tsate.common.enums.taxservice.ServiceCollectionEunm;
import kd.taxc.tsate.msmessage.domain.MessageSend;

public class MessageConstant {
    public static final String MSG_STATUS_WAITING = "waiting";
    public static final String MSG_STATUS_FAIL = "fail";
    public static final String MSG_STATUS_SUCCESS = "success";
    private static final String NODE_TYPE_QINGDAO = "qingdao";
    public static final String MSG_TYPE = "declare";
    public static final String PAY_MSG_TYPE = "pay";
    public static final String HISTORY_TYPE = "history";
    public static final String QC_TYPE = "qcxz";
    public static final String LSXZ_TYPE = "lsxz";
    public static final String VERIFICATION_TYPE = "verification";
    public static final String VERIFICATION_TYPE_SZYH = "verification_szyh";
    public static final String VERIFICATION_TYPE_YZF = "verification_yzf";
    public static final String VERIFICATION_TYPE_ZWY = "verification_kd";
    public static final String VERIFICATION_TYPE_QXY = "verification_qxy";
    public static final String NoCallBackUrl = "-1";
    private static final Map<String, String> MSG_COLLECTION_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MessageConstant.MSG_TYPE, "kd.taxc.tsate.msmessage.collection.SbbCollection");
            this.put(MessageConstant.PAY_MSG_TYPE, "kd.taxc.tsate.msmessage.collection.CloudccPayCollection");
            this.put(MessageConstant.HISTORY_TYPE, "kd.taxc.tsate.msmessage.collection.HistoryCollectionForKdImpl");
            this.put(MessageConstant.QC_TYPE, "kd.taxc.tsate.msmessage.collection.HistoryCollectionForKdImpl");
            this.put(MessageConstant.LSXZ_TYPE, "kd.taxc.tsate.msmessage.collection.HistoryCollectionForKdImpl");
            this.put(MessageConstant.VERIFICATION_TYPE_SZYH, "kd.taxc.tsate.msmessage.collection.verification.VerificationCollectionForSzyhImpl");
            this.put(MessageConstant.VERIFICATION_TYPE_YZF, "kd.taxc.tsate.msmessage.collection.verification.VerificationCollectionForYzfImpl");
            this.put(MessageConstant.VERIFICATION_TYPE_ZWY, "kd.taxc.tsate.msmessage.collection.verification.VerificationCollectionForKdImpl");
            this.put(MessageConstant.VERIFICATION_TYPE_QXY, "kd.taxc.tsate.msmessage.collection.verification.VerificationCollectionForQxyImpl");
        }
    };
    private static final Map<String, String> MSG_OUTADAPTER_MAP = new HashMap<String, String>(){
        private static final long serialVersionUID = 1L;
        {
            this.put(MessageConstant.NODE_TYPE_QINGDAO, "QingDaoOutAdapter");
        }
    };

    public static String getCollection(String msgType, String businessType) {
        String coll = MSG_COLLECTION_MAP.get(msgType + "." + businessType);
        if (coll == null) {
            coll = MSG_COLLECTION_MAP.get(msgType);
        }
        return coll;
    }

    public static String getCollection(String msgType, String businessType, String supplier) {
        String coll = MSG_COLLECTION_MAP.get(msgType + "." + businessType);
        if (coll == null) {
            coll = MSG_COLLECTION_MAP.get(msgType + "_" + supplier);
        }
        if (coll == null) {
            coll = MSG_COLLECTION_MAP.get(msgType);
        }
        return coll;
    }

    public static String getOutAdapter(String nodeType, String msgType) {
        String coll = MSG_OUTADAPTER_MAP.get(nodeType + "." + msgType);
        if (coll == null) {
            coll = MSG_OUTADAPTER_MAP.get(nodeType);
        }
        return coll;
    }

    public static String getCollectionForModel(MessageSend messageSend) {
        String businessIdentification = messageSend.getMsgtype() + "_" + messageSend.getVersion();
        String classNameByIdentification = ServiceCollectionEunm.getClassNameByIdentification((String)businessIdentification);
        if (StringUtil.isNotBlank((CharSequence)classNameByIdentification)) {
            return classNameByIdentification;
        }
        return "";
    }
}

