/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.domain;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

class BaseMessageVo
implements Serializable {
    private static final Log LOGGER = LogFactory.getLog(BaseMessageVo.class);
    private final Map<String, Object> params = new HashMap<String, Object>();

    BaseMessageVo() {
    }

    public void fillBySource(BaseMessageVo source) {
        this.setParams(source.getParams());
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params.putAll(params);
    }

    public <T extends BaseMessageVo> T handler(Class<T> a) {
        try {
            BaseMessageVo obj = (BaseMessageVo)a.newInstance();
            obj.setParams(this.getParams());
            return (T)obj;
        }
        catch (Exception e) {
            LOGGER.error(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b9e\u4f8b\u5931\u8d25", (String)"BaseMessageVo_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            return null;
        }
    }

    public String toString() {
        return JSON.toJSONString(this.params);
    }

    protected <T> T getProp(String propKey, Class<T> clazz) {
        Object obj = this.getParams().get(propKey);
        if (obj == null) {
            return null;
        }
        if (clazz.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (clazz == String.class) {
            return (T)obj.toString();
        }
        String format = ResManager.loadKDString((String)"%s \u5c5e\u6027\u7c7b\u578b\u4e0d\u5339\u914d\uff0c\u9700\u8981\u68c0\u67e5\u7c7b\u578b\u662f\u5426\u5df2\u6b63\u786e\u6307\u5b9a", (String)"BaseMessageVo_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
        LOGGER.warn(String.format(format, propKey));
        return null;
    }

    public String getString(IMapKey mapKey) {
        return this.getProp(mapKey.getKey(), String.class);
    }

    public Float getFloat(IMapKey mapKey) {
        if (mapKey.getType() != Float.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Float.class);
    }

    public Double getDouble(IMapKey mapKey) {
        if (mapKey.getType() != Double.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Double.class);
    }

    public Integer getInteger(IMapKey mapKey) {
        if (mapKey.getType() != Integer.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Integer.class);
    }

    public Long getLong(IMapKey mapKey) {
        if (mapKey.getType() != Long.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Long.class);
    }

    public Character getChar(IMapKey mapKey) {
        if (mapKey.getType() != Character.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Character.class);
    }

    public Byte getByte(IMapKey mapKey) {
        if (mapKey.getType() != Byte.class) {
            return null;
        }
        return this.getProp(mapKey.getKey(), Byte.class);
    }

    public Date getDate(IMapKey mapKey) {
        if (mapKey.getType() != Date.class) {
            return null;
        }
        Date target = this.getProp(mapKey.getKey(), Date.class);
        if (target == null) {
            String dateStr = this.getProp(mapKey.getKey(), String.class);
            if (dateStr == null) {
                return null;
            }
            int length = dateStr.length();
            HashMap<Integer, String> lenthMap = new HashMap<Integer, String>(10);
            lenthMap.put(4, "yyyy");
            lenthMap.put(7, "yyyy-MM");
            lenthMap.put(10, "yyyy-MM-dd");
            lenthMap.put(13, "yyyy-MM-dd HH");
            lenthMap.put(16, "yyyy-MM-dd HH:mm");
            lenthMap.put(19, "yyyy-MM-dd HH:mm:ss");
            if (lenthMap.containsKey(length)) {
                SimpleDateFormat sdf = new SimpleDateFormat((String)lenthMap.get(length));
                try {
                    return sdf.parse(dateStr);
                }
                catch (ParseException e) {
                    LOGGER.error(ResManager.loadKDString((String)"\u5b57\u7b26\u4e32\u8f6c\u6362\u65f6\u95f4\u5f02\u5e38 \u5b57\u7b26\u4e32\uff1a%1$s \u683c\u5f0f\uff1a%2$s", (String)"BaseMessageVo_2", (String)"taxc-tsate-mservice", (Object[])new Object[]{dateStr, lenthMap.get(length)}));
                    return null;
                }
            }
            return null;
        }
        return target;
    }

    static interface IMapKey {
        public String getKey();

        public Class getType();
    }
}

