/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSON;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.util.HttpUtil;

public abstract class AbstractIscRequest {
    private static final Log logger = LogFactory.getLog(AbstractIscRequest.class);
    private static final String kEY_PROXY = "kd_proxy";

    public Object post(String url, Map<String, String> headers, String body) {
        if (this.getIscSwitch()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            boolean checkJson = false;
            try {
                JSON.parseObject((String)body);
                checkJson = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (checkJson) {
                paramMap.put("body", JSON.parseObject((String)body));
            } else {
                paramMap.put("body", body);
            }
            return this.invokeService(url, headers, this.resolveParamsMap(url, headers, paramMap));
        }
        return this.doHttpUtilPost(url, headers, body);
    }

    protected abstract String name();

    protected Object doHttpUtilPost(String url, Map<String, String> headers, Object body) {
        if (body instanceof String) {
            return HttpUtil.doPost((String)url, headers, (String)((String)body));
        }
        if (body instanceof Map) {
            return HttpUtil.doPost((String)url, headers, (Map)((Map)body));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bf7\u6c42\u5f02\u5e38-\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b", (String)"AbstractIscRequest_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
    }

    protected Object doHttpUtilGet(String url, Map<String, String> headers, Object body) {
        if (body instanceof Map) {
            return HttpUtil.doGet((String)url, headers, (Map)((Map)body));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u8bf7\u6c42\u5f02\u5e38-\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b", (String)"AbstractIscRequest_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
    }

    public Object post(String url, Map<String, String> headers, Map<String, Object> params) {
        if (this.getIscSwitch()) {
            return this.invokeService(url, headers, this.resolveParamsMap(url, headers, params));
        }
        return this.doHttpUtilPost(url, headers, params);
    }

    public Object get(String url, Map<String, String> headers, Map<String, Object> params) {
        if (this.getIscSwitch()) {
            return this.invokeService(url, headers, this.resolveParamsMap(url, headers, params));
        }
        return this.doHttpUtilGet(url, headers, params);
    }

    protected abstract boolean getIscSwitch();

    protected boolean querySwitch(String key) {
        QFilter filter = new QFilter("key", "=", (Object)key);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter});
        return obj != null && "on".equals(obj.getString("value"));
    }

    protected abstract String resolveApiCode(String var1, Map<String, String> var2, Map<String, Object> var3);

    public Map<String, Object> resolveParamsMap(String url, Map<String, String> headers, Map<String, Object> params) {
        return params;
    }

    protected Map<String, Object> resolveCookiesMap(String url, Map<String, String> headers, Map<String, Object> params) {
        return new HashMap<String, Object>(2);
    }

    protected String[] getProxy() {
        String proxyStr;
        QFilter filter = new QFilter("key", "=", (Object)kEY_PROXY);
        DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter});
        if (obj != null && (proxyStr = obj.getString("value")) != null && proxyStr.contains(":")) {
            return proxyStr.split(":");
        }
        return null;
    }

    public Object invokeService(String url, Map<String, String> headers, Map<String, Object> params) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>(16);
        inputParams.put("inputParams", this.resolveParamsMap(url, headers, params));
        String apiNumber = this.resolveApiCode(url, headers, params);
        if (apiNumber == null) {
            String e = ResManager.loadKDString((String)"\u89e3\u6790apiNumber\u4e3a\u7a7a\uff0c\u9700\u8981\u68c0\u67e5\u8bf7\u6c42\u8def\u5f84\u4e0e\u96c6\u6210\u4e91code\u6620\u5c04\u5173\u7cfb:%1$s", (String)"AbstractIscRequest_1", (String)"taxc-tsate-mservice", (Object[])new Object[]{url});
            logger.error(e);
            throw new KDBizException(e);
        }
        inputParams.put("apiNumber", apiNumber);
        inputParams.put("caller", "taxc-tsate");
        inputParams.put("enableSingleApiNumber", true);
        url = this.dealIscProxyUrl(url);
        HashMap<String, Object> rq = new HashMap<String, Object>(16);
        rq.put("url", url);
        rq.put("method", "post");
        rq.put("headers", headers);
        rq.put("cookies", this.resolveCookiesMap(url, headers, params));
        rq.put("charset", StandardCharsets.UTF_8);
        inputParams.put("requestMapping", rq);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tdm", (String)"MicroServiceApiDispatcher", (String)"executeTaxService", (Object[])new Object[]{SerializationUtils.toJsonString(inputParams)});
        RequestResult reqResult = (RequestResult)SerializationUtils.fromJsonString((String)result, RequestResult.class);
        return this.handleRep(reqResult, apiNumber);
    }

    protected Object handleRep(RequestResult reqResult, String apiNumber) {
        Map map;
        Object data = reqResult.getData();
        if (data instanceof Map && (map = (Map)data).containsKey("result")) {
            return map.get("result");
        }
        logger.error("\u96c6\u6210\u4e91\u8fd4\u56de\u7684\u683c\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42:" + JSON.toJSONString((Object)reqResult));
        return null;
    }

    private String dealIscProxyUrl(String url) {
        StringBuilder sb = new StringBuilder(url);
        String[] proxyInfo = this.getProxy();
        if (proxyInfo != null) {
            int indexOfProtocolEnd = url.indexOf("://");
            indexOfProtocolEnd = indexOfProtocolEnd != -1 ? (indexOfProtocolEnd += 3) : 0;
            StringBuilder proxy = new StringBuilder();
            proxy.append(proxyInfo[0]).append(":").append(proxyInfo[1]);
            proxy.append("=>");
            sb.insert(indexOfProtocolEnd, proxy);
        }
        return sb.toString();
    }
}

