/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.fileservice.utils.ExceptionUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.cloudcc.CloudccMessageSendConstant;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.ext.cloudcc.beans.UrlParams;
import kd.taxc.tsate.common.ext.cloudcc.utils.HttpUtils;
import kd.taxc.tsate.common.ext.cloudcc.utils.Md5Utils;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.enums.CcxwsTypeEnums;
import kd.taxc.tsate.msmessage.enums.szyh.SzyhStatusPriorityEnums;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.szyh.SzyhRequest;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;

public class CloudccDirectDeclareService {
    private static final Log logger = LogFactory.getLog(CloudccDirectDeclareService.class);
    public static final String REQUEST_ID = "requestId";
    public static final String FILE_NO = "FileNo";
    public static final String VERSION = "1.0";
    public static final String DATE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String DECLARE = "declare";
    public static final String PAY = "pay";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final Integer STATUS_LEVELS = 4;

    public static ApiResult declare(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/submissionOfTaxMessage/dataSubmit";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            MessageSend templateMessage = new MessageSend();
            templateMessage.setMsgtype(DECLARE);
            templateMessage.setBusinessid(vo.getBusinessId());
            templateMessage.setBusinesstype(vo.getType());
            templateMessage.setNsrType(vo.getType());
            CloudccDirectDeclareService.dealCcxwsType(vo, templateMessage);
            templateMessage.setNodetype(vo.getSbdq());
            templateMessage.setSupplier(SupplierEnum.CLOUDCC.getName());
            String reqContent = MessageService.collection(templateMessage, vo.getNsrsbh());
            if (StringUtils.isNotBlank((CharSequence)reqContent)) {
                reqContent = reqContent.replaceAll("---", "##");
            }
            StringBuilder detailLog = new StringBuilder();
            detailLog.append(ResManager.loadKDString((String)"\u7533\u62a5\u62a5\u6587:", (String)"CloudccDirectDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(reqContent).append(SEPARATOR);
            String passWord = (String)configMap.get("cloudcc_access_password");
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            detailLog.append((CharSequence)reqStringBuilder);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, reqContent);
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            logger.info(String.format("cloudcc declare resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = CloudccDirectDeclareService.dealResponse(responseMap, vo, "directdeclare", REQUEST_ID);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult queryTaskStatus(SBMessageBaseVo vo, String requestId, String type) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            String reqUrl = baseUrl + "/declarationResultController/declareNumResultQuery";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            urlParams.setAccessKeyID(accessKeyId);
            MessageSend send = new MessageSend();
            send.setMsgtype(DECLARE);
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(DECLARE);
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.CLOUDCC.getName());
            send.setBusinessid(vo.getBusinessId());
            String passWord = (String)configMap.get("cloudcc_access_password");
            String content = MessageService.collectionPayData(send, requestId, vo.getNsrsbh(), BigDecimal.ZERO);
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, content);
            logger.info(String.format("cloudcc querystatus resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null && StringUtils.equals((CharSequence)"2", (CharSequence)(apiResult = CloudccDirectDeclareService.getTaskStatus(responseMap, type)).getErrorCode())) {
                logger.info("cloudcc\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                if ("directdeclare".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", new StringBuilder());
                } else if ("fastpay".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", new StringBuilder());
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult pay(String requestId, SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            Object detailInfo;
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/deductionController/deductionDeclareNum";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            MessageSend send = new MessageSend();
            send.setMsgtype(PAY);
            send.setBusinesstype(PAY);
            send.setSupplier(SupplierEnum.CLOUDCC.getName());
            send.setBusinessid(vo.getBusinessId());
            apiResult = CloudccDirectDeclareService.queryTaskStatus(vo, requestId, "directdeclare");
            if (apiResult != null && (detailInfo = apiResult.getData()) != null) {
                JSONObject body = JSONObject.parseObject((String)String.valueOf(detailInfo));
                JSONArray taxAmountArray = body.getJSONObject("Root").getJSONArray("TaskResult").getJSONObject(0).getJSONArray("Result").getJSONObject(0).getJSONArray("TaxAmounts");
                BigDecimal taxAmount = BigDecimal.ZERO;
                if (taxAmountArray != null && taxAmountArray.size() > 0) {
                    JSONArray taxAmounts = taxAmountArray.getJSONObject(0).getJSONArray("TaxAmount");
                    for (int i = 0; i < taxAmounts.size(); ++i) {
                        String[] amounts;
                        String amount = taxAmounts.getString(i);
                        if (!EmptyCheckUtils.isNotEmpty((Object)amount) || (amounts = amount.contains(":") ? amount.split(":") : amount.split("####")) == null || amounts.length <= 1) continue;
                        taxAmount = taxAmount.add(new BigDecimal(amounts[1]));
                    }
                }
                if (vo.getYbtse().compareTo(taxAmount) != 0) {
                    String message = ResManager.loadKDString((String)"\u7533\u62a5\u7a0e\u989d\u4e0d\u4e00\u81f4", (String)"CloudccDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                } else {
                    vo.setRequestId(requestId);
                    String reqContent = MessageService.collectionPayData(send, requestId, vo.getNsrsbh(), taxAmount);
                    String passWord = (String)configMap.get("cloudcc_access_password");
                    StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
                    CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
                    String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, reqContent);
                    logger.info(String.format("cloudcc pay resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
                    if (StringUtils.isBlank((CharSequence)response)) {
                        String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                        apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                        return apiResult;
                    }
                    Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
                    apiResult = CloudccDirectDeclareService.dealResponse(responseMap, vo, "fastpay", REQUEST_ID);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static ApiResult downloadVoucher(SBMessageBaseVo vo, StringBuilder failedLog, Date skssqz) {
        String response;
        HashMap<String, Object> params;
        String passWord;
        String accessKeyId;
        String baseUrl;
        InputStream in;
        ApiResult apiResult;
        block15: {
            apiResult = new ApiResult();
            in = null;
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/externalCompany/companyData";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            passWord = (String)configMap.get("cloudcc_access_password");
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            StringBuilder detailLog = new StringBuilder();
            detailLog.append((CharSequence)reqStringBuilder);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            params = new HashMap<String, Object>();
            params.put("orgTaxNum", vo.getNsrsbh());
            params.put("declareDate", DateUtils.format((Date)skssqz, (String)"yyyy-MM"));
            response = SzyhRequest.doPost(reqStringBuilder.toString(), null, params);
            if (!StringUtils.isBlank((CharSequence)response)) break block15;
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u5b8c\u7a0e\u51ed\u8bc1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            ApiResult apiResult2 = apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            if (in == null) return apiResult2;
            try {
                in.close();
                return apiResult2;
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u7cfb\u7edf\u5f02\u5e38", (String)"CloudccDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
            return apiResult2;
        }
        logger.info(String.format("cloudcc downloadVoucher resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
        Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
        if (StringUtils.equals((CharSequence)((CharSequence)responseMap.get("Code")), (CharSequence)"200")) {
            String suffixName = vo.getPzTypeName();
            String endName = ((String)responseMap.get("ftpPath")).substring(((String)responseMap.get("ftpPath")).lastIndexOf("."));
            DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
            String name = ((DynamicObject)org.get("org")).getString("name");
            StringBuilder reqS = new StringBuilder(baseUrl).append("/externalCompany/companyDataFile");
            UrlParams urlParam = new UrlParams();
            urlParam.setVersion(VERSION);
            urlParam.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParam.setSignatureNonce(UUID.randomUUID().toString());
            urlParam.setAccessKeyID(accessKeyId);
            CloudccDirectDeclareService.buildSignature(urlParam, passWord, reqS);
            byte[] res = SzyhRequest.doPostByteMode(reqS.toString(), null, params);
            in = new ByteArrayInputStream(res);
            SbpzRecordSaveUtils.saveRecord(vo, in, name, suffixName + endName, failedLog);
            apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "4", true);
        } else {
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccDirectDeclareService_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append((String)responseMap.get("Message"));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "4", false);
        }
        if (in == null) return apiResult;
        try {
            in.close();
            return apiResult;
        }
        catch (IOException e) {
            logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e);
            failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u7cfb\u7edf\u5f02\u5e38", (String)"CloudccDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return apiResult;
        catch (Exception e) {
            try {
                logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
                logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
                String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccDirectDeclareService_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(message);
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                if (in == null) return apiResult;
            }
            catch (Throwable throwable) {
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException e2) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e2);
                    failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u7cfb\u7edf\u5f02\u5e38", (String)"CloudccDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                }
                throw throwable;
            }
            try {
                in.close();
                return apiResult;
            }
            catch (IOException e3) {
                logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Throwable)e3);
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u7cfb\u7edf\u5f02\u5e38", (String)"CloudccDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
            return apiResult;
        }
    }

    public static ApiResult submit(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/declareDataFile/submit";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            MessageSend templateMessage = new MessageSend();
            templateMessage.setMsgtype(DECLARE);
            templateMessage.setBusinessid(vo.getBusinessId());
            templateMessage.setBusinesstype(vo.getType());
            templateMessage.setNsrType(vo.getType());
            CloudccDirectDeclareService.dealCcxwsType(vo, templateMessage);
            templateMessage.setNodetype(vo.getSbdq());
            templateMessage.setSupplier(SupplierEnum.SZYH.getName());
            String reqContent = MessageService.collection(templateMessage, vo.getNsrsbh());
            logger.info("\u62a5\u6587\u751f\u6210\uff1a" + reqContent);
            if (StringUtils.isNotBlank((CharSequence)reqContent)) {
                reqContent = reqContent.replaceAll("---", "##");
            }
            StringBuilder detailLog = new StringBuilder();
            detailLog.append(ResManager.loadKDString((String)"\u7533\u62a5\u62a5\u6587:", (String)"CloudccDirectDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(reqContent).append(SEPARATOR);
            String passWord = (String)configMap.get("cloudcc_access_password");
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            detailLog.append((CharSequence)reqStringBuilder);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, reqContent);
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            logger.info(String.format("cloudcc declare resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = CloudccDirectDeclareService.dealResponse(responseMap, vo, "directdeclare", FILE_NO);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult queryTaskStatusByFileNo(SBMessageBaseVo vo, String fileNo, String type) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            String reqUrl = baseUrl + "/declarationResultController/declareFileNoResultQuery";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            urlParams.setAccessKeyID(accessKeyId);
            MessageSend send = new MessageSend();
            send.setMsgtype(DECLARE);
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(DECLARE);
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.SZYH.getName());
            String passWord = (String)configMap.get("cloudcc_access_password");
            String content = MessageService.collectionPayData(send, fileNo, vo.getNsrsbh(), BigDecimal.ZERO);
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, content);
            logger.info(String.format("szyh querystatus resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "qtsf_tysbb".equals(vo.getType()) || "qtsf_fsstysbb".equals(vo.getType()) ? CloudccDirectDeclareService.getFileStatusForhb(responseMap, type, vo.getType()) : CloudccDirectDeclareService.getFileStatus(responseMap, type);
                if (StringUtils.equals((CharSequence)"2", (CharSequence)apiResult.getErrorCode())) {
                    logger.info("cloudcc\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                    StringBuilder msg = new StringBuilder();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)apiResult.getMessage())) {
                        msg.append(apiResult.getMessage());
                    }
                    if ("directdeclare".equals(type)) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", msg);
                    } else if ("fastpay".equals(type)) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", msg);
                    }
                } else if (StringUtils.equals((CharSequence)"91", (CharSequence)apiResult.getErrorCode())) {
                    StringBuilder nopayMsg = new StringBuilder(ResManager.loadKDString((String)"1\u5143\u4ee5\u4e0b\u65e0\u9700\u7f34\u6b3e", (String)"CloudccDirectDeclareService_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "nopay", "2", nopayMsg);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(ExceptionUtil.toString((Throwable)e));
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult downloadVerification(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/taxCollection/submit";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            urlParams.setAccessKeyID(accessKeyId);
            String passWord = (String)configMap.get("cloudcc_access_password");
            String plateformNo = (String)configMap.get("cloudcc_platform_no");
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgTaxNum", vo.getNsrsbh());
            params.put("platformNo", plateformNo);
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, JsonUtil.toJson(params));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u91c7\u96c6\u8ba4\u5b9a\u4fe1\u606f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            logger.info(String.format("cloudcc downloadVerification resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = CloudccDirectDeclareService.dealVerificationResponse(vo, responseMap);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult queryVerification(SBMessageBaseVo vo, Map<String, String> data) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String baseUrl = (String)configMap.get("cloudcc_base_url");
            String reqUrl = baseUrl + "/collectionResults/submit";
            UrlParams urlParams = new UrlParams();
            urlParams.setVersion(VERSION);
            urlParams.setTimeStamp(DateFormatUtils.format((Date)new Date(), (String)DATE_PATTERN, (TimeZone)TimeZone.getTimeZone("GMT+08:00")));
            urlParams.setSignatureNonce(UUID.randomUUID().toString());
            String accessKeyId = (String)configMap.get("cloudcc_access_id");
            String plateformNo = (String)configMap.get("cloudcc_platform_no");
            urlParams.setAccessKeyID(accessKeyId);
            String passWord = (String)configMap.get("cloudcc_access_password");
            StringBuilder reqStringBuilder = new StringBuilder(reqUrl);
            CloudccDirectDeclareService.buildSignature(urlParams, passWord, reqStringBuilder);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("orgTaxNum", vo.getNsrsbh());
            params.put("platformNo", plateformNo);
            params.putAll(data);
            String response = SzyhRequest.doPost(reqStringBuilder.toString(), null, JsonUtil.toJson(params));
            if (StringUtils.isBlank((CharSequence)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u91c7\u96c6\u8ba4\u5b9a\u4fe1\u606f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            logger.info(String.format("cloudcc queryVerification resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            String message = (String)responseMap.get("Message");
            apiResult = StringUtils.equals((CharSequence)((CharSequence)responseMap.get("Code")), (CharSequence)"200") ? CustomApiResult.dealResponse(responseMap.get("data"), "", "4", true) : (StringUtils.equals((CharSequence)((CharSequence)responseMap.get("Code")), (CharSequence)"301") ? CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), "2", true) : CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), "3", false));
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"CloudccDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealVerificationResponse(SBMessageBaseVo vo, Map<String, Object> responseMap) throws InterruptedException {
        ApiResult apiResult;
        if (responseMap != null) {
            if ("200".equals(String.valueOf(responseMap.get("Code")))) {
                Object data = responseMap.get("data");
                if (data != null) {
                    Map dataMap = (Map)data;
                    ConnectConfigService.buildRequestId(JsonUtil.toJson((Object)dataMap), vo, RequestTypeEnum.VERIFICATION);
                    apiResult = CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), String.valueOf(responseMap.get("Code")), true);
                } else {
                    String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u91c7\u96c6\u8ba4\u5b9a\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                }
            } else {
                apiResult = StringUtils.equals((CharSequence)String.valueOf(responseMap.get("Code")), (CharSequence)"400") ? CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("Message")), "2", true) : CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), String.valueOf(responseMap.get("Code")), false);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u91c7\u96c6\u8ba4\u5b9a\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealResponse(Map<String, Object> responseMap, SBMessageBaseVo vo, String key, String resultKey) throws InterruptedException {
        ApiResult apiResult;
        if (responseMap != null) {
            if ("200".equals(String.valueOf(responseMap.get("Code")))) {
                String requestId = null;
                if (!"fastpay".equals(key)) {
                    CloudccDirectDeclareService.buildRequestId(String.valueOf(responseMap.get(resultKey)), vo);
                    CloudccDirectDeclareService.dealRelationData(responseMap, vo, resultKey);
                    requestId = String.valueOf(responseMap.get(resultKey));
                } else {
                    requestId = vo.getRequestId();
                }
                if (EmptyCheckUtils.isEmpty((Object)requestId)) {
                    String message = ResManager.loadKDString((String)"requestId\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    return CustomApiResult.dealResponse(null, message, "3", false);
                }
                apiResult = StringUtils.equals((CharSequence)resultKey, (CharSequence)REQUEST_ID) ? CloudccDirectDeclareService.queryTaskStatus(vo, requestId, key) : CloudccDirectDeclareService.queryTaskStatusByFileNo(vo, requestId, key);
            } else {
                apiResult = CustomApiResult.dealResponse(null, (String)responseMap.get("Message"), String.valueOf(responseMap.get("Code")), false);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"CloudccDirectDeclareService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void dealRelationData(Map<String, Object> responseMap, SBMessageBaseVo vo, String resultKey) {
        List<Long> relationIds;
        if (SupplierEnum.SZYH.getCode().equals(vo.getDatasource()) && CollectionUtils.isNotEmpty(relationIds = vo.getRelationIds())) {
            DynamicObject[] mainObj;
            for (DynamicObject obj : mainObj = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)MetadataUtil.getAllFieldString((String)"tcvat_nsrxx"), (QFilter[])new QFilter[]{new QFilter("id", "in", relationIds)})) {
                SBMessageBaseVo tempVo = new SBMessageBaseVo();
                tempVo.setOrg(obj.getString("org.id"));
                tempVo.setDatasource(SupplierEnum.SZYH.getCode());
                tempVo.setBusinessId(obj.getString("id"));
                tempVo.setType(obj.getString("type"));
                tempVo.setNsrsbh(obj.getString("nsrsbh"));
                tempVo.setSkssqq(obj.getDate("skssqq"));
                tempVo.setSkssqz(obj.getDate("skssqz"));
                CloudccDirectDeclareService.buildRequestId(String.valueOf(responseMap.get(resultKey)), tempVo);
            }
        }
    }

    private static ApiResult getTaskStatus(Map<String, Object> responseMap, String type) {
        ApiResult apiResult = new ApiResult();
        if (!StringUtils.equals((CharSequence)"200", (CharSequence)String.valueOf(responseMap.get("Code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("Message")), "3", false);
        } else {
            Object data = responseMap.get("Data");
            if (data != null) {
                String jsonData = XmlTJsonUtil.xml2JSONString(data.toString());
                JSONObject body = JSONObject.parseObject((String)jsonData);
                JSONObject statusObj = body.getJSONObject("Root").getJSONArray("TaskResult").getJSONObject(0).getJSONArray("Result").getJSONObject(0);
                apiResult = CloudccDirectDeclareService.convertStatus(type, apiResult, body, statusObj);
            }
        }
        return apiResult;
    }

    private static ApiResult getFileStatus(Map<String, Object> responseMap, String type) {
        ApiResult apiResult = new ApiResult();
        if (!StringUtils.equals((CharSequence)"200", (CharSequence)String.valueOf(responseMap.get("Code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("Message")), "3", false);
        } else {
            Object data = responseMap.get("Data");
            if (data != null) {
                String jsonData = XmlTJsonUtil.xml2JSONString(data.toString());
                JSONObject body = JSONObject.parseObject((String)jsonData);
                JSONObject statusObj = body.getJSONObject("Root").getJSONArray("TaskResult").getJSONObject(0).getJSONArray("Result").getJSONObject(0);
                String processCode = statusObj.getString("ProcessCode");
                if (StringUtils.isBlank((CharSequence)processCode) || "2".equals(processCode)) {
                    String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u63a5\u53e3\u8fd4\u56de\u6d88\u606f\uff1a", (String)"CloudccDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message + statusObj.getString("ProcessMessage"), "3", false);
                    return apiResult;
                }
                JSONObject resultObj = statusObj.getJSONArray("TaxTypes").getJSONObject(0).getJSONArray("TaxType").getJSONObject(0).getJSONArray("DeclareTypes").getJSONObject(0).getJSONArray("DeclareType").getJSONObject(0);
                apiResult = CloudccDirectDeclareService.convertStatus(type, apiResult, body, resultObj);
            }
        }
        return apiResult;
    }

    private static ApiResult getFileStatusForhb(Map<String, Object> responseMap, String type, String nsrtype) {
        ApiResult apiResult = new ApiResult();
        if (!StringUtils.equals((CharSequence)"200", (CharSequence)String.valueOf(responseMap.get("Code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("Message")), "3", false);
        } else {
            Object data = responseMap.get("Data");
            if (data != null) {
                String jsonData = XmlTJsonUtil.xml2JSONString(data.toString());
                JSONObject body = JSONObject.parseObject((String)jsonData);
                JSONObject statusObj = body.getJSONObject("Root").getJSONArray("TaskResult").getJSONObject(0).getJSONArray("Result").getJSONObject(0);
                String processCode = statusObj.getString("ProcessCode");
                if (StringUtils.isBlank((CharSequence)processCode) || "2".equals(processCode)) {
                    String message = ResManager.loadKDString((String)"\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u63a5\u53e3\u8fd4\u56de\u6d88\u606f\uff1a", (String)"CloudccDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message + statusObj.getString("ProcessMessage"), "3", false);
                    return apiResult;
                }
                JSONArray jsonArrayResult = statusObj.getJSONArray("TaxTypes").getJSONObject(0).getJSONArray("TaxType");
                Integer i = 1;
                while (i <= STATUS_LEVELS) {
                    String statusByLevel = SzyhStatusPriorityEnums.getStatusByLevel(i);
                    if (!StringUtils.isBlank((CharSequence)statusByLevel)) {
                        for (Object obj : jsonArrayResult) {
                            ApiResult singleResult = new ApiResult();
                            JSONObject jsonObj = (JSONObject)obj;
                            JSONObject resultObj = jsonObj.getJSONArray("DeclareTypes").getJSONObject(0).getJSONArray("DeclareType").getJSONObject(0);
                            JSONArray taxAmountArray = resultObj.getJSONArray("TaxAmounts");
                            if (taxAmountArray != null && taxAmountArray.size() > 0) {
                                Object taxObj = taxAmountArray.getJSONObject(0).get((Object)"TaxAmount");
                                if (taxObj instanceof JSONArray) {
                                    String jsonString;
                                    JSONArray taxAmounts = taxAmountArray.getJSONObject(0).getJSONArray("TaxAmount");
                                    if (taxAmounts != null && taxAmounts.size() > 0 && EmptyCheckUtils.isNotEmpty((Object)(jsonString = taxAmounts.getString(0)))) {
                                        singleResult = CloudccDirectDeclareService.convertStatus(type, singleResult, body, resultObj);
                                    }
                                } else {
                                    String jsonString = taxAmountArray.getJSONObject(0).getString("TaxAmount");
                                    if (EmptyCheckUtils.isNotEmpty((Object)jsonString)) {
                                        singleResult = CloudccDirectDeclareService.convertStatus(type, singleResult, body, resultObj);
                                    }
                                }
                            }
                            if (StringUtils.equals((CharSequence)type, (CharSequence)"fastpay")) {
                                return singleResult;
                            }
                            if (!statusByLevel.equals(singleResult.getErrorCode())) continue;
                            return singleResult;
                        }
                    }
                    Integer n = i;
                    i = i + 1;
                    Integer n2 = i;
                }
            }
        }
        return apiResult;
    }

    private static ApiResult convertStatus(String type, ApiResult apiResult, JSONObject body, JSONObject resultObj) {
        boolean isSuccess = true;
        String errorMessage = resultObj.getString("ErrorMessage");
        if (StringUtils.equals((CharSequence)type, (CharSequence)"directdeclare")) {
            String status = resultObj.getString("DeclareStatusCode");
            if (Arrays.asList(CloudccMessageSendConstant.FAIL_STATUS).contains(status)) {
                isSuccess = false;
                status = "3";
            } else if (Arrays.asList(CloudccMessageSendConstant.SUCCESS_STATUS).contains(status)) {
                status = "4";
            } else if (Arrays.asList(CloudccMessageSendConstant.WAIT_STATUS).contains(status)) {
                status = "2";
            } else if (Arrays.asList(CloudccMessageSendConstant.INIT_STATUS).contains(status) || StringUtils.isBlank((CharSequence)status)) {
                status = "1";
            }
            apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString((Object)body), errorMessage, status, isSuccess);
        } else if (StringUtils.equals((CharSequence)type, (CharSequence)"fastpay")) {
            String status = resultObj.getString("TaxStatusCode");
            if (Arrays.asList(CloudccMessageSendConstant.PAY_FAIL_STATUS).contains(status)) {
                isSuccess = false;
                status = "3";
            } else if (Arrays.asList(CloudccMessageSendConstant.PAY_SUCCESS_STATUS).contains(status)) {
                status = "4";
            } else if (Arrays.asList(CloudccMessageSendConstant.PAY_WAIT_STATUS).contains(status)) {
                status = "2";
            } else if (Arrays.asList(CloudccMessageSendConstant.PAY_INIT_STATUS).contains(status) || StringUtils.isBlank((CharSequence)status)) {
                status = "1";
            } else if (Arrays.asList(CloudccMessageSendConstant.PAY_NOPAY_STATUS).contains(status) || StringUtils.isBlank((CharSequence)status)) {
                status = "91";
            }
            apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString((Object)body), errorMessage, status, isSuccess);
        }
        return apiResult;
    }

    private static void buildRequestId(String requestId, SBMessageBaseVo vo) {
        DynamicObject requestInfo = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
        if (requestInfo == null) {
            requestInfo = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"2");
            if (requestInfo == null) {
                requestInfo = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_status_info");
                requestInfo.set("org", (Object)vo.getOrg());
                requestInfo.set("skssqq", (Object)vo.getSkssqq());
                requestInfo.set("skssqz", (Object)vo.getSkssqz());
                requestInfo.set("type", (Object)vo.getType());
                requestInfo.set("billstatus", (Object)"C");
                requestInfo.set("requesttype", (Object)RequestTypeEnum.DECLARE.getCode());
                requestInfo.set("executestatus", (Object)"1");
            }
            requestInfo.set("sbbid", (Object)vo.getBusinessId());
            requestInfo.set("channel", (Object)SupplierEnum.SZYH.getId());
            requestInfo.set("createtime", (Object)new Date());
            requestInfo.set("creator", (Object)RequestContext.get().getUserId());
            requestInfo.set("requestid", (Object)requestId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestInfo});
        }
    }

    private static void buildSignature(UrlParams urlParams, String passWord, StringBuilder url) throws UnsupportedEncodingException {
        String urlParam = HttpUtils.buildUrlParams((UrlParams)urlParams);
        String accessKeySecret = Md5Utils.getEncode((byte[])passWord.getBytes(StandardCharsets.UTF_8));
        String signature = Md5Utils.getSignature((byte[])urlParam.getBytes(StandardCharsets.UTF_8), (byte[])accessKeySecret.getBytes(StandardCharsets.UTF_8));
        urlParams.setSignature(signature);
        url.append("?").append(HttpUtils.buildUrlParams((UrlParams)urlParams));
    }

    private static void dealCcxwsType(SBMessageBaseVo vo, MessageSend templateMessage) {
        String type;
        QFilter sbbidFilter;
        DynamicObjectCollection tcretCcxwsZbs;
        if (StringUtils.equals((CharSequence)vo.getType(), (CharSequence)"ccxws") && !CollectionUtils.isEmpty((Collection)(tcretCcxwsZbs = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"taxtype", (QFilter[])new QFilter[]{sbbidFilter = new QFilter("sbbid", "=", (Object)vo.getBusinessId())}))) && StringUtils.isNotBlank((CharSequence)(type = CcxwsTypeEnums.getTypeByZwType(((DynamicObject)tcretCcxwsZbs.get(0)).getString("taxtype"))))) {
            templateMessage.setBusinesstype(type);
        }
    }
}

