/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSONObject;
import java.time.Duration;
import java.time.Instant;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.mservice.constant.SupplierDeclareServiceEnum;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.CloudccDirectDeclareService;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import org.apache.commons.lang.StringUtils;

public class CloudccMessageSendServiceImpl
implements MessageSendService {
    public static final String DECLARESTATUS = "declarestatus";
    public static final String PAYSTATUS = "paystatus";
    private static final Log logger = LogFactory.getLog(CloudccMessageSendServiceImpl.class);

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result;
        block11: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                Boolean isQuery = vo.getQuery();
                logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
                logger.info("cloudcc\u7533\u62a5\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
                DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    result = CloudccDirectDeclareService.queryTaskStatus(vo, requestId, "directdeclare");
                    logger.info("cloudcc \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                    if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        logger.info("cloudcc\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                    } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("cloudcc \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    }
                } else if (isQuery.booleanValue()) {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
                    if (declare != null && "declaring".equals(declare.getString(DECLARESTATUS))) {
                        logger.info("cloudcc\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u7ee7\u7eed\u7533\u62a5" + vo.getNsrsbh());
                        Long minutes = Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes();
                        if (minutes > 5L) {
                            result = this.tryDeclare(vo, failedLog);
                        }
                    }
                } else {
                    result = this.tryDeclare(vo, failedLog);
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                if (requestObj == null) break block11;
                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    private ApiResult tryDeclare(SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult result = CloudccDirectDeclareService.declare(vo);
        DynamicObject dynamicObject = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("cloudcc\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                }
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("cloudcc\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                }
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            if (dynamicObject != null) {
                ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            logger.info("cloudcc\u6263\u6b3e\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"2");
            if (requestObj != null) {
                String requestId = requestObj.getString("requestid");
                result = CloudccDirectDeclareService.queryTaskStatus(vo, requestId, "fastpay");
                logger.info("\u6263\u6b3e\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("cloudcc \u6263\u6b3e\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("\u7f34\u6b3e\u5931\u8d25" + JsonUtil.toJson((Object)result));
                    if (isQuery.booleanValue()) {
                        logger.info("\u7f34\u6b3e\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u7f34\u6b3e\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh(), result.getMessage()}));
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                    } else {
                        logger.info("cloudcc\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u91cd\u65b0\u7f34\u6b3e" + vo.getNsrsbh());
                        result = this.tryPay(vo, failedLog, requestId);
                    }
                } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && !isQuery.booleanValue()) {
                    logger.info("cloudcc\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u672a\u7f34\u6b3e\uff0c\u91cd\u65b0\u7f34\u6b3e" + vo.getNsrsbh());
                    result = this.tryPay(vo, failedLog, requestId);
                }
            } else {
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setSuccess(false);
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u65e0\u7533\u62a5\u8bb0\u5f55", (String)"CloudccMessageSendServiceImpl_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
        }
        return result;
    }

    private ApiResult tryPay(SBMessageBaseVo vo, StringBuilder failedLog, String requestId) {
        ApiResult result = CloudccDirectDeclareService.pay(requestId, vo);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("cloudcc\u6263\u6b3e\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u65e0\u9700\u6263\u6b3e\u6216\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("cloudcc\u6263\u6b3e\u7b2c\u4e09\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u66f4\u65b0\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u7f34\u6b3e\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh(), result.getMessage()}));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        MessageSendService szyhService = SupplierDeclareServiceEnum.getServiceBySupplier(SupplierEnum.SZYH);
        return szyhService.downloadVoucher(vo);
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result;
        block14: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    result = CloudccDirectDeclareService.queryTaskStatus(vo, requestId, vo.getName());
                    logger.info("cloudcc \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                    if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        if ("directdeclare".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                        } else if ("fastpay".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                        }
                    } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("cloudcc \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"CloudccMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        if ("directdeclare".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                        } else if ("fastpay".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"CloudccMessageSendServiceImpl_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                if ("directdeclare".equals(vo.getName())) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                    if (requestObj != null) {
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    }
                }
                if (!"fastpay".equals(vo.getName())) break block14;
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            }
        }
        return result;
    }
}

