/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Constructor;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.CacheHelper;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.enums.TaxTypeDeclareEnums;
import kd.taxc.tsate.msmessage.service.GzsjDeclareService;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.formula.functions.T;

public class GzdzsjMessageSendServiceImpl
implements MessageSendService {
    private static final Log logger = LogFactory.getLog(GzdzsjMessageSendServiceImpl.class);
    private static final String DECLARESTATUS = "declarestatus";
    private static final String PAYSTATUS = "paystatus";
    private static final String SEPARATOR = System.getProperty("line.separator");

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result;
        block15: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
                if (identityData == null) {
                    failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"GzdzsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    return result;
                }
                Class<T> clazz = Class.forName(TaxTypeDeclareEnums.getClassPathByKey(vo.getType()));
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object newInstance = constructor.newInstance(new Object[0]);
                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                String applicationId = (String)configMap.get("gzdzsj_applicationId");
                String qddm = (String)configMap.get("gzdzsj_qddm");
                vo.setApplicationId(applicationId);
                vo.setQddm(qddm);
                logger.info("\u5f00\u59cb\u767b\u5f55\u7535\u5b50\u7a0e\u5c40,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                result = GzsjDeclareService.loginDzsj(identityData, vo);
                logger.info("\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u7ed3\u675f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                if (!result.getSuccess() || result.getData() == null) {
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(ResManager.loadKDString((String)"\u767b\u5f55\u5f02\u5e38", (String)"GzdzsjMessageSendServiceImpl_5", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(SEPARATOR);
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    return result;
                }
                Boolean isLogin = this.isLogin(vo, result, failedLog);
                if (!isLogin.booleanValue()) {
                    return result;
                }
                logger.info("\u5207\u6362\u4f01\u4e1a\u8eab\u4efd\u4fe1\u606f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                result = GzsjDeclareService.qhQySf(vo);
                logger.info("\u5207\u6362\u4f01\u4e1a\u8eab\u4efd\u4fe1\u606f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                if (!result.getSuccess()) {
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(ResManager.loadKDString((String)"\u5207\u6362\u4f01\u4e1a\u8eab\u4efd\u4fe1\u606f\u5f02\u5e38", (String)"GzdzsjMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(SEPARATOR);
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    return result;
                }
                Boolean isQuery = vo.getQuery();
                logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
                logger.info("gzdzsj\u7533\u62a5\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
                DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    result = (ApiResult)clazz.getMethod("getTaskResult", SBMessageBaseVo.class, String.class).invoke(newInstance, vo, requestId);
                    logger.info("gzdzsj \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                    if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        logger.info("gzdzsj\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                    } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("gzdzsj \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                        logger.info("gzdzsj \u7533\u62a5\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    }
                } else if (isQuery.booleanValue()) {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
                    if (declare != null && "declaring".equals(declare.getString(DECLARESTATUS))) {
                        logger.info("gzdzsj\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u7ee7\u7eed\u7533\u62a5" + vo.getNsrsbh());
                        Long minutes = Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes();
                        if (minutes > 5L) {
                            result = this.tryDeclare(vo, failedLog, clazz, newInstance);
                        }
                    }
                } else {
                    result = this.tryDeclare(vo, failedLog, clazz, newInstance);
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"GzdzsjMessageSendServiceImpl_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                if (requestObj == null) break block15;
                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isLogin(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog) {
        Map resultMap = (Map)result.getData();
        vo.setSessionId(String.valueOf(resultMap.get("ssoSessionId")));
        CacheHelper.put((String)(vo.getNsrsbh() + "_sso"), (String)vo.getSessionId());
        Map loginInfoMap = (Map)resultMap.get("ssoLoginInfo");
        Object nsrs = loginInfoMap.get("nsrs");
        if (nsrs == null) {
            failedLog.append(ResManager.loadKDString((String)"\u65e0\u5bf9\u5e94\u4f01\u4e1a\u4fe1\u606f", (String)"GzdzsjMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            return false;
        }
        List nsrxxList = (List)nsrs;
        if (!CollectionUtils.isNotEmpty((Collection)nsrxxList)) return true;
        Optional<Map> nsrMap = nsrxxList.stream().filter(o -> StringUtils.equals((String)vo.getNsrsbh(), (String)String.valueOf(o.get("shxydm")))).findFirst();
        if (!nsrMap.isPresent()) {
            failedLog.append(ResManager.loadKDString((String)"\u65e0\u5bf9\u5e94\u4f01\u4e1a\u4fe1\u606f", (String)"GzdzsjMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            return false;
        }
        if (StringUtils.equals((String)String.valueOf(nsrMap.get().get("gdsywsx")), (String)"2")) {
            vo.setDjxh(nsrMap.get().get("dszdjxh").toString());
        } else {
            vo.setDjxh(nsrMap.get().get("gszdjxh").toString());
        }
        vo.setQybdid(String.valueOf(nsrMap.get().get("qybdid")));
        return true;
    }

    private ApiResult tryDeclare(SBMessageBaseVo vo, StringBuilder failedLog, Class<T> clazz, Object newInstance) throws Exception {
        ApiResult result = (ApiResult)clazz.getMethod("declare", SBMessageBaseVo.class).invoke(newInstance, vo);
        DynamicObject dynamicObject = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("gzdzsj\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                }
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("gzdzsj\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                }
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            if (dynamicObject != null) {
                ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        return result;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        return result;
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result;
        block26: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
                if (identityData == null) {
                    failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"GzdzsjMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    return result;
                }
                Class<?> clazz = Class.forName(TaxTypeDeclareEnums.getClassPathByKey(vo.getType()));
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                Object newInstance = constructor.newInstance(new Object[0]);
                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                String applicationId = (String)configMap.get("gzdzsj_applicationId");
                String qddm = (String)configMap.get("gzdzsj_qddm");
                vo.setApplicationId(applicationId);
                vo.setQddm(qddm);
                logger.info("\u5f00\u59cb\u767b\u5f55\u7535\u5b50\u7a0e\u5c40,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                result = GzsjDeclareService.loginDzsj(identityData, vo);
                logger.info("\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u7ed3\u675f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                if (!result.getSuccess() || result.getData() == null) {
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(ResManager.loadKDString((String)"\u5207\u6362\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38", (String)"GzdzsjMessageSendServiceImpl_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                        if (requestObj != null) {
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                        }
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                    }
                    return result;
                }
                Boolean isLogin = this.isLogin(vo, result, failedLog);
                if (!isLogin.booleanValue()) {
                    return result;
                }
                logger.info("\u5207\u6362\u4f01\u4e1a\u8eab\u4efd\u4fe1\u606f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                result = GzsjDeclareService.qhQySf(vo);
                logger.info("\u5207\u6362\u4f01\u4e1a\u8eab\u4efd\u4fe1\u606f,\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7: " + vo.getNsrsbh());
                if (!result.getSuccess()) {
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(ResManager.loadKDString((String)"\u5207\u6362\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38", (String)"GzdzsjMessageSendServiceImpl_4", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(SEPARATOR);
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                        if (requestObj != null) {
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                        }
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                    }
                    return result;
                }
                DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    result = (ApiResult)clazz.getMethod("getTaskResult", SBMessageBaseVo.class, String.class).invoke(newInstance, vo, requestId);
                    logger.info("gzdzsj \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                    if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        if ("directdeclare".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                        } else if ("fastpay".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                        }
                    } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("gzdzsj \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"GzdzsjMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        if ("directdeclare".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                        } else if ("fastpay".equals(vo.getName())) {
                            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"GzdzsjMessageSendServiceImpl_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                if ("directdeclare".equals(vo.getName())) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    DynamicObject requestObj = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
                    if (requestObj != null) {
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    }
                }
                if (!"fastpay".equals(vo.getName())) break block26;
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            }
        }
        return result;
    }
}

