/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.gzdzsj.GzdzsjMessageSendConstant;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.common.util.Sm4Util;
import kd.taxc.tsate.common.util.declare.SampleJsonFileParser;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.GzsjDeclareService;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import org.apache.commons.lang3.StringUtils;

public class GzsjDeclareForQysdsjbService
extends GzsjDeclareService {
    private static Log logger = LogFactory.getLog(GzsjDeclareService.class);

    @Override
    public ApiResult getQcData(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("nsrsbh", vo.getNsrsbh());
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, String> bodyMap = new HashMap<String, String>(16);
            bodyMap.put("nsrsbh", vo.getNsrsbh());
            bodyMap.put("gdslxDm", vo.getSessionId());
            bodyMap.put("djxh", vo.getDjxh());
            bodyMap.put("ywbm", "QYSDS_A_21YJD");
            bodyMap.put("sssqQ", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            bodyMap.put("sssqZ", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            bodyMap.put("appid", vo.getApplicationId());
            bodyMap.put("ywzt", "Y");
            bodyMap.put("version", "1.0.4.23");
            bodyMap.put("ywlx", "SB");
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            paramMap.put("body", bodyMap);
            Map<String, Object> inputParams = GzsjDeclareForQysdsjbService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareForQysdsjbService.invokeService(inputParams, "v1/dzswj/csxj/sb/sdsjma/dzswjcx/yjdqcshq");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u671f\u521d\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForQysdsjbService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)resultResult.getData();
            Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
            if (responseMap != null) {
                if ("Y".equals(String.valueOf(bodyResultMap.get("returnFlag")))) {
                    apiResult = CustomApiResult.dealResponse(bodyResultMap.get("body"), ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u521d\u6210\u529f", (String)"GzsjDeclareForQysdsjbService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
                } else {
                    Map errorMap = (Map)bodyResultMap.get("errInfo");
                    apiResult = CustomApiResult.dealResponse(null, String.valueOf(errorMap.get("msg")), "3", false);
                }
            } else {
                String message = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"GzsjDeclareForQysdsjbService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u671f\u521d\u6570\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u521d\u6570\u5f02\u5e38", (String)"GzsjDeclareForQysdsjbService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    @Override
    public ApiResult declare(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, Object> bodyMap = new HashMap<String, Object>(16);
            bodyMap.put("appid", vo.getApplicationId());
            bodyMap.put("ywlx", "SB");
            bodyMap.put("ywbm", "QYSDS_A_21YJD");
            bodyMap.put("djxh", vo.getDjxh());
            bodyMap.put("sssqQ", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            bodyMap.put("sssqZ", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            bodyMap.put("version", "1.0.4.23");
            ApiResult qyhjxxReslut = this.qyhjxx(vo);
            if (qyhjxxReslut == null || !qyhjxxReslut.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7f13\u7f34\u4fe1\u606f\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForQysdsjbService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            GzsjDeclareForQysdsjbService.dealQyhjxx(bodyMap, qyhjxxReslut);
            ApiResult qcDataResult = this.getQcData(vo);
            if (qcDataResult == null || !qcDataResult.getSuccess()) {
                if (qcDataResult != null && qcDataResult.getMessage() != null && qcDataResult.getMessage().contains(ResManager.loadKDString((String)"\u8be5\u7eb3\u7a0e\u4eba\u91cd\u590d\u7533\u62a5", (String)"GzsjDeclareForQysdsjbService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]))) {
                    return CustomApiResult.dealResponse(null, qcDataResult.getMessage(), "4", true);
                }
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u671f\u521d\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForQysdsjbService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                String msg = qcDataResult != null ? message + "-" + qcDataResult.getMessage() : message;
                apiResult = CustomApiResult.dealResponse(null, msg, "3", false);
                return apiResult;
            }
            if (qcDataResult.getMessage() != null && qcDataResult.getMessage().contains(ResManager.loadKDString((String)"\u8be5\u7eb3\u7a0e\u4eba\u91cd\u590d\u7533\u62a5", (String)"GzsjDeclareForQysdsjbService_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]))) {
                return CustomApiResult.dealResponse(null, qcDataResult.getMessage(), "4", true);
            }
            Object qcData = qcDataResult.getData();
            if (EmptyCheckUtils.isNotEmpty((Object)qcData)) {
                Map<String, Object> qcDataMap = this.dealQcData(qcData);
                bodyMap.put("params", this.buildParams(vo, qcDataMap));
                MessageSend send = new MessageSend();
                send.setMsgtype("declare");
                send.setBusinessid(vo.getBusinessId());
                send.setBusinesstype(vo.getType());
                send.setNsrType(vo.getType());
                send.setNodetype(vo.getSbdq());
                send.setSupplier(SupplierEnum.GZDZSJ.getName());
                String reqContent = MessageService.collectionData(send, vo.getDjxh(), vo.getNsrsbh());
                if (StringUtils.isNotBlank((CharSequence)reqContent)) {
                    reqContent = SampleJsonFileParser.jsonEmbeded2Plate((JSONObject)JSONObject.parseObject((String)reqContent)).toJSONString();
                    StringBuilder detailLog = new StringBuilder();
                    detailLog.append(reqContent);
                    DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
                    bodyMap.put("wbcsh", reqContent);
                    HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
                    paramMap.put("head", headMap);
                    paramMap.put("body", bodyMap);
                    Map<String, Object> inputParams = GzsjDeclareForQysdsjbService.dealInputParams(paramMap, "ex_gztax_cit_session");
                    RequestResult resultResult = GzsjDeclareForQysdsjbService.invokeService(inputParams, "v1/dzswj/csxj/sb/qysdsa/dzswjcz/yjdsbbbc");
                    if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                        String message = ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForQysdsjbService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                        apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                        return apiResult;
                    }
                    Map responseMap = (Map)resultResult.getData();
                    if (responseMap != null) {
                        Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
                        apiResult = this.dealResponse(bodyResultMap, vo);
                    } else {
                        String message = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"GzsjDeclareForQysdsjbService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                        apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u7533\u62a5\u5904\u7406\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u7533\u62a5\u5904\u7406\u5f02\u5e38", (String)"GzsjDeclareForQysdsjbService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    @Override
    public ApiResult getTaskResult(SBMessageBaseVo vo, String requestId) {
        ApiResult apiResult;
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            requestId = "\"" + requestId + "\"";
            paramMap.put("body", requestId);
            Map<String, Object> inputParams = GzsjDeclareForQysdsjbService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareForQysdsjbService.invokeService(inputParams, "v1/dzswj/csxj/sb/qysds/dzswjcx/sbjgxxhq");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForQysdsjbService_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                ApiResult apiResult2 = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult2;
            }
            Map responseMap = (Map)resultResult.getData();
            if (responseMap != null) {
                Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
                apiResult = GzsjDeclareForQysdsjbService.dealTaskStatus(bodyResultMap);
                if (StringUtils.equals((CharSequence)"2", (CharSequence)apiResult.getErrorCode())) {
                    logger.info("gzdzsj\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", new StringBuilder());
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", new StringBuilder());
                    }
                }
            } else {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u4e3a\u7a7a", (String)"GzsjDeclareForQysdsjbService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u5f02\u5e38", (String)"GzsjDeclareForQysdsjbService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    private ApiResult dealResponse(Map<String, Object> responseMap, SBMessageBaseVo vo) throws Exception {
        ApiResult apiResult;
        if (responseMap != null) {
            if ("0".equals(String.valueOf(responseMap.get("code")))) {
                String jylsh = null;
                Object uuid = responseMap.get("uuid");
                if (uuid != null) {
                    jylsh = String.valueOf(uuid);
                } else {
                    Object jmsbId = responseMap.get("jmsbId");
                    jylsh = String.valueOf(jmsbId);
                }
                GzsjDeclareForQysdsjbService.buildRequestId(jylsh, vo);
                Thread.sleep(120000L);
                apiResult = this.getTaskResult(vo, jylsh);
                if (apiResult.getSuccess() && "2".equals(apiResult.getErrorCode())) {
                    logger.info("\u4efb\u52a1\u5df2\u4e0b\u53d1+" + apiResult.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                    boolean isCompleted = false;
                    do {
                        Thread.sleep(120000L);
                        apiResult = this.getTaskResult(vo, jylsh);
                        if (apiResult.getSuccess() && !"3".equals(apiResult.getErrorCode()) && !"4".equals(apiResult.getErrorCode())) continue;
                        isCompleted = true;
                    } while (!isCompleted);
                }
            } else {
                apiResult = CustomApiResult.dealResponse(null, (String)responseMap.get("rtnMessage"), "3", false);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"GzsjDeclareForQysdsjbService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void dealQyhjxx(Map<String, Object> bodyMap, ApiResult qyhjxxReslut) {
        Object hjxxData = qyhjxxReslut.getData();
        if (EmptyCheckUtils.isNotEmpty((Object)hjxxData)) {
            Map hjxxMap = (Map)JsonUtil.fromJson((String)String.valueOf(hjxxData), Map.class);
            Map hjxxBodyMap = (Map)hjxxMap.get("zzyxwqyhj");
            bodyMap.put("hjbz", hjxxBodyMap.get("scsbbz"));
            bodyMap.put("lbDm", hjxxBodyMap.get("lbDm"));
        }
    }

    private static ApiResult dealTaskStatus(Map<String, Object> responseMap) {
        ApiResult apiResult = new ApiResult();
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)String.valueOf(responseMap.get("code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("msg")), "3", false);
        } else {
            String sbzt = String.valueOf(responseMap.get("sbzt"));
            String status = "";
            if (EmptyCheckUtils.isNotEmpty((Object)sbzt)) {
                boolean isSuccess = true;
                if (Arrays.asList(GzdzsjMessageSendConstant.QYSDS_FAIL_STATUS).contains(sbzt)) {
                    isSuccess = false;
                    status = "3";
                } else if (Arrays.asList(GzdzsjMessageSendConstant.QYSDS_SUCCESS_STATUS).contains(sbzt)) {
                    status = "4";
                } else if (Arrays.asList(GzdzsjMessageSendConstant.QYSDS_WAIT_STATUS).contains(sbzt)) {
                    status = "2";
                }
                apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("msg")), status, isSuccess);
            }
        }
        return apiResult;
    }

    private Map<String, Object> dealQcData(Object qcData) {
        HashMap<String, Object> qcMap = new HashMap<String, Object>();
        try {
            String jsonBody = (String)qcData;
            if (EmptyCheckUtils.isNotEmpty((Object)jsonBody)) {
                Map fqMap;
                Object smzxx;
                Object sbxxGridlb;
                Map hqMap;
                Object sbxxGrid;
                Map bodyMap = (Map)JsonUtil.fromJson((String)jsonBody, Map.class);
                Object hq = bodyMap.get("hq_");
                if (EmptyCheckUtils.isNotEmpty(hq) && EmptyCheckUtils.isNotEmpty(sbxxGrid = (hqMap = (Map)hq).get("sbxxGrid")) && EmptyCheckUtils.isNotEmpty(sbxxGridlb = ((Map)sbxxGrid).get("sbxxGridlb"))) {
                    List sbxxList = (List)sbxxGridlb;
                    qcMap.putAll((Map)sbxxList.get(0));
                }
                Object fq = bodyMap.get("fq_");
                if (EmptyCheckUtils.isNotEmpty(hq) && EmptyCheckUtils.isNotEmpty(smzxx = (fqMap = (Map)fq).get("smzxx"))) {
                    Map smzxxMap = (Map)smzxx;
                    qcMap.putAll(smzxxMap);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u671f\u521d\u4fe1\u606f\u4e2d\u5f81\u6536\u54c1\u76ee\u4fe1\u606f\u9519\u8bef");
        }
        return qcMap;
    }

    private String buildParams(SBMessageBaseVo vo, Map<String, Object> qcDataMap) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>(16);
        paramsMap.put("ywzt", "Y");
        paramsMap.put("sssqQ", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
        paramsMap.put("sssqZ", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
        paramsMap.put("skssq_q", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
        paramsMap.put("skssq_z", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
        paramsMap.put("nsqx_dm", String.valueOf(qcDataMap.get("nsqxDm")));
        paramsMap.put("sbqx", String.valueOf(qcDataMap.get("sbqx")));
        paramsMap.put("zsxmDm", String.valueOf(qcDataMap.get("zsxmDm")));
        paramsMap.put("zspmDm", String.valueOf(qcDataMap.get("zspmDm")));
        paramsMap.put("tjNd", String.valueOf(DateUtils.getYearOfDate((Date)new Date())));
        paramsMap.put("tjYf", String.valueOf(DateUtils.getMonthOfDate((Date)new Date())));
        paramsMap.put("djxh", vo.getDjxh());
        paramsMap.put("gsnsrsbh", vo.getNsrsbh());
        paramsMap.put("gszgswskfjDm", String.valueOf(qcDataMap.get("swjgDm")));
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("zjlx", String.valueOf(qcDataMap.get("zjlx")));
        contentMap.put("zjhm", String.valueOf(qcDataMap.get("zjhm")));
        contentMap.put("sjhm", String.valueOf(qcDataMap.get("sjhm")));
        contentMap.put("xm", String.valueOf(qcDataMap.get("xm")));
        paramsMap.put("content", Sm4Util.encryptEcb((String)JsonUtil.toJson(contentMap)));
        paramsMap.put("reset", "Y");
        return GzsjDeclareForQysdsjbService.buildUrlParams(paramsMap);
    }

    public static String buildUrlParams(Map<String, Object> paramsMap) {
        StringBuilder stringBuilder = new StringBuilder();
        if (paramsMap != null) {
            Iterator<Map.Entry<String, Object>> iterator = paramsMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> item = iterator.next();
                stringBuilder.append(item.getKey()).append('=').append(item.getValue());
                if (!iterator.hasNext()) continue;
                stringBuilder.append('&');
            }
        }
        return stringBuilder.toString();
    }
}

