/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.gzdzsj.GzdzsjMessageSendConstant;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.service.GzsjDeclareService;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class GzsjDeclareForZzsxgmService
extends GzsjDeclareService {
    private static final Log logger = LogFactory.getLog(GzsjDeclareService.class);

    @Override
    public ApiResult getQcData(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("nsrsbh", vo.getNsrsbh());
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, String> bodyMap = new HashMap<String, String>(16);
            bodyMap.put("nsrsbh", vo.getNsrsbh());
            bodyMap.put("sessionId", vo.getSessionId());
            bodyMap.put("djxh", vo.getDjxh());
            bodyMap.put("applicationId", vo.getApplicationId());
            bodyMap.put("serviceId", "GD.SB.XGM.DZSWJCX.qcsjhq");
            bodyMap.put("version", "1.0.4.23");
            HashMap<String, String> subBodyMap = new HashMap<String, String>(16);
            subBodyMap.put("nsqxDm", "06");
            subBodyMap.put("type", "XML");
            subBodyMap.put("sbny", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyyMM"));
            bodyMap.put("body", Base64.encodeBase64String((byte[])JsonUtil.toJson(subBodyMap).getBytes(StandardCharsets.UTF_8)));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            paramMap.put("body", bodyMap);
            Map<String, Object> inputParams = GzsjDeclareForZzsxgmService.dealInputParams(paramMap, "ex_gztax_vat");
            RequestResult resultResult = GzsjDeclareForZzsxgmService.invokeService(inputParams, "v1/dzswj/csxj/sb/xgm/dzswjcx/qcsjhq");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u671f\u521d\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForZzsxgmService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)resultResult.getData();
            Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(bodyResultMap.get("rtnCode"))) ? CustomApiResult.dealResponse(new String(Base64.decodeBase64((String)((String)bodyResultMap.get("body"))), StandardCharsets.UTF_8), (String)responseMap.get("rtnMessage"), String.valueOf(responseMap.get("code")), true) : CustomApiResult.dealResponse(null, (String)bodyResultMap.get("rtnMessage"), String.valueOf(bodyResultMap.get("rtnCode")), false);
            } else {
                String message = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"GzsjDeclareForZzsxgmService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u671f\u521d\u6570\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u671f\u521d\u6570\u5f02\u5e38", (String)"GzsjDeclareForZzsxgmService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    @Override
    public ApiResult declare(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("nsrsbh", vo.getNsrsbh());
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, Object> bodyMap = new HashMap<String, Object>(16);
            bodyMap.put("nsrsbh", vo.getNsrsbh());
            bodyMap.put("sessionId", vo.getSessionId());
            bodyMap.put("djxh", vo.getDjxh());
            bodyMap.put("applicationId", vo.getApplicationId());
            bodyMap.put("serviceId", "GD.SB.XGM.DZSWJCZ.sbbbc");
            bodyMap.put("version", "1.0.4.23");
            HashMap<String, Object> paramerMap = new HashMap<String, Object>(16);
            ApiResult qyhjxxReslut = this.qyhjxx(vo);
            if (qyhjxxReslut == null || !qyhjxxReslut.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7f13\u7f34\u4fe1\u606f\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForZzsxgmService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            GzsjDeclareForZzsxgmService.dealQyhjxx(bodyMap, paramerMap, qyhjxxReslut);
            ApiResult qcDataResult = this.getQcData(vo);
            if (qcDataResult == null || !qcDataResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u671f\u521d\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForZzsxgmService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Object qcData = qcDataResult.getData();
            Map<String, String> zspmMap = this.dealQcData(qcData);
            MessageSend send = new MessageSend();
            send.setMsgtype("declare");
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(vo.getType());
            send.setNsrType(vo.getType());
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.GZDZSJ.getName());
            String reqContent = MessageService.collectionData(send, zspmMap, vo.getDjxh(), vo.getNsrsbh());
            StringBuilder detailLog = new StringBuilder();
            detailLog.append(reqContent);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            bodyMap.put("body", Base64.encodeBase64String((byte[])reqContent.getBytes(StandardCharsets.UTF_8)));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            paramMap.put("body", bodyMap);
            Map<String, Object> inputParams = GzsjDeclareForZzsxgmService.dealInputParams(paramMap, "ex_gztax_vat");
            RequestResult resultResult = GzsjDeclareForZzsxgmService.invokeService(inputParams, "v1/dzswj/csxj/sb/xgm/dzswjcz/sbbbc");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForZzsxgmService_4", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)resultResult.getData();
            if (responseMap != null) {
                Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
                apiResult = this.dealResponse(bodyResultMap, vo);
            } else {
                String message = ResManager.loadKDString((String)"\u671f\u521d\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"GzsjDeclareForZzsxgmService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u7533\u62a5\u5904\u7406\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u7533\u62a5\u5904\u7406\u5f02\u5e38", (String)"GzsjDeclareForZzsxgmService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    @Override
    public ApiResult getTaskResult(SBMessageBaseVo vo, String requestId) {
        ApiResult apiResult;
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put("nsrsbh", vo.getNsrsbh());
            headMap.put("sessionId", vo.getSessionId());
            HashMap<String, String> bodyMap = new HashMap<String, String>(16);
            bodyMap.put("nsrsbh", vo.getNsrsbh());
            bodyMap.put("sessionId", vo.getSessionId());
            bodyMap.put("djxh", vo.getDjxh());
            bodyMap.put("applicationId", vo.getApplicationId());
            bodyMap.put("serviceId", "GD.SB.ZZS.DZSWJCX.sbjgxxhq");
            bodyMap.put("version", "1.0.4.23");
            HashMap<String, String> data = new HashMap<String, String>(2);
            data.put("JYLSH", requestId);
            bodyMap.put("body", Base64.encodeBase64String((byte[])JSON.toJSONString(data).getBytes(StandardCharsets.UTF_8)));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            paramMap.put("body", bodyMap);
            Map<String, Object> inputParams = GzsjDeclareForZzsxgmService.dealInputParams(paramMap, "ex_gztax_vat");
            RequestResult resultResult = GzsjDeclareForZzsxgmService.invokeService(inputParams, "v1/dzswj/csxj/sb/zzs/dzswjcx/sbjgxxhq");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u671f\u521d\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareForZzsxgmService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                ApiResult apiResult2 = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult2;
            }
            Map responseMap = (Map)resultResult.getData();
            if (responseMap != null) {
                apiResult = GzsjDeclareForZzsxgmService.dealTaskStatus(responseMap);
                if (StringUtils.equals((CharSequence)"2", (CharSequence)apiResult.getErrorCode())) {
                    logger.info("gzdzsj\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                    if ("directdeclare".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", new StringBuilder());
                    } else if ("fastpay".equals(vo.getName())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", new StringBuilder());
                    }
                }
            } else {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u4e3a\u7a7a", (String)"GzsjDeclareForZzsxgmService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7533\u62a5\u7ed3\u679c\u5f02\u5e38", (String)"GzsjDeclareForZzsxgmService_7", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        if (!apiResult.getSuccess()) {
            StringBuilder sb = new StringBuilder();
            if (apiResult.getMessage() != null) {
                sb.append(apiResult.getMessage());
            }
            sb.append("(").append(ResManager.loadKDString((String)"\u7a0e\u5c40\u6d41\u6c34\u53f7", (String)"GzsjDeclareForZzsxgmService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(requestId).append(")");
            apiResult.setMessage(sb.toString());
        }
        return apiResult;
    }

    private ApiResult dealResponse(Map<String, Object> responseMap, SBMessageBaseVo vo) throws Exception {
        ApiResult apiResult;
        if (responseMap != null) {
            if ("0".equals(String.valueOf(responseMap.get("rtnCode")))) {
                byte[] bb = Base64.decodeBase64((String)((String)responseMap.get("body")));
                String jsonData = XmlTJsonUtil.xml2JSONString(new String(bb, StandardCharsets.UTF_8));
                if (EmptyCheckUtils.isNotEmpty((Object)jsonData)) {
                    JSONObject body = JSONObject.parseObject((String)jsonData);
                    String jylsh = body.getJSONObject("SBFKXX").getString("JYLSH");
                    try {
                        String erroCode = body.getJSONObject("SBFKXX").getJSONArray("SBFK").getJSONObject(0).getString("FKDM");
                        if ("-1".equals(erroCode)) {
                            String erroMsg = body.getJSONObject("SBFKXX").getJSONArray("SBFK").getJSONObject(0).getString("FKXX");
                            if (erroMsg != null && erroMsg.contains(ResManager.loadKDString((String)"\u60a8\u5df2\u7ecf\u7533\u62a5\u6210\u529f", (String)"GzsjDeclareForZzsxgmService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]))) {
                                return CustomApiResult.dealResponse(null, erroMsg, "4", true);
                            }
                            return CustomApiResult.dealResponse(null, erroMsg, "3", false);
                        }
                    }
                    catch (Exception e) {
                        logger.warn("\u4ea4\u6613\u6d41\u6c34\u53f7-" + jylsh + " \u5e7f\u5dde\u7a0e\u5c40\u5c0f\u89c4\u6a21\u7533\u62a5\u7ed3\u679c\u672a\u53d1\u73b0\u9519\u8bef\u4fe1\u606f\uff08\u6b63\u5e38\uff09");
                    }
                    GzsjDeclareForZzsxgmService.buildRequestId(jylsh, vo);
                    Thread.sleep(120000L);
                    apiResult = this.getTaskResult(vo, jylsh);
                    if (apiResult == null) {
                        return apiResult;
                    }
                    if (apiResult.getSuccess() && "2".equals(apiResult.getErrorCode())) {
                        logger.info("\u4efb\u52a1\u5df2\u4e0b\u53d1+" + apiResult.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                        boolean isCompleted = false;
                        do {
                            Thread.sleep(120000L);
                            apiResult = this.getTaskResult(vo, jylsh);
                            if (apiResult.getSuccess() && !"3".equals(apiResult.getErrorCode()) && !"4".equals(apiResult.getErrorCode())) continue;
                            isCompleted = true;
                        } while (!isCompleted);
                    }
                } else {
                    apiResult = CustomApiResult.dealResponse(null, (String)responseMap.get("rtnMessage"), "3", false);
                }
            } else {
                apiResult = CustomApiResult.dealResponse(null, (String)responseMap.get("rtnMessage"), "3", false);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"GzsjDeclareForZzsxgmService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void dealQyhjxx(Map<String, Object> bodyMap, Map<String, Object> paramerMap, ApiResult qyhjxxReslut) {
        Object hjxxData = qyhjxxReslut.getData();
        if (EmptyCheckUtils.isNotEmpty((Object)hjxxData)) {
            Map hjxxMap = (Map)JsonUtil.fromJson((String)String.valueOf(hjxxData), Map.class);
            Map hjxxBodyMap = (Map)hjxxMap.get("zzyxwqyhj");
            paramerMap.put("hjbz", hjxxBodyMap.get("scsbbz"));
            paramerMap.put("yxshjzcLy", "");
            paramerMap.put("lbDm", hjxxBodyMap.get("lbDm"));
            bodyMap.put("paramerMap", paramerMap);
        }
    }

    private static ApiResult dealTaskStatus(Map<String, Object> responseMap) {
        ApiResult apiResult = new ApiResult();
        Map headerMap = (Map)responseMap.get("head");
        if (!StringUtils.equals((CharSequence)"0", (CharSequence)String.valueOf(headerMap.get("errorCode")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("errorMsg")), "3", false);
        } else {
            Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
            if ("0".equals(String.valueOf(bodyResultMap.get("rtnCode")))) {
                byte[] bb = Base64.decodeBase64((String)((String)bodyResultMap.get("body")));
                String jsonData = XmlTJsonUtil.xml2JSONString(new String(bb, StandardCharsets.UTF_8));
                if (EmptyCheckUtils.isNotEmpty((Object)jsonData)) {
                    JSONObject body = JSONObject.parseObject((String)jsonData);
                    String fkdm = body.getJSONObject("SBFKXX").getJSONArray("SBFK").getJSONObject(0).getString("FKDM");
                    String status = null;
                    boolean isSuccess = true;
                    String fkxx = ResManager.loadKDString((String)"\u7a0e\u5c40\u8fd4\u56de\uff1a%s", (String)"GzsjDeclareForZzsxgmService_11", (String)"taxc-tsate-mservice", (Object[])new Object[]{body.getJSONObject("SBFKXX").getJSONArray("SBFK").getJSONObject(0).getString("FKXX")});
                    if (Arrays.asList(GzdzsjMessageSendConstant.FAIL_STATUS).contains(fkdm)) {
                        isSuccess = false;
                        status = "3";
                    } else if (Arrays.asList(GzdzsjMessageSendConstant.SUCCESS_STATUS).contains(fkdm)) {
                        status = "4";
                    } else if (Arrays.asList(GzdzsjMessageSendConstant.WAIT_STATUS).contains(fkdm)) {
                        status = "2";
                    }
                    apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString((Object)body), fkxx, status, isSuccess);
                }
            } else if ("9".equals(String.valueOf(bodyResultMap.get("rtnCode")))) {
                apiResult = CustomApiResult.dealResponse(JSONObject.toJSONString(responseMap), String.valueOf(bodyResultMap.get("rtnMessage")), "2", true);
            }
        }
        return apiResult;
    }

    private Map<String, String> dealQcData(Object qcData) {
        String qcDataJson = XmlTJsonUtil.xml2JSONString(String.valueOf(qcData));
        JSONObject jsonBody = JSONObject.parseObject((String)qcDataJson);
        HashMap<String, String> fjsZspmMap = new HashMap<String, String>(16);
        try {
            String erromsg = jsonBody.getJSONObject("HDXX").getJSONArray("SBZL").getJSONObject(0).getString("QCCGBZMS");
            fjsZspmMap.put("erromsg", erromsg);
            JSONArray fjsSbxx = jsonBody.getJSONObject("HDXX").getJSONArray("SBZL").getJSONObject(0).getJSONArray("fjsSbxxGrid").getJSONObject(0).getJSONArray("fjsSbxxGridlb");
            for (Object obj : fjsSbxx) {
                JSONObject jsonObject = (JSONObject)obj;
                fjsZspmMap.put("zsxm_" + jsonObject.getString("zsxmdm"), jsonObject.getString("zspmdm"));
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u671f\u521d\u4fe1\u606f\u4e2d\u5f81\u6536\u54c1\u76ee\u4fe1\u606f\u9519\u8bef");
        }
        return fjsZspmMap;
    }
}

