/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;

public abstract class GzsjDeclareService {
    private static Log logger = LogFactory.getLog(GzsjDeclareService.class);
    private static final String LOGIN_WITH_YHM = "loginWithYhm";
    protected static final String SESSION_ID_KEY = "sessionId";
    protected static final String NSRSBH_KEY = "nsrsbh";
    protected static final String VERSION = "1.0.4.23";
    protected static final String VERSION_KEY = "version";
    protected static final String SERVICE_ID_KEY = "serviceId";
    protected static final String DJXH = "djxh";
    protected static final String APPLICATION_ID = "applicationId";

    public static ApiResult loginDzsj(IdentityData identityData, SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> param = new HashMap<String, String>(16);
            param.put("yhm", identityData.getUsername());
            param.put("password", identityData.getPassword());
            param.put("ip", InetAddress.getLocalHost().getHostAddress());
            param.put("sjly", "0");
            param.put("qddm", vo.getQddm());
            HashMap<String, Object> bodyParam = new HashMap<String, Object>(16);
            bodyParam.put("body", Collections.singleton(param));
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("methodKey", LOGIN_WITH_YHM);
            String encryptStr = GzsjDeclareService.desEncrypt(bodyParam, "jsbgn");
            map.put("jsonEncStr", encryptStr);
            Map<String, Object> inputParams = GzsjDeclareService.dealInputParams(map, "ex_gztax_sso");
            RequestResult resultResult = GzsjDeclareService.invokeService(inputParams, "v1/dzswj/csxj/qx/sso/dzswjcz/yhmmmdl");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            if (resultResult.getData() != null) {
                Map dataMap = (Map)resultResult.getData();
                Map bodyMap = (Map)JsonUtil.fromJson((String)((String)dataMap.get("body")), Map.class);
                Map innerBodyMap = (Map)bodyMap.get("body");
                apiResult = "0".equals(innerBodyMap.get("returncode")) ? CustomApiResult.dealResponse(innerBodyMap, (String)innerBodyMap.get("returnmessage"), "4", true) : CustomApiResult.dealResponse(null, (String)innerBodyMap.get("returnmessage"), "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38", (String)"GzsjDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult logout(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put(SESSION_ID_KEY, vo.getSessionId());
            HashMap<String, String> body = new HashMap<String, String>(16);
            body.put("ssoSessionId", vo.getSessionId());
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("body", Collections.singletonList(body));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            String encryptStr = GzsjDeclareService.desEncrypt(r, "foresee@2016");
            paramMap.put("body", JsonUtil.toJson((Object)encryptStr));
            Map<String, Object> inputParams = GzsjDeclareService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareService.invokeService(inputParams, "v1/dzswj/csxj/qx/sso/dzswjcz/zxhhtcdl");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u6ce8\u9500\u4f1a\u8bdd\u4fe1\u606f\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareService_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            CustomApiResult.dealResponse(null, resultResult.getMessage(), "4", true);
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38", (String)"GzsjDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult getHhxx(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put(SESSION_ID_KEY, vo.getSessionId());
            HashMap<String, String> body = new HashMap<String, String>(16);
            body.put("ssoSessionId", vo.getSessionId());
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("body", Collections.singletonList(body));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            String encryptStr = GzsjDeclareService.desEncrypt(r, "foresee@2016");
            paramMap.put("body", JsonUtil.toJson((Object)encryptStr));
            Map<String, Object> inputParams = GzsjDeclareService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareService.invokeService(inputParams, "v1/dzswj/csxj/qx/sso/dzswjcz/hqhhxx");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            if (resultResult.getData() != null) {
                Map dataMap = (Map)resultResult.getData();
                Map bodyMap = (Map)JsonUtil.fromJson((String)((String)dataMap.get("body")), Map.class);
                Map innerBodyMap = (Map)bodyMap.get("body");
                apiResult = "1".equals(innerBodyMap.get("returncode")) ? CustomApiResult.dealResponse(innerBodyMap, (String)innerBodyMap.get("returnmessage"), "4", true) : CustomApiResult.dealResponse(null, (String)innerBodyMap.get("returnmessage"), "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38", (String)"GzsjDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public static ApiResult qhQySf(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put(SESSION_ID_KEY, vo.getSessionId());
            HashMap<String, String> body = new HashMap<String, String>(16);
            body.put("ssoSessionId", vo.getSessionId());
            body.put("qybdid", vo.getQybdid());
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("body", Collections.singletonList(body));
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            paramMap.put("head", headMap);
            String encryptStr = GzsjDeclareService.desEncrypt(r, "foresee@2016");
            paramMap.put("body", JsonUtil.toJson((Object)encryptStr));
            Map<String, Object> inputParams = GzsjDeclareService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareService.invokeService(inputParams, "v1/dzswj/csxj/qx/sso/dzswjcz/xzqysf");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            if (resultResult.getData() != null) {
                Map dataMap = (Map)resultResult.getData();
                Map bodyMap = (Map)JsonUtil.fromJson((String)((String)dataMap.get("body")), Map.class);
                Map innerBodyMap = (Map)bodyMap.get("body");
                apiResult = "1".equals(innerBodyMap.get("returncode")) ? CustomApiResult.dealResponse(innerBodyMap, (String)innerBodyMap.get("returnmessage"), "4", true) : CustomApiResult.dealResponse(null, (String)innerBodyMap.get("returnmessage"), "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u8c03\u7528\u767b\u5f55\u7535\u5b50\u7a0e\u5c40\u63a5\u53e3\u5f02\u5e38", (String)"GzsjDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public abstract ApiResult getQcData(SBMessageBaseVo var1);

    public abstract ApiResult declare(SBMessageBaseVo var1);

    public ApiResult qyhjxx(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, String> headMap = new HashMap<String, String>(16);
            headMap.put(SESSION_ID_KEY, vo.getSessionId());
            HashMap<String, Object> qqbwMap = new HashMap<String, Object>(16);
            qqbwMap.put("skssqq", vo.getSkssqq());
            qqbwMap.put("skssqz", vo.getSkssqz());
            qqbwMap.put("sid", "dzswj.ywzz.sb.zzyxwqyhj.cxZzyxwqyhj");
            qqbwMap.put(DJXH, vo.getDjxh());
            HashMap<String, String> bodyMap = new HashMap<String, String>(16);
            HashMap<String, Object> paramMap = new HashMap<String, Object>(16);
            bodyMap.put("qqbw", JsonUtil.toJson(qqbwMap));
            paramMap.put("head", headMap);
            paramMap.put("body", bodyMap);
            Map<String, Object> inputParams = GzsjDeclareService.dealInputParams(paramMap, "ex_gztax_cit_session");
            RequestResult resultResult = GzsjDeclareService.invokeService(inputParams, "v1/dzswj/csxj/qyxx/cxqyhslxxx");
            if (resultResult == null || !"0000".equals(resultResult.getErrorCode())) {
                String message = ResManager.loadKDString((String)"\u8c03\u7528\u83b7\u53d6\u7f13\u4ea4\u4fe1\u606f\u63a5\u53e3\u5931\u8d25", (String)"GzsjDeclareService_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)resultResult.getData();
            Map bodyResultMap = (Map)JsonUtil.fromJson((String)((String)responseMap.get("body")), Map.class);
            if (responseMap != null) {
                apiResult = "000".equals(String.valueOf(bodyResultMap.get("rtnCode"))) ? CustomApiResult.dealResponse(bodyResultMap.get("body"), "", String.valueOf(bodyResultMap.get("rtnCode")), true) : CustomApiResult.dealResponse(null, "", String.valueOf(bodyResultMap.get("rtnCode")), false);
            } else {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7f13\u7f34\u6570\u636e\u4e3a\u7a7a", (String)"GzsjDeclareService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u7f13\u7f34\u6570\u636e\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6\u7f13\u7f34\u6570\u636e\u5f02\u5e38", (String)"GzsjDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    public abstract ApiResult getTaskResult(SBMessageBaseVo var1, String var2);

    protected static RequestResult invokeService(Map<String, Object> params, String url) {
        HashMap<String, Object> rq = new HashMap<String, Object>(16);
        rq.put("url", url);
        rq.put("method", "post");
        HashMap<String, String> headersq = new HashMap<String, String>(16);
        headersq.put("Content-Type", "application/json");
        headersq.put("Accept", "application/json");
        rq.put("headers", headersq);
        rq.put("cookies", new HashMap(16));
        rq.put("charset", StandardCharsets.UTF_8);
        params.put("requestMapping", rq);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tdm", (String)"MicroServiceApiDispatcher", (String)"executeTaxService", (Object[])new Object[]{SerializationUtils.toJsonString(params)});
        logger.info("\u8c03\u7528\u96c6\u6210\u4e91\u8fd4\u56de----" + result);
        return (RequestResult)SerializationUtils.fromJsonString((String)result, RequestResult.class);
    }

    protected static Map<String, Object> dealInputParams(Map<String, Object> paramMap, String type) {
        HashMap<String, Object> inputParams = new HashMap<String, Object>(16);
        inputParams.put("inputParams", paramMap);
        inputParams.put("apiNumber", type);
        inputParams.put("caller", "taxc-tsate");
        return inputParams;
    }

    protected static String desEncrypt(Map<String, Object> bodyParam, String pword) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName("DES");
        Constructor<?> constructor = clazz.getConstructor(String.class);
        Object newInstance = constructor.newInstance(pword);
        Method method = clazz.getMethod("encrypt", String.class);
        return (String)method.invoke(newInstance, SerializationUtils.toJsonString(bodyParam));
    }

    public static void buildRequestId(String requestId, SBMessageBaseVo vo) {
        DynamicObject taxOrg = QueryServiceHelper.queryOne((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        if (taxOrg != null) {
            DynamicObject requestInfo = ConnectConfigService.getRequestId(vo.getNsrsbh(), vo.getType(), vo.getSkssqq(), vo.getSkssqz(), "1");
            if (requestInfo == null) {
                requestInfo = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_status_info");
                requestInfo.set("org", (Object)taxOrg.getLong("org"));
                requestInfo.set("skssqq", (Object)vo.getSkssqq());
                requestInfo.set("skssqz", (Object)vo.getSkssqz());
                requestInfo.set("type", (Object)vo.getType());
                requestInfo.set("billstatus", (Object)"C");
                requestInfo.set("requesttype", (Object)RequestTypeEnum.DECLARE.getCode());
            }
            requestInfo.set("executestatus", (Object)"1");
            requestInfo.set("createtime", (Object)new Date());
            requestInfo.set("creator", (Object)RequestContext.get().getUserId());
            requestInfo.set("requestid", (Object)requestId);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{requestInfo});
        }
    }
}

