/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.tsate.business.TctbTaxMainBusiness;
import kd.taxc.tsate.business.TsateDeclareQueryListBusiness;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.constant.kd.KdMessageSendConstant;
import kd.taxc.tsate.common.enums.DeclareTypeEnum;
import kd.taxc.tsate.common.enums.PayStatusEnum;
import kd.taxc.tsate.common.enums.TaxPeriodType;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.common.util.RsaCryptTools;
import kd.taxc.tsate.mservice.SupplierTaskServiceHelper;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.enums.KdStateTypeEnum;
import kd.taxc.tsate.msmessage.enums.KddlfsMappingEnums;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.zwy.ZwyRequest;
import kd.taxc.tsate.msmessage.service.zwy.api.ZwyApi;
import kd.taxc.tsate.msmessage.service.zwy.constant.ZwyDfsfMappingEnums;
import kd.taxc.tsate.msmessage.service.zwy.helper.ZwyTaxTranslateHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class KdDirectDeclareService {
    private static final Log logger = LogFactory.getLog(KdDirectDeclareService.class);
    private static final String SEPARATOR = System.getProperty("line.separator");

    public static ApiResult getToken() {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            param.put("nonce", nonce);
            param.put("timestamp", timestamp);
            param.put("appId", appCode);
            param.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(appCode + timestamp + nonce))));
            String url = baseUrl + "/taxopenservice/auth/token/get";
            logger.info("zwy getoken params " + JsonUtil.toJson(param));
            logger.info("zwy getoken url " + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(param));
            logger.info("zwy getoken response " + response);
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6Token\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(((Map)responseMap.get("data")).get("token"), (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), true) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), false);
            } else {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6token\u5904\u7406\u5f02\u5e38\uff1a" + e);
            String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult withData(SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            MessageSend send = new MessageSend();
            send.setMsgtype("declare");
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(vo.getBusinessType());
            send.setNsrType(vo.getType());
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.ZWY.getName());
            StringBuilder detailLog = new StringBuilder();
            logger.info("zwy getSbbData start:");
            String reqContent = MessageService.collectionData(send, null, vo.getNsrsbh());
            detailLog.append(ResManager.loadKDString((String)"\u7533\u62a5\u62a5\u6587:", (String)"KdDirectDeclareService_6", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(reqContent).append(SEPARATOR);
            if (StringUtils.isNotBlank((String)reqContent)) {
                Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(reqContent);
                Map sbbDataMap = (Map)sbbDataRootMap.get("Root");
                KdDirectDeclareService.sortMap(sbbDataMap);
                String sbbData = JsonUtil.toJson((Object)sbbDataMap);
                Map configMap = CommonInfoUtil.getCommonConfigInfo();
                String appCode = (String)configMap.get("zwy_app_id");
                String baseUrl = (String)configMap.get("zwy_base_url");
                String nonce = UUID.randomUUID().toString();
                Long timestamp = System.currentTimeMillis();
                HashMap<String, Object> paramMap = new HashMap<String, Object>();
                DynamicObject areaObj = CommonInfoUtil.getAreaInfo((Long)Long.valueOf(vo.getBusinessId()));
                if (areaObj == null) {
                    apiResult = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5730\u533a\u4fe1\u606f", (String)"KdDirectDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
                    return apiResult;
                }
                logger.info("zwy save-getToken start:");
                apiResult = KdDirectDeclareService.getToken();
                logger.info("zwy save-getToken end:" + JsonUtil.toJson((Object)apiResult));
                if (apiResult == null || !apiResult.getSuccess()) {
                    String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                    return apiResult;
                }
                String token = String.valueOf(apiResult.getData());
                paramMap.put("nonce", nonce);
                paramMap.put("appId", appCode);
                paramMap.put("timestamp", timestamp);
                paramMap.put("token", token);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
                params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
                params.put("taxCode", vo.getNsrsbh());
                params.put("region", areaObj.getString("xzqh"));
                params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
                params.put("taxData", RsaCryptTools.encrypt((String)sbbData));
                paramMap.put("params", params);
                String urlParam = KdDirectDeclareService.buildUrlParams(params);
                paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
                String url = baseUrl + "/taxopenservice/auto-tax/tax-info/save/with-data";
                logger.info("zwy save url:" + url);
                String notify = ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%1$s %2$s \u8bf7\u6c42\u53c2\u6570\uff1a%3$s %4$s", (String)"KdDirectDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                String notifyMsg = String.format(notify, url, SEPARATOR, JsonUtil.toJson(paramMap), SEPARATOR);
                failedLog.append(notifyMsg);
                DirectDeclareLogUtils.dealDetailLog(failedLog, vo.getId());
                String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
                logger.info(String.format("zwy save resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
                if (StringUtils.isBlank((String)response)) {
                    String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u7533\u62a5\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                    return apiResult;
                }
                Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
                if (responseMap != null) {
                    apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(null, (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), true) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), false);
                } else {
                    String message = ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"KdDirectDeclareService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                }
            } else {
                String message = ResManager.loadKDString((String)"\u7533\u62a5\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"KdDirectDeclareService_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult declare(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy declare-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy declare-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            DynamicObject declare = TsateDeclareQueryListBusiness.queryOneDeclareById((String)vo.getBusinessId());
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            params.put("taxCode", vo.getNsrsbh());
            params.put("amount", KdDirectDeclareService.getYbtse(declare));
            params.put("debitType", KdDirectDeclareService.getDebitType(declare));
            String zwyTaxTypeCode = KdDirectDeclareService.getZwyTaxType(vo.getBusinessType(), DateUtils.getTaxLimit3((Date)vo.getSkssqq(), (Date)vo.getSkssqz()));
            params.put("taxType", zwyTaxTypeCode);
            params.put("appointDebitDate", DateUtils.format((Date)vo.getPayDate(), (String)"yyyy-MM-dd"));
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/submit";
            logger.info("zwy declare params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy declare url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info("zwy declare resonse:" + response);
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u7533\u62a5\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealResponse(responseMap, vo, "directdeclare");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult pay(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy pay-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy pay-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            DynamicObject declare = TsateDeclareQueryListBusiness.queryOneDeclareById((String)vo.getBusinessId());
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            params.put("taxCode", vo.getNsrsbh());
            params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            params.put("amount", KdDirectDeclareService.getYbtse(declare));
            String agreementAccount = TctbTaxMainBusiness.getTripleAggrementInfo((Long)Long.parseLong(vo.getOrg()));
            if (StringUtil.isNotEmpty((CharSequence)agreementAccount)) {
                params.put("sfxyh", agreementAccount);
            } else {
                params.put("sfxyh", "");
            }
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/debit";
            logger.info("zwy pay params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy pay url:" + url);
            StringBuilder detailLog = new StringBuilder();
            String notify = ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%1$s %2$s \u8bf7\u6c42\u53c2\u6570\uff1a%3$s %4$s", (String)"KdDirectDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, url, SEPARATOR, JsonUtil.toJson(paramMap), SEPARATOR);
            detailLog.append(notifyMsg);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy pay resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u6263\u6b3e\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealResponse(responseMap, vo, "fastpay");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult queryTaskStatus(SBMessageBaseVo vo, String type) {
        ApiResult apiResult = new ApiResult();
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            apiResult = KdDirectDeclareService.getToken();
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            if (vo.getSkssqq() != null) {
                params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            }
            if (vo.getSkssqz() != null) {
                params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            }
            params.put("taxCode", vo.getNsrsbh());
            if (StringUtils.isNotBlank((String)vo.getBusinessType())) {
                Map voParams = vo.getParams();
                if ("ccxws".equals(voParams.get("type")) && "tbzt".equals(voParams.get("key"))) {
                    Long businessId = Long.valueOf(String.valueOf(voParams.get("businessId")));
                    String supplierLabel = String.valueOf(vo.getParams().get("supplier"));
                    SupplierTaskServiceHelper.buildCcxwsTaxType(businessId, vo, supplierLabel);
                }
                params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            }
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/get/state";
            logger.info("zwy querystatus params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy querystatus url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy querystatus resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u67e5\u8be2\u4efb\u52a1\u72b6\u6001\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null && StringUtils.equals((String)"2", (String)(apiResult = KdDirectDeclareService.getTaskStatus(responseMap, type)).getErrorCode())) {
                logger.info("zwy\u5904\u7406\u4e2d" + JsonUtil.toJson((Object)apiResult));
                StringBuilder msg = new StringBuilder();
                if (kd.bos.util.StringUtils.isNotEmpty((String)apiResult.getMessage())) {
                    String notify = ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s %2$s", (String)"KdDirectDeclareService_29", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                    String notifyMsg = String.format(notify, vo.getNsrsbh(), apiResult.getMessage());
                    msg.append(notifyMsg);
                }
                if ("directdeclare".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declaring", "1", msg, true);
                } else if ("fastpay".equals(type)) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paying", "1", msg);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult verify(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy verify-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy verify-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("taxCode", vo.getNsrsbh());
            KdDirectDeclareService.builLoginParams(identityData, params, "extInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-company/verify";
            logger.info("zwy virify params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy virify url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy virify resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u9a8c\u8bc1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_13", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealResponse(responseMap, vo, "verify");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    private static void builLoginParams(IdentityData identityData, Map<String, Object> params, String key) {
        HashMap<String, Object> extraInfo = new HashMap<String, Object>();
        extraInfo.put("username", identityData.getUsername());
        extraInfo.put("password", identityData.getPassword());
        extraInfo.put("taxmanName", identityData.getTaxmanName());
        extraInfo.put("taxmanPwd", identityData.getTaxmanPwd());
        ZwyDfsfMappingEnums dlsfEnum = ZwyDfsfMappingEnums.valueOfKdCode(identityData.getDlsf());
        if (dlsfEnum == null) {
            dlsfEnum = ZwyDfsfMappingEnums.BSR;
        }
        extraInfo.put("dlsf", dlsfEnum.getZwyCode());
        extraInfo.put("dlfs", KddlfsMappingEnums.getDlfsByCode(identityData.getLoginType()));
        HashMap<String, String> additionalExtend = new HashMap<String, String>();
        additionalExtend.put("sfzjhm", identityData.getTaxmanSfz());
        additionalExtend.put("shPhone", identityData.getTelephoneNum());
        additionalExtend.put("caPwd", identityData.getCapassword());
        additionalExtend.put("rackId", identityData.getJghm());
        additionalExtend.put("rackPort", identityData.getJgport());
        extraInfo.put("additionalExtend", additionalExtend);
        logger.info("zwy login params" + JsonUtil.toJson(extraInfo));
        params.put(key, RsaCryptTools.encryptByPrivateKey((String)JsonUtil.toJson(extraInfo)));
    }

    public static ApiResult getQcData(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy getQcData-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy getQcData-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            params.put("taxCode", vo.getNsrsbh());
            params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/obtain_qc";
            logger.info("zwy getQcData params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy getQcData url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy getQcData resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u83b7\u53d6\u671f\u521d\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                return CustomApiResult.dealResponse(null, message, "001", false);
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealResponse(responseMap, vo, "getData");
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult getQynsxx(SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy getQynsxx-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy getQynsxx-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("submitMonth", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"));
            String declareType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
            String zwyTaxType = ZwyTaxTranslateHelper.getZwyTaxTypeByDeclareType(declareType, vo.getDate(SbpzMessageVo.Key.SKSSQQ), vo.getDate(SbpzMessageVo.Key.SKSSQZ));
            params.put("taxType", zwyTaxType);
            params.put("periodBegin", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQQ)));
            params.put("periodEnd", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            params.put("type", vo.getScreenshotType());
            params.put("taxCode", vo.getNsrsbh());
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-company/screenshot/get";
            logger.info("zwy getQynsxx params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy getQynsxx url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy getQynsxx resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u4f01\u4e1a\u7eb3\u7a0e\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_15", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "4", true) : ("7016".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "2", true) : CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "001", false));
            } else {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_21", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + ExceptionUtil.toString((Exception)e));
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult screenShot(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog, String screenType) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy screenShot-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy screenShot-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("submitMonth", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"));
            String declareType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
            String zwyTaxType = ZwyTaxTranslateHelper.getZwyTaxTypeByDeclareType(declareType, vo.getDate(SbpzMessageVo.Key.SKSSQQ), vo.getDate(SbpzMessageVo.Key.SKSSQZ));
            params.put("taxType", zwyTaxType);
            params.put("periodBegin", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQQ)));
            params.put("periodEnd", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ)));
            params.put("taxCode", vo.getNsrsbh());
            params.put("type", screenType);
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/screenshot";
            logger.info("zwy screenShot params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy screenShot url:" + url);
            StringBuilder detailLog = new StringBuilder();
            String notify = ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%1$s %2$s \u8bf7\u6c42\u53c2\u6570\uff1a%3$s %4$s", (String)"KdDirectDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, url, SEPARATOR, JsonUtil.toJson(paramMap), SEPARATOR);
            detailLog.append(notifyMsg);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy screenShot resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u622a\u56fe\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealResponse(responseMap, vo, screenType, true);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult saveQyxx(IdentityData identityData, SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            DynamicObject areaObj = CommonInfoUtil.getAreaInfoByNsrsbh((String)vo.getNsrsbh());
            if (areaObj == null) {
                apiResult.setSuccess(false);
                apiResult.setMessage(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u5730\u533a\u4fe1\u606f", (String)"KdDirectDeclareService_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                return apiResult;
            }
            logger.info("zwy saveQyxx-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy saveQyxx-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("companyName", identityData.getNsrmc());
            params.put("region", areaObj.getString("xzqh"));
            params.put("taxCode", vo.getNsrsbh());
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/company/save";
            logger.info("zwy saveQyxx params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy saveQyxx url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy saveQyxx resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(null, (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), true) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), String.valueOf(responseMap.get("code")), false);
            } else {
                String message = ResManager.loadKDString((String)"\u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38", (String)"KdDirectDeclareService_20", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult downloadHistoryData(SBMessageBaseVo vo) {
        ApiResult apiResult = new ApiResult();
        try {
            logger.info("zwy downloadHistoryData start:");
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy save-downloadHistoryData start:");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy save-downloadHistoryData end:" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            String token = String.valueOf(apiResult.getData());
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            params.put("taxCode", vo.getNsrsbh());
            params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            StringBuilder urlSb = new StringBuilder(baseUrl);
            String key = (String)vo.getParams().get("key");
            if ("qcxz".equals(key)) {
                urlSb.append("/taxopenservice/auto-tax/tax-info/get/qc-taxdata");
            } else {
                urlSb.append("/taxopenservice/auto-tax/tax-info/get/taxdata");
            }
            String url = urlSb.toString();
            logger.info("zwy downloadHistoryData url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy downloadHistoryData resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u5386\u53f2\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_23", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "3", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "4", true) : ("1003".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "2", true) : CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "001", false));
            } else {
                String message = ResManager.loadKDString((String)"\u5386\u53f2\u6570\u636e\u83b7\u53d6\u5f02\u5e38", (String)"KdDirectDeclareService_24", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public static ApiResult obtainHistory(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy obtainHistory-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy obtainHistory-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            params.put("taxCode", vo.getNsrsbh());
            params.put("taxType", KdMessageSendConstant.getTaxTypeMap().get(vo.getBusinessType()));
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            String key = (String)vo.getParams().get("key");
            if ("qcxz".equals(key)) {
                params.put("markFunction", "");
            }
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            StringBuilder urlSb = new StringBuilder(baseUrl);
            if ("qcxz".equals(key)) {
                urlSb.append("/taxopenservice/auto-tax/tax-info/obtain_qc");
            } else {
                urlSb.append("/taxopenservice/auto-tax/tax-info/obtain-history");
            }
            String url = urlSb.toString();
            logger.info("zwy obtainHistory params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy obtainHistory url:" + url);
            StringBuilder detailLog = new StringBuilder();
            String notify = ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%1$s %2$s \u8bf7\u6c42\u53c2\u6570\uff1a%3$s %4$s", (String)"KdDirectDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, url, SEPARATOR, JsonUtil.toJson(paramMap), SEPARATOR);
            detailLog.append(notifyMsg);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy obtainHistory resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u83b7\u53d6\u5386\u53f2\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_25", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                return CustomApiResult.dealResponse(null, message, "001", false);
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealHistoryResponse(responseMap, vo);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public ApiResult obtainPdf(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy screenShot-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy screenShot-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("taxCode", vo.getNsrsbh());
            DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)vo.getString(SbpzMessageVo.Key.TYPENUMBER));
            TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)vo.getSkssqq(), (Date)vo.getSkssqz());
            String zwyTaxType = KdDirectDeclareService.getZwyTaxType(declareType.getCode(), periodType);
            params.put("taxType", zwyTaxType);
            params.put("submitMonth", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"));
            params.put("periodBegin", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/get/data/pdf";
            logger.info("zwy obtainpdf params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy obtainpdf url:" + url);
            StringBuilder detailLog = new StringBuilder();
            String notify = ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\uff1a%1$s %2$s \u8bf7\u6c42\u53c2\u6570\uff1a%3$s %4$s", (String)"KdDirectDeclareService_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            String notifyMsg = String.format(notify, url, SEPARATOR, JsonUtil.toJson(paramMap), SEPARATOR);
            detailLog.append(notifyMsg);
            DirectDeclareLogUtils.dealDetailLog(detailLog, vo.getId());
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy obtainpdf resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u622a\u56fe\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            apiResult = KdDirectDeclareService.dealPdfResponse(responseMap, vo, identityData);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    public ApiResult obtainpRrove(SBMessageBaseVo vo, IdentityData identityData) {
        DeclareTypeEnum declareType = DeclareTypeEnum.valueOfCode((String)vo.getString(SbpzMessageVo.Key.TYPENUMBER));
        TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)vo.getSkssqq(), (Date)vo.getSkssqz());
        String zwyTaxType = KdDirectDeclareService.getZwyTaxType(declareType.getCode(), periodType);
        String skssqq = DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQQ));
        String skssqz = DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SKSSQZ));
        String taxcode = vo.getNsrsbh();
        ApiResult proveResult = ZwyApi.taxProve(DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"), skssqq, skssqz, taxcode, zwyTaxType, identityData);
        if (!proveResult.getSuccess()) {
            return proveResult;
        }
        return KdDirectDeclareService.searchResult(vo, identityData);
    }

    public static ApiResult searchResult(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult apiResult = new ApiResult();
        try {
            Map configMap = CommonInfoUtil.getCommonConfigInfo();
            String appCode = (String)configMap.get("zwy_app_id");
            String baseUrl = (String)configMap.get("zwy_base_url");
            String nonce = UUID.randomUUID().toString();
            Long timestamp = System.currentTimeMillis();
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            logger.info("zwy searchResult-getToken start");
            apiResult = KdDirectDeclareService.getToken();
            logger.info("zwy searchResult-getToken end" + JsonUtil.toJson((Object)apiResult));
            if (apiResult == null || !apiResult.getSuccess()) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6token\u5f02\u5e38", (String)"KdDirectDeclareService_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Date skssqq = vo.getDate(SbpzMessageVo.Key.SKSSQQ);
            Date skssqz = vo.getDate(SbpzMessageVo.Key.SKSSQZ);
            TaxPeriodType periodType = DateUtils.getTaxLimit3((Date)skssqq, (Date)skssqz);
            String declareType = vo.getString(SbpzMessageVo.Key.TYPENUMBER);
            String token = (String)apiResult.getData();
            paramMap.put("nonce", nonce);
            paramMap.put("appId", appCode);
            paramMap.put("timestamp", timestamp);
            paramMap.put("token", token);
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("submitMonth", DateUtils.format((Date)vo.getDate(SbpzMessageVo.Key.SBQJ), (String)"yyyy-MM"));
            params.put("periodBegin", DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd"));
            params.put("periodEnd", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
            params.put("type", vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE));
            params.put("taxType", KdDirectDeclareService.getZwyTaxType(declareType, periodType));
            params.put("taxCode", vo.getNsrsbh());
            KdDirectDeclareService.builLoginParams(identityData, params, "extraInfo");
            paramMap.put("params", params);
            String urlParam = KdDirectDeclareService.buildUrlParams(params);
            paramMap.put("sign", RsaCryptTools.encryptByPrivateKey((String)DigestUtils.md5Hex((String)(urlParam + timestamp + nonce + token))));
            String url = baseUrl + "/taxopenservice/auto-tax/tax-info/get/search/result";
            logger.info("zwy searchResult params:" + JsonUtil.toJson(paramMap));
            logger.info("zwy searchResult url:" + url);
            String response = ZwyRequest.doPost(url, null, JsonUtil.toJson(paramMap));
            logger.info(String.format("zwy searchResult resonse: %s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", response, vo.getNsrsbh()));
            if (StringUtils.isBlank((String)response)) {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_26", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
                return apiResult;
            }
            Map responseMap = (Map)JsonUtil.fromJson((String)response, Map.class);
            if (responseMap != null) {
                apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "4", true) : ("7016".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "2", true) : CustomApiResult.dealResponse(responseMap.get("data"), (String)responseMap.get("message"), "001", false));
            } else {
                String message = ResManager.loadKDString((String)"\u83b7\u53d6\u67e5\u8be2\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_26", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
                apiResult = CustomApiResult.dealResponse(null, message, "001", false);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5f02\u5e38\uff1a" + e);
            logger.error(String.format("\u5904\u7406\u5f02\u5e38\uff1a%s \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7 %s", e.getMessage(), vo.getNsrsbh()));
            String message = ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38", (String)"KdDirectDeclareService_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "001", false);
        }
        return apiResult;
    }

    private static String buildUrlParams(Map<String, Object> paramMap) {
        paramMap = KdDirectDeclareService.sortByKey(paramMap);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, Object>> iterator = paramMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> item = iterator.next();
            stringBuilder.append(item.getKey()).append('=').append(item.getValue());
            if (!iterator.hasNext()) continue;
            stringBuilder.append('&');
        }
        return stringBuilder.toString();
    }

    private static Map<String, Object> sortByKey(Map<String, Object> map) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(map.size());
        map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEachOrdered(e -> result.put((String)e.getKey(), e.getValue()));
        return result;
    }

    private static ApiResult getTaskStatus(Map<String, Object> responseMap, String type) {
        ApiResult apiResult = new ApiResult();
        if (!StringUtils.equals((String)"0", (String)String.valueOf(responseMap.get("code")))) {
            apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "3", false);
        } else {
            Map result = (Map)responseMap.get("data");
            if (result != null) {
                switch (type) {
                    case "verify": {
                        apiResult = CustomApiResult.dealResponse(null, String.valueOf(result.get("verifyMsg")), String.valueOf(result.get("verifyState")), true);
                        break;
                    }
                    default: {
                        boolean isMatch = false;
                        if (result.get("stateList") != null) {
                            List stateList = (List)result.get("stateList");
                            if (!CollectionUtils.isNotEmpty((Collection)stateList)) break;
                            for (Map stateMap : stateList) {
                                if (!StringUtils.equals((String)KdStateTypeEnum.getTypeByKey(type), (String)String.valueOf(stateMap.get("stateType")))) continue;
                                isMatch = true;
                                apiResult = CustomApiResult.dealResponse(JsonUtil.toJson((Object)stateMap), String.valueOf(stateMap.get("stateMsg")), String.valueOf(stateMap.get("stateVal")), true);
                                break;
                            }
                            if (isMatch) break;
                            apiResult = CustomApiResult.dealResponse(null, null, "1", true);
                            break;
                        }
                        apiResult = CustomApiResult.dealResponse(null, String.valueOf(responseMap.get("message")), "1", false);
                    }
                }
            }
        }
        return apiResult;
    }

    private static ApiResult dealResponse(Map<String, Object> responseMap, SBMessageBaseVo vo, String key) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            if ("0".equals(String.valueOf(responseMap.get("code")))) {
                apiResult = KdDirectDeclareService.queryTaskStatus(vo, key);
                if (apiResult.getSuccess() && ("1".equals(apiResult.getErrorCode()) || "2".equals(apiResult.getErrorCode()))) {
                    logger.info("\u4efb\u52a1\u5df2\u4e0b\u53d1+" + apiResult.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                    int num = 0;
                    while (!(!(apiResult = KdDirectDeclareService.queryTaskStatus(vo, key)).getSuccess() || "3".equals(apiResult.getErrorCode()) || "4".equals(apiResult.getErrorCode()) || "5".equals(apiResult.getErrorCode()) || "6".equals(apiResult.getErrorCode()) || ++num > 3)) {
                    }
                }
            } else {
                apiResult = "1003".equals(String.valueOf(responseMap.get("code"))) ? CustomApiResult.dealResponse(null, (String)responseMap.get("message"), "2", true) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), "3", false);
            }
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealHistoryResponse(Map<String, Object> responseMap, SBMessageBaseVo vo) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? KdDirectDeclareService.downloadHistoryData(vo) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), "3", false);
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealResponse(Map<String, Object> responseMap, SBMessageBaseVo vo, String key, boolean flag) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? KdDirectDeclareService.getQynsxx(vo, new StringBuilder()) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), "3", false);
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static ApiResult dealPdfResponse(Map<String, Object> responseMap, SBMessageBaseVo vo, IdentityData identityData) throws InterruptedException {
        ApiResult apiResult = new ApiResult();
        if (responseMap != null) {
            apiResult = "0".equals(String.valueOf(responseMap.get("code"))) ? KdDirectDeclareService.searchResult(vo, identityData) : CustomApiResult.dealResponse(null, (String)responseMap.get("message"), "3", false);
        } else {
            String message = ResManager.loadKDString((String)"\u4e0b\u53d1\u4efb\u52a1\u8fd4\u56de\u4e3a\u7a7a", (String)"KdDirectDeclareService_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]);
            apiResult = CustomApiResult.dealResponse(null, message, "3", false);
        }
        return apiResult;
    }

    private static void sortMap(Map<String, Object> sbbDataMap) {
        if (sbbDataMap != null) {
            for (Map.Entry<String, Object> entry : sbbDataMap.entrySet()) {
                if (!(entry.getValue() instanceof List)) continue;
                List values = (List)entry.getValue();
                values = values.stream().filter(a -> EmptyCheckUtils.isNotEmpty((Object)a)).collect(Collectors.toList());
                values.sort(Comparator.comparingInt(o -> {
                    try {
                        return Integer.parseInt((String)o.get("ewblxh"));
                    }
                    catch (NumberFormatException e) {
                        return 99;
                    }
                }));
                entry.setValue(values);
            }
        }
    }

    private static String getZwyTaxType(String declareType, TaxPeriodType taxPeriodType) {
        DeclareTypeEnum declareTypeEnum = DeclareTypeEnum.valueOfCode((String)declareType);
        if (DeclareTypeEnum.FR0001 == declareTypeEnum && TaxPeriodType.YEAR == taxPeriodType) {
            return "398010201";
        }
        if (DeclareTypeEnum.FR0002 == declareTypeEnum && TaxPeriodType.YEAR == taxPeriodType) {
            return "398010202";
        }
        if (DeclareTypeEnum.YHS == declareTypeEnum) {
            declareType = TaxPeriodType.SINGLE == taxPeriodType ? "yhscb" : "yhsyb";
        }
        return (String)KdMessageSendConstant.getTaxTypeMap().get(declareType);
    }

    private static String getYbtse(DynamicObject declare) {
        if (declare == null) {
            return "";
        }
        return declare.getBigDecimal("bqybtse").toPlainString();
    }

    private static String getDebitType(DynamicObject declare) {
        if (declare != null) {
            String paystatus = declare.getString("paystatus");
            if (PayStatusEnum.YYPAID.getCode().equals(paystatus)) {
                return null;
            }
        }
        String kStr = "zwy_debittype";
        QFilter filter = new QFilter("key", "=", (Object)kStr);
        DynamicObject dyn = BusinessDataServiceHelper.loadSingle((String)"tsate_param_setting", (String)"value", (QFilter[])new QFilter[]{filter});
        if (dyn == null) {
            return "1";
        }
        return dyn.getString("value");
    }
}

