/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.api.ApiResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareRecordBusiness;
import kd.taxc.tsate.business.historydeclaration.HistoryDeclarationHandlerFactory;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.DeclareStatusEnum;
import kd.taxc.tsate.common.enums.ExecuteTypeEnums;
import kd.taxc.tsate.common.ext.aisino.beans.IdentityData;
import kd.taxc.tsate.common.helper.CommonUtils;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.HistoryDataUtils;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.common.util.template.TemplateUtils;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.enums.KdDownloadTypeEnum;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.helper.sfzhdxx.TsateSfzhdxxHelper;
import kd.taxc.tsate.msmessage.service.KdDirectDeclareService;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.lsxz.HistoryDataAdditionFactory;
import kd.taxc.tsate.msmessage.service.sbsxxz.SbsxxzStrategyFactory;
import kd.taxc.tsate.msmessage.service.zwy.api.ZwyApi;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.lang.StringUtils;

public class KdMessageSendServiceImpl
implements MessageSendService {
    private static final Log logger = LogFactory.getLog(KdMessageSendServiceImpl.class);
    private static final String SEPARATOR = System.getProperty("line.separator");

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
                return result;
            }
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            KdMessageSendServiceImpl.dealResult(result, vo, identityData, failedLog, isQuery);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + ExceptionUtil.toString((Exception)e));
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
                return result;
            }
            logger.info("zwy\u6263\u6b3e\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            result = KdMessageSendServiceImpl.dealGetStatus(vo, "fastpay");
            logger.info("\u6263\u6b3e\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paid", "2", failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode()) || StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("\u7f34\u6b3e\u5931\u8d25" + JsonUtil.toJson((Object)result));
                if (isQuery.booleanValue()) {
                    DynamicObject declare;
                    if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
                        logger.info("\u7f34\u6b3e\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s\u7f34\u6b3e\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_9", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh(), result.getMessage()}));
                    } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "paying".equals(declare.getString("paystatus"))) {
                        this.tryPay(vo, result, failedLog, identityData);
                    }
                } else {
                    this.tryPay(vo, result, failedLog, identityData);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        try {
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                ConnectConfigService.updateIdentityData(identityData.getId(), "2");
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            logger.info("zwy\u7a0e\u5c40\u9a8c\u8bc1\u7b2c\u4e00\u6b65\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            result = KdMessageSendServiceImpl.dealGetStatus(vo, "verify");
            logger.info("\u9a8c\u8bc1\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("\u7a0e\u5c40\u9a8c\u8bc1\u5931\u8d25" + JsonUtil.toJson((Object)result));
                if (isQuery.booleanValue()) {
                    logger.info("\u7a0e\u5c40\u9a8c\u8bc1\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                    result.setErrorCode(ErrorCode.FAIL.getCode());
                    result.setSuccess(false);
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                    ConnectConfigService.updateIdentityData(identityData.getId(), "2");
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                } else {
                    logger.info("zwy\u7533\u62a5\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u9a8c\u8bc1\u5931\u8d25\uff0c\u91cd\u65b0\u9a8c\u8bc1" + vo.getNsrsbh());
                    result = this.dealVirifyStatus(vo, failedLog, identityData);
                }
            } else if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                if (isQuery.booleanValue()) {
                    logger.info("zwy\u7a0e\u5c40\u9a8c\u8bc1\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u9a8c\u8bc1\u6210\u529f" + vo.getNsrsbh());
                    ConnectConfigService.updateIdentityData(identityData.getId(), "1");
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                } else {
                    logger.info("zwy\u7a0e\u5c40\u9a8c\u8bc1\u7b2c\u4e8c\u6b65,\u5f00\u59cb\u9a8c\u8bc1" + vo.getNsrsbh());
                    result = this.dealVirifyStatus(vo, failedLog, identityData);
                }
            } else if (StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u672a\u9a8c\u8bc1\uff0c\u5f00\u59cb\u9a8c\u8bc1" + vo.getNsrsbh());
                result = this.dealVirifyStatus(vo, failedLog, identityData);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            if (identityData != null) {
                ConnectConfigService.updateIdentityData(identityData.getId(), "2");
            }
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            logger.info("zwy\u622a\u56fe\u7b2c\u4e00\u6b65" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            if ("schtask".equals(vo.getString(SbpzMessageVo.Key.MSG_SOURCE))) {
                isQuery = true;
                logger.info("zwy\u622a\u56fe\u4efb\u52a1-\u5b9a\u65f6\u4efb\u52a1\u67e5\u8be2\u4efb\u52a1\u7ed3\u679c");
            }
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            if (isQuery.booleanValue()) {
                result = KdDirectDeclareService.getQynsxx(vo, null);
                logger.info("\u622a\u56fe\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                if (StringUtils.equals((String)"2", (String)result.getErrorCode())) {
                    logger.info("\u622a\u56fe\u5904\u7406\u4e2d,\u7b49\u5f85\u4e0b\u6b21\u5b9a\u65f6\u89e6\u53d1\u5237\u65b0\u4efb\u52a1\u72b6\u6001" + JsonUtil.toJson((Object)result));
                    return result;
                }
                if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("\u622a\u56fe\u5931\u8d25" + JsonUtil.toJson((Object)result));
                    result.setErrorCode(ErrorCode.FAIL.getCode());
                    result.setSuccess(false);
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                } else if (result.getSuccess() || StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("\u622a\u56fe\u6210\u529f-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                    logger.info("zwy\u622a\u56fe\u7b2c\u4e8c\u6b65,\u72b6\u6001\u622a\u56fe\u6210\u529f\uff0c\u4fdd\u5b58\u9644\u4ef6" + vo.getNsrsbh());
                    result = KdMessageSendServiceImpl.dealAttachment(vo, failedLog);
                }
            } else {
                logger.info("zwy\u622a\u56fe\u7b2c\u4e8c\u6b65,\u5f00\u59cb\u622a\u56fe" + vo.getNsrsbh());
                result = this.dealScreenStatus(vo, failedLog, identityData);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            logger.info("zwy\u4e0b\u8f7d\u7b2c\u4e00\u6b65" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            if (isQuery.booleanValue()) {
                this.refreshVoucher(vo, identityData);
            } else {
                logger.info("zwy\u4e0b\u8f7d\u7b2c\u4e8c\u6b65,\u5f00\u59cb\u622a\u56fe" + vo.getNsrsbh());
                result = this.dealDownloadStatus(vo, failedLog, identityData);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + ExceptionUtil.toString((Exception)e));
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult downloadQcData(SBMessageBaseVo vo) {
        return this.downloadDeclareData(vo);
    }

    @Override
    public ApiResult downloadHistoryData(SBMessageBaseVo vo) {
        return this.downloadDeclareData(vo);
    }

    private ApiResult downloadDeclareData(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                return result;
            }
            logger.info("zwy\u83b7\u53d6\u5386\u53f2\u6570\u636e\u7b2c\u4e00\u6b65" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            this.dealHistoryProcess(isQuery, result, vo, identityData, failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult downloadSbsx(SBMessageBaseVo vo) {
        ApiResult result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8d26\u65e0\u5fe7\u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u4e0b\u8f7d\u8c03\u7528\u5931\u8d25", (String)"KdMessageSendServiceImpl_19", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        Long recordId = vo.getId();
        StringBuilder failedLog = new StringBuilder();
        try {
            if (!this.checkIdentityDataAndSaveInfo(failedLog, vo)) {
                ApiResult apiResult = result;
                return apiResult;
            }
            SbsxxzStrategyFactory.doCommonHandler(vo, SupplierEnum.ZWY);
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"KdMessageSendServiceImpl_30", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Exception)e);
            failedLog.append(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38\u6216\u5931\u8d25,\u8be6\u60c5\uff1a", (String)"KdMessageSendServiceImpl_31", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(e.getMessage());
            logger.error("\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u5931\u8d25,recordId={}" + e.getMessage(), (Object)recordId);
            logger.error(stackMsg);
        }
        finally {
            if (result.getSuccess()) {
                DirectDeclareLogUtils.updateStatus(recordId, "2", failedLog);
            } else {
                DirectDeclareLogUtils.updateStatus(recordId, "3", failedLog);
            }
        }
        return result;
    }

    private boolean checkIdentityDataAndSaveInfo(StringBuilder failedLog, SBMessageBaseVo vo) throws Exception {
        boolean checkFlag = false;
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        if (identityData == null) {
            failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
            return checkFlag;
        }
        ApiResult result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
        if (!result.getSuccess()) {
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            return checkFlag;
        }
        return true;
    }

    private ApiResult dealHistoryProcess(boolean isQuery, ApiResult result, SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        if (isQuery) {
            result = KdDirectDeclareService.downloadHistoryData(vo);
            logger.info("\u83b7\u53d6\u5386\u53f2\u6570\u636e\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
            if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("\u4e0b\u8f7d\u5386\u53f2\u6570\u636e\u5931\u8d25" + JsonUtil.toJson((Object)result));
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setSuccess(false);
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            } else if (result.getSuccess() || StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("\u83b7\u53d6\u5386\u53f2\u6570\u636e\u6210\u529f-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                logger.info("zwy\u83b7\u53d6\u5386\u53f2\u6570\u636e\u7b2c\u4e8c\u6b65,\u83b7\u53d6\u6210\u529f\uff0c\u4fdd\u5b58\u5386\u53f2\u6570\u636e" + vo.getNsrsbh());
                Object data = result.getData();
                if (data != null) {
                    Map historyData = (Map)data;
                    DirectDeclareLogUtils.dealDetailLog(new StringBuilder(JsonUtil.toJson((Object)historyData)), vo.getId());
                    this.dealHistoryData(vo, (Map)JsonUtil.fromJson((String)((String)historyData.get("taxData")), Map.class), failedLog);
                }
            }
        } else {
            logger.info("zwy\u622a\u56fe\u7b2c\u4e8c\u6b65,\u5f00\u59cb\u83b7\u53d6\u5386\u53f2\u6570\u636e" + vo.getNsrsbh());
            result = this.dealHistory(vo, failedLog, identityData);
        }
        return result;
    }

    private ApiResult dealScreenStatus(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) throws Exception {
        ApiResult result = KdMessageSendServiceImpl.dealScreenShot(vo, identityData, failedLog);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zw\u622a\u56fe\u7b2c\u4e09\u6b65,\u622a\u56fe\u72b6\u6001\u72b6\u6001\u4e3a\u622a\u56fe\u6210\u529f" + vo.getNsrsbh());
                result = KdMessageSendServiceImpl.dealAttachment(vo, failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zw\u622a\u56fe\u7b2c\u4e09\u6b65,\u622a\u56fe\u72b6\u6001\u72b6\u6001\u4e3a\u622a\u56fe\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ApiResult dealAttachment(SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult result = new ApiResult();
        if ("kkjt".equals(vo.getName()) || "sbjt".equals(vo.getName())) {
            result = KdDirectDeclareService.getQynsxx(vo, null);
        } else if (StringUtils.isNotBlank((String)vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE))) {
            IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
            result = KdDirectDeclareService.searchResult(vo, identityData);
        }
        InputStream in = null;
        try {
            if (result.getSuccess() && EmptyCheckUtils.isNotEmpty((Object)result.getData())) {
                String screenUrl = null;
                String suffixName = null;
                if ("kkjt".equals(vo.getName()) || "sbjt".equals(vo.getName())) {
                    screenUrl = (String)result.getData();
                    if (StringUtils.equals((String)"1", (String)vo.getScreenshotType())) {
                        suffixName = ResManager.loadKDString((String)"\u7533\u62a5%s", (String)"KdMessageSendServiceImpl_2", (String)"taxc-tsate-mservice", (Object[])new Object[]{screenUrl.substring(screenUrl.lastIndexOf("."))});
                    } else if (StringUtils.equals((String)"2", (String)vo.getScreenshotType())) {
                        suffixName = ResManager.loadKDString((String)"\u7f34\u6b3e%s", (String)"KdMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[]{screenUrl.substring(screenUrl.lastIndexOf("."))});
                    }
                } else if (StringUtils.isNotBlank((String)vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE))) {
                    Map dataMap = (Map)result.getData();
                    screenUrl = (String)dataMap.get("data");
                    suffixName = ResManager.loadKDString((String)"\u7533\u62a5\u8868\u6587\u4ef6%s", (String)"KdMessageSendServiceImpl_18", (String)"taxc-tsate-mservice", (Object[])new Object[]{screenUrl.substring(screenUrl.lastIndexOf("."))});
                }
                if (StringUtils.isNotBlank((String)screenUrl)) {
                    DynamicObject recordObj = BusinessDataServiceHelper.loadSingle((Object)vo.getId(), (String)"tsate_declare_record");
                    if (StringUtils.equals((String)recordObj.getString("executestatus"), (String)"1")) {
                        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
                        String name = ((DynamicObject)org.get("org")).getString("name");
                        screenUrl = KdMessageSendServiceImpl.dealWithGatewayUrl(screenUrl);
                        URL url = new URL(screenUrl);
                        Map configMap = CommonInfoUtil.getCommonConfigInfo();
                        String proxyUrl = (String)configMap.get("kd_file_proxy");
                        if (StringUtils.isNotEmpty((String)proxyUrl)) {
                            String[] values = proxyUrl.trim().split(":");
                            if (values.length < 2) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u4ee3\u7406\u914d\u7f6e\u683c\u5f0f\u9519\u8bef", (String)"KdMessageSendServiceImpl_17", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                            }
                            Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(values[0], Integer.parseInt(values[1])));
                            in = url.openConnection(proxy).getInputStream();
                        } else {
                            in = url.openStream();
                        }
                        SbpzRecordSaveUtils.saveRecord(vo, in, name, suffixName, failedLog);
                    }
                } else {
                    failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u6682\u65e0\u9644\u4ef6\u622a\u56fe", (String)"KdMessageSendServiceImpl_5", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u9644\u4ef6\u5f02\u5e38", (Throwable)e);
            failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u5904\u7406\u9644\u4ef6\u5f02\u5e38", (String)"KdMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38", (Object)ExceptionUtil.toString((Exception)e));
                }
            } else {
                logger.warn("\u6d41\u5df2\u5173\u95ed");
            }
        }
        return result;
    }

    @Override
    public ApiResult getStatus(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        this.refresh(vo);
        return result;
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        IdentityData identityData = null;
        try {
            String resultMsg;
            ExecuteTypeEnums executeType;
            identityData = ConnectConfigService.queryIdentityData(vo);
            if (identityData == null) {
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u57fa\u7840\u8bbe\u7f6e\u5f02\u5e38\uff0c\u672a\u914d\u7f6e\u901a\u9053\u9a8c\u8bc1\u4fe1\u606f", (String)"KdMessageSendServiceImpl_0", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh()}));
                DirectDeclareLogUtils.uploadLogById(failedLog, vo.getId());
                return result;
            }
            result = KdMessageSendServiceImpl.dealQyxx(identityData, vo, failedLog);
            if (!result.getSuccess()) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s \u4fdd\u5b58\u4f01\u4e1a\u4fe1\u606f\u5f02\u5e38\uff1a", (String)"KdMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.uploadLogById(failedLog, vo.getId());
                return result;
            }
            if ("sfzhdxx".equals(vo.getName())) {
                this.downLoadApprovedInfosRefresh(vo);
                return result;
            }
            if ("tbzt".equals(vo.getName()) || "directdeclare".equals(vo.getName())) {
                boolean isObtainQCData = false;
                boolean isExistQcRecord = false;
                if ("tbzt".equals(vo.getName())) {
                    isExistQcRecord = ConnectConfigService.isExistQcRecord(vo, true);
                    isObtainQCData = ConnectConfigService.isObtainQcData(vo, true);
                } else {
                    isExistQcRecord = ConnectConfigService.isExistQcRecord(vo);
                    isObtainQCData = ConnectConfigService.isObtainQcData(vo);
                }
                if (!isObtainQCData) {
                    result = KdMessageSendServiceImpl.dealGetStatus(vo, "getData");
                    if (!isExistQcRecord) {
                        logger.info("\u6570\u636e\u5e93\u4e0d\u5b58\u5728\u671f\u521d\u8bb0\u5f55\uff0c\u5c06\u53d1\u8d77\u671f\u521d");
                        KdMessageSendServiceImpl.dealGetQcData(vo, identityData, failedLog);
                        return null;
                    }
                    if (StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                        logger.info("zwy\u671f\u521d\u72b6\u6001\u4e3a\u521d\u59cb\u5316\uff0c\u5c06\u53d1\u8d77\u671f\u521d");
                        KdMessageSendServiceImpl.dealGetQcData(vo, identityData, failedLog);
                        return null;
                    }
                    if (result.getSuccess() && StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        logger.info("zwy\u671f\u521d\u72b6\u6001\u4e3a\u6210\u529f\uff0c\u5c06\u7ee7\u7eed\u6267\u884c\u540e\u7eed\u4e1a\u52a1");
                        ConnectConfigService.updateSignInfo(vo, "1");
                    } else {
                        if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                            logger.info("zwy\u671f\u521d\u72b6\u6001\u4e3a\u5931\u8d25\uff0c\u5c06\u4fee\u6539\u7533\u62a5\u4e1a\u52a1\u72b6\u6001\u4e3a\u5931\u8d25");
                            ConnectConfigService.updateSignInfo(vo, "2");
                            failedLog.append(result.getMessage());
                            this.dealFailedStatus(vo, failedLog, identityData);
                            return null;
                        }
                        logger.info("zwy\u671f\u521d\u4efb\u52a1\u72b6\u6001:" + JSON.toJSONString((Object)result));
                        return null;
                    }
                }
            }
            if (ExecuteTypeEnums.QCXZ == (executeType = ExecuteTypeEnums.valuesOfKey((String)vo.getName())) || ExecuteTypeEnums.LSXZ == executeType) {
                return this.dealHistoryProcess(true, result, vo, identityData, failedLog);
            }
            if ("wspz".equals(vo.getName()) || "sbbfile".equals(vo.getName())) {
                return this.refreshVoucher(vo, identityData);
            }
            String statusType = vo.getName();
            if ("tbzt".equals(vo.getName())) {
                statusType = "directdeclare";
            }
            if (kd.bos.util.StringUtils.isNotEmpty((String)(resultMsg = (result = KdMessageSendServiceImpl.dealGetStatus(vo, statusType)).getMessage()))) {
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            }
            if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zwy\u83b7\u53d6\u72b6\u6001\u5931\u8d25" + vo.getNsrsbh());
                if (kd.bos.util.StringUtils.isEmpty((String)resultMsg)) {
                    failedLog.append(ResManager.loadKDString((String)"\u901a\u9053\u63d0\u4f9b\u65b9\u672a\u8fd4\u56de\u63d0\u793a\u4fe1\u606f", (String)"KdMessageSendServiceImpl_22", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                }
                this.dealFailedStatus(vo, failedLog, identityData);
            } else if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u83b7\u53d6\u72b6\u6001\u6210\u529f" + vo.getNsrsbh());
                this.dealSuccessStatus(vo, failedLog, identityData);
            } else if (StringUtils.equals((String)"5", (String)result.getErrorCode())) {
                logger.info("zwy\u6709\u7559\u62b5\u9000\u7a0e\u9009\u9879, \u8bb0\u5f55url" + vo.getNsrsbh());
                ConnectConfigService.dealFkxx(result.getData(), vo.getBusinessId(), true);
            } else if (StringUtils.equals((String)"6", (String)result.getErrorCode())) {
                logger.info("zwy\u5df2\u7533\u62a5\u672a\u5bfc\u5165, \u66f4\u65b0\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "importing", "1", failedLog);
            } else if (StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                logger.info("zwy\u672a\u5904\u7406" + vo.getNsrsbh());
                if ("directdeclare".equals(vo.getName())) {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
                    DeclareStatusEnum declareStatus = DeclareStatusEnum.valueOfCode((String)declare.getString("declarestatus"));
                    if (declare != null && (DeclareStatusEnum.SUBMITTED == declareStatus || DeclareStatusEnum.DECLARING == declareStatus)) {
                        logger.info("zwy\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u7ee7\u7eed\u7533\u62a5" + vo.getNsrsbh());
                        Long minutes = Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes();
                        if (minutes >= 3L) {
                            KdMessageSendServiceImpl.dealSbProcess(result, vo, identityData, failedLog, true);
                        }
                    }
                } else if ("tbzt".equals(vo.getName())) {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
                    if (declare != null && "declared".equals(declare.getString("declarestatus"))) {
                        logger.info("zwy\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u66f4\u65b0\u7533\u62a5\u8bb0\u5f55\u72b6\u6001\u4e3a\u65e0\u7533\u62a5" + vo.getNsrsbh());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "editing", "2", failedLog);
                    } else {
                        failedLog.append(ResManager.loadKDString((String)"\u7533\u62a5\u8bb0\u5f55\u72b6\u6001\u4e0d\u662f\u7533\u62a5\u6210\u529f,\u4e0d\u9700\u8981\u540c\u6b65\u7a0e\u5c40\u4f5c\u5e9f\u72b6\u6001", (String)"KdMessageSendServiceImpl_23", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u72b6\u6001\u5f02\u5e38" + vo.getNsrsbh());
            logger.error(ExceptionUtil.toString((Exception)e));
            failedLog.append(ResManager.loadKDString((String)"\u5904\u7406\u5f02\u5e38\uff1a%1$s traceid-%2$s", (String)"KdMessageSendServiceImpl_24", (String)"taxc-tsate-mservice", (Object[])new Object[]{e.getMessage(), RequestContext.get().getTraceId()}));
            this.dealFailedStatus(vo, failedLog, identityData);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult downloadVerification(SBMessageBaseVo sbMessageBaseVo) {
        ApiResult result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u8d26\u65e0\u5fe7\u7a0e\u8d39\u79cd\u6838\u5b9a\u4fe1\u606f\u4e0b\u8f7d\u8c03\u7528\u5931\u8d25\uff1a", (String)"KdMessageSendServiceImpl_20", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        Long recordId = sbMessageBaseVo.getId();
        String nsrsbh = sbMessageBaseVo.getNsrsbh();
        StringBuilder failedLog = new StringBuilder();
        try {
            if (!this.checkIdentityDataAndSaveInfo(failedLog, sbMessageBaseVo)) {
                ApiResult apiResult = result;
                return apiResult;
            }
            logger.info("zwy\u5f00\u59cb\u4e0b\u8f7d\u7a0e\u8d39\u79cd\u6838\u5b9a\u4fe1\u606f recordId={} \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7={}", (Object)recordId, (Object)nsrsbh);
            ApiResult taskResult = ZwyApi.downLoadApprovedinfosTask(nsrsbh);
            if (taskResult.getSuccess()) {
                result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"KdMessageSendServiceImpl_30", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
            } else {
                failedLog.append(taskResult.getMessage());
            }
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Exception)e);
            failedLog.append(e.getMessage());
            logger.error("zwy\u7a0e\u8d39\u79cd\u6838\u5b9a\u4fe1\u606f\u4e0b\u8f7d\u5931\u8d25,recordId={}" + e.getMessage(), (Object)recordId);
            logger.error(stackMsg);
        }
        finally {
            if (!result.getSuccess()) {
                StringBuilder failMsg = new StringBuilder();
                failMsg.append(result.getMessage()).append((CharSequence)failedLog);
                DirectDeclareLogUtils.updateStatus(recordId, "3", failMsg);
            }
        }
        return result;
    }

    private void downLoadApprovedInfosRefresh(SBMessageBaseVo sbMessageBaseVo) {
        ApiResult approvedInfos = ZwyApi.downLoadApprovedInfos(sbMessageBaseVo.getNsrsbh());
        String message = approvedInfos.getMessage();
        if ("1003".equals(approvedInfos.getErrorCode())) {
            return;
        }
        if (!approvedInfos.getSuccess()) {
            throw new KDBizException(message);
        }
        Object data = approvedInfos.getData();
        if (EmptyCheckUtils.isEmpty((Object)data)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u6570\u636e\uff1a%1$s", (String)"KdMessageSendServiceImpl_25", (String)"taxc-tsate-mservice", (Object[])new Object[]{message}));
        }
        Map approvedData = (Map)JSON.parseObject((String)data.toString(), Map.class);
        String sfzhdData = TsateSfzhdxxHelper.doDataCollection(sbMessageBaseVo, approvedData, SupplierEnum.ZWY);
        Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(sfzhdData);
        Map sfzhdMap = (Map)sbbDataRootMap.get("Root");
        if (CollectionUtils.isEmpty((Map)sfzhdMap)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u6362\u540e\u65e0\u6570\u636e", (String)"KdMessageSendServiceImpl_26", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        TsateSfzhdxxHelper.saveAndCompareData(sfzhdMap, sbMessageBaseVo.getOrg(), sbMessageBaseVo.getId());
        DirectDeclareLogUtils.updateStatus(sbMessageBaseVo.getId(), "2", new StringBuilder());
    }

    private void dealSuccessStatus(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) throws Exception {
        if ("directdeclare".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declared", "2", failedLog);
            KdMessageSendServiceImpl.dealYyjk(vo, failedLog);
        } else if ("fastpay".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paid", "2", failedLog);
        } else if ("yyjk".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "yypaid", "2", failedLog);
            DynamicObject declareObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(vo.getBusinessId()), (String)"tcvat_nsrxx");
            KdMessageSendServiceImpl.assembleDeclareRecord(declareObj, "ZLJK");
        } else if ("verify".equals(vo.getName())) {
            ConnectConfigService.updateIdentityData(identityData.getId(), "1");
            DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
        } else if ("sbjt".equals(vo.getName()) || "kkjt".equals(vo.getName()) || "sbbfile".equals(vo.getName())) {
            logger.info("zwy\u622a\u56fe\u7b2c\u4e8c\u6b65,\u72b6\u6001\u622a\u56fe\u6210\u529f\uff0c\u4fdd\u5b58\u9644\u4ef6" + vo.getNsrsbh());
            KdMessageSendServiceImpl.dealAttachment(vo, failedLog);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
        } else {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
        }
    }

    private void dealFailedStatus(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) {
        if ("directdeclare".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
        } else if ("fastpay".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
        } else if ("yyjk".equals(vo.getName())) {
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "yypayfailed", "3", failedLog);
        } else if ("verify".equals(vo.getName())) {
            if (identityData != null) {
                ConnectConfigService.updateIdentityData(identityData.getId(), "2");
            }
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        } else {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
    }

    private static void dealSbProcess(ApiResult result, SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog, boolean isQuery) throws Exception {
        logger.info("zwy\u7533\u62a5\u7b2c\u4e00\u6b65,\u4fdd\u5b58\u62a5\u6587" + vo.getNsrsbh());
        result = KdMessageSendServiceImpl.dealWithData(vo, failedLog);
        if (!result.getSuccess()) {
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
            return;
        }
        logger.info("zwy\u7533\u62a5\u7b2c\u4e8c\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
        result = KdMessageSendServiceImpl.dealGetStatus(vo, "directdeclare");
        logger.info("\u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
        if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
            logger.info("zwy\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
            if (kd.bos.util.StringUtils.isNotEmpty((String)result.getMessage())) {
                failedLog.append(result.getMessage());
            }
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declared", "2", failedLog);
            KdMessageSendServiceImpl.dealYyjk(vo, failedLog);
        } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode()) || StringUtils.equals((String)"1", (String)result.getErrorCode())) {
            logger.info("\u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
            if (isQuery) {
                DynamicObject declare;
                if (StringUtils.equals((String)"3", (String)result.getErrorCode()) || !result.getSuccess()) {
                    logger.info("\u7533\u62a5\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                    result.setErrorCode(ErrorCode.FAIL.getCode());
                    result.setSuccess(false);
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
                } else if (StringUtils.equals((String)"1", (String)result.getErrorCode()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "submitted".equals(declare.getString("declarestatus"))) {
                    KdMessageSendServiceImpl.tryDeclare(result, vo, identityData, failedLog);
                }
            } else {
                logger.info("zwy\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u91cd\u65b0\u7533\u62a5" + vo.getNsrsbh());
                KdMessageSendServiceImpl.tryDeclare(result, vo, identityData, failedLog);
            }
        } else if (StringUtils.equals((String)"5", (String)result.getErrorCode())) {
            logger.info("zwy\u7533\u62a5\u7b2c\u4e09\u6b65,\u6709\u7559\u62b5\u9000\u7a0e\u9009\u9879, \u8bb0\u5f55url" + vo.getNsrsbh());
            ConnectConfigService.dealFkxx(result.getData(), vo.getBusinessId(), true);
        } else if (StringUtils.equals((String)"6", (String)result.getErrorCode())) {
            logger.info("zwy\u7533\u62a5\u7b2c\u4e09\u6b65,\u5df2\u7533\u62a5\u672a\u5bfc\u5165, \u66f4\u65b0\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "importing", "1", failedLog);
        }
    }

    private static void tryDeclare(ApiResult result, SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        result = KdMessageSendServiceImpl.dealDeclare(vo, identityData, failedLog);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declared", "2", failedLog);
                KdMessageSendServiceImpl.dealYyjk(vo, failedLog);
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
            } else if (StringUtils.equals((String)"5", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u56db\u6b65,\u6709\u7559\u62b5\u9000\u7a0e\u9009\u9879, \u8bb0\u5f55url" + vo.getNsrsbh());
                ConnectConfigService.dealFkxx(result.getData(), vo.getBusinessId(), true);
            } else if (StringUtils.equals((String)"6", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u56db\u6b65,\u5df2\u7533\u62a5\u672a\u5bfc\u5165, \u66f4\u65b0\u7533\u62a5\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "importing", "1", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
        }
    }

    private ApiResult tryPay(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog, IdentityData identityData) throws Exception {
        logger.info("zwy\u6263\u6b3e\u7b2c\u4e8c\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u91cd\u65b0\u7f34\u6b3e" + vo.getNsrsbh());
        result = KdMessageSendServiceImpl.dealPay(vo, identityData, failedLog);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u6263\u6b3e\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u65e0\u9700\u6263\u6b3e\u6216\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "paid", "2", failedLog);
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zwy\u6263\u6b3e\u7b2c\u4e09\u6b65,\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25\uff0c\u66f4\u65b0\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s\u7f34\u6b3e\u5931\u8d25\uff1a%2$s", (String)"KdMessageSendServiceImpl_9", (String)"taxc-tsate-mservice", (Object[])new Object[]{vo.getNsrsbh(), result.getMessage()}));
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "paystatus", "payfailed", "3", failedLog);
        }
        return result;
    }

    private ApiResult dealVirifyStatus(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) throws Exception {
        ApiResult result = KdMessageSendServiceImpl.dealVerifyInfo(vo, identityData, failedLog);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u7a0e\u5c40\u9a8c\u8bc1\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u9a8c\u8bc1\u6210\u529f" + vo.getNsrsbh());
                ConnectConfigService.updateIdentityData(identityData.getId(), "1");
                DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zwy\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u9a8c\u8bc1\u5931\u8d25\uff0c\u66f4\u65b0\u9a8c\u8bc1\u72b6\u6001" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                ConnectConfigService.updateIdentityData(identityData.getId(), "2");
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            ConnectConfigService.updateIdentityData(identityData.getId(), "2");
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private static void dealResult(ApiResult result, SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog, boolean isQuery) throws Exception {
        boolean isObtainQCData = ConnectConfigService.isObtainQcData(vo);
        if (!isObtainQCData) {
            result = KdMessageSendServiceImpl.dealGetStatus(vo, "getData");
            if (StringUtils.equals((String)"1", (String)result.getErrorCode()) || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                result = KdMessageSendServiceImpl.dealGetQcData(vo, identityData, failedLog);
                if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("zwy\u83b7\u53d6\u671f\u521d\u72b6\u6001" + vo.getNsrsbh());
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                    ConnectConfigService.updateSignInfo(vo, "2");
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), "declarestatus", "declarefailed", "3", failedLog);
                } else if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    ConnectConfigService.updateSignInfo(vo, "1");
                    KdMessageSendServiceImpl.dealSbProcess(result, vo, identityData, failedLog, isQuery);
                }
            } else if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                ConnectConfigService.updateSignInfo(vo, "1");
                KdMessageSendServiceImpl.dealSbProcess(result, vo, identityData, failedLog, isQuery);
            }
        } else {
            KdMessageSendServiceImpl.dealSbProcess(result, vo, identityData, failedLog, isQuery);
        }
    }

    private static ApiResult dealQyxx(IdentityData identityData, SBMessageBaseVo vo, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.saveQyxx(identityData, vo);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u5904\u7406\u4f01\u4e1a\u4fe1\u606f\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.saveQyxx(identityData, vo);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealVerifyInfo(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.verify(vo, identityData, failedLog);
        ConnectConfigService.updateIdentityData(identityData.getId(), "3");
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u9a8c\u8bc1\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.verify(vo, identityData, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealGetStatus(SBMessageBaseVo vo, String type) throws Exception {
        IdentityData identityData = ConnectConfigService.queryIdentityData(vo);
        ApiResult result = "kkjt".equals(vo.getName()) || "sbjt".equals(vo.getName()) ? KdDirectDeclareService.getQynsxx(vo, null) : (StringUtils.isNotBlank((String)vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE)) ? KdDirectDeclareService.searchResult(vo, identityData) : KdDirectDeclareService.queryTaskStatus(vo, type));
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u83b7\u53d6\u72b6\u6001\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = "kkjt".equals(vo.getName()) || "sbjt".equals(vo.getName()) ? KdDirectDeclareService.getQynsxx(vo, null) : (StringUtils.isNotBlank((String)vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE)) ? KdDirectDeclareService.searchResult(vo, identityData) : KdDirectDeclareService.queryTaskStatus(vo, type));
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealGetQcData(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.getQcData(vo, identityData, failedLog);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u83b7\u53d6\u671f\u521d\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.getQcData(vo, identityData, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealWithData(SBMessageBaseVo vo, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.withData(vo, failedLog);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u63d0\u4ea4\u7533\u62a5\u6570\u636e\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.withData(vo, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealDeclare(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.declare(vo, identityData, failedLog);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u7533\u62a5\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.declare(vo, identityData, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealPay(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.pay(vo, identityData, failedLog);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u7f34\u6b3e\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.pay(vo, identityData, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealScreenShot(SBMessageBaseVo vo, IdentityData identityData, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.screenShot(vo, identityData, failedLog, vo.getScreenshotType());
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u622a\u56fe\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.screenShot(vo, identityData, failedLog, vo.getScreenshotType());
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private ApiResult dealHistory(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) throws Exception {
        ApiResult result = KdMessageSendServiceImpl.dealHistoryDataTask(vo, identityData);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zwy\u4e0b\u8f7d\u5386\u53f2\u6570\u636e\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u6210\u529f" + vo.getNsrsbh());
                Object data = result.getData();
                if (data != null) {
                    Map historyData = (Map)data;
                    this.dealHistoryData(vo, (Map)JsonUtil.fromJson((String)((String)historyData.get("taxData")), Map.class), failedLog);
                }
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zwy\u4e0b\u8f7d\u5386\u53f2\u6570\u636e\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private ApiResult dealDownloadStatus(SBMessageBaseVo vo, StringBuilder failedLog, IdentityData identityData) throws Exception {
        ApiResult result = KdMessageSendServiceImpl.dealDownloadTask(vo, identityData);
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("zw\u622a\u56fe\u7b2c\u4e09\u6b65,\u622a\u56fe\u72b6\u6001\u72b6\u6001\u4e3a\u622a\u56fe\u6210\u529f" + vo.getNsrsbh());
                result = KdMessageSendServiceImpl.dealAttachment(vo, failedLog);
            } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("zw\u622a\u56fe\u7b2c\u4e09\u6b65,\u622a\u56fe\u72b6\u6001\u72b6\u6001\u4e3a\u622a\u56fe\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    private static ApiResult dealDownloadTask(SBMessageBaseVo vo, IdentityData identityData) throws Exception {
        Class<?> clazz = Class.forName("kd.taxc.tsate.msmessage.service.KdDirectDeclareService");
        Constructor<?> constructor = clazz.getConstructor(new Class[0]);
        Object newInstance = constructor.newInstance(new Object[0]);
        Method method = clazz.getMethod(KdDownloadTypeEnum.getMethodNameByType(vo.getString(SbpzMessageVo.Key.VOUCHER_TYPE)), SBMessageBaseVo.class, IdentityData.class);
        ApiResult result = (ApiResult)method.invoke(newInstance, vo, identityData);
        if (!result.getSuccess()) {
            result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
        }
        return result;
    }

    private void dealHistoryData(SBMessageBaseVo vo, Map<String, Object> map, StringBuilder failedLog) throws MessageException {
        try {
            List zwyNsrxxMap;
            ExecuteTypeEnums executeType = ExecuteTypeEnums.valuesOfKey((String)vo.getName());
            String declareDataType = ExecuteTypeEnums.QCXZ == executeType ? "0" : "1";
            MessageSend send = new MessageSend();
            if ("0".equals(declareDataType)) {
                send.setMsgtype(ExecuteTypeEnums.QCXZ.getKey());
            } else {
                send.setMsgtype("history");
            }
            send.setBusinessid(vo.getBusinessId());
            send.setBusinesstype(vo.getType());
            send.setNsrType(vo.getType());
            send.setNodetype(vo.getSbdq());
            send.setSupplier(SupplierEnum.ZWY.getName());
            HistoryDataAdditionFactory.get(vo.getType()).forEach(handler -> handler.handle(Long.parseLong(vo.getOrg()), vo.getSkssqq(), vo.getSkssqz(), vo.getNsrsbh(), map));
            String historyData = MessageService.collectionHistoryData(send, map, vo.getNsrsbh());
            TsateDeclareRecordBusiness.appendDetailLog((Long)vo.getId(), (String)historyData);
            Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(historyData);
            Map sbbDataMap = (Map)sbbDataRootMap.get("Root");
            Map objectMap = HistoryDataUtils.embeded2Plate((Map)sbbDataMap, (String)"#");
            QFilter dateFilter = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqq()))).and(new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)DateUtils.format((Date)vo.getSkssqz()))));
            QFilter typeFilter = new QFilter("type", "=", (Object)vo.getType());
            QFilter orgFilter = new QFilter("org", "=", (Object)Long.parseLong(vo.getOrg()));
            Map nsrxxMap = TemplateUtils.dataToMap((String)"tcvat_nsrxx", (String)"#", (QFilter[])new QFilter[]{dateFilter, typeFilter, orgFilter});
            if (nsrxxMap == null || nsrxxMap.size() == 0) {
                nsrxxMap = CommonUtils.createYbnsr((String)String.valueOf(DB.genLongId((String)"tcvat_nsrxx")), (String)vo.getType(), (String)vo.getOrg(), (String)DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"), (String)DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"), (boolean)true, new HashMap(), null);
            }
            objectMap.putAll(nsrxxMap);
            TemplateUtils.dealData((String)"#", (Map)objectMap);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            if (map.containsKey("tcvat_nsrxx") && map.get("tcvat_nsrxx") != null && !CollectionUtils.isEmpty((Collection)(zwyNsrxxMap = (List)map.get("tcvat_nsrxx")))) {
                HashMap extendParam = new HashMap();
                extendParam.put("sbrq", ((Map)zwyNsrxxMap.get(0)).get("sbrq"));
                extendParam.put("bqybtse", EmptyCheckUtils.isNotEmpty(((Map)zwyNsrxxMap.get(0)).get("taxAmount")) ? ((Map)zwyNsrxxMap.get(0)).get("taxAmount") : "0.00");
                paramMap.put("extendParams", extendParam);
            }
            paramMap.put("orgId", vo.getOrg());
            paramMap.put("templateType", vo.getType());
            paramMap.put("skssqq", DateUtils.format((Date)vo.getSkssqq(), (String)"yyyy-MM-dd"));
            paramMap.put("skssqz", DateUtils.format((Date)vo.getSkssqz(), (String)"yyyy-MM-dd"));
            HashMap<String, String> businessMap = new HashMap<String, String>(8);
            businessMap.put("declaredatatype", declareDataType);
            paramMap.put("businessMap", businessMap);
            try {
                StringBuilder reqInfo = new StringBuilder(ResManager.loadKDString((String)"\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\uff1aparam:%1$s;object:%2$s", (String)"KdMessageSendServiceImpl_27", (String)"taxc-tsate-mservice", (Object[])new Object[]{SerializationUtils.toJsonString(paramMap), JSON.toJSONString((Object)objectMap)}));
                DirectDeclareLogUtils.dealDetailLog(reqInfo, vo.getId());
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u670d\u52a1\u8bf7\u6c42\u53c2\u6570\u5931\u8d25");
                logger.error(ExceptionUtil.toString((Exception)e));
            }
            objectMap.remove("tcvat_nsrxx#1#attachment");
            String resonse = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"TaxBureauDeclareService", (String)"saveData", (Object[])new Object[]{SerializationUtils.toJsonString(paramMap), objectMap});
            if (EmptyCheckUtils.isNotEmpty((Object)resonse)) {
                RequestResult result = (RequestResult)SerializationUtils.fromJsonString((String)resonse, RequestResult.class);
                if (result.getSuccess()) {
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                    HistoryDeclarationHandlerFactory.get((String)vo.getType()).forEach(hanlder -> hanlder.post(paramMap, objectMap));
                } else {
                    failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5386\u53f2\u6570\u636e\u4fdd\u5b58\u5931\u8d25", (String)"KdMessageSendServiceImpl_16", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                }
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.toString((Exception)e));
            failedLog.append(ResManager.loadKDString((String)"\u6570\u636e\u5f02\u5e38", (String)"KdMessageSendServiceImpl_28", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
    }

    private static ApiResult dealHistoryDataTask(SBMessageBaseVo vo, IdentityData identityData) throws Exception {
        ApiResult result = KdDirectDeclareService.obtainHistory(vo, identityData);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u622a\u56fe\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.obtainHistory(vo, identityData);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static ApiResult dealGetQyxx(SBMessageBaseVo vo, StringBuilder failedLog) throws Exception {
        ApiResult result = KdDirectDeclareService.getQynsxx(vo, failedLog);
        if (!result.getSuccess()) {
            if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                logger.info("\u622a\u56fe\u91cd\u8bd5\u4efb\u52a1\u5df2\u4e0b\u53d1+" + result.getErrorCode() + "\u91cd\u8bd5\u5f00\u59cb");
                boolean isCompleted = false;
                int count = 0;
                do {
                    ++count;
                    result = KdDirectDeclareService.getQynsxx(vo, failedLog);
                    if (StringUtils.equals((String)"001", (String)result.getErrorCode())) continue;
                    isCompleted = true;
                } while (!isCompleted && count <= 3);
                if (StringUtils.equals((String)"001", (String)result.getErrorCode())) {
                    result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
                }
            } else {
                result = CustomApiResult.dealResponse(null, result.getMessage(), "3", false);
            }
        }
        return result;
    }

    private static void dealYyjk(SBMessageBaseVo vo, StringBuilder failedLog) throws Exception {
        String payType;
        DynamicObject declareObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(vo.getBusinessId()), (String)"tcvat_nsrxx");
        if (declareObj != null && "2".equals(payType = declareObj.getString("paytype"))) {
            DynamicObject[] records = KdMessageSendServiceImpl.assembleDeclareRecord(declareObj, "YYJK");
            ApiResult result = KdMessageSendServiceImpl.dealGetStatus(vo, "yyjk");
            if (result.getSuccess()) {
                if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("zwy\u9884\u7ea6\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u7f34\u6b3e\u72b6\u6001\u4e3a\u9884\u7ea6\u6210\u529f" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), records[0].getLong("id"), "paystatus", "yypaid", "2", failedLog);
                } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("zwy\u9884\u7ea6\u6263\u6b3e\u5931\u8d25\uff0c\u66f4\u65b0\u7f34\u6b3e\u72b6\u6001\u4e3a\u9884\u7ea6\u5931\u8d25" + vo.getNsrsbh());
                    failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), records[0].getLong("id"), "paystatus", "yypayfailed", "3", failedLog);
                }
            } else {
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setSuccess(false);
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), records[0].getLong("id"), "paystatus", "yypayfailed", "3", failedLog);
            }
        }
    }

    private static DynamicObject[] assembleDeclareRecord(DynamicObject declare, String executeType) {
        DynamicObject channelObj;
        QFilter qFilter = new QFilter("sbbid", "=", (Object)declare.getString("id")).and(new QFilter("tasktype.number", "=", (Object)executeType)).and(new QFilter("executestatus", "=", (Object)"1"));
        DynamicObject[] recordObjs = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{qFilter});
        if (recordObjs != null && recordObjs.length > 0) {
            return recordObjs;
        }
        DynamicObject recordObj = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        DynamicObject org = declare.getDynamicObject("org");
        recordObj.set("org", (Object)org.getLong("id"));
        recordObj.set("skssqq", (Object)declare.getDate("skssqq"));
        recordObj.set("createtime", (Object)new Date());
        recordObj.set("creator", (Object)RequestContext.get().getUserId());
        recordObj.set("executestatus", (Object)"1");
        recordObj.set("skssqz", (Object)declare.getDate("skssqz"));
        recordObj.set("type", (Object)declare.getString("type"));
        recordObj.set("billstatus", (Object)"C");
        recordObj.set("sbbid", (Object)declare.getString("id"));
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)executeType)});
        if (taskObj != null) {
            recordObj.set("executetype", (Object)executeType);
            recordObj.set("tasktype", (Object)taskObj.getLong("id"));
        }
        if ((channelObj = CommonInfoUtil.getChannel((Long)declare.getLong("id"))) != null) {
            recordObj.set("channel", (Object)channelObj.getDynamicObject("declarechannel").getString("number"));
            recordObj.set("declarechannel", (Object)channelObj.getDynamicObject("declarechannel").getLong("id"));
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        recordObj = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", recordObj, null);
        String number = codeRuleService.readNumber("tsate_declare_record", recordObj, null);
        recordObj.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
    }

    private static String dealWithGatewayUrl(String urlStr) {
        try {
            QFilter filter = new QFilter("key", "=", (Object)"zwy_gateway_url");
            DynamicObject obj = QueryServiceHelper.queryOne((String)"tsate_param_setting", (String)"key,value", (QFilter[])new QFilter[]{filter});
            if (obj == null || obj.getString("value") == null) {
                return urlStr;
            }
            String gatewayUrl = obj.getString("value");
            if (kd.bos.util.StringUtils.isEmpty((String)gatewayUrl)) {
                return urlStr;
            }
            URL originUrl = new URL(urlStr);
            if (gatewayUrl.endsWith("/")) {
                gatewayUrl = gatewayUrl.substring(0, gatewayUrl.length() - 1);
            }
            int subIndex = urlStr.indexOf(originUrl.getPath());
            String targetUrl = gatewayUrl + urlStr.substring(subIndex);
            logger.info("\u5df2\u53d8\u66f4\u4e3a\u7f51\u5173URL" + targetUrl);
            return targetUrl;
        }
        catch (MalformedURLException e) {
            logger.error(urlStr + " \u8f6c\u6362url\u5f02\u5e38");
            return urlStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePzFile(SBMessageBaseVo vo, byte[] datas) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        String name = ((DynamicObject)org.get("org")).getString("name");
        String suffixName = vo.getPzTypeName() + ".zip";
        StringBuilder logDetail = new StringBuilder();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(datas);
            SbpzRecordSaveUtils.saveRecord(vo, in, name, suffixName, logDetail);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38");
                }
            }
        }
    }

    private ApiResult refreshVoucher(SBMessageBaseVo vo, IdentityData identityData) {
        ApiResult result = KdDirectDeclareService.searchResult(vo, identityData);
        StringBuilder failedLog = new StringBuilder();
        logger.info("\u4e0b\u8f7d\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
        if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
            logger.info("\u4e0b\u8f7d\u5931\u8d25" + JsonUtil.toJson((Object)result));
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"KdMessageSendServiceImpl_11", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        } else if (result.getSuccess() && StringUtils.equals((String)"4", (String)result.getErrorCode())) {
            logger.info("\u4e0b\u8f7d\u6210\u529f-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
            logger.info("zwy\u4e0b\u8f7d\u7b2c\u4e8c\u6b65,\u7a0e\u8868\u4e0b\u8f7d\u6210\u529f\uff0c\u4fdd\u5b58\u9644\u4ef6" + vo.getNsrsbh());
            result = KdMessageSendServiceImpl.dealAttachment(vo, failedLog);
        } else if (StringUtils.equals((String)"2", (String)result.getErrorCode())) {
            logger.info("\u4e0b\u8f7d\u8fdb\u884c\u4e2d-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
        }
        return result;
    }
}

