/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.enums.tpo.ModelVersionEnum;
import kd.taxc.tsate.business.TsateChannelBusiness;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.msmessage.collection.BaseCollection;
import kd.taxc.tsate.msmessage.collection.BaseHistoryCollection;
import kd.taxc.tsate.msmessage.constant.MessageConstant;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.out.BaseOutAdapter;
import kd.taxc.tsate.msmessage.util.VmTemplateUtils;
import org.apache.commons.io.FilenameUtils;

public class MessageService {
    private static final Integer DEAL_TIMES = 3;
    private static Log logger = LogFactory.getLog(MessageService.class);

    public static String collection(MessageSend messageSend, String nsrsbh) throws MessageException {
        String template = MessageService.getTemplatePath(messageSend, nsrsbh);
        String collClassName = MessageConstant.getCollection(messageSend.getMsgtype(), messageSend.getBusinesstype());
        if (collClassName == null) {
            throw new MessageException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u91c7\u96c6\u5904\u7406\u7c7b", (String)"MessageService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        BaseCollection collection = null;
        try {
            collection = (BaseCollection)Class.forName(collClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u91c7\u96c6\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%s", (String)"MessageService_4", (String)"taxc-tsate-mservice", (Object[])new Object[]{collClassName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        Map<Object, Object> map = collection.doBusiness(messageSend);
        map.put("tcvat_nsrxx_1_sbcreatetime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        return VmTemplateUtils.generateFromTemplate(template, map);
    }

    public static Map<Object, Object> collectionWithoutTemplate(MessageSend messageSend, String nsrsbh) throws MessageException {
        String collClassName = MessageConstant.getCollection(messageSend.getMsgtype(), messageSend.getBusinesstype());
        if (collClassName == null) {
            throw new MessageException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u91c7\u96c6\u5904\u7406\u7c7b", (String)"MessageService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        BaseCollection collection = null;
        try {
            collection = (BaseCollection)Class.forName(collClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u91c7\u96c6\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%s", (String)"MessageService_4", (String)"taxc-tsate-mservice", (Object[])new Object[]{collClassName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        Map<Object, Object> map = collection.doBusiness(messageSend);
        map.put("tcvat_nsrxx_1_sbcreatetime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        return map;
    }

    public static String collectionData(MessageSend messageSend, String djxh, String nsrsbh) throws MessageException {
        BaseCollection collection;
        String template = MessageService.getTemplatePath(messageSend, nsrsbh);
        String collClassName = MessageConstant.getCollection(messageSend.getMsgtype(), messageSend.getBusinesstype());
        if (ModelVersionEnum.MODEL3.getVersion().equals(messageSend.getVersion())) {
            collClassName = MessageConstant.getCollectionForModel(messageSend);
        }
        if (collClassName == null) {
            throw new MessageException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u91c7\u96c6\u5904\u7406\u7c7b", (String)"MessageService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        try {
            collection = (BaseCollection)Class.forName(collClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u91c7\u96c6\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%s", (String)"MessageService_4", (String)"taxc-tsate-mservice", (Object[])new Object[]{collClassName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        Map<Object, Object> map = collection.doBusiness(messageSend);
        map.put("tcvat_nsrxx_1_djxh", djxh);
        map.put("tcvat_nsrxx_1_sbcreatetime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        String content = VmTemplateUtils.generateFromTemplate(template, map);
        logger.info("vm\u62a5\u6587\u65e5\u5fd7\uff1a" + content);
        return content;
    }

    public static String collectionData(MessageSend messageSend, Map<String, String> otherMap, String djxh, String nsrsbh) throws MessageException {
        String template = MessageService.getTemplatePath(messageSend, nsrsbh);
        String collClassName = MessageConstant.getCollection(messageSend.getMsgtype(), messageSend.getBusinesstype());
        if (collClassName == null) {
            throw new MessageException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u91c7\u96c6\u5904\u7406\u7c7b", (String)"MessageService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        BaseCollection collection = null;
        try {
            collection = (BaseCollection)Class.forName(collClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u91c7\u96c6\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%s", (String)"MessageService_4", (String)"taxc-tsate-mservice", (Object[])new Object[]{collClassName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        Map<Object, Object> map = collection.doBusiness(messageSend);
        map.put("tcvat_nsrxx_1_djxh", djxh);
        map.put("tcvat_nsrxx_1_sbcreatetime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd"));
        map.putAll(otherMap);
        String content = VmTemplateUtils.generateFromTemplate(template, map);
        return content;
    }

    public static void send(MessageSend send, String nsrsbh) throws MessageException {
        send.setErrormsg("success");
        int dealTimes = send.getDealtimes() == null ? 0 : send.getDealtimes();
        send.setDealtimes(dealTimes + 1);
        send.setReqcontent(MessageService.collection(send, nsrsbh));
        String outAdapterName = MessageConstant.getOutAdapter(send.getNodetype(), send.getMsgtype());
        BaseOutAdapter outAdapter = null;
        try {
            outAdapter = (BaseOutAdapter)Class.forName(outAdapterName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u53d1\u9001\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%2$s", (String)"MessageService_3", (String)"taxc-tsate-mservice", (Object[])new Object[]{outAdapterName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        if (outAdapter != null) {
            outAdapter.send(send);
        }
        if ("success".equals(send.getErrormsg())) {
            send.setStatus("success");
        } else if (send.getDealtimes() >= DEAL_TIMES) {
            send.setStatus("fail");
        }
    }

    public static String collectionPayData(MessageSend messageSend, String requestId, String nsrsbh, BigDecimal ybtse) throws MessageException {
        String template = MessageService.getTemplatePath(messageSend, nsrsbh);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sblsh", requestId);
        map.put("amount", ybtse);
        String content = VmTemplateUtils.generateFromTemplate(template, map);
        return content;
    }

    public static String collectionHistoryData(MessageSend messageSend, Map<String, Object> map, String nsrsbh) throws MessageException {
        BaseHistoryCollection collection;
        String template = MessageService.getTemplatePathForHistory(messageSend, nsrsbh);
        String collClassName = MessageConstant.getCollection(messageSend.getMsgtype(), messageSend.getBusinesstype(), messageSend.getSupplier());
        if (collClassName == null) {
            throw new MessageException(ResManager.loadKDString((String)"\u672a\u914d\u7f6e\u91c7\u96c6\u5904\u7406\u7c7b", (String)"MessageService_0", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
        }
        try {
            collection = (BaseHistoryCollection)Class.forName(collClassName).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new MessageException(ResManager.loadKDString((String)"\u91c7\u96c6\u5904\u7406\u7c7b[%1$s]\u5b9e\u4f8b\u5316\u5931\u8d25\u3002%2$s", (String)"MessageService_2", (String)"taxc-tsate-mservice", (Object[])new Object[]{collClassName, e.getClass().getSimpleName()}), (Throwable)e);
        }
        collection.doBusiness(map);
        String content = VmTemplateUtils.generateFromTemplate(template, map);
        return content;
    }

    private static String getTemplatePath(MessageSend messageSend, String nsrsbh) {
        DynamicObject areaObj;
        String template = "";
        if (!MessageService.isEmpty(messageSend.getMsgtype())) {
            template = template + messageSend.getMsgtype();
        }
        if (!MessageService.isEmpty(messageSend.getBusinesstype())) {
            if (!MessageService.isEmpty(template)) {
                template = template + "/";
            }
            template = template + messageSend.getBusinesstype();
        }
        if (!MessageService.isEmpty(messageSend.getSubBusinesstype())) {
            if (!MessageService.isEmpty(template)) {
                template = template + "-";
            }
            template = template + messageSend.getSubBusinesstype();
        }
        if ((areaObj = TsateChannelBusiness.getAreaInfo((Long)Long.valueOf(messageSend.getBusinessid()))) == null) {
            return null;
        }
        String templatePath = "message/" + messageSend.getSupplier() + "/" + template + ".vm";
        if (areaObj.getBoolean("isspecial")) {
            templatePath = "message/" + messageSend.getSupplier() + "/" + areaObj.getString("xzqh") + "/" + template + ".vm";
            try (InputStream inStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(FilenameUtils.normalize((String)templatePath));){
                if (inStream == null) {
                    templatePath = "message/" + messageSend.getSupplier() + "/" + template + ".vm";
                }
            }
            catch (Exception e) {
                throw new KDBizException("getTemplatePath getFile fail" + e.getMessage());
            }
        }
        return templatePath;
    }

    private static String getTemplatePathForHistory(MessageSend messageSend, String nsrsbh) {
        String template = "";
        if (!MessageService.isEmpty(messageSend.getMsgtype())) {
            template = template + messageSend.getMsgtype();
        }
        if (!MessageService.isEmpty(messageSend.getBusinesstype())) {
            if (!MessageService.isEmpty(template)) {
                template = template + "/";
            }
            template = template + messageSend.getBusinesstype();
        }
        String templatePath = "message/" + messageSend.getSupplier() + "/" + template + ".vm";
        return templatePath;
    }

    public static boolean isEmpty(String str) {
        if (str == null) {
            return true;
        }
        return "".equals(str.trim());
    }
}

