/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.tsate.msmessage.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.tsate.business.TsateDeclareQueryListBusiness;
import kd.taxc.tsate.business.TsateRequestInfoBusiness;
import kd.taxc.tsate.common.constant.RequestResult;
import kd.taxc.tsate.common.constant.SupplierEnum;
import kd.taxc.tsate.common.enums.RequestTypeEnum;
import kd.taxc.tsate.common.metadata.MetadataUtil;
import kd.taxc.tsate.common.util.CommonInfoUtil;
import kd.taxc.tsate.common.util.DateUtils;
import kd.taxc.tsate.common.util.EmptyCheckUtils;
import kd.taxc.tsate.common.util.ExceptionUtil;
import kd.taxc.tsate.common.util.JsonUtil;
import kd.taxc.tsate.msmessage.config.ConnectConfigService;
import kd.taxc.tsate.msmessage.constant.ErrorCode;
import kd.taxc.tsate.msmessage.domain.CustomApiResult;
import kd.taxc.tsate.msmessage.domain.MessageSend;
import kd.taxc.tsate.msmessage.domain.SBMessageBaseVo;
import kd.taxc.tsate.msmessage.domain.SbpzMessageVo;
import kd.taxc.tsate.msmessage.domain.SbsxxzMessageVo;
import kd.taxc.tsate.msmessage.exception.MessageException;
import kd.taxc.tsate.msmessage.service.CloudccDirectDeclareService;
import kd.taxc.tsate.msmessage.service.MessageSendService;
import kd.taxc.tsate.msmessage.service.MessageService;
import kd.taxc.tsate.msmessage.service.sbsxxz.SbsxxzHandlerStrategy;
import kd.taxc.tsate.msmessage.service.sbsxxz.SbsxxzStrategyFactory;
import kd.taxc.tsate.msmessage.service.szyh.api.SzyhApi;
import kd.taxc.tsate.msmessage.service.szyh.helper.TaxTypeTranslateHelper;
import kd.taxc.tsate.msmessage.util.DirectDeclareLogUtils;
import kd.taxc.tsate.msmessage.util.SbpzRecordSaveUtils;
import kd.taxc.tsate.msxml.util.XmlTJsonUtil;
import org.apache.commons.lang.StringUtils;

public class SzyhMessageSendServiceImpl
implements MessageSendService {
    public static final String DECLARESTATUS = "declarestatus";
    public static final String DECLARE_TYPE = "declare";
    public static final String PAYSTATUS = "paystatus";
    public static final String PAY_TYPE = "pay";
    private static Log logger = LogFactory.getLog(SzyhMessageSendServiceImpl.class);

    @Override
    public ApiResult sendMessage(SBMessageBaseVo vo) {
        ApiResult result;
        block13: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            try {
                Boolean isQuery = vo.getQuery();
                logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
                logger.info("szyh\u7533\u62a5\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
                DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    result = CloudccDirectDeclareService.queryTaskStatusByFileNo(vo, requestId, "directdeclare");
                    logger.info("szyh \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                    if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                        logger.info("szyh\u7533\u62a5\u7b2c\u4e09\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                        this.dealPayTask(vo);
                    } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                        logger.info("szyh \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                        logger.info("szyh \u7533\u62a5\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                        result.setErrorCode(ErrorCode.FAIL.getCode());
                        result.setSuccess(false);
                        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    } else if (StringUtils.equals((String)"1", (String)result.getErrorCode())) {
                        logger.info("szyh \u7533\u62a5\u91cd\u65b0\u63d0\u4ea4" + vo.getNsrsbh());
                        result = this.tryDeclare(vo, failedLog);
                    }
                } else if (isQuery.booleanValue()) {
                    DynamicObject declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx");
                    if (declare != null && "declaring".equals(declare.getString(DECLARESTATUS))) {
                        logger.info("szyh\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u7ee7\u7eed\u7533\u62a5" + vo.getNsrsbh());
                        Long minutes = Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes();
                        if (minutes > 5L) {
                            result = this.tryDeclare(vo, failedLog);
                        }
                    }
                } else {
                    result = this.tryDeclare(vo, failedLog);
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + ExceptionUtil.toString((Exception)e));
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
                if (requestObj == null) break block13;
                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    private ApiResult tryDeclare(SBMessageBaseVo vo, StringBuilder failedLog) {
        ApiResult result = CloudccDirectDeclareService.submit(vo);
        DynamicObject dynamicObject = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
        if (result.getSuccess()) {
            if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                logger.info("szyh\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5" + vo.getNsrsbh());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                }
                this.dealPayTask(vo);
            } else if (StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                logger.info("szyh\u7533\u62a5\u7b2c\u56db\u6b65,\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25\uff0c\u66f4\u65b0\u7533\u62a5\u72b6\u6001\u4e3a\u7533\u62a5\u5931\u8d25" + vo.getNsrsbh());
                failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                if (dynamicObject != null) {
                    ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                }
            }
        } else {
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setSuccess(false);
            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
            if (dynamicObject != null) {
                ConnectConfigService.updateStatusInfo(dynamicObject.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    @Override
    public ApiResult paymentRequest(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            logger.info("szyh\u6263\u6b3e\u7b2c\u4e00\u6b65,\u67e5\u8be2\u72b6\u6001" + vo.getNsrsbh());
            Boolean isQuery = vo.getQuery();
            logger.info("\u662f\u5426\u4ec5\u67e5\u8be2" + isQuery);
            DynamicObject requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"2");
            if (requestObj != null) {
                String requestId = requestObj.getString("requestid");
                result = CloudccDirectDeclareService.queryTaskStatusByFileNo(vo, requestId, "fastpay");
                logger.info("\u6263\u6b3e\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                    logger.info("szyh \u6263\u6b3e\u7b2c\u4e8c\u6b65,\u72b6\u6001\u4e3a\u6263\u6b3e\u6210\u529f\uff0c\u66f4\u65b0\u6263\u6b3e\u72b6\u6001" + vo.getNsrsbh());
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                    TsateDeclareQueryListBusiness.updateDeclarePayerByDeclarer((String)vo.getBusinessId());
                } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                    logger.info("\u7f34\u6b3e\u5931\u8d25" + JsonUtil.toJson((Object)result));
                    logger.info("\u7f34\u6b3e\u5931\u8d25-\u4ec5\u67e5\u8be2" + JsonUtil.toJson((Object)result));
                    result.setErrorCode(ErrorCode.FAIL.getCode());
                    result.setSuccess(false);
                    String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s, \u7f34\u6b3e\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_8", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), result.getMessage());
                    failedLog.append(msg);
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
                }
            } else {
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s\u65e0\u7533\u62a5\u8bb0\u5f55\u3002", (String)"SzyhMessageSendServiceImpl_2", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh());
                failedLog.append(msg);
                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
            }
        }
        catch (Exception e) {
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "payfailed", "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult verify(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            failedLog.append(ResManager.loadKDString((String)"\u5f53\u524d\u6682\u4e0d\u652f\u6301\u9a8c\u8bc1", (String)"SzyhMessageSendServiceImpl_5", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult screenshot(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            failedLog.append(ResManager.loadKDString((String)"\u5f53\u524d\u6682\u4e0d\u652f\u6301\u622a\u56fe", (String)"SzyhMessageSendServiceImpl_6", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
            result.setErrorCode(ErrorCode.FAIL.getCode());
            result.setMessage(message);
            failedLog.append(message);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        }
        return result;
    }

    @Override
    public ApiResult downloadVoucher(SBMessageBaseVo vo) {
        logger.info("szyh\u5f00\u59cb\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1" + vo.getNsrsbh());
        StringBuilder logDetail = new StringBuilder();
        String businessType = "DECLARE_INFORMATION";
        String orgTaxNum = vo.getNsrsbh();
        Date sbqj = vo.getDate(SbpzMessageVo.Key.SBQJ);
        String declareDate = DateUtils.formatMonth((Date)sbqj);
        String kdTaxType = vo.getString(SbpzMessageVo.Key.TAXTYPE);
        List<String> yhTaxTypeList = TaxTypeTranslateHelper.kdTaxTypeToSzyh(kdTaxType, Long.parseLong(vo.getOrg()));
        if (yhTaxTypeList.size() == 0) {
            String notFindMsg = TaxTypeTranslateHelper.getTaxTypeNotFindMessage(kdTaxType);
            logDetail.append(notFindMsg);
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", logDetail);
            logger.info("szyh\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u5931\u8d25\uff0c\u672a\u627e\u5230\u5339\u914d\u7a0e\u79cd\u7f16\u7801");
        }
        boolean existFile = false;
        logger.warn("szyh \u5f00\u59cb\u5faa\u73af\u7a0e\u79cd\u5217\u8868\u4e0b\u8f7d\u51ed\u8bc1" + vo.getNsrsbh() + " \u7a0e\u79cd\uff1a" + JSON.toJSONString(yhTaxTypeList));
        for (String yhType : yhTaxTypeList) {
            ApiResult result = SzyhApi.declareFileQuery(businessType, orgTaxNum, declareDate, yhType);
            if (!result.getSuccess()) {
                logger.warn("szyh\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u5931\u8d25" + vo.getNsrsbh() + " \u7a0e\u79cd\uff1a" + yhType);
                logDetail.append(ResManager.loadKDString((String)"\u7a0e\u79cd-", (String)"SzyhMessageSendServiceImpl_19", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(yhType).append(ResManager.loadKDString((String)"\u51ed\u8bc1\u4e0b\u8f7d\u5931\u8d25\uff1a", (String)"SzyhMessageSendServiceImpl_20", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(result.getMessage()).append("\uff1b");
                continue;
            }
            existFile = true;
            logger.info("szyh\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u6210\u529f" + vo.getNsrsbh());
            DirectDeclareLogUtils.updateStatus(vo.getId(), "2", logDetail);
            byte[] data = (byte[])result.getData();
            this.savePzFile(vo, data);
            break;
        }
        if (!existFile) {
            DirectDeclareLogUtils.updateStatus(vo.getId(), "3", logDetail);
            logger.info("szyh\u4e0b\u8f7d\u5b8c\u7a0e\u51ed\u8bc1\u7ed3\u675f\uff0c\u4f46\u672a\u4e0b\u8f7d\u5230\u6587\u4ef6");
        }
        return ApiResult.success(null);
    }

    @Override
    public ApiResult refresh(SBMessageBaseVo vo) {
        ApiResult result;
        block29: {
            result = new ApiResult();
            StringBuilder failedLog = new StringBuilder();
            DynamicObject requestObj = null;
            if ("directdeclare".equals(vo.getName())) {
                requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"1");
            } else if ("fastpay".equals(vo.getName())) {
                requestObj = TsateRequestInfoBusiness.getSzyhRequestBySbbIdAndStatus((String)vo.getBusinessId(), (String)"2");
            } else if ("sfzhdxx".equals(vo.getName())) {
                requestObj = ConnectConfigService.getRequestIdByRequestType(vo.getNsrsbh(), "1", RequestTypeEnum.VERIFICATION);
            }
            try {
                DynamicObject declare;
                if (requestObj != null) {
                    String requestId = requestObj.getString("requestid");
                    if ("directdeclare".equals(vo.getName()) || "fastpay".equals(vo.getName())) {
                        result = CloudccDirectDeclareService.queryTaskStatusByFileNo(vo, requestId, vo.getName());
                        if (kd.bos.util.StringUtils.isNotEmpty((String)result.getMessage())) {
                            failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
                        }
                        logger.info("szyh \u7533\u62a5\u72b6\u6001\u8fd4\u56de" + JsonUtil.toJson((Object)result));
                        if (StringUtils.equals((String)"4", (String)result.getErrorCode())) {
                            if ("directdeclare".equals(vo.getName())) {
                                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declared", "2", failedLog);
                                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                                this.dealPayTask(vo);
                            } else if ("fastpay".equals(vo.getName())) {
                                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), PAYSTATUS, "paid", "2", failedLog);
                                DirectDeclareLogUtils.uploadLogById(new StringBuilder(ResManager.loadKDString((String)"\u7f34\u6b3e\u6210\u529f", (String)"GxsjDeclareService_23", (String)"taxc-tsate-mservice", (Object[])new Object[0])), vo.getId());
                                TsateDeclareQueryListBusiness.updateDeclarePayerByDeclarer((String)vo.getBusinessId());
                            }
                        } else if (!result.getSuccess() || StringUtils.equals((String)"3", (String)result.getErrorCode())) {
                            logger.info("szyh \u7533\u62a5\u5931\u8d25" + JsonUtil.toJson((Object)result));
                            result.setErrorCode(ErrorCode.FAIL.getCode());
                            result.setSuccess(false);
                            if ("directdeclare".equals(vo.getName())) {
                                DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                            } else if ("fastpay".equals(vo.getName())) {
                                failedLog = new StringBuilder(ResManager.loadKDString((String)"\u7f34\u6b3e\u5931\u8d25\u8bf7\u4e1a\u52a1\u4eba\u5458\u5230\u4e91\u5408\u5e73\u53f0\u5e72\u9884\u3002", (String)"SzyhMessageSendServiceImpl_22", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append((CharSequence)failedLog);
                                DirectDeclareLogUtils.uploadLogById(failedLog, vo.getId());
                            }
                        }
                        break block29;
                    }
                    if (!"sfzhdxx".equals(vo.getName())) break block29;
                    Map requestMap = (Map)JsonUtil.fromJson((String)requestId, Map.class);
                    result = CloudccDirectDeclareService.queryVerification(vo, requestMap);
                    if (result.getSuccess()) {
                        if (!"4".equals(result.getErrorCode())) break block29;
                        logger.info("szyh\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u6210\u529f" + vo.getNsrsbh());
                        Object data = result.getData();
                        if (data == null) break block29;
                        Map dataMap = (Map)data;
                        result = this.dealVerificationData(vo, dataMap, failedLog, requestObj.getLong("id"));
                        if (result.getSuccess()) {
                            DirectDeclareLogUtils.updateStatus(vo.getId(), "2", failedLog);
                            if (requestObj != null) {
                                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "2");
                            }
                        } else {
                            this.dealFailInfoForSfzhdxx(vo, result, failedLog);
                        }
                        break block29;
                    }
                    this.dealFailInfoForSfzhdxx(vo, result, failedLog);
                    break block29;
                }
                logger.info("szyh\u672a\u5904\u7406" + vo.getNsrsbh());
                if ("directdeclare".equals(vo.getName()) && (declare = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(vo.getBusinessId()), (String)"tcvat_nsrxx")) != null && "submitted".equals(declare.getString(DECLARESTATUS))) {
                    logger.info("zwy\u65e0\u7533\u62a5\u8bb0\u5f55\uff0c\u7ee7\u7eed\u7533\u62a5" + vo.getNsrsbh());
                    Long minutes = Duration.between(declare.getDate("sbrq").toInstant(), Instant.now()).toMinutes();
                    if (minutes > 5L) {
                        this.tryDeclare(vo, failedLog);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
                logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
                String message = String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%1$s \u5904\u7406\u5931\u8d25\uff1a%2$s", (String)"SzyhMessageSendServiceImpl_3", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh(), e.getMessage());
                result.setErrorCode(ErrorCode.FAIL.getCode());
                result.setMessage(message);
                failedLog.append(message);
                if ("directdeclare".equals(vo.getName())) {
                    DirectDeclareLogUtils.updateDeclareStatusAndBackupData(vo.getBusinessId(), vo.getId(), DECLARESTATUS, "declarefailed", "3", failedLog);
                    if (requestObj != null) {
                        ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
                    }
                }
                if ("fastpay".equals(vo.getName())) {
                    DirectDeclareLogUtils.uploadLogById(failedLog, vo.getId());
                }
                if (!"sfzhdxx".equals(vo.getName()) || requestObj == null) break block29;
                DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
                ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
            }
        }
        return result;
    }

    @Override
    public ApiResult downloadVerification(SBMessageBaseVo vo) {
        ApiResult result = new ApiResult();
        StringBuilder failedLog = new StringBuilder();
        try {
            result = CloudccDirectDeclareService.downloadVerification(vo);
            if (!result.getSuccess()) {
                this.dealFailInfoForSfzhdxx(vo, result, failedLog);
            }
        }
        catch (Exception e) {
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e);
            logger.error("\u5904\u7406\u5931\u8d25\uff1a" + e.getMessage());
            this.dealFailInfoForSfzhdxx(vo, result, failedLog);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiResult downloadSbsx(SBMessageBaseVo vo) {
        ApiResult result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u795e\u5dde\u4e91\u5408\u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u4e0b\u8f7d\u8c03\u7528\u5931\u8d25", (String)"SzyhMessageSendServiceImpl_14", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "3", false);
        Long recordId = vo.getId();
        StringBuilder failedlog = new StringBuilder();
        try {
            logger.info("szyh \u7533\u62a5\u4e8b\u9879\u4fe1\u606f\u67e5\u8be2\u4e0b\u8f7d\u5f00\u59cb recordId={} \u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7={} ", (Object)recordId, (Object)vo.getNsrsbh());
            SbsxxzMessageVo sbsxxzVo = (SbsxxzMessageVo)vo.handler(SbsxxzMessageVo.class);
            String taskCode = sbsxxzVo.getString(SbsxxzMessageVo.Key.TASK_CODE);
            SbsxxzHandlerStrategy strategy = SbsxxzStrategyFactory.getStrategy(SbsxxzStrategyFactory.genKeyByTaskTypeAndChannel(taskCode, SupplierEnum.SZYH.getCode()));
            strategy.handlerSbsxxzDownLoad(sbsxxzVo);
            result = CustomApiResult.dealResponse(null, ResManager.loadKDString((String)"\u6210\u529f", (String)"SzyhMessageSendServiceImpl_18", (String)"taxc-tsate-mservice", (Object[])new Object[0]), "4", true);
        }
        catch (Exception e) {
            String stackMsg = ExceptionUtil.toString((Exception)e);
            failedlog.append(ResManager.loadKDString((String)"\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u63a5\u53e3\u5f02\u5e38\u6216\u5931\u8d25,\u8be6\u60c5\uff1a", (String)"SzyhMessageSendServiceImpl_21", (String)"taxc-tsate-mservice", (Object[])new Object[0])).append(e.getMessage());
            logger.error("\u8c03\u7528\u7533\u62a5\u4e8b\u9879\u4e0b\u8f7d\u5931\u8d25,recordId={}" + e.getMessage(), (Object)recordId);
            logger.error(stackMsg);
        }
        finally {
            if (result.getSuccess()) {
                DirectDeclareLogUtils.updateStatus(recordId, "2", failedlog);
            } else {
                DirectDeclareLogUtils.updateStatus(recordId, "3", failedlog);
            }
        }
        return result;
    }

    private void dealFailInfoForSfzhdxx(SBMessageBaseVo vo, ApiResult result, StringBuilder failedLog) {
        DynamicObject requestObj = ConnectConfigService.getRequestIdByRequestType(vo.getNsrsbh(), "1", RequestTypeEnum.VERIFICATION);
        result.setErrorCode(ErrorCode.FAIL.getCode());
        result.setSuccess(false);
        failedLog.append(String.format(ResManager.loadKDString((String)"\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\uff1a%s", (String)"SzyhMessageSendServiceImpl_1", (String)"taxc-tsate-mservice", (Object[])new Object[0]), vo.getNsrsbh())).append(result.getMessage());
        DirectDeclareLogUtils.updateStatus(vo.getId(), "3", failedLog);
        if (requestObj != null) {
            ConnectConfigService.updateStatusInfo(requestObj.getLong("id"), JSONObject.toJSONString((Object)result.getData()), "3");
        }
    }

    private static DynamicObject[] assembleDeclareRecord(DynamicObject declare, String executeType) {
        DynamicObject channelObj;
        QFilter qFilter = new QFilter("sbbid", "=", (Object)declare.getString("id")).and(new QFilter("tasktype.number", "=", (Object)executeType)).and(new QFilter("executestatus", "=", (Object)"1"));
        DynamicObject[] recordObjs = BusinessDataServiceHelper.load((String)"tsate_declare_record", (String)MetadataUtil.getAllFieldString((String)"tsate_declare_record"), (QFilter[])new QFilter[]{qFilter});
        if (recordObjs != null && recordObjs.length > 0) {
            return recordObjs;
        }
        DynamicObject recordObj = BusinessDataServiceHelper.newDynamicObject((String)"tsate_declare_record");
        DynamicObject org = declare.getDynamicObject("org");
        recordObj.set("org", (Object)org.getLong("id"));
        recordObj.set("skssqq", (Object)declare.getDate("skssqq"));
        recordObj.set("createtime", (Object)new Date());
        recordObj.set("creator", (Object)RequestContext.get().getUserId());
        recordObj.set("executestatus", (Object)"1");
        recordObj.set("skssqz", (Object)declare.getDate("skssqz"));
        recordObj.set("type", (Object)declare.getString("type"));
        recordObj.set("billstatus", (Object)"C");
        recordObj.set("sbbid", (Object)declare.getString("id"));
        DynamicObject taskObj = BusinessDataServiceHelper.loadSingle((String)"tsate_tasktype", (String)MetadataUtil.getAllFieldString((String)"tsate_tasktype"), (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)executeType)});
        if (taskObj != null) {
            recordObj.set("executetype", (Object)executeType);
            recordObj.set("tasktype", (Object)taskObj.getLong("id"));
        }
        if ((channelObj = CommonInfoUtil.getChannel((Long)declare.getLong("id"))) != null) {
            recordObj.set("channel", (Object)channelObj.getDynamicObject("declarechannel").getString("number"));
            recordObj.set("declarechannel", (Object)channelObj.getDynamicObject("declarechannel").getLong("id"));
        }
        DynamicObject[] objs = (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
        recordObj = objs[0];
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        codeRuleService.getNumber("tsate_declare_record", recordObj, null);
        String number = codeRuleService.readNumber("tsate_declare_record", recordObj, null);
        recordObj.set("billno", (Object)number);
        return (DynamicObject[])SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{recordObj});
    }

    private void dealPayTask(SBMessageBaseVo vo) {
        DynamicObject declareObj = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(vo.getBusinessId()), (String)"tcvat_nsrxx");
        BigDecimal bqybtse = declareObj.getBigDecimal("bqybtse");
        if (BigDecimal.ZERO.compareTo(bqybtse) < 0) {
            SzyhMessageSendServiceImpl.assembleDeclareRecord(declareObj, "ZLJK");
        }
    }

    private ApiResult dealVerificationData(SBMessageBaseVo vo, Map<String, Object> map, StringBuilder failedLog, Long requestId) throws MessageException {
        MessageSend send = new MessageSend();
        send.setMsgtype("verification");
        send.setBusinessid(vo.getBusinessId());
        send.setBusinesstype("verification");
        send.setNsrType(vo.getType());
        send.setNodetype(vo.getSbdq());
        send.setSupplier(SupplierEnum.SZYH.getName());
        String sfzhdData = MessageService.collectionHistoryData(send, map, vo.getNsrsbh());
        Map<String, Object> sbbDataRootMap = XmlTJsonUtil.xml2ObjectMap(sfzhdData);
        Map sfzhdMap = (Map)sbbDataRootMap.get("Root");
        return this.dealSfzhdxxObj(sfzhdMap, vo, failedLog, requestId);
    }

    private ApiResult dealSfzhdxxObj(Map<String, Object> sfzhdMap, SBMessageBaseVo vo, StringBuilder failedLog, Long requestId) {
        ApiResult apiResult;
        if (sfzhdMap != null && sfzhdMap.size() > 0) {
            HashMap<String, Long> saveMap = new HashMap<String, Long>();
            saveMap.put("orgId", Long.valueOf(vo.getOrg()));
            logger.info("\u4fdd\u5b58\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u5f00\u59cb" + vo.getNsrsbh());
            String response = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxtypeCardService", (String)"save", (Object[])new Object[]{SerializationUtils.toJsonString(sfzhdMap), SerializationUtils.toJsonString(saveMap)});
            logger.info("\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u5b8c\u6210" + response);
            if (EmptyCheckUtils.isNotEmpty((Object)response)) {
                RequestResult result = (RequestResult)SerializationUtils.fromJsonString((String)response, RequestResult.class);
                if (result.getSuccess()) {
                    HashMap<String, String> extensionParams = new HashMap<String, String>();
                    extensionParams.put("isAuto", "1");
                    logger.info("\u5f00\u59cb\u8fdb\u884c\u5dee\u5f02\u6bd4\u5bf9----" + vo.getNsrsbh());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxtypeCardService", (String)"compare", (Object[])new Object[]{SerializationUtils.toJsonString((Object)result.getData()), SerializationUtils.toJsonString(extensionParams)});
                    logger.info("\u7ed3\u675f\u5dee\u5f02\u6bd4\u5bf9----" + vo.getNsrsbh());
                    apiResult = CustomApiResult.dealResponse(null, null, "4", true);
                } else {
                    failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u4fdd\u5b58\u5931\u8d25", (String)"SzyhMessageSendServiceImpl_9", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                    apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
                }
            } else {
                failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u4efb\u52a1\u4fdd\u5b58\u8fd4\u56de\u4e3a\u7a7a", (String)"SzyhMessageSendServiceImpl_10", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
                apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
            }
        } else {
            failedLog.append(ResManager.loadKDString((String)"\u4e0b\u8f7d\u7a0e\u79cd\u6838\u5b9a\u4fe1\u606f\u6570\u636e\u8fd4\u56de\u4e3a\u7a7a", (String)"SzyhMessageSendServiceImpl_12", (String)"taxc-tsate-mservice", (Object[])new Object[0]));
            apiResult = CustomApiResult.dealResponse(null, failedLog.toString(), "3", false);
        }
        return apiResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePzFile(SBMessageBaseVo vo, byte[] datas) {
        DynamicObject org = BusinessDataServiceHelper.loadSingle((String)"bastax_taxorg", (String)"org", (QFilter[])new QFilter[]{new QFilter("unifiedsocialcode", "=", (Object)vo.getNsrsbh())});
        String name = ((DynamicObject)org.get("org")).getString("name");
        String suffixName = vo.getPzTypeName() + ".zip";
        StringBuilder logDetail = new StringBuilder();
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(datas);
            SbpzRecordSaveUtils.saveRecord(vo, in, name, suffixName, logDetail);
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6d41\u5f02\u5e38");
                }
            }
        }
    }
}

